/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@I
public class HashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 362498820763181265L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int TREEIFY_THRESHOLD = 8;
    static final int UNTREEIFY_THRESHOLD = 6;
    static final int MIN_TREEIFY_CAPACITY = 64;
    transient Node<K, V>[] table;
    transient Set<Map.Entry<K, V>> entrySet;
    transient int size;
    transient int modCount;
    int threshold;
    final float loadFactor;

    static final int hash(Object object) {
        int n;
        if (object == null) {
            n = 0;
        } else {
            int n2 = object.hashCode();
            n = n2 ^ n2 >>> 16;
        }
        return n;
    }

    static Class<?> comparableClassFor(Object object) {
        if (object instanceof Comparable) {
            Class<?> clazz = object.getClass();
            if (clazz == String.class) {
                return clazz;
            }
            Type[] typeArray = clazz.getGenericInterfaces();
            if (typeArray != null) {
                for (int i = 0; i < typeArray.length; ++i) {
                    Type[] typeArray2;
                    ParameterizedType parameterizedType;
                    Type type = typeArray[i];
                    if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != Comparable.class || (typeArray2 = parameterizedType.getActualTypeArguments()) == null || typeArray2.length != 1 || typeArray2[0] != clazz) continue;
                    return clazz;
                }
            }
        }
        return null;
    }

    static int compareComparables(Class<?> clazz, Object object, Object object2) {
        return object2 == null || object2.getClass() != clazz ? 0 : ((Comparable)object).compareTo(object2);
    }

    static final int tableSizeFor(int n) {
        int n2 = n - 1;
        n2 |= n2 >>> 1;
        n2 |= n2 >>> 2;
        n2 |= n2 >>> 4;
        n2 |= n2 >>> 8;
        return (n2 |= n2 >>> 16) < 0 ? 1 : (n2 >= 0x40000000 ? 0x40000000 : n2 + 1);
    }

    public HashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        this.loadFactor = f;
        this.threshold = HashMap.tableSizeFor(n);
    }

    public HashMap(int n) {
        this(n, 0.75f);
    }

    public HashMap() {
        this.loadFactor = 0.75f;
    }

    public @PolyRead HashMap(@org.checkerframework.checker.igj.qual.ReadOnly @PolyRead Map<? extends K, ? extends V> map) {
        this.loadFactor = 0.75f;
        this.putMapEntries(map, false);
    }

    final void putMapEntries(Map<? extends K, ? extends V> map, boolean bl) {
        int n = map.size();
        if (n > 0) {
            if (this.table == null) {
                int n2;
                float f = (float)n / this.loadFactor + 1.0f;
                int n3 = n2 = f < 1.0737418E9f ? (int)f : 0x40000000;
                if (n2 > this.threshold) {
                    this.threshold = HashMap.tableSizeFor(n2);
                }
            } else if (n > this.threshold) {
                this.resize();
            }
            for (Map.Entry<K, V> entry : map.entrySet()) {
                K k = entry.getKey();
                V v = entry.getValue();
                this.putVal(HashMap.hash(k), k, v, false, bl);
            }
        }
    }

    @Override
    @Pure
    public int size(@org.checkerframework.checker.igj.qual.ReadOnly HashMap<K, V> this) {
        return this.size;
    }

    @Override
    @Pure
    public boolean isEmpty(@org.checkerframework.checker.igj.qual.ReadOnly HashMap<K, V> this) {
        return this.size == 0;
    }

    @Override
    @Pure
    public @Nullable V get(@org.checkerframework.checker.igj.qual.ReadOnly HashMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        Node<K, V> node = this.getNode(HashMap.hash(object), object);
        return node == null ? null : (V)node.value;
    }

    final Node<K, V> getNode(int n, Object object) {
        Node<K, V> node;
        int n2;
        Node<K, V>[] nodeArray = this.table;
        if (this.table != null && (n2 = nodeArray.length) > 0 && (node = nodeArray[n2 - 1 & n]) != null) {
            Object k;
            if (node.hash == n && ((k = node.key) == object || object != null && object.equals(k))) {
                return node;
            }
            Node node2 = node.next;
            if (node2 != null) {
                if (node instanceof TreeNode) {
                    return ((TreeNode)node).getTreeNode(n, object);
                }
                do {
                    if (node2.hash != n || (k = node2.key) != object && (object == null || !object.equals(k))) continue;
                    return node2;
                } while ((node2 = node2.next) != null);
            }
        }
        return null;
    }

    @Override
    @Pure
    public boolean containsKey(@org.checkerframework.checker.igj.qual.ReadOnly HashMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        return this.getNode(HashMap.hash(object), object) != null;
    }

    @Override
    public @Nullable V put(@Mutable HashMap<K, V> this, K k, V v) {
        return this.putVal(HashMap.hash(k), k, v, false, true);
    }

    final V putVal(int n, K k, V v, boolean bl, boolean bl2) {
        int n2;
        Node<K, V> node;
        int n3;
        Node<K, V>[] nodeArray = this.table;
        if (this.table == null || (n3 = nodeArray.length) == 0) {
            nodeArray = this.resize();
            n3 = nodeArray.length;
        }
        if ((node = nodeArray[n2 = n3 - 1 & n]) == null) {
            nodeArray[n2] = this.newNode(n, k, v, null);
        } else {
            Node<K, V> node2;
            Object k2;
            if (node.hash == n && ((k2 = node.key) == k || k != null && k.equals(k2))) {
                node2 = node;
            } else if (node instanceof TreeNode) {
                node2 = ((TreeNode)node).putTreeVal(this, nodeArray, n, k, v);
            } else {
                int n4 = 0;
                while (true) {
                    if ((node2 = node.next) == null) {
                        node.next = this.newNode(n, k, v, null);
                        if (n4 < 7) break;
                        this.treeifyBin(nodeArray, n);
                        break;
                    }
                    if (node2.hash == n && ((k2 = node2.key) == k || k != null && k.equals(k2))) break;
                    node = node2;
                    ++n4;
                }
            }
            if (node2 != null) {
                Object v2 = node2.value;
                if (!bl || v2 == null) {
                    node2.value = v;
                }
                this.afterNodeAccess(node2);
                return v2;
            }
        }
        ++this.modCount;
        if (++this.size > this.threshold) {
            this.resize();
        }
        this.afterNodeInsertion(bl2);
        return null;
    }

    final Node<K, V>[] resize() {
        int n;
        Node<K, V>[] nodeArray = this.table;
        int n2 = nodeArray == null ? 0 : nodeArray.length;
        int n3 = this.threshold;
        int n4 = 0;
        if (n2 > 0) {
            if (n2 >= 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return nodeArray;
            }
            n = n2 << 1;
            if (n < 0x40000000 && n2 >= 16) {
                n4 = n3 << 1;
            }
        } else if (n3 > 0) {
            n = n3;
        } else {
            n = 16;
            n4 = 12;
        }
        if (n4 == 0) {
            float f = (float)n * this.loadFactor;
            n4 = n < 0x40000000 && f < 1.0737418E9f ? (int)f : Integer.MAX_VALUE;
        }
        this.threshold = n4;
        Node[] nodeArray2 = new Node[n];
        this.table = nodeArray2;
        if (nodeArray != null) {
            for (int i = 0; i < n2; ++i) {
                Node node;
                Node<K, V> node2 = nodeArray[i];
                if (node2 == null) continue;
                nodeArray[i] = null;
                if (node2.next == null) {
                    nodeArray2[node2.hash & n - 1] = node2;
                    continue;
                }
                if (node2 instanceof TreeNode) {
                    ((TreeNode)node2).split(this, nodeArray2, i, n2);
                    continue;
                }
                Node<K, V> node3 = null;
                Node<K, V> node4 = null;
                Node<K, V> node5 = null;
                Node<K, V> node6 = null;
                do {
                    node = node2.next;
                    if ((node2.hash & n2) == 0) {
                        if (node4 == null) {
                            node3 = node2;
                        } else {
                            node4.next = node2;
                        }
                        node4 = node2;
                        continue;
                    }
                    if (node6 == null) {
                        node5 = node2;
                    } else {
                        node6.next = node2;
                    }
                    node6 = node2;
                } while ((node2 = node) != null);
                if (node4 != null) {
                    node4.next = null;
                    nodeArray2[i] = node3;
                }
                if (node6 == null) continue;
                node6.next = null;
                nodeArray2[i + n2] = node5;
            }
        }
        return nodeArray2;
    }

    final void treeifyBin(Node<K, V>[] nodeArray, int n) {
        int n2;
        if (nodeArray == null || (n2 = nodeArray.length) < 64) {
            this.resize();
        } else {
            int n3 = n2 - 1 & n;
            Node<K, V> node = nodeArray[n3];
            if (node != null) {
                TreeNode<K, V> treeNode = null;
                TreeNode<K, V> treeNode2 = null;
                do {
                    TreeNode<K, V> treeNode3 = this.replacementTreeNode(node, null);
                    if (treeNode2 == null) {
                        treeNode = treeNode3;
                    } else {
                        treeNode3.prev = treeNode2;
                        treeNode2.next = treeNode3;
                    }
                    treeNode2 = treeNode3;
                } while ((node = node.next) != null);
                nodeArray[n3] = treeNode;
                if (nodeArray[n3] != null) {
                    treeNode.treeify(nodeArray);
                }
            }
        }
    }

    @Override
    public void putAll(@Mutable HashMap<K, V> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Map<? extends K, ? extends V> map) {
        this.putMapEntries(map, true);
    }

    @Override
    public @Nullable V remove(@Mutable HashMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        Node<K, V> node = this.removeNode(HashMap.hash(object), object, null, false, true);
        return node == null ? null : (V)node.value;
    }

    final Node<K, V> removeNode(int n, Object object, Object object2, boolean bl, boolean bl2) {
        int n2;
        Node<K, V> node;
        int n3;
        Node<K, V>[] nodeArray = this.table;
        if (this.table != null && (n3 = nodeArray.length) > 0 && (node = nodeArray[n2 = n3 - 1 & n]) != null) {
            Object v;
            Object k;
            Node<K, V> node2 = null;
            if (node.hash == n && ((k = node.key) == object || object != null && object.equals(k))) {
                node2 = node;
            } else {
                Node node3 = node.next;
                if (node3 != null) {
                    if (node instanceof TreeNode) {
                        node2 = ((TreeNode)node).getTreeNode(n, object);
                    } else {
                        do {
                            if (node3.hash == n && ((k = node3.key) == object || object != null && object.equals(k))) {
                                node2 = node3;
                                break;
                            }
                            node = node3;
                        } while ((node3 = node3.next) != null);
                    }
                }
            }
            if (node2 != null && (!bl || (v = node2.value) == object2 || object2 != null && object2.equals(v))) {
                if (node2 instanceof TreeNode) {
                    ((TreeNode)node2).removeTreeNode(this, nodeArray, bl2);
                } else if (node2 == node) {
                    nodeArray[n2] = node2.next;
                } else {
                    node.next = node2.next;
                }
                ++this.modCount;
                --this.size;
                this.afterNodeRemoval(node2);
                return node2;
            }
        }
        return null;
    }

    @Override
    public void clear(@Mutable HashMap<K, V> this) {
        ++this.modCount;
        Node<K, V>[] nodeArray = this.table;
        if (this.table != null && this.size > 0) {
            this.size = 0;
            for (int i = 0; i < nodeArray.length; ++i) {
                nodeArray[i] = null;
            }
        }
    }

    @Override
    @Pure
    public boolean containsValue(@org.checkerframework.checker.igj.qual.ReadOnly HashMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        Node<K, V>[] nodeArray = this.table;
        if (this.table != null && this.size > 0) {
            for (int i = 0; i < nodeArray.length; ++i) {
                Node<K, V> node = nodeArray[i];
                while (node != null) {
                    Object v = node.value;
                    if (v == object || object != null && object.equals(v)) {
                        return true;
                    }
                    node = node.next;
                }
            }
        }
        return false;
    }

    @Override
    @SideEffectFree
    public @I @PolyRead Set<@KeyFor(value={"this"}) K> keySet(@org.checkerframework.checker.igj.qual.ReadOnly HashMap<K, V> this) {
        Set set = this.keySet;
        return set == null ? (this.keySet = new KeySet()) : set;
    }

    @Override
    @SideEffectFree
    public @I @PolyRead Collection<V> values(@org.checkerframework.checker.igj.qual.ReadOnly HashMap<K, V> this) {
        Collection collection = this.values;
        return collection == null ? (this.values = new Values()) : collection;
    }

    @Override
    @SideEffectFree
    public @I @PolyRead Set<@I @PolyRead Map.Entry<@KeyFor(value={"this"}) K, V>> entrySet(@org.checkerframework.checker.igj.qual.ReadOnly HashMap<K, V> this) {
        EntrySet entrySet = this.entrySet;
        return entrySet == null ? (this.entrySet = new EntrySet()) : entrySet;
    }

    @Override
    public V getOrDefault(Object object, V v) {
        Node<K, V> node = this.getNode(HashMap.hash(object), object);
        return node == null ? v : node.value;
    }

    @Override
    public V putIfAbsent(K k, V v) {
        return this.putVal(HashMap.hash(k), k, v, true, true);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        return this.removeNode(HashMap.hash(object), object, object2, true, true) != null;
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        Object v3;
        Node<K, V> node = this.getNode(HashMap.hash(k), k);
        if (node != null && ((v3 = node.value) == v || v3 != null && v3.equals(v))) {
            node.value = v2;
            this.afterNodeAccess(node);
            return true;
        }
        return false;
    }

    @Override
    public V replace(K k, V v) {
        Node<K, V> node = this.getNode(HashMap.hash(k), k);
        if (node != null) {
            Object v2 = node.value;
            node.value = v;
            this.afterNodeAccess(node);
            return v2;
        }
        return null;
    }

    @Override
    public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
        Object object;
        int n;
        Node<K, V> node;
        int n2;
        Node<K, V>[] nodeArray;
        Node node2;
        TreeNode treeNode;
        int n3;
        int n4;
        block16: {
            block15: {
                if (function == null) {
                    throw new NullPointerException();
                }
                n4 = HashMap.hash(k);
                n3 = 0;
                treeNode = null;
                node2 = null;
                if (this.size > this.threshold) break block15;
                nodeArray = this.table;
                if (this.table != null && (n2 = nodeArray.length) != 0) break block16;
            }
            nodeArray = this.resize();
            n2 = nodeArray.length;
        }
        if ((node = nodeArray[n = n2 - 1 & n4]) != null) {
            if (node instanceof TreeNode) {
                treeNode = (TreeNode)node;
                node2 = treeNode.getTreeNode(n4, k);
            } else {
                object = node;
                do {
                    Object k2;
                    if (((Node)object).hash == n4 && ((k2 = ((Node)object).key) == k || k != null && k.equals(k2))) {
                        node2 = object;
                        break;
                    }
                    ++n3;
                } while ((object = ((Node)object).next) != null);
            }
            if (node2 != null && (object = node2.value) != null) {
                this.afterNodeAccess(node2);
                return object;
            }
        }
        if ((object = function.apply(k)) == null) {
            return null;
        }
        if (node2 != null) {
            node2.value = object;
            this.afterNodeAccess(node2);
            return object;
        }
        if (treeNode != null) {
            treeNode.putTreeVal(this, nodeArray, n4, k, object);
        } else {
            nodeArray[n] = this.newNode(n4, k, object, node);
            if (n3 >= 7) {
                this.treeifyBin(nodeArray, n4);
            }
        }
        ++this.modCount;
        ++this.size;
        this.afterNodeInsertion(true);
        return object;
    }

    @Override
    public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Object v;
        if (biFunction == null) {
            throw new NullPointerException();
        }
        int n = HashMap.hash(k);
        Node<K, V> node = this.getNode(n, k);
        if (node != null && (v = node.value) != null) {
            V v2 = biFunction.apply(k, v);
            if (v2 != null) {
                node.value = v2;
                this.afterNodeAccess(node);
                return v2;
            }
            this.removeNode(n, k, null, false, true);
        }
        return null;
    }

    @Override
    public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Object object;
        Node<K, V> node;
        int n;
        Node<K, V> node2;
        int n2;
        Node<K, V>[] nodeArray;
        Node node3;
        TreeNode treeNode;
        int n3;
        int n4;
        block18: {
            block17: {
                if (biFunction == null) {
                    throw new NullPointerException();
                }
                n4 = HashMap.hash(k);
                n3 = 0;
                treeNode = null;
                node3 = null;
                if (this.size > this.threshold) break block17;
                nodeArray = this.table;
                if (this.table != null && (n2 = nodeArray.length) != 0) break block18;
            }
            nodeArray = this.resize();
            n2 = nodeArray.length;
        }
        if ((node2 = nodeArray[n = n2 - 1 & n4]) != null) {
            if (node2 instanceof TreeNode) {
                treeNode = (TreeNode)node2;
                node3 = treeNode.getTreeNode(n4, k);
            } else {
                node = node2;
                do {
                    if (node.hash == n4 && ((object = node.key) == k || k != null && k.equals(object))) {
                        node3 = node;
                        break;
                    }
                    ++n3;
                } while ((node = node.next) != null);
            }
        }
        node = node3 == null ? null : node3.value;
        object = biFunction.apply(k, node);
        if (node3 != null) {
            if (object != null) {
                node3.value = object;
                this.afterNodeAccess(node3);
            } else {
                this.removeNode(n4, k, null, false, true);
            }
        } else if (object != null) {
            if (treeNode != null) {
                treeNode.putTreeVal(this, nodeArray, n4, k, object);
            } else {
                nodeArray[n] = this.newNode(n4, k, object, node2);
                if (n3 >= 7) {
                    this.treeifyBin(nodeArray, n4);
                }
            }
            ++this.modCount;
            ++this.size;
            this.afterNodeInsertion(true);
        }
        return object;
    }

    @Override
    public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        Node<K, V> node;
        int n;
        Node<K, V> node2;
        int n2;
        Node<K, V>[] nodeArray;
        Node node3;
        TreeNode treeNode;
        int n3;
        int n4;
        block18: {
            block17: {
                if (v == null) {
                    throw new NullPointerException();
                }
                if (biFunction == null) {
                    throw new NullPointerException();
                }
                n4 = HashMap.hash(k);
                n3 = 0;
                treeNode = null;
                node3 = null;
                if (this.size > this.threshold) break block17;
                nodeArray = this.table;
                if (this.table != null && (n2 = nodeArray.length) != 0) break block18;
            }
            nodeArray = this.resize();
            n2 = nodeArray.length;
        }
        if ((node2 = nodeArray[n = n2 - 1 & n4]) != null) {
            if (node2 instanceof TreeNode) {
                treeNode = (TreeNode)node2;
                node3 = treeNode.getTreeNode(n4, k);
            } else {
                node = node2;
                do {
                    Object k2;
                    if (node.hash == n4 && ((k2 = node.key) == k || k != null && k.equals(k2))) {
                        node3 = node;
                        break;
                    }
                    ++n3;
                } while ((node = node.next) != null);
            }
        }
        if (node3 != null) {
            node = node3.value != null ? biFunction.apply(node3.value, v) : v;
            if (node != null) {
                node3.value = node;
                this.afterNodeAccess(node3);
            } else {
                this.removeNode(n4, k, null, false, true);
            }
            return (V)node;
        }
        if (v != null) {
            if (treeNode != null) {
                treeNode.putTreeVal(this, nodeArray, n4, k, v);
            } else {
                nodeArray[n] = this.newNode(n4, k, v, node2);
                if (n3 >= 7) {
                    this.treeifyBin(nodeArray, n4);
                }
            }
            ++this.modCount;
            ++this.size;
            this.afterNodeInsertion(true);
        }
        return v;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        if (biConsumer == null) {
            throw new NullPointerException();
        }
        if (this.size > 0) {
            Node<K, V>[] nodeArray = this.table;
            if (this.table != null) {
                int n = this.modCount;
                for (int i = 0; i < nodeArray.length; ++i) {
                    Node<K, V> node = nodeArray[i];
                    while (node != null) {
                        biConsumer.accept(node.key, node.value);
                        node = node.next;
                    }
                }
                if (this.modCount != n) {
                    throw new ConcurrentModificationException();
                }
            }
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        if (biFunction == null) {
            throw new NullPointerException();
        }
        if (this.size > 0) {
            Node<K, V>[] nodeArray = this.table;
            if (this.table != null) {
                int n = this.modCount;
                for (int i = 0; i < nodeArray.length; ++i) {
                    Node<K, V> node = nodeArray[i];
                    while (node != null) {
                        node.value = biFunction.apply(node.key, node.value);
                        node = node.next;
                    }
                }
                if (this.modCount != n) {
                    throw new ConcurrentModificationException();
                }
            }
        }
    }

    @Override
    @SideEffectFree
    public @I(value="N") Object clone(@ReadOnly HashMap<K, V> this) {
        HashMap hashMap;
        try {
            hashMap = (HashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
        hashMap.reinitialize();
        hashMap.putMapEntries(this, false);
        return hashMap;
    }

    final float loadFactor() {
        return this.loadFactor;
    }

    final int capacity() {
        return this.table != null ? this.table.length : (this.threshold > 0 ? this.threshold : 16);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.capacity();
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(n);
        objectOutputStream.writeInt(this.size);
        this.internalWriteEntries(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.reinitialize();
        if (this.loadFactor <= 0.0f || Float.isNaN(this.loadFactor)) {
            throw new InvalidObjectException("Illegal load factor: " + this.loadFactor);
        }
        objectInputStream.readInt();
        int n = objectInputStream.readInt();
        if (n < 0) {
            throw new InvalidObjectException("Illegal mappings count: " + n);
        }
        if (n > 0) {
            float f = Math.min(Math.max(0.25f, this.loadFactor), 4.0f);
            float f2 = (float)n / f + 1.0f;
            int n2 = f2 < 16.0f ? 16 : (f2 >= 1.0737418E9f ? 0x40000000 : HashMap.tableSizeFor((int)f2));
            float f3 = (float)n2 * f;
            this.threshold = n2 < 0x40000000 && f3 < 1.0737418E9f ? (int)f3 : Integer.MAX_VALUE;
            Node[] nodeArray = new Node[n2];
            this.table = nodeArray;
            for (int i = 0; i < n; ++i) {
                Object object = objectInputStream.readObject();
                Object object2 = objectInputStream.readObject();
                this.putVal(HashMap.hash(object), object, object2, false, false);
            }
        }
    }

    Node<K, V> newNode(int n, K k, V v, Node<K, V> node) {
        return new Node<K, V>(n, k, v, node);
    }

    Node<K, V> replacementNode(Node<K, V> node, Node<K, V> node2) {
        return new Node(node.hash, node.key, node.value, node2);
    }

    TreeNode<K, V> newTreeNode(int n, K k, V v, Node<K, V> node) {
        return new TreeNode<K, V>(n, k, v, node);
    }

    TreeNode<K, V> replacementTreeNode(Node<K, V> node, Node<K, V> node2) {
        return new TreeNode(node.hash, node.key, node.value, node2);
    }

    void reinitialize() {
        this.table = null;
        this.entrySet = null;
        this.keySet = null;
        this.values = null;
        this.modCount = 0;
        this.threshold = 0;
        this.size = 0;
    }

    void afterNodeAccess(Node<K, V> node) {
    }

    void afterNodeInsertion(boolean bl) {
    }

    void afterNodeRemoval(Node<K, V> node) {
    }

    void internalWriteEntries(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.size > 0) {
            Node<K, V>[] nodeArray = this.table;
            if (this.table != null) {
                for (int i = 0; i < nodeArray.length; ++i) {
                    Node<K, V> node = nodeArray[i];
                    while (node != null) {
                        objectOutputStream.writeObject(node.key);
                        objectOutputStream.writeObject(node.value);
                        node = node.next;
                    }
                }
            }
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator(HashMap this$0) {
        }

        @Override
        public final Map.Entry<K, V> next() {
            return this.nextNode();
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public final int size() {
            return HashMap.this.size;
        }

        @Override
        public final void clear() {
            HashMap.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(HashMap.this);
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Node candidate = HashMap.this.getNode(key);
            return candidate != null && candidate.equals(e);
        }

        @Override
        public final boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return HashMap.this.removeNode(HashMap.hash(key), key, value, true, true) != null;
            }
            return false;
        }

        @Override
        public final Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator(HashMap.this, 0, -1, 0, 0);
        }

        @Override
        public final void forEach(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (HashMap.this.size > 0) {
                Node<K, V>[] tab = HashMap.this.table;
                if (HashMap.this.table != null) {
                    int mc = HashMap.this.modCount;
                    for (Node e : tab) {
                        while (e != null) {
                            action.accept(e);
                            e = e.next;
                        }
                    }
                    if (HashMap.this.modCount != mc) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }

    static final class EntrySpliterator<K, V>
    extends HashMapSpliterator<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        EntrySpliterator(HashMap<K, V> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        public EntrySpliterator<K, V> trySplit() {
            EntrySpliterator<K, V> entrySpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid || this.current != null) {
                entrySpliterator = null;
            } else {
                this.index = mid;
                EntrySpliterator<K, V> entrySpliterator2 = new EntrySpliterator<K, V>(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                entrySpliterator = entrySpliterator2;
            }
            return entrySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
            int i;
            int mc;
            if (action == null) {
                throw new NullPointerException();
            }
            HashMap m = this.map;
            Node<K, V>[] tab = m.table;
            int hi = this.fence;
            if (hi < 0) {
                mc = this.expectedModCount = m.modCount;
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            } else {
                mc = this.expectedModCount;
            }
            if (tab != null && tab.length >= hi && (i = this.index) >= 0 && (i < (this.index = hi) || this.current != null)) {
                Node p = this.current;
                this.current = null;
                do {
                    if (p == null) {
                        p = tab[i++];
                        continue;
                    }
                    action.accept(p);
                    p = p.next;
                } while (p != null || i < hi);
                if (m.modCount != mc) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> action) {
            int hi;
            if (action == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] tab = this.map.table;
            if (tab != null && tab.length >= (hi = this.getFence()) && this.index >= 0) {
                while (this.current != null || this.index < hi) {
                    if (this.current == null) {
                        this.current = tab[this.index++];
                        continue;
                    }
                    Node e = this.current;
                    this.current = this.current.next;
                    action.accept(e);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return (this.fence < 0 || this.est == this.map.size ? 64 : 0) | 1;
        }
    }

    abstract class HashIterator {
        Node<K, V> next;
        Node<K, V> current;
        int expectedModCount;
        int index;

        HashIterator() {
            this.expectedModCount = HashMap.this.modCount;
            Node<K, V>[] t = HashMap.this.table;
            this.next = null;
            this.current = null;
            this.index = 0;
            if (t != null && HashMap.this.size > 0) {
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final Node<K, V> nextNode() {
            Node e = this.next;
            if (HashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.current = e;
            this.next = this.current.next;
            if (this.next == null) {
                Node<K, V>[] t = HashMap.this.table;
                if (HashMap.this.table != null) {
                    while (this.index < t.length && (this.next = t[this.index++]) == null) {
                    }
                }
            }
            return e;
        }

        public final void remove() {
            Node p = this.current;
            if (p == null) {
                throw new IllegalStateException();
            }
            if (HashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.current = null;
            HashMap.this.removeNode(p.hash, p.key, null, false, false);
            this.expectedModCount = HashMap.this.modCount;
        }
    }

    static class HashMapSpliterator<K, V> {
        final HashMap<K, V> map;
        Node<K, V> current;
        int index;
        int fence;
        int est;
        int expectedModCount;

        HashMapSpliterator(HashMap<K, V> m, int origin, int fence, int est, int expectedModCount) {
            this.map = m;
            this.index = origin;
            this.fence = fence;
            this.est = est;
            this.expectedModCount = expectedModCount;
        }

        final int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                HashMap<K, V> m = this.map;
                this.est = m.size;
                this.expectedModCount = m.modCount;
                Node<K, V>[] tab = m.table;
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            }
            return hi;
        }

        public final long estimateSize() {
            this.getFence();
            return this.est;
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        KeyIterator(HashMap this$0) {
        }

        @Override
        public final K next() {
            return this.nextNode().key;
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public final int size() {
            return HashMap.this.size;
        }

        @Override
        public final void clear() {
            HashMap.this.clear();
        }

        @Override
        public final Iterator<K> iterator() {
            return new KeyIterator(HashMap.this);
        }

        @Override
        public final boolean contains(Object o) {
            return HashMap.this.containsKey(o);
        }

        @Override
        public final boolean remove(Object key) {
            return HashMap.this.removeNode(HashMap.hash(key), key, null, false, true) != null;
        }

        @Override
        public final Spliterator<K> spliterator() {
            return new KeySpliterator(HashMap.this, 0, -1, 0, 0);
        }

        @Override
        public Object[] toArray() {
            return HashMap.this.keysToArray(new Object[HashMap.this.size]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return HashMap.this.keysToArray(HashMap.this.prepareArray(a));
        }

        @Override
        public final void forEach(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (HashMap.this.size > 0) {
                Node<K, V>[] tab = HashMap.this.table;
                if (HashMap.this.table != null) {
                    int mc = HashMap.this.modCount;
                    for (Node e : tab) {
                        while (e != null) {
                            action.accept(e.key);
                            e = e.next;
                        }
                    }
                    if (HashMap.this.modCount != mc) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }

    static final class KeySpliterator<K, V>
    extends HashMapSpliterator<K, V>
    implements Spliterator<K> {
        KeySpliterator(HashMap<K, V> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        public KeySpliterator<K, V> trySplit() {
            KeySpliterator<K, V> keySpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid || this.current != null) {
                keySpliterator = null;
            } else {
                this.index = mid;
                KeySpliterator<K, V> keySpliterator2 = new KeySpliterator<K, V>(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                keySpliterator = keySpliterator2;
            }
            return keySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> action) {
            int i;
            int mc;
            if (action == null) {
                throw new NullPointerException();
            }
            HashMap m = this.map;
            Node<K, V>[] tab = m.table;
            int hi = this.fence;
            if (hi < 0) {
                mc = this.expectedModCount = m.modCount;
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            } else {
                mc = this.expectedModCount;
            }
            if (tab != null && tab.length >= hi && (i = this.index) >= 0 && (i < (this.index = hi) || this.current != null)) {
                Node p = this.current;
                this.current = null;
                do {
                    if (p == null) {
                        p = tab[i++];
                        continue;
                    }
                    action.accept(p.key);
                    p = p.next;
                } while (p != null || i < hi);
                if (m.modCount != mc) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            int hi;
            if (action == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] tab = this.map.table;
            if (tab != null && tab.length >= (hi = this.getFence()) && this.index >= 0) {
                while (this.current != null || this.index < hi) {
                    if (this.current == null) {
                        this.current = tab[this.index++];
                        continue;
                    }
                    Object k = this.current.key;
                    this.current = this.current.next;
                    action.accept(k);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return (this.fence < 0 || this.est == this.map.size ? 64 : 0) | 1;
        }
    }

    static class Node<K, V>
    implements Map.Entry<K, V> {
        final int hash;
        final K key;
        V value;
        Node<K, V> next;

        Node(int hash, K key, V value, Node<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }

        @Override
        public final int hashCode() {
            return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Map.Entry e;
            if (o == this) {
                return true;
            }
            return o instanceof Map.Entry && Objects.equals(this.key, (e = (Map.Entry)o).getKey()) && Objects.equals(this.value, e.getValue());
        }
    }

    static final class TreeNode<K, V>
    extends LinkedHashMap.Entry<K, V> {
        TreeNode<K, V> parent;
        TreeNode<K, V> left;
        TreeNode<K, V> right;
        TreeNode<K, V> prev;
        boolean red;

        TreeNode(int hash, K key, V val, Node<K, V> next) {
            super(hash, key, val, next);
        }

        final TreeNode<K, V> root() {
            TreeNode<K, V> r = this;
            TreeNode<K, V> p;
            while ((p = r.parent) != null) {
                r = p;
            }
            return r;
        }

        static <K, V> void moveRootToFront(Node<K, V>[] tab, TreeNode<K, V> root) {
            int n;
            if (root != null && tab != null && (n = tab.length) > 0) {
                int index = n - 1 & root.hash;
                TreeNode first = (TreeNode)tab[index];
                if (root != first) {
                    tab[index] = root;
                    TreeNode<K, V> rp = root.prev;
                    Node rn = root.next;
                    if (rn != null) {
                        ((TreeNode)rn).prev = rp;
                    }
                    if (rp != null) {
                        rp.next = rn;
                    }
                    if (first != null) {
                        first.prev = root;
                    }
                    root.next = first;
                    root.prev = null;
                }
                assert (TreeNode.checkInvariants(root));
            }
        }

        final TreeNode<K, V> find(int h, Object k, Class<?> kc) {
            TreeNode<K, V> p = this;
            do {
                int dir;
                TreeNode<K, V> pl = p.left;
                TreeNode<K, V> pr = p.right;
                int ph = p.hash;
                if (ph > h) {
                    p = pl;
                    continue;
                }
                if (ph < h) {
                    p = pr;
                    continue;
                }
                Object pk = p.key;
                if (pk == k || k != null && k.equals(pk)) {
                    return p;
                }
                if (pl == null) {
                    p = pr;
                    continue;
                }
                if (pr == null) {
                    p = pl;
                    continue;
                }
                if ((kc != null || (kc = HashMap.comparableClassFor(k)) != null) && (dir = HashMap.compareComparables(kc, k, pk)) != 0) {
                    p = dir < 0 ? pl : pr;
                    continue;
                }
                TreeNode<K, V> q = pr.find(h, k, kc);
                if (q != null) {
                    return q;
                }
                p = pl;
            } while (p != null);
            return null;
        }

        final TreeNode<K, V> getTreeNode(int h, Object k) {
            return (this.parent != null ? this.root() : this).find(h, k, null);
        }

        static int tieBreakOrder(Object a, Object b) {
            int d;
            if (a == null || b == null || (d = a.getClass().getName().compareTo(b.getClass().getName())) == 0) {
                d = System.identityHashCode(a) <= System.identityHashCode(b) ? -1 : 1;
            }
            return d;
        }

        final void treeify(Node<K, V>[] tab) {
            TreeNode<K, V> root = null;
            TreeNode<K, V> x = this;
            while (x != null) {
                TreeNode next = (TreeNode)x.next;
                x.right = null;
                x.left = null;
                if (root == null) {
                    x.parent = null;
                    x.red = false;
                    root = x;
                } else {
                    TreeNode<K, V> xp;
                    int dir;
                    Object k = x.key;
                    int h = x.hash;
                    Class<?> kc = null;
                    TreeNode<K, V> p = root;
                    do {
                        Object pk = p.key;
                        int ph = p.hash;
                        if (ph > h) {
                            dir = -1;
                        } else if (ph < h) {
                            dir = 1;
                        } else if (kc == null && (kc = HashMap.comparableClassFor(k)) == null || (dir = HashMap.compareComparables(kc, k, pk)) == 0) {
                            dir = TreeNode.tieBreakOrder(k, pk);
                        }
                        xp = p;
                    } while ((p = dir <= 0 ? p.left : p.right) != null);
                    x.parent = xp;
                    if (dir <= 0) {
                        xp.left = x;
                    } else {
                        xp.right = x;
                    }
                    root = TreeNode.balanceInsertion(root, x);
                }
                x = next;
            }
            TreeNode.moveRootToFront(tab, root);
        }

        final Node<K, V> untreeify(HashMap<K, V> map) {
            Node<K, V> hd = null;
            Node<K, V> tl = null;
            Node q = this;
            while (q != null) {
                Node<K, V> p = map.replacementNode(q, null);
                if (tl == null) {
                    hd = p;
                } else {
                    tl.next = p;
                }
                tl = p;
                q = q.next;
            }
            return hd;
        }

        final TreeNode<K, V> putTreeVal(HashMap<K, V> map, Node<K, V>[] tab, int h, K k, V v) {
            TreeNode<K, V> xp;
            int dir;
            TreeNode<K, V> root;
            Class<?> kc = null;
            boolean searched = false;
            TreeNode<K, V> p = root = this.parent != null ? this.root() : this;
            do {
                int ph;
                if ((ph = p.hash) > h) {
                    dir = -1;
                } else if (ph < h) {
                    dir = 1;
                } else {
                    Object pk = p.key;
                    if (pk == k || k != null && k.equals(pk)) {
                        return p;
                    }
                    if (kc == null && (kc = HashMap.comparableClassFor(k)) == null || (dir = HashMap.compareComparables(kc, k, pk)) == 0) {
                        if (!searched) {
                            TreeNode<K, V> q;
                            searched = true;
                            TreeNode<K, V> ch = p.left;
                            if (ch != null && (q = ch.find(h, k, kc)) != null || (ch = p.right) != null && (q = ch.find(h, k, kc)) != null) {
                                return q;
                            }
                        }
                        dir = TreeNode.tieBreakOrder(k, pk);
                    }
                }
                xp = p;
            } while ((p = dir <= 0 ? p.left : p.right) != null);
            Node xpn = xp.next;
            TreeNode<K, V> x = map.newTreeNode(h, k, v, xpn);
            if (dir <= 0) {
                xp.left = x;
            } else {
                xp.right = x;
            }
            xp.next = x;
            x.prev = xp;
            x.parent = x.prev;
            if (xpn != null) {
                ((TreeNode)xpn).prev = x;
            }
            TreeNode.moveRootToFront(tab, TreeNode.balanceInsertion(root, x));
            return null;
        }

        final void removeTreeNode(HashMap<K, V> map, Node<K, V>[] tab, boolean movable) {
            TreeNode<K, V> r;
            TreeNode<K, V> replacement;
            TreeNode<K, V> rl;
            TreeNode<K, V> first;
            int n;
            if (tab == null || (n = tab.length) == 0) {
                return;
            }
            int index = n - 1 & this.hash;
            TreeNode<K, V> root = first = (TreeNode<K, V>)tab[index];
            TreeNode succ = (TreeNode)this.next;
            TreeNode<K, V> pred = this.prev;
            if (pred == null) {
                first = succ;
                tab[index] = first;
            } else {
                pred.next = succ;
            }
            if (succ != null) {
                succ.prev = pred;
            }
            if (first == null) {
                return;
            }
            if (root.parent != null) {
                root = root.root();
            }
            if (root == null || movable && (root.right == null || (rl = root.left) == null || rl.left == null)) {
                tab[index] = first.untreeify(map);
                return;
            }
            TreeNode<K, V> p = this;
            TreeNode<K, V> pl = this.left;
            TreeNode<K, V> pr = this.right;
            if (pl != null && pr != null) {
                TreeNode<K, V> sl;
                TreeNode<K, V> s = pr;
                while ((sl = s.left) != null) {
                    s = sl;
                }
                boolean c = s.red;
                s.red = p.red;
                p.red = c;
                TreeNode<K, V> sr = s.right;
                TreeNode<K, V> pp = p.parent;
                if (s == pr) {
                    p.parent = s;
                    s.right = p;
                } else {
                    TreeNode<K, V> sp = s.parent;
                    p.parent = sp;
                    if (p.parent != null) {
                        if (s == sp.left) {
                            sp.left = p;
                        } else {
                            sp.right = p;
                        }
                    }
                    if ((s.right = pr) != null) {
                        pr.parent = s;
                    }
                }
                p.left = null;
                p.right = sr;
                if (p.right != null) {
                    sr.parent = p;
                }
                if ((s.left = pl) != null) {
                    pl.parent = s;
                }
                if ((s.parent = pp) == null) {
                    root = s;
                } else if (p == pp.left) {
                    pp.left = s;
                } else {
                    pp.right = s;
                }
                replacement = sr != null ? sr : p;
            } else {
                replacement = pl != null ? pl : (pr != null ? pr : p);
            }
            if (replacement != p) {
                replacement.parent = p.parent;
                TreeNode<K, V> pp = replacement.parent;
                if (pp == null) {
                    root = replacement;
                    replacement.red = false;
                } else if (p == pp.left) {
                    pp.left = replacement;
                } else {
                    pp.right = replacement;
                }
                p.parent = null;
                p.right = null;
                p.left = null;
            }
            TreeNode<K, V> treeNode = r = p.red ? root : TreeNode.balanceDeletion(root, replacement);
            if (replacement == p) {
                TreeNode<K, V> pp = p.parent;
                p.parent = null;
                if (pp != null) {
                    if (p == pp.left) {
                        pp.left = null;
                    } else if (p == pp.right) {
                        pp.right = null;
                    }
                }
            }
            if (movable) {
                TreeNode.moveRootToFront(tab, r);
            }
        }

        final void split(HashMap<K, V> map, Node<K, V>[] tab, int index, int bit) {
            TreeNode b = this;
            TreeNode loHead = null;
            TreeNode loTail = null;
            TreeNode hiHead = null;
            TreeNode hiTail = null;
            int lc = 0;
            int hc = 0;
            TreeNode e = b;
            while (e != null) {
                TreeNode next = (TreeNode)e.next;
                e.next = null;
                if ((e.hash & bit) == 0) {
                    e.prev = loTail;
                    if (e.prev == null) {
                        loHead = e;
                    } else {
                        loTail.next = e;
                    }
                    loTail = e;
                    ++lc;
                } else {
                    e.prev = hiTail;
                    if (e.prev == null) {
                        hiHead = e;
                    } else {
                        hiTail.next = e;
                    }
                    hiTail = e;
                    ++hc;
                }
                e = next;
            }
            if (loHead != null) {
                if (lc <= 6) {
                    tab[index] = loHead.untreeify(map);
                } else {
                    tab[index] = loHead;
                    if (hiHead != null) {
                        loHead.treeify(tab);
                    }
                }
            }
            if (hiHead != null) {
                if (hc <= 6) {
                    tab[index + bit] = hiHead.untreeify(map);
                } else {
                    tab[index + bit] = hiHead;
                    if (loHead != null) {
                        hiHead.treeify(tab);
                    }
                }
            }
        }

        static <K, V> TreeNode<K, V> rotateLeft(TreeNode<K, V> root, TreeNode<K, V> p) {
            TreeNode<K, V> r;
            if (p != null && (r = p.right) != null) {
                p.right = r.left;
                TreeNode<K, V> rl = p.right;
                if (p.right != null) {
                    rl.parent = p;
                }
                TreeNode<K, V> pp = r.parent = p.parent;
                if (r.parent == null) {
                    root = r;
                    r.red = false;
                } else if (pp.left == p) {
                    pp.left = r;
                } else {
                    pp.right = r;
                }
                r.left = p;
                p.parent = r;
            }
            return root;
        }

        static <K, V> TreeNode<K, V> rotateRight(TreeNode<K, V> root, TreeNode<K, V> p) {
            TreeNode<K, V> l;
            if (p != null && (l = p.left) != null) {
                p.left = l.right;
                TreeNode<K, V> lr = p.left;
                if (p.left != null) {
                    lr.parent = p;
                }
                TreeNode<K, V> pp = l.parent = p.parent;
                if (l.parent == null) {
                    root = l;
                    l.red = false;
                } else if (pp.right == p) {
                    pp.right = l;
                } else {
                    pp.left = l;
                }
                l.right = p;
                p.parent = l;
            }
            return root;
        }

        static <K, V> TreeNode<K, V> balanceInsertion(TreeNode<K, V> root, TreeNode<K, V> x) {
            x.red = true;
            while (true) {
                TreeNode<K, V> xpp;
                TreeNode<K, V> xp;
                if ((xp = x.parent) == null) {
                    x.red = false;
                    return x;
                }
                if (!xp.red || (xpp = xp.parent) == null) {
                    return root;
                }
                TreeNode<K, V> xppl = xpp.left;
                if (xp == xppl) {
                    TreeNode<K, V> xppr = xpp.right;
                    if (xppr != null && xppr.red) {
                        xppr.red = false;
                        xp.red = false;
                        xpp.red = true;
                        x = xpp;
                        continue;
                    }
                    if (x == xp.right) {
                        x = xp;
                        root = TreeNode.rotateLeft(root, x);
                        xp = x.parent;
                        TreeNode<K, V> treeNode = xpp = xp == null ? null : xp.parent;
                    }
                    if (xp == null) continue;
                    xp.red = false;
                    if (xpp == null) continue;
                    xpp.red = true;
                    root = TreeNode.rotateRight(root, xpp);
                    continue;
                }
                if (xppl != null && xppl.red) {
                    xppl.red = false;
                    xp.red = false;
                    xpp.red = true;
                    x = xpp;
                    continue;
                }
                if (x == xp.left) {
                    x = xp;
                    root = TreeNode.rotateRight(root, x);
                    xp = x.parent;
                    TreeNode<K, V> treeNode = xpp = xp == null ? null : xp.parent;
                }
                if (xp == null) continue;
                xp.red = false;
                if (xpp == null) continue;
                xpp.red = true;
                root = TreeNode.rotateLeft(root, xpp);
            }
        }

        static <K, V> TreeNode<K, V> balanceDeletion(TreeNode<K, V> root, TreeNode<K, V> x) {
            while (x != null && x != root) {
                TreeNode<K, V> sr;
                TreeNode<K, V> sl;
                TreeNode<K, V> xp = x.parent;
                if (xp == null) {
                    x.red = false;
                    return x;
                }
                if (x.red) {
                    x.red = false;
                    return root;
                }
                TreeNode<K, V> xpl = xp.left;
                if (xpl == x) {
                    TreeNode<K, V> xpr = xp.right;
                    if (xpr != null && xpr.red) {
                        xpr.red = false;
                        xp.red = true;
                        root = TreeNode.rotateLeft(root, xp);
                        xp = x.parent;
                        TreeNode<K, V> treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr == null) {
                        x = xp;
                        continue;
                    }
                    sl = xpr.left;
                    sr = xpr.right;
                    if (!(sr != null && sr.red || sl != null && sl.red)) {
                        xpr.red = true;
                        x = xp;
                        continue;
                    }
                    if (sr == null || !sr.red) {
                        if (sl != null) {
                            sl.red = false;
                        }
                        xpr.red = true;
                        root = TreeNode.rotateRight(root, xpr);
                        xp = x.parent;
                        TreeNode<K, V> treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr != null) {
                        xpr.red = xp == null ? false : xp.red;
                        sr = xpr.right;
                        if (sr != null) {
                            sr.red = false;
                        }
                    }
                    if (xp != null) {
                        xp.red = false;
                        root = TreeNode.rotateLeft(root, xp);
                    }
                    x = root;
                    continue;
                }
                if (xpl != null && xpl.red) {
                    xpl.red = false;
                    xp.red = true;
                    root = TreeNode.rotateRight(root, xp);
                    xp = x.parent;
                    TreeNode<K, V> treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl == null) {
                    x = xp;
                    continue;
                }
                sl = xpl.left;
                sr = xpl.right;
                if (!(sl != null && sl.red || sr != null && sr.red)) {
                    xpl.red = true;
                    x = xp;
                    continue;
                }
                if (sl == null || !sl.red) {
                    if (sr != null) {
                        sr.red = false;
                    }
                    xpl.red = true;
                    root = TreeNode.rotateLeft(root, xpl);
                    xp = x.parent;
                    TreeNode<K, V> treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl != null) {
                    xpl.red = xp == null ? false : xp.red;
                    sl = xpl.left;
                    if (sl != null) {
                        sl.red = false;
                    }
                }
                if (xp != null) {
                    xp.red = false;
                    root = TreeNode.rotateRight(root, xp);
                }
                x = root;
            }
            return root;
        }

        static <K, V> boolean checkInvariants(TreeNode<K, V> t) {
            TreeNode<K, V> tp = t.parent;
            TreeNode<K, V> tl = t.left;
            TreeNode<K, V> tr = t.right;
            TreeNode<K, V> tb = t.prev;
            TreeNode tn = (TreeNode)t.next;
            if (tb != null && tb.next != t) {
                return false;
            }
            if (tn != null && tn.prev != t) {
                return false;
            }
            if (tp != null && t != tp.left && t != tp.right) {
                return false;
            }
            if (tl != null && (tl.parent != t || tl.hash > t.hash)) {
                return false;
            }
            if (tr != null && (tr.parent != t || tr.hash < t.hash)) {
                return false;
            }
            if (t.red && tl != null && tl.red && tr != null && tr.red) {
                return false;
            }
            if (tl != null && !TreeNode.checkInvariants(tl)) {
                return false;
            }
            return tr == null || TreeNode.checkInvariants(tr);
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        ValueIterator(HashMap this$0) {
        }

        @Override
        public final V next() {
            return this.nextNode().value;
        }
    }

    static final class ValueSpliterator<K, V>
    extends HashMapSpliterator<K, V>
    implements Spliterator<V> {
        ValueSpliterator(HashMap<K, V> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        public ValueSpliterator<K, V> trySplit() {
            ValueSpliterator<K, V> valueSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid || this.current != null) {
                valueSpliterator = null;
            } else {
                this.index = mid;
                ValueSpliterator<K, V> valueSpliterator2 = new ValueSpliterator<K, V>(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                valueSpliterator = valueSpliterator2;
            }
            return valueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> action) {
            int i;
            int mc;
            if (action == null) {
                throw new NullPointerException();
            }
            HashMap m = this.map;
            Node<K, V>[] tab = m.table;
            int hi = this.fence;
            if (hi < 0) {
                mc = this.expectedModCount = m.modCount;
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            } else {
                mc = this.expectedModCount;
            }
            if (tab != null && tab.length >= hi && (i = this.index) >= 0 && (i < (this.index = hi) || this.current != null)) {
                Node p = this.current;
                this.current = null;
                do {
                    if (p == null) {
                        p = tab[i++];
                        continue;
                    }
                    action.accept(p.value);
                    p = p.next;
                } while (p != null || i < hi);
                if (m.modCount != mc) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> action) {
            int hi;
            if (action == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] tab = this.map.table;
            if (tab != null && tab.length >= (hi = this.getFence()) && this.index >= 0) {
                while (this.current != null || this.index < hi) {
                    if (this.current == null) {
                        this.current = tab[this.index++];
                        continue;
                    }
                    Object v = this.current.value;
                    this.current = this.current.next;
                    action.accept(v);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return this.fence < 0 || this.est == this.map.size ? 64 : 0;
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public final int size() {
            return HashMap.this.size;
        }

        @Override
        public final void clear() {
            HashMap.this.clear();
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator(HashMap.this);
        }

        @Override
        public final boolean contains(Object o) {
            return HashMap.this.containsValue(o);
        }

        @Override
        public final Spliterator<V> spliterator() {
            return new ValueSpliterator(HashMap.this, 0, -1, 0, 0);
        }

        @Override
        public Object[] toArray() {
            return HashMap.this.valuesToArray(new Object[HashMap.this.size]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return HashMap.this.valuesToArray(HashMap.this.prepareArray(a));
        }

        @Override
        public final void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (HashMap.this.size > 0) {
                Node<K, V>[] tab = HashMap.this.table;
                if (HashMap.this.table != null) {
                    int mc = HashMap.this.modCount;
                    for (Node e : tab) {
                        while (e != null) {
                            action.accept(e.value);
                            e = e.next;
                        }
                    }
                    if (HashMap.this.modCount != mc) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }
}

