/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.time.Instant;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.JapaneseImperialCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.checkerframework.checker.igj.qual.AssignsFields;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.igj.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import sun.util.BuddhistCalendar;
import sun.util.calendar.ZoneInfo;
import sun.util.locale.provider.CalendarDataUtility;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.spi.CalendarProvider;

@I
public abstract class Calendar
implements Serializable,
Cloneable,
Comparable<Calendar> {
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int FIELD_COUNT = 17;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;
    public static final int AM = 0;
    public static final int PM = 1;
    public static final int ALL_STYLES = 0;
    static final int STANDALONE_MASK = 32768;
    public static final int SHORT = 1;
    public static final int LONG = 2;
    public static final int NARROW_FORMAT = 4;
    public static final int NARROW_STANDALONE = 32772;
    public static final int SHORT_FORMAT = 1;
    public static final int LONG_FORMAT = 2;
    public static final int SHORT_STANDALONE = 32769;
    public static final int LONG_STANDALONE = 32770;
    protected int[] fields = new int[17];
    protected boolean[] isSet = new boolean[17];
    private transient int[] stamp = new int[17];
    protected long time;
    protected boolean isTimeSet;
    protected boolean areFieldsSet;
    transient boolean areAllFieldsSet;
    private boolean lenient = true;
    private TimeZone zone;
    private transient boolean sharedZone = false;
    private int firstDayOfWeek;
    private int minimalDaysInFirstWeek;
    private static final ConcurrentMap<Locale, int[]> cachedLocaleData = new ConcurrentHashMap<Locale, int[]>(3);
    private static final int UNSET = 0;
    private static final int COMPUTED = 1;
    private static final int MINIMUM_USER_STAMP = 2;
    static final int ALL_FIELDS = 131071;
    private int nextStamp = 2;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;
    static final long serialVersionUID = -1807547505821590642L;
    static final int ERA_MASK = 1;
    static final int YEAR_MASK = 2;
    static final int MONTH_MASK = 4;
    static final int WEEK_OF_YEAR_MASK = 8;
    static final int WEEK_OF_MONTH_MASK = 16;
    static final int DAY_OF_MONTH_MASK = 32;
    static final int DATE_MASK = 32;
    static final int DAY_OF_YEAR_MASK = 64;
    static final int DAY_OF_WEEK_MASK = 128;
    static final int DAY_OF_WEEK_IN_MONTH_MASK = 256;
    static final int AM_PM_MASK = 512;
    static final int HOUR_MASK = 1024;
    static final int HOUR_OF_DAY_MASK = 2048;
    static final int MINUTE_MASK = 4096;
    static final int SECOND_MASK = 8192;
    static final int MILLISECOND_MASK = 16384;
    static final int ZONE_OFFSET_MASK = 32768;
    static final int DST_OFFSET_MASK = 65536;
    private static final String[] FIELD_NAME = new String[]{"ERA", "YEAR", "MONTH", "WEEK_OF_YEAR", "WEEK_OF_MONTH", "DAY_OF_MONTH", "DAY_OF_YEAR", "DAY_OF_WEEK", "DAY_OF_WEEK_IN_MONTH", "AM_PM", "HOUR", "HOUR_OF_DAY", "MINUTE", "SECOND", "MILLISECOND", "ZONE_OFFSET", "DST_OFFSET"};

    protected Calendar() {
        this(TimeZone.getDefaultRef(), Locale.getDefault(Locale.Category.FORMAT));
        this.sharedZone = true;
    }

    protected Calendar(TimeZone timeZone, Locale locale) {
        this.zone = timeZone;
        this.setWeekCountData(locale);
    }

    public static @I Calendar getInstance() {
        return Calendar.createCalendar(TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
    }

    public static @I Calendar getInstance(@ReadOnly TimeZone timeZone) {
        return Calendar.createCalendar(timeZone, Locale.getDefault(Locale.Category.FORMAT));
    }

    public static @I Calendar getInstance(@ReadOnly Locale locale) {
        return Calendar.createCalendar(TimeZone.getDefault(), locale);
    }

    public static @I Calendar getInstance(@ReadOnly TimeZone timeZone, Locale locale) {
        return Calendar.createCalendar(timeZone, locale);
    }

    private static Calendar createCalendar(TimeZone timeZone, Locale locale) {
        String string;
        CalendarProvider calendarProvider = LocaleProviderAdapter.getAdapter(CalendarProvider.class, locale).getCalendarProvider();
        if (calendarProvider != null) {
            try {
                return calendarProvider.getInstance(timeZone, locale);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        Calendar calendar = null;
        if (locale.hasExtensions() && (string = locale.getUnicodeLocaleType("ca")) != null) {
            switch (string) {
                case "buddhist": {
                    calendar = new BuddhistCalendar(timeZone, locale);
                    break;
                }
                case "japanese": {
                    calendar = new JapaneseImperialCalendar(timeZone, locale);
                    break;
                }
                case "gregory": {
                    calendar = new GregorianCalendar(timeZone, locale);
                }
            }
        }
        if (calendar == null) {
            calendar = locale.getLanguage() == "th" && locale.getCountry() == "TH" ? new BuddhistCalendar(timeZone, locale) : (locale.getVariant() == "JP" && locale.getLanguage() == "ja" && locale.getCountry() == "JP" ? new JapaneseImperialCalendar(timeZone, locale) : new GregorianCalendar(timeZone, locale));
        }
        return calendar;
    }

    public static synchronized Locale @ReadOnly [] getAvailableLocales() {
        return DateFormat.getAvailableLocales();
    }

    protected abstract void computeTime();

    protected abstract void computeFields();

    public final @I Date getTime(@ReadOnly Calendar this) {
        return new Date(this.getTimeInMillis());
    }

    public final void setTime(@AssignsFields Calendar this, Date date) {
        this.setTimeInMillis(date.getTime());
    }

    public long getTimeInMillis(@ReadOnly Calendar this) {
        if (!this.isTimeSet) {
            this.updateTime();
        }
        return this.time;
    }

    public void setTimeInMillis(@AssignsFields Calendar this, long l) {
        if (this.time == l && this.isTimeSet && this.areFieldsSet && this.areAllFieldsSet && this.zone instanceof ZoneInfo && !((ZoneInfo)this.zone).isDirty()) {
            return;
        }
        this.time = l;
        this.isTimeSet = true;
        this.areFieldsSet = false;
        this.computeFields();
        this.areFieldsSet = true;
        this.areAllFieldsSet = true;
    }

    @Pure
    public int get(@ReadOnly Calendar this, int n) {
        this.complete();
        return this.internalGet(n);
    }

    protected final int internalGet(int n) {
        return this.fields[n];
    }

    final void internalSet(int n, int n2) {
        this.fields[n] = n2;
    }

    public void set(@AssignsFields Calendar this, int n, int n2) {
        if (this.areFieldsSet && !this.areAllFieldsSet) {
            this.computeFields();
        }
        this.internalSet(n, n2);
        this.isTimeSet = false;
        this.areFieldsSet = false;
        this.isSet[n] = true;
        ++this.nextStamp;
        if (this.nextStamp == Integer.MAX_VALUE) {
            this.adjustStamp();
        }
    }

    public final void set(@AssignsFields Calendar this, int n, int n2, int n3) {
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
    }

    public final void set(@AssignsFields Calendar this, int n, int n2, int n3, int n4, int n5) {
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
    }

    public final void set(@AssignsFields Calendar this, int n, int n2, int n3, int n4, int n5, int n6) {
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
        this.set(13, n6);
    }

    public final void clear(@AssignsFields Calendar this) {
        int n = 0;
        while (n < this.fields.length) {
            this.fields[n] = 0;
            this.stamp[n] = 0;
            this.isSet[n++] = false;
        }
        this.areFieldsSet = false;
        this.areAllFieldsSet = false;
        this.isTimeSet = false;
    }

    public final void clear(@AssignsFields Calendar this, int n) {
        this.fields[n] = 0;
        this.stamp[n] = 0;
        this.isSet[n] = false;
        this.areFieldsSet = false;
        this.areAllFieldsSet = false;
        this.isTimeSet = false;
    }

    @Pure
    public final boolean isSet(@ReadOnly Calendar this, int n) {
        return this.stamp[n] != 0;
    }

    public @Nullable String getDisplayName(@ReadOnly Calendar this, int n, int n2, Locale locale) {
        int n3;
        if (!this.checkDisplayNameParams(n, n2, 1, 4, locale, 645)) {
            return null;
        }
        if (this.isStandaloneStyle(n2) || this.isNarrowStyle(n2)) {
            return CalendarDataUtility.retrieveFieldValueName(this.getCalendarType(), n, this.get(n), n2, locale);
        }
        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
        String[] stringArray = this.getFieldStrings(n, n2, dateFormatSymbols);
        if (stringArray != null && (n3 = this.get(n)) < stringArray.length) {
            return stringArray[n3];
        }
        return null;
    }

    public @Nullable Map<String, Integer> getDisplayNames(@ReadOnly Calendar this, int n, int n2, Locale locale) {
        if (!this.checkDisplayNameParams(n, n2, 0, 4, locale, 645)) {
            return null;
        }
        if (n2 == 0 || this.isStandaloneStyle(n2)) {
            return CalendarDataUtility.retrieveFieldValueNames(this.getCalendarType(), n, n2, locale);
        }
        return this.getDisplayNamesImpl(n, n2, locale);
    }

    private Map<String, Integer> getDisplayNamesImpl(int n, int n2, Locale locale) {
        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
        String[] stringArray = this.getFieldStrings(n, n2, dateFormatSymbols);
        if (stringArray != null) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() == 0) continue;
                hashMap.put(stringArray[i], i);
            }
            return hashMap;
        }
        return null;
    }

    boolean checkDisplayNameParams(int n, int n2, int n3, int n4, Locale locale, int n5) {
        int n6 = this.getBaseStyle(n2);
        if (n < 0 || n >= this.fields.length || n6 < n3 || n6 > n4) {
            throw new IllegalArgumentException();
        }
        if (locale == null) {
            throw new NullPointerException();
        }
        return Calendar.isFieldSet(n5, n);
    }

    private String[] getFieldStrings(int n, int n2, DateFormatSymbols dateFormatSymbols) {
        int n3 = this.getBaseStyle(n2);
        if (n3 == 4) {
            return null;
        }
        String[] stringArray = null;
        switch (n) {
            case 0: {
                stringArray = dateFormatSymbols.getEras();
                break;
            }
            case 2: {
                stringArray = n3 == 2 ? dateFormatSymbols.getMonths() : dateFormatSymbols.getShortMonths();
                break;
            }
            case 7: {
                stringArray = n3 == 2 ? dateFormatSymbols.getWeekdays() : dateFormatSymbols.getShortWeekdays();
                break;
            }
            case 9: {
                stringArray = dateFormatSymbols.getAmPmStrings();
            }
        }
        return stringArray;
    }

    protected void complete() {
        if (!this.isTimeSet) {
            this.updateTime();
        }
        if (!this.areFieldsSet || !this.areAllFieldsSet) {
            this.computeFields();
            this.areFieldsSet = true;
            this.areAllFieldsSet = true;
        }
    }

    final boolean isExternallySet(int n) {
        return this.stamp[n] >= 2;
    }

    final int getSetStateFields() {
        int n = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.stamp[i] == 0) continue;
            n |= 1 << i;
        }
        return n;
    }

    final void setFieldsComputed(int n) {
        if (n == 131071) {
            for (int i = 0; i < this.fields.length; ++i) {
                this.stamp[i] = 1;
                this.isSet[i] = true;
            }
            this.areAllFieldsSet = true;
            this.areFieldsSet = true;
        } else {
            for (int i = 0; i < this.fields.length; ++i) {
                if ((n & 1) == 1) {
                    this.stamp[i] = 1;
                    this.isSet[i] = true;
                } else if (this.areAllFieldsSet && !this.isSet[i]) {
                    this.areAllFieldsSet = false;
                }
                n >>>= 1;
            }
        }
    }

    final void setFieldsNormalized(int n) {
        if (n != 131071) {
            for (int i = 0; i < this.fields.length; ++i) {
                if ((n & 1) == 0) {
                    this.fields[i] = 0;
                    this.stamp[i] = 0;
                    this.isSet[i] = false;
                }
                n >>= 1;
            }
        }
        this.areFieldsSet = true;
        this.areAllFieldsSet = false;
    }

    final boolean isPartiallyNormalized() {
        return this.areFieldsSet && !this.areAllFieldsSet;
    }

    final boolean isFullyNormalized() {
        return this.areFieldsSet && this.areAllFieldsSet;
    }

    final void setUnnormalized() {
        this.areAllFieldsSet = false;
        this.areFieldsSet = false;
    }

    static boolean isFieldSet(int n, int n2) {
        return (n & 1 << n2) != 0;
    }

    final int selectFields() {
        int n = 2;
        if (this.stamp[0] != 0) {
            n |= 1;
        }
        int n2 = this.stamp[7];
        int n3 = this.stamp[2];
        int n4 = this.stamp[5];
        int n5 = Calendar.aggregateStamp(this.stamp[4], n2);
        int n6 = Calendar.aggregateStamp(this.stamp[8], n2);
        int n7 = this.stamp[6];
        int n8 = Calendar.aggregateStamp(this.stamp[3], n2);
        int n9 = n4;
        if (n5 > n9) {
            n9 = n5;
        }
        if (n6 > n9) {
            n9 = n6;
        }
        if (n7 > n9) {
            n9 = n7;
        }
        if (n8 > n9) {
            n9 = n8;
        }
        if (n9 == 0) {
            n5 = this.stamp[4];
            n6 = Math.max(this.stamp[8], n2);
            n8 = this.stamp[3];
            n9 = Math.max(Math.max(n5, n6), n8);
            if (n9 == 0) {
                n9 = n4 = n3;
            }
        }
        if (n9 == n4 || n9 == n5 && this.stamp[4] >= this.stamp[3] || n9 == n6 && this.stamp[8] >= this.stamp[3]) {
            n |= 4;
            if (n9 == n4) {
                n |= 0x20;
            } else {
                assert (n9 == n5 || n9 == n6);
                if (n2 != 0) {
                    n |= 0x80;
                }
                if (n5 == n6) {
                    n = this.stamp[4] >= this.stamp[8] ? (n |= 0x10) : (n |= 0x100);
                } else if (n9 == n5) {
                    n |= 0x10;
                } else {
                    assert (n9 == n6);
                    if (this.stamp[8] != 0) {
                        n |= 0x100;
                    }
                }
            }
        } else {
            assert (n9 == n7 || n9 == n8 || n9 == 0);
            if (n9 == n7) {
                n |= 0x40;
            } else {
                assert (n9 == n8);
                if (n2 != 0) {
                    n |= 0x80;
                }
                n |= 8;
            }
        }
        int n10 = this.stamp[11];
        int n11 = Calendar.aggregateStamp(this.stamp[10], this.stamp[9]);
        int n12 = n9 = n11 > n10 ? n11 : n10;
        if (n9 == 0) {
            n9 = Math.max(this.stamp[10], this.stamp[9]);
        }
        if (n9 != 0) {
            if (n9 == n10) {
                n |= 0x800;
            } else {
                n |= 0x400;
                if (this.stamp[9] != 0) {
                    n |= 0x200;
                }
            }
        }
        if (this.stamp[12] != 0) {
            n |= 0x1000;
        }
        if (this.stamp[13] != 0) {
            n |= 0x2000;
        }
        if (this.stamp[14] != 0) {
            n |= 0x4000;
        }
        if (this.stamp[15] >= 2) {
            n |= 0x8000;
        }
        if (this.stamp[16] >= 2) {
            n |= 0x10000;
        }
        return n;
    }

    int getBaseStyle(int n) {
        return n & 0xFFFF7FFF;
    }

    boolean isStandaloneStyle(int n) {
        return (n & 0x8000) != 0;
    }

    boolean isNarrowStyle(int n) {
        return n == 4 || n == 32772;
    }

    private static int aggregateStamp(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return 0;
        }
        return n > n2 ? n : n2;
    }

    public static Set<String> getAvailableCalendarTypes() {
        return AvailableCalendarTypes.access$000();
    }

    public String getCalendarType() {
        return this.getClass().getName();
    }

    @Pure
    public boolean equals(@ReadOnly Calendar this, @Nullable @ReadOnly Object object) {
        if (this == object) {
            return true;
        }
        try {
            Calendar calendar = (Calendar)object;
            return this.compareTo(Calendar.getMillisOf(calendar)) == 0 && this.lenient == calendar.lenient && this.firstDayOfWeek == calendar.firstDayOfWeek && this.minimalDaysInFirstWeek == calendar.minimalDaysInFirstWeek && this.zone.equals(calendar.zone);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Pure
    public int hashCode(@ReadOnly Calendar this) {
        int n = (this.lenient ? 1 : 0) | this.firstDayOfWeek << 1 | this.minimalDaysInFirstWeek << 4 | this.zone.hashCode() << 7;
        long l = Calendar.getMillisOf(this);
        return (int)l ^ (int)(l >> 32) ^ n;
    }

    public boolean before(@ReadOnly Calendar this, Object object) {
        return object instanceof Calendar && this.compareTo((Calendar)object) < 0;
    }

    public boolean after(@ReadOnly Calendar this, Object object) {
        return object instanceof Calendar && this.compareTo((Calendar)object) > 0;
    }

    @Override
    @Pure
    public int compareTo(@ReadOnly Calendar this, @ReadOnly Calendar calendar) {
        return this.compareTo(Calendar.getMillisOf(calendar));
    }

    public abstract void add(@Mutable Calendar this, int var1, int var2);

    public abstract void roll(int var1, boolean var2);

    public void roll(int n, int n2) {
        while (n2 > 0) {
            this.roll(n, true);
            --n2;
        }
        while (n2 < 0) {
            this.roll(n, false);
            ++n2;
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        this.zone = timeZone;
        this.sharedZone = false;
        this.areFieldsSet = false;
        this.areAllFieldsSet = false;
    }

    public TimeZone getTimeZone() {
        if (this.sharedZone) {
            this.zone = (TimeZone)this.zone.clone();
            this.sharedZone = false;
        }
        return this.zone;
    }

    TimeZone getZone() {
        return this.zone;
    }

    void setZoneShared(boolean bl) {
        this.sharedZone = bl;
    }

    public void setLenient(boolean bl) {
        this.lenient = bl;
    }

    @Pure
    public boolean isLenient() {
        return this.lenient;
    }

    public void setFirstDayOfWeek(int n) {
        if (this.firstDayOfWeek == n) {
            return;
        }
        this.firstDayOfWeek = n;
        this.invalidateWeekFields();
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setMinimalDaysInFirstWeek(int n) {
        if (this.minimalDaysInFirstWeek == n) {
            return;
        }
        this.minimalDaysInFirstWeek = n;
        this.invalidateWeekFields();
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek;
    }

    public boolean isWeekDateSupported() {
        return false;
    }

    public int getWeekYear() {
        throw new UnsupportedOperationException();
    }

    public void setWeekDate(int n, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    public int getWeeksInWeekYear() {
        throw new UnsupportedOperationException();
    }

    public abstract int getMinimum(int var1);

    public abstract int getMaximum(int var1);

    public abstract int getGreatestMinimum(int var1);

    public abstract int getLeastMaximum(int var1);

    public int getActualMinimum(int n) {
        int n2;
        int n3 = this.getGreatestMinimum(n);
        if (n3 == (n2 = this.getMinimum(n))) {
            return n3;
        }
        Calendar calendar = (Calendar)this.clone();
        calendar.setLenient(true);
        int n4 = n3;
        do {
            calendar.set(n, n3);
            if (calendar.get(n) != n3) break;
            n4 = n3--;
        } while (n3 >= n2);
        return n4;
    }

    public int getActualMaximum(int n) {
        int n2;
        int n3 = this.getLeastMaximum(n);
        if (n3 == (n2 = this.getMaximum(n))) {
            return n3;
        }
        Calendar calendar = (Calendar)this.clone();
        calendar.setLenient(true);
        if (n == 3 || n == 4) {
            calendar.set(7, this.firstDayOfWeek);
        }
        int n4 = n3;
        do {
            calendar.set(n, n3);
            if (calendar.get(n) != n3) break;
            n4 = n3++;
        } while (n3 <= n2);
        return n4;
    }

    @SideEffectFree
    public @I(value="N") Object clone() {
        try {
            Calendar calendar = (Calendar)super.clone();
            calendar.fields = new int[17];
            calendar.isSet = new boolean[17];
            calendar.stamp = new int[17];
            for (int i = 0; i < 17; ++i) {
                calendar.fields[i] = this.fields[i];
                calendar.stamp[i] = this.stamp[i];
                calendar.isSet[i] = this.isSet[i];
            }
            calendar.zone = (TimeZone)this.zone.clone();
            return calendar;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }

    static String getFieldName(int n) {
        return FIELD_NAME[n];
    }

    @SideEffectFree
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(800);
        stringBuilder.append(this.getClass().getName()).append('[');
        Calendar.appendValue(stringBuilder, "time", this.isTimeSet, this.time);
        stringBuilder.append(",areFieldsSet=").append(this.areFieldsSet);
        stringBuilder.append(",areAllFieldsSet=").append(this.areAllFieldsSet);
        stringBuilder.append(",lenient=").append(this.lenient);
        stringBuilder.append(",zone=").append(this.zone);
        Calendar.appendValue(stringBuilder, ",firstDayOfWeek", true, this.firstDayOfWeek);
        Calendar.appendValue(stringBuilder, ",minimalDaysInFirstWeek", true, this.minimalDaysInFirstWeek);
        for (int i = 0; i < 17; ++i) {
            stringBuilder.append(',');
            Calendar.appendValue(stringBuilder, FIELD_NAME[i], this.isSet(i), this.fields[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static void appendValue(StringBuilder stringBuilder, String string, boolean bl, long l) {
        stringBuilder.append(string).append('=');
        if (bl) {
            stringBuilder.append(l);
        } else {
            stringBuilder.append('?');
        }
    }

    private void setWeekCountData(Locale locale) {
        int[] nArray = (int[])cachedLocaleData.get(locale);
        if (nArray == null) {
            nArray = new int[]{CalendarDataUtility.retrieveFirstDayOfWeek(locale), CalendarDataUtility.retrieveMinimalDaysInFirstWeek(locale)};
            cachedLocaleData.putIfAbsent(locale, nArray);
        }
        this.firstDayOfWeek = nArray[0];
        this.minimalDaysInFirstWeek = nArray[1];
    }

    private void updateTime() {
        this.computeTime();
        this.isTimeSet = true;
    }

    @Override
    private int compareTo(long l) {
        long l2 = Calendar.getMillisOf(this);
        return l2 > l ? 1 : (l2 == l ? 0 : -1);
    }

    private static long getMillisOf(Calendar calendar) {
        if (calendar.isTimeSet) {
            return calendar.time;
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.setLenient(true);
        return calendar2.getTimeInMillis();
    }

    private void adjustStamp() {
        int n;
        int n2 = 2;
        int n3 = 2;
        do {
            int n4;
            n = Integer.MAX_VALUE;
            for (n4 = 0; n4 < this.stamp.length; ++n4) {
                int n5 = this.stamp[n4];
                if (n5 >= n3 && n > n5) {
                    n = n5;
                }
                if (n2 >= n5) continue;
                n2 = n5;
            }
            if (n2 != n && n == Integer.MAX_VALUE) break;
            for (n4 = 0; n4 < this.stamp.length; ++n4) {
                if (this.stamp[n4] != n) continue;
                this.stamp[n4] = n3;
            }
            ++n3;
        } while (n != n2);
        this.nextStamp = n3;
    }

    private void invalidateWeekFields() {
        int n;
        if (this.stamp[4] != 1 && this.stamp[3] != 1) {
            return;
        }
        Calendar calendar = (Calendar)this.clone();
        calendar.setLenient(true);
        calendar.clear(4);
        calendar.clear(3);
        if (this.stamp[4] == 1 && this.fields[4] != (n = calendar.get(4))) {
            this.fields[4] = n;
        }
        if (this.stamp[3] == 1 && this.fields[3] != (n = calendar.get(3))) {
            this.fields[3] = n;
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (!this.isTimeSet) {
            try {
                this.updateTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        TimeZone timeZone = null;
        if (this.zone instanceof ZoneInfo) {
            SimpleTimeZone simpleTimeZone = ((ZoneInfo)this.zone).getLastRuleInstance();
            if (simpleTimeZone == null) {
                simpleTimeZone = new SimpleTimeZone(this.zone.getRawOffset(), this.zone.getID());
            }
            timeZone = this.zone;
            this.zone = simpleTimeZone;
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(timeZone);
        if (timeZone != null) {
            this.zone = timeZone;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string;
        Serializable serializable;
        ZoneInfo zoneInfo;
        block13: {
            final ObjectInputStream objectInputStream2 = objectInputStream;
            objectInputStream2.defaultReadObject();
            this.stamp = new int[17];
            if (this.serialVersionOnStream >= 2) {
                this.isTimeSet = true;
                if (this.fields == null) {
                    this.fields = new int[17];
                }
                if (this.isSet == null) {
                    this.isSet = new boolean[17];
                }
            } else if (this.serialVersionOnStream >= 0) {
                for (int i = 0; i < 17; ++i) {
                    this.stamp[i] = this.isSet[i] ? 1 : 0;
                }
            }
            this.serialVersionOnStream = 1;
            zoneInfo = null;
            try {
                zoneInfo = AccessController.doPrivileged(new PrivilegedExceptionAction<ZoneInfo>(this){

                    @Override
                    public ZoneInfo run() throws Exception {
                        return (ZoneInfo)objectInputStream2.readObject();
                    }
                }, CalendarAccessControlContext.access$100());
            }
            catch (PrivilegedActionException privilegedActionException) {
                serializable = privilegedActionException.getException();
                if (serializable instanceof OptionalDataException) break block13;
                if (serializable instanceof RuntimeException) {
                    throw (RuntimeException)serializable;
                }
                if (serializable instanceof IOException) {
                    throw (IOException)serializable;
                }
                if (serializable instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)serializable;
                }
                throw new RuntimeException((Throwable)serializable);
            }
        }
        if (zoneInfo != null) {
            this.zone = zoneInfo;
        }
        if (this.zone instanceof SimpleTimeZone && (serializable = TimeZone.getTimeZone(string = this.zone.getID())) != null && ((TimeZone)serializable).hasSameRules(this.zone) && ((TimeZone)serializable).getID().equals(string)) {
            this.zone = serializable;
        }
    }

    public final Instant toInstant() {
        return Instant.ofEpochMilli(this.getTimeInMillis());
    }

    private static class AvailableCalendarTypes {
        private static final Set<String> SET = Set.of((Object)"gregory", (Object)"buddhist", (Object)"japanese");

        private AvailableCalendarTypes() {
        }
    }

    public static class Builder {
        private static final int NFIELDS = 18;
        private static final int WEEK_YEAR = 17;
        private long instant;
        private int[] fields;
        private int nextStamp;
        private int maxFieldIndex;
        private String type;
        private TimeZone zone;
        private boolean lenient = true;
        private Locale locale;
        private int firstDayOfWeek;
        private int minimalDaysInFirstWeek;

        public Builder setInstant(long instant) {
            if (this.fields != null) {
                throw new IllegalStateException();
            }
            this.instant = instant;
            this.nextStamp = 1;
            return this;
        }

        public Builder setInstant(Date instant) {
            return this.setInstant(instant.getTime());
        }

        public Builder set(int field, int value) {
            if (field < 0 || field >= 17) {
                throw new IllegalArgumentException("field is invalid");
            }
            if (this.isInstantSet()) {
                throw new IllegalStateException("instant has been set");
            }
            this.allocateFields();
            this.internalSet(field, value);
            return this;
        }

        public Builder setFields(int ... fieldValuePairs) {
            int len = fieldValuePairs.length;
            if (len % 2 != 0) {
                throw new IllegalArgumentException();
            }
            if (this.isInstantSet()) {
                throw new IllegalStateException("instant has been set");
            }
            if (this.nextStamp + len / 2 < 0) {
                throw new IllegalStateException("stamp counter overflow");
            }
            this.allocateFields();
            int i = 0;
            while (i < len) {
                int field;
                if ((field = fieldValuePairs[i++]) < 0 || field >= 17) {
                    throw new IllegalArgumentException("field is invalid");
                }
                this.internalSet(field, fieldValuePairs[i++]);
            }
            return this;
        }

        public Builder setDate(int year, int month, int dayOfMonth) {
            return this.setFields(1, year, 2, month, 5, dayOfMonth);
        }

        public Builder setTimeOfDay(int hourOfDay, int minute, int second) {
            return this.setTimeOfDay(hourOfDay, minute, second, 0);
        }

        public Builder setTimeOfDay(int hourOfDay, int minute, int second, int millis) {
            return this.setFields(11, hourOfDay, 12, minute, 13, second, 14, millis);
        }

        public Builder setWeekDate(int weekYear, int weekOfYear, int dayOfWeek) {
            this.allocateFields();
            this.internalSet(17, weekYear);
            this.internalSet(3, weekOfYear);
            this.internalSet(7, dayOfWeek);
            return this;
        }

        public Builder setTimeZone(TimeZone zone) {
            if (zone == null) {
                throw new NullPointerException();
            }
            this.zone = zone;
            return this;
        }

        public Builder setLenient(boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        public Builder setCalendarType(String type) {
            if (type.equals("gregorian")) {
                type = "gregory";
            }
            if (!Calendar.getAvailableCalendarTypes().contains(type) && !type.equals("iso8601")) {
                throw new IllegalArgumentException("unknown calendar type: " + type);
            }
            if (this.type == null) {
                this.type = type;
            } else if (!this.type.equals(type)) {
                throw new IllegalStateException("calendar type override");
            }
            return this;
        }

        public Builder setLocale(Locale locale) {
            if (locale == null) {
                throw new NullPointerException();
            }
            this.locale = locale;
            return this;
        }

        public Builder setWeekDefinition(int firstDayOfWeek, int minimalDaysInFirstWeek) {
            if (!this.isValidWeekParameter(firstDayOfWeek) || !this.isValidWeekParameter(minimalDaysInFirstWeek)) {
                throw new IllegalArgumentException();
            }
            this.firstDayOfWeek = firstDayOfWeek;
            this.minimalDaysInFirstWeek = minimalDaysInFirstWeek;
            return this;
        }

        public Calendar build() {
            if (this.locale == null) {
                this.locale = Locale.getDefault();
            }
            if (this.zone == null) {
                this.zone = Calendar.defaultTimeZone((Locale)this.locale);
            }
            if (this.type == null) {
                this.type = this.locale.getUnicodeLocaleType("ca");
            }
            if (this.type == null) {
                this.type = this.locale.getCountry() == "TH" && this.locale.getLanguage() == "th" ? "buddhist" : "gregory";
            }
            Calendar cal = switch (this.type) {
                case "gregory" -> new GregorianCalendar(this.zone, this.locale, true);
                case "iso8601" -> {
                    GregorianCalendar gcal = new GregorianCalendar(this.zone, this.locale, true);
                    gcal.setGregorianChange(new Date(Long.MIN_VALUE));
                    this.setWeekDefinition(2, 4);
                    yield gcal;
                }
                case "buddhist" -> {
                    BuddhistCalendar buddhistCalendar = new BuddhistCalendar(this.zone, this.locale);
                    buddhistCalendar.clear();
                    yield buddhistCalendar;
                }
                case "japanese" -> new JapaneseImperialCalendar(this.zone, this.locale, true);
                default -> throw new IllegalArgumentException("unknown calendar type: " + this.type);
            };
            cal.setLenient(this.lenient);
            if (this.firstDayOfWeek != 0) {
                cal.setFirstDayOfWeek(this.firstDayOfWeek);
                cal.setMinimalDaysInFirstWeek(this.minimalDaysInFirstWeek);
            }
            if (this.isInstantSet()) {
                cal.setTimeInMillis(this.instant);
                cal.complete();
                return cal;
            }
            if (this.fields != null) {
                boolean weekDate;
                boolean bl = weekDate = this.isSet(17) && this.fields[17] > this.fields[1];
                if (weekDate && !cal.isWeekDateSupported()) {
                    throw new IllegalArgumentException("week date is unsupported by " + this.type);
                }
                block12: for (int stamp = 2; stamp < this.nextStamp; ++stamp) {
                    for (int index = 0; index <= this.maxFieldIndex; ++index) {
                        if (this.fields[index] != stamp) continue;
                        cal.set(index, this.fields[18 + index]);
                        continue block12;
                    }
                }
                if (weekDate) {
                    int weekOfYear = this.isSet(3) ? this.fields[21] : 1;
                    int dayOfWeek = this.isSet(7) ? this.fields[25] : cal.getFirstDayOfWeek();
                    cal.setWeekDate(this.fields[35], weekOfYear, dayOfWeek);
                }
                cal.complete();
            }
            return cal;
        }

        private void allocateFields() {
            if (this.fields == null) {
                this.fields = new int[36];
                this.nextStamp = 2;
                this.maxFieldIndex = -1;
            }
        }

        private void internalSet(int field, int value) {
            ++this.nextStamp;
            if (this.nextStamp < 0) {
                throw new IllegalStateException("stamp counter overflow");
            }
            this.fields[18 + field] = value;
            if (field > this.maxFieldIndex && field < 17) {
                this.maxFieldIndex = field;
            }
        }

        private boolean isInstantSet() {
            return this.nextStamp == 1;
        }

        private boolean isSet(int index) {
            return this.fields != null && this.fields[index] > 0;
        }

        private boolean isValidWeekParameter(int value) {
            return value > 0 && value <= 7;
        }
    }

    private static class CalendarAccessControlContext {
        private static final AccessControlContext INSTANCE;

        private CalendarAccessControlContext() {
        }

        static {
            RuntimePermission perm = new RuntimePermission("accessClassInPackage.sun.util.calendar");
            PermissionCollection perms = perm.newPermissionCollection();
            perms.add(perm);
            INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        }
    }
}

