/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.ReferenceQueue;
import org.checkerframework.dataflow.qual.SideEffectFree;
import sun.misc.Cleaner;

public abstract class Reference<T> {
    private T referent;
    volatile ReferenceQueue<? super T> queue;
    Reference next;
    private transient Reference<T> discovered;
    private static Lock lock = new Lock();
    private static Reference<Object> pending = null;

    @SideEffectFree
    public T get() {
        return this.referent;
    }

    public void clear() {
        this.referent = null;
    }

    public boolean isEnqueued() {
        return this.queue == ReferenceQueue.ENQUEUED;
    }

    public boolean enqueue() {
        return this.queue.enqueue(this);
    }

    Reference(T t) {
        this(t, null);
    }

    Reference(T t, ReferenceQueue<? super T> referenceQueue) {
        this.referent = t;
        this.queue = referenceQueue == null ? ReferenceQueue.NULL : referenceQueue;
    }

    static {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Object object = threadGroup;
        while (object != null) {
            threadGroup = object;
            object = threadGroup.getParent();
        }
        object = new ReferenceHandler(threadGroup, "Reference Handler");
        ((Thread)object).setPriority(10);
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }

    private static class Lock {
        private Lock() {
        }
    }

    private static class ReferenceHandler
    extends Thread {
        ReferenceHandler(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Reference reference;
                ReferenceQueue referenceQueue = lock;
                synchronized (referenceQueue) {
                    if (pending == null) {
                        try {
                            try {
                                lock.wait();
                            }
                            catch (OutOfMemoryError outOfMemoryError) {}
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    reference = pending;
                    pending = reference.discovered;
                    reference.discovered = null;
                }
                if (reference instanceof Cleaner) {
                    ((Cleaner)reference).clean();
                    continue;
                }
                referenceQueue = reference.queue;
                if (referenceQueue == ReferenceQueue.NULL) continue;
                referenceQueue.enqueue(reference);
            }
        }
    }
}

