/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Arrays;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class StringBuffer
extends AbstractStringBuilder
implements Serializable,
CharSequence {
    private transient char[] toStringCache;
    static final long serialVersionUID = 3388685877147921107L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("value", char[].class), new ObjectStreamField("count", Integer.TYPE), new ObjectStreamField("shared", Boolean.TYPE)};

    public StringBuffer() {
        super(16);
    }

    public StringBuffer(int n) {
        super(n);
    }

    public StringBuffer(String string) {
        super(string.length() + 16);
        this.append(string);
    }

    public StringBuffer(@ReadOnly CharSequence charSequence) {
        this(charSequence.length() + 16);
        this.append(charSequence);
    }

    @Override
    @Pure
    public synchronized int length(@ReadOnly StringBuffer this) {
        return this.count;
    }

    @Override
    public synchronized int capacity(@ReadOnly StringBuffer this) {
        return this.value.length;
    }

    @Override
    public synchronized void ensureCapacity(int n) {
        if (n > this.value.length) {
            this.expandCapacity(n);
        }
    }

    @Override
    public synchronized void trimToSize() {
        super.trimToSize();
    }

    @Override
    public synchronized void setLength(int n) {
        this.toStringCache = null;
        super.setLength(n);
    }

    @Override
    public synchronized char charAt(@ReadOnly StringBuffer this, int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n];
    }

    @Override
    public synchronized int codePointAt(@ReadOnly StringBuffer this, int n) {
        return super.codePointAt(n);
    }

    @Override
    public synchronized int codePointBefore(@ReadOnly StringBuffer this, int n) {
        return super.codePointBefore(n);
    }

    @Override
    public synchronized int codePointCount(@ReadOnly StringBuffer this, int n, int n2) {
        return super.codePointCount(n, n2);
    }

    @Override
    public synchronized int offsetByCodePoints(@ReadOnly StringBuffer this, int n, int n2) {
        return super.offsetByCodePoints(n, n2);
    }

    @Override
    public synchronized void getChars(@ReadOnly StringBuffer this, int n, int n2, char[] cArray, int n3) {
        super.getChars(n, n2, cArray, n3);
    }

    @Override
    public synchronized void setCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.toStringCache = null;
        this.value[n] = c;
    }

    @Override
    public synchronized StringBuffer append(@Nullable @ReadOnly Object object) {
        this.toStringCache = null;
        super.append(String.valueOf(object));
        return this;
    }

    @Override
    public synchronized StringBuffer append(@Nullable String string) {
        this.toStringCache = null;
        super.append(string);
        return this;
    }

    @Override
    public synchronized StringBuffer append(@Nullable @ReadOnly StringBuffer stringBuffer) {
        this.toStringCache = null;
        super.append(stringBuffer);
        return this;
    }

    @Override
    synchronized StringBuffer append(AbstractStringBuilder abstractStringBuilder) {
        this.toStringCache = null;
        super.append(abstractStringBuilder);
        return this;
    }

    @Override
    public synchronized StringBuffer append(@Nullable @ReadOnly CharSequence charSequence) {
        this.toStringCache = null;
        super.append(charSequence);
        return this;
    }

    @Override
    public synchronized StringBuffer append(@Nullable @ReadOnly CharSequence charSequence, int n, int n2) {
        this.toStringCache = null;
        super.append(charSequence, n, n2);
        return this;
    }

    @Override
    public synchronized StringBuffer append(char @ReadOnly [] cArray) {
        this.toStringCache = null;
        super.append(cArray);
        return this;
    }

    @Override
    public synchronized StringBuffer append(char @ReadOnly [] cArray, int n, int n2) {
        this.toStringCache = null;
        super.append(cArray, n, n2);
        return this;
    }

    @Override
    public synchronized StringBuffer append(boolean bl) {
        this.toStringCache = null;
        super.append(bl);
        return this;
    }

    @Override
    public synchronized StringBuffer append(char c) {
        this.toStringCache = null;
        super.append(c);
        return this;
    }

    @Override
    public synchronized StringBuffer append(int n) {
        this.toStringCache = null;
        super.append(n);
        return this;
    }

    @Override
    public synchronized StringBuffer appendCodePoint(int n) {
        this.toStringCache = null;
        super.appendCodePoint(n);
        return this;
    }

    @Override
    public synchronized StringBuffer append(long l) {
        this.toStringCache = null;
        super.append(l);
        return this;
    }

    @Override
    public synchronized StringBuffer append(float f) {
        this.toStringCache = null;
        super.append(f);
        return this;
    }

    @Override
    public synchronized StringBuffer append(double d) {
        this.toStringCache = null;
        super.append(d);
        return this;
    }

    @Override
    public synchronized StringBuffer delete(int n, int n2) {
        this.toStringCache = null;
        super.delete(n, n2);
        return this;
    }

    @Override
    public synchronized StringBuffer deleteCharAt(int n) {
        this.toStringCache = null;
        super.deleteCharAt(n);
        return this;
    }

    @Override
    public synchronized StringBuffer replace(int n, int n2, String string) {
        this.toStringCache = null;
        super.replace(n, n2, string);
        return this;
    }

    @Override
    public synchronized String substring(@ReadOnly StringBuffer this, int n) {
        return this.substring(n, this.count);
    }

    @Override
    public synchronized @ReadOnly CharSequence subSequence(@ReadOnly StringBuffer this, int n, int n2) {
        return super.substring(n, n2);
    }

    @Override
    public synchronized String substring(@ReadOnly StringBuffer this, int n, int n2) {
        return super.substring(n, n2);
    }

    @Override
    public synchronized StringBuffer insert(int n, char @ReadOnly [] cArray, int n2, int n3) {
        this.toStringCache = null;
        super.insert(n, cArray, n2, n3);
        return this;
    }

    @Override
    public synchronized StringBuffer insert(int n, @Nullable @ReadOnly Object object) {
        this.toStringCache = null;
        super.insert(n, String.valueOf(object));
        return this;
    }

    @Override
    public synchronized StringBuffer insert(int n, @Nullable String string) {
        this.toStringCache = null;
        super.insert(n, string);
        return this;
    }

    @Override
    public synchronized StringBuffer insert(int n, char @ReadOnly [] cArray) {
        this.toStringCache = null;
        super.insert(n, cArray);
        return this;
    }

    @Override
    public StringBuffer insert(int n, @Nullable @ReadOnly CharSequence charSequence) {
        super.insert(n, charSequence);
        return this;
    }

    @Override
    public synchronized StringBuffer insert(int n, @Nullable @ReadOnly CharSequence charSequence, int n2, int n3) {
        this.toStringCache = null;
        super.insert(n, charSequence, n2, n3);
        return this;
    }

    @Override
    public StringBuffer insert(int n, boolean bl) {
        super.insert(n, bl);
        return this;
    }

    @Override
    public synchronized StringBuffer insert(int n, char c) {
        this.toStringCache = null;
        super.insert(n, c);
        return this;
    }

    @Override
    public StringBuffer insert(int n, int n2) {
        super.insert(n, n2);
        return this;
    }

    @Override
    public StringBuffer insert(int n, long l) {
        super.insert(n, l);
        return this;
    }

    @Override
    public StringBuffer insert(int n, float f) {
        super.insert(n, f);
        return this;
    }

    @Override
    public StringBuffer insert(int n, double d) {
        super.insert(n, d);
        return this;
    }

    @Override
    @Pure
    public int indexOf(@ReadOnly StringBuffer this, String string) {
        return super.indexOf(string);
    }

    @Override
    @Pure
    public synchronized int indexOf(@ReadOnly StringBuffer this, String string, int n) {
        return super.indexOf(string, n);
    }

    @Override
    @Pure
    public int lastIndexOf(@ReadOnly StringBuffer this, String string) {
        return this.lastIndexOf(string, this.count);
    }

    @Override
    @Pure
    public synchronized int lastIndexOf(@ReadOnly StringBuffer this, String string, int n) {
        return super.lastIndexOf(string, n);
    }

    @Override
    public synchronized StringBuffer reverse() {
        this.toStringCache = null;
        super.reverse();
        return this;
    }

    @Override
    @SideEffectFree
    public synchronized String toString(@ReadOnly StringBuffer this) {
        if (this.toStringCache == null) {
            this.toStringCache = Arrays.copyOfRange(this.value, 0, this.count);
        }
        return new String(this.toStringCache, true);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("value", this.value);
        putField.put("count", this.count);
        putField.put("shared", false);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.value = (char[])getField.get("value", null);
        this.count = getField.get("count", 0);
    }
}

