/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@ReadOnly
public final class Short
extends Number
implements Comparable<Short> {
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final Class<Short> TYPE = Class.getPrimitiveClass("short");
    private final short value;
    public static final int SIZE = 16;
    public static final int BYTES = 2;
    private static final long serialVersionUID = 7515723908773894738L;

    @SideEffectFree
    public static String toString(short s) {
        return Integer.toString(s, 10);
    }

    @Pure
    public static short parseShort(String string, int n) throws NumberFormatException {
        int n2 = Integer.parseInt(string, n);
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw new NumberFormatException("Value out of range. Value:\"" + string + "\" Radix:" + n);
        }
        return (short)n2;
    }

    @Pure
    public static short parseShort(String string) throws NumberFormatException {
        return Short.parseShort(string, 10);
    }

    @SideEffectFree
    public static Short valueOf(String string, int n) throws NumberFormatException {
        return Short.parseShort(string, n);
    }

    @SideEffectFree
    public static Short valueOf(String string) throws NumberFormatException {
        return Short.valueOf(string, 10);
    }

    @SideEffectFree
    public static Short valueOf(short s) {
        short s2 = s;
        if (s2 >= -128 && s2 <= 127) {
            return ShortCache.cache[s2 + 128];
        }
        return new Short(s);
    }

    @SideEffectFree
    public static Short decode(String string) throws NumberFormatException {
        int n = Integer.decode(string);
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new NumberFormatException("Value " + n + " out of range from input " + string);
        }
        return (short)n;
    }

    @SideEffectFree
    public Short(short s) {
        this.value = s;
    }

    @SideEffectFree
    public Short(String string) throws NumberFormatException {
        this.value = Short.parseShort(string, 10);
    }

    @Override
    @Pure
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    @Pure
    public short shortValue() {
        return this.value;
    }

    @Override
    @Pure
    public int intValue() {
        return this.value;
    }

    @Override
    @Pure
    public long longValue() {
        return this.value;
    }

    @Override
    @Pure
    public float floatValue() {
        return this.value;
    }

    @Override
    @Pure
    public double doubleValue() {
        return this.value;
    }

    @SideEffectFree
    public String toString() {
        return Integer.toString(this.value);
    }

    @Pure
    public int hashCode() {
        return Short.hashCode(this.value);
    }

    public static int hashCode(short s) {
        return s;
    }

    @Pure
    public boolean equals(@Nullable @ReadOnly Object object) {
        if (object instanceof Short) {
            return this.value == (Short)object;
        }
        return false;
    }

    @Override
    @Pure
    public int compareTo(Short s) {
        return Short.compare(this.value, s.value);
    }

    public static int compare(short s, short s2) {
        return s - s2;
    }

    @Pure
    public static short reverseBytes(short s) {
        return (short)((s & 0xFF00) >> 8 | s << 8);
    }

    public static int toUnsignedInt(short s) {
        return s & 0xFFFF;
    }

    public static long toUnsignedLong(short s) {
        return (long)s & 0xFFFFL;
    }

    private static class ShortCache {
        static final Short[] cache = new Short[256];

        private ShortCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                ShortCache.cache[i] = new Short((short)(i - 128));
            }
        }
    }
}

