/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@ReadOnly
public final class Byte
extends Number
implements Comparable<Byte> {
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    public static final Class<Byte> TYPE = Class.getPrimitiveClass("byte");
    private final byte value;
    public static final int SIZE = 8;
    public static final int BYTES = 1;
    private static final long serialVersionUID = -7183698231559129828L;

    @SideEffectFree
    public static String toString(byte by) {
        return Integer.toString(by, 10);
    }

    @Pure
    public static Byte valueOf(byte by) {
        return ByteCache.cache[by + 128];
    }

    @Pure
    public static byte parseByte(String string, int n) throws NumberFormatException {
        int n2 = Integer.parseInt(string, n);
        if (n2 < -128 || n2 > 127) {
            throw new NumberFormatException("Value out of range. Value:\"" + string + "\" Radix:" + n);
        }
        return (byte)n2;
    }

    @Pure
    public static byte parseByte(String string) throws NumberFormatException {
        return Byte.parseByte(string, 10);
    }

    @Pure
    public static Byte valueOf(String string, int n) throws NumberFormatException {
        return Byte.parseByte(string, n);
    }

    @Pure
    public static Byte valueOf(String string) throws NumberFormatException {
        return Byte.valueOf(string, 10);
    }

    @Pure
    public static Byte decode(String string) throws NumberFormatException {
        int n = Integer.decode(string);
        if (n < -128 || n > 127) {
            throw new NumberFormatException("Value " + n + " out of range from input " + string);
        }
        return (byte)n;
    }

    public Byte(byte by) {
        this.value = by;
    }

    public Byte(String string) throws NumberFormatException {
        this.value = Byte.parseByte(string, 10);
    }

    @Override
    @Pure
    public byte byteValue() {
        return this.value;
    }

    @Override
    @Pure
    public short shortValue() {
        return this.value;
    }

    @Override
    @Pure
    public int intValue() {
        return this.value;
    }

    @Override
    @Pure
    public long longValue() {
        return this.value;
    }

    @Override
    @Pure
    public float floatValue() {
        return this.value;
    }

    @Override
    @Pure
    public double doubleValue() {
        return this.value;
    }

    @SideEffectFree
    public String toString() {
        return Integer.toString(this.value);
    }

    @Pure
    public int hashCode() {
        return Byte.hashCode(this.value);
    }

    public static int hashCode(byte by) {
        return by;
    }

    @Pure
    public boolean equals(@Nullable @ReadOnly Object object) {
        if (object instanceof Byte) {
            return this.value == (Byte)object;
        }
        return false;
    }

    @Override
    @Pure
    public int compareTo(Byte by) {
        return Byte.compare(this.value, by.value);
    }

    public static int compare(byte by, byte by2) {
        return by - by2;
    }

    public static int toUnsignedInt(byte by) {
        return by & 0xFF;
    }

    public static long toUnsignedLong(byte by) {
        return (long)by & 0xFFL;
    }

    private static class ByteCache {
        static final Byte[] cache = new Byte[256];

        private ByteCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                ByteCache.cache[i] = new Byte((byte)(i - 128));
            }
        }
    }
}

