/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class FilterOutputStream
extends OutputStream {
    protected OutputStream out;

    public FilterOutputStream(@Nullable OutputStream outputStream) {
        this.out = outputStream;
    }

    @Override
    public void write(int n) throws IOException {
        this.out.write(n);
    }

    @Override
    public void write(byte @ReadOnly [] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte @ReadOnly [] byArray, int n, int n2) throws IOException {
        if ((n | n2 | byArray.length - (n2 + n) | n + n2) < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[n + i]);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        try (OutputStream outputStream = this.out;){
            this.flush();
        }
    }
}

