/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DefaultFileSystem;
import java.io.DeleteOnExitHook;
import java.io.FileFilter;
import java.io.FileSystem;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.ArrayList;
import jdk.internal.util.StaticProperty;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.DefaultQualifier;
import sun.misc.Unsafe;

@DefaultQualifier(value=NonNull.class)
public class File
implements Serializable,
Comparable<File> {
    private static final FileSystem fs = DefaultFileSystem.getFileSystem();
    private final String path;
    private transient PathStatus status = null;
    private final transient int prefixLength;
    public static final char separatorChar = fs.getSeparator();
    public static final String separator = "" + separatorChar;
    public static final char pathSeparatorChar = fs.getPathSeparator();
    public static final String pathSeparator = "" + pathSeparatorChar;
    private static final long PATH_OFFSET;
    private static final long PREFIX_LENGTH_OFFSET;
    private static final Unsafe UNSAFE;
    private static final long serialVersionUID = 301077366599181567L;
    private volatile transient Path filePath;

    final boolean isInvalid() {
        if (this.status == null) {
            this.status = this.path.indexOf(0) < 0 ? PathStatus.CHECKED : PathStatus.INVALID;
        }
        return this.status == PathStatus.INVALID;
    }

    int getPrefixLength() {
        return this.prefixLength;
    }

    private File(String string, int n) {
        this.path = string;
        this.prefixLength = n;
    }

    private File(String string, File file) {
        assert (file.path != null);
        assert (!file.path.equals(""));
        this.path = fs.resolve(file.path, string);
        this.prefixLength = file.prefixLength;
    }

    public File(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.path = fs.normalize(string);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(@Nullable String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.path = string != null ? (string.equals("") ? fs.resolve(fs.getDefaultParent(), fs.normalize(string2)) : fs.resolve(fs.normalize(string), fs.normalize(string2))) : fs.normalize(string2);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public @PolyRead File(@Nullable @PolyRead File file, String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.path = file != null ? (file.path.equals("") ? fs.resolve(fs.getDefaultParent(), fs.normalize(string)) : fs.resolve(file.path, fs.normalize(string))) : fs.normalize(string);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(@ReadOnly URI uRI) {
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute");
        }
        if (uRI.isOpaque()) {
            throw new IllegalArgumentException("URI is not hierarchical");
        }
        String string = uRI.getScheme();
        if (string == null || !string.equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("URI scheme is not \"file\"");
        }
        if (uRI.getAuthority() != null) {
            throw new IllegalArgumentException("URI has an authority component");
        }
        if (uRI.getFragment() != null) {
            throw new IllegalArgumentException("URI has a fragment component");
        }
        if (uRI.getQuery() != null) {
            throw new IllegalArgumentException("URI has a query component");
        }
        String string2 = uRI.getPath();
        if (string2.equals("")) {
            throw new IllegalArgumentException("URI path component is empty");
        }
        string2 = fs.fromURIPath(string2);
        if (separatorChar != '/') {
            string2 = string2.replace('/', separatorChar);
        }
        this.path = fs.normalize(string2);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public String getName(@ReadOnly File this) {
        int n = this.path.lastIndexOf(separatorChar);
        if (n < this.prefixLength) {
            return this.path.substring(this.prefixLength);
        }
        return this.path.substring(n + 1);
    }

    @Pure
    public @Nullable String getParent(@ReadOnly File this) {
        int n = this.path.lastIndexOf(separatorChar);
        if (n < this.prefixLength) {
            if (this.prefixLength > 0 && this.path.length() > this.prefixLength) {
                return this.path.substring(0, this.prefixLength);
            }
            return null;
        }
        return this.path.substring(0, n);
    }

    @Pure
    public @Nullable @PolyRead File getParentFile(@PolyRead File this) {
        String string = this.getParent();
        if (string == null) {
            return null;
        }
        return new File(string, this.prefixLength);
    }

    public String getPath(@ReadOnly File this) {
        return this.path;
    }

    @Pure
    public boolean isAbsolute(@ReadOnly File this) {
        return fs.isAbsolute(this);
    }

    public String getAbsolutePath(@ReadOnly File this) {
        return fs.resolve(this);
    }

    public @PolyRead File getAbsoluteFile(@PolyRead File this) {
        String string = this.getAbsolutePath();
        return new File(string, fs.prefixLength(string));
    }

    public String getCanonicalPath(@ReadOnly File this) throws IOException {
        if (this.isInvalid()) {
            throw new IOException("Invalid file path");
        }
        return fs.canonicalize(fs.resolve(this));
    }

    public @PolyRead File getCanonicalFile(@PolyRead File this) throws IOException {
        String string = this.getCanonicalPath();
        return new File(string, fs.prefixLength(string));
    }

    private static String slashify(String string, boolean bl) {
        String string2 = string;
        if (separatorChar != '/') {
            string2 = string2.replace(separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (!string2.endsWith("/") && bl) {
            string2 = string2 + "/";
        }
        return string2;
    }

    @Deprecated
    @Deprecated
    public @PolyRead URL toURL(@PolyRead File this) throws MalformedURLException {
        if (this.isInvalid()) {
            throw new MalformedURLException("Invalid file path");
        }
        return new URL("file", "", File.slashify(this.getAbsolutePath(), this.isDirectory()));
    }

    public @PolyRead URI toURI(@PolyRead File this) {
        try {
            File file = this.getAbsoluteFile();
            String string = File.slashify(file.getPath(), file.isDirectory());
            if (string.startsWith("//")) {
                string = "//" + string;
            }
            return new URI("file", null, string, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new Error(uRISyntaxException);
        }
    }

    public boolean canRead(@ReadOnly File this) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.checkAccess(this, 4);
    }

    public boolean canWrite(@ReadOnly File this) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.checkAccess(this, 2);
    }

    public boolean exists(@ReadOnly File this) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return (fs.getBooleanAttributes(this) & 1) != 0;
    }

    @Pure
    public boolean isDirectory(@ReadOnly File this) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return (fs.getBooleanAttributes(this) & 4) != 0;
    }

    @Pure
    public boolean isFile(@ReadOnly File this) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return (fs.getBooleanAttributes(this) & 2) != 0;
    }

    @Pure
    public boolean isHidden(@ReadOnly File this) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return (fs.getBooleanAttributes(this) & 8) != 0;
    }

    public long lastModified(@ReadOnly File this) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return 0L;
        }
        return fs.getLastModifiedTime(this);
    }

    public long length(@ReadOnly File this) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return 0L;
        }
        return fs.getLength(this);
    }

    public boolean createNewFile() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        if (this.isInvalid()) {
            throw new IOException("Invalid file path");
        }
        return fs.createFileExclusively(this.path);
    }

    public boolean delete() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.delete(this);
    }

    public void deleteOnExit() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(this.path);
        }
        if (this.isInvalid()) {
            return;
        }
        DeleteOnExitHook.add(this.path);
    }

    public String @Nullable [] list(@ReadOnly File this) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return null;
        }
        return fs.list(this);
    }

    public String @Nullable [] list(@ReadOnly File this, @Nullable FilenameFilter filenameFilter) {
        String[] stringArray = this.list();
        if (stringArray == null || filenameFilter == null) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!filenameFilter.accept(this, stringArray[i])) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public @PolyRead File @Nullable [] listFiles(@PolyRead File this) {
        String[] stringArray = this.list();
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        File[] fileArray = new File[n];
        for (int i = 0; i < n; ++i) {
            fileArray[i] = new File(stringArray[i], this);
        }
        return fileArray;
    }

    public @PolyRead File @Nullable [] listFiles(@PolyRead File this, @Nullable FilenameFilter filenameFilter) {
        String[] stringArray = this.list();
        if (stringArray == null) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : stringArray) {
            if (filenameFilter != null && !filenameFilter.accept(this, string)) continue;
            arrayList.add(new File(string, this));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public @PolyRead File @Nullable [] listFiles(@PolyRead File this, @Nullable FileFilter fileFilter) {
        String[] stringArray = this.list();
        if (stringArray == null) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : stringArray) {
            File file = new File(string, this);
            if (fileFilter != null && !fileFilter.accept(file)) continue;
            arrayList.add(file);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public boolean mkdir() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.createDirectory(this);
    }

    public boolean mkdirs() {
        if (this.exists()) {
            return false;
        }
        if (this.mkdir()) {
            return true;
        }
        File file = null;
        try {
            file = this.getCanonicalFile();
        }
        catch (IOException iOException) {
            return false;
        }
        File file2 = file.getParentFile();
        return file2 != null && (file2.mkdirs() || file2.exists()) && file.mkdir();
    }

    public boolean renameTo(File file) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
            securityManager.checkWrite(file.path);
        }
        if (file == null) {
            throw new NullPointerException();
        }
        if (this.isInvalid() || file.isInvalid()) {
            return false;
        }
        return fs.rename(this, file);
    }

    public boolean setLastModified(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative time");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.setLastModifiedTime(this, l);
    }

    public boolean setReadOnly() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.setReadOnly(this);
    }

    public boolean setWritable(boolean bl, boolean bl2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.setPermission(this, 2, bl, bl2);
    }

    public boolean setWritable(boolean bl) {
        return this.setWritable(bl, true);
    }

    public boolean setReadable(boolean bl, boolean bl2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.setPermission(this, 4, bl, bl2);
    }

    public boolean setReadable(boolean bl) {
        return this.setReadable(bl, true);
    }

    public boolean setExecutable(boolean bl, boolean bl2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.setPermission(this, 1, bl, bl2);
    }

    public boolean setExecutable(boolean bl) {
        return this.setExecutable(bl, true);
    }

    public boolean canExecute(@ReadOnly File this) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExec(this.path);
        }
        if (this.isInvalid()) {
            return false;
        }
        return fs.checkAccess(this, 1);
    }

    public static File @Nullable [] listRoots() {
        return fs.listRoots();
    }

    public long getTotalSpace(@ReadOnly File this) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getFileSystemAttributes"));
            securityManager.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return 0L;
        }
        return fs.getSpace(this, 0);
    }

    public long getFreeSpace(@ReadOnly File this) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getFileSystemAttributes"));
            securityManager.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return 0L;
        }
        return fs.getSpace(this, 1);
    }

    public long getUsableSpace(@ReadOnly File this) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getFileSystemAttributes"));
            securityManager.checkRead(this.path);
        }
        if (this.isInvalid()) {
            return 0L;
        }
        return fs.getSpace(this, 2);
    }

    public static File createTempFile(String string, @Nullable String string2, @Nullable File file) throws IOException {
        File file2;
        if (string.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        if (string2 == null) {
            string2 = ".tmp";
        }
        File file3 = file != null ? file : TempDirectory.location();
        SecurityManager securityManager = System.getSecurityManager();
        do {
            file2 = TempDirectory.generateFile(string, string2, file3);
            if (securityManager == null) continue;
            try {
                securityManager.checkWrite(file2.getPath());
            }
            catch (SecurityException securityException) {
                if (file == null) {
                    throw new SecurityException("Unable to create temporary file");
                }
                throw securityException;
            }
        } while ((fs.getBooleanAttributes(file2) & 1) != 0);
        if (!fs.createFileExclusively(file2.getPath())) {
            throw new IOException("Unable to create temporary file");
        }
        return file2;
    }

    public static File createTempFile(String string, @Nullable String string2) throws IOException {
        return File.createTempFile(string, string2, null);
    }

    @Override
    @Pure
    public int compareTo(@ReadOnly File this, @ReadOnly File file) {
        return fs.compare(this, file);
    }

    @Pure
    public boolean equals(@ReadOnly File this, @Nullable @ReadOnly Object object) {
        if (object != null && object instanceof File) {
            return this.compareTo((File)object) == 0;
        }
        return false;
    }

    @Pure
    public int hashCode(@ReadOnly File this) {
        return fs.hashCode(this);
    }

    @SideEffectFree
    public String toString(@ReadOnly File this) {
        return this.getPath();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeChar(separatorChar);
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        String string = (String)getField.get("path", null);
        char c = objectInputStream.readChar();
        if (c != separatorChar) {
            string = string.replace(c, separatorChar);
        }
        String string2 = fs.normalize(string);
        UNSAFE.putObject(this, PATH_OFFSET, string2);
        UNSAFE.putIntVolatile(this, PREFIX_LENGTH_OFFSET, fs.prefixLength(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path toPath() {
        Path path = this.filePath;
        if (path == null) {
            File file = this;
            synchronized (file) {
                path = this.filePath;
                if (path == null) {
                    this.filePath = path = FileSystems.getDefault().getPath(this.path, new String[0]);
                }
            }
        }
        return path;
    }

    static {
        try {
            Unsafe unsafe = Unsafe.getUnsafe();
            PATH_OFFSET = unsafe.objectFieldOffset(File.class.getDeclaredField("path"));
            PREFIX_LENGTH_OFFSET = unsafe.objectFieldOffset(File.class.getDeclaredField("prefixLength"));
            UNSAFE = unsafe;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new Error(reflectiveOperationException);
        }
    }

    private static enum PathStatus {
        INVALID,
        CHECKED;

    }

    private static class TempDirectory {
        private static final File TMPDIR = new File(StaticProperty.javaIoTmpDir());
        private static final SecureRandom RANDOM = new SecureRandom();

        private TempDirectory() {
        }

        static File location() {
            return TMPDIR;
        }

        private static int shortenSubName(int subNameLength, int excess, int nameMin) {
            int newLength = Math.max(nameMin, subNameLength - excess);
            if (newLength < subNameLength) {
                return newLength;
            }
            return subNameLength;
        }

        static File generateFile(String prefix, String suffix, File dir) throws IOException {
            String name;
            int nameMax;
            int suffixLength;
            int nusLength;
            long n = RANDOM.nextLong();
            String nus = Long.toUnsignedString(n);
            int prefixLength = (prefix = new File(prefix).getName()).length();
            int excess = prefixLength + (nusLength = nus.length()) + (suffixLength = suffix.length()) - (nameMax = FS.getNameMax(dir.getPath()));
            if (excess <= 0) {
                name = prefix + nus + suffix;
            } else {
                if ((excess = (prefixLength = TempDirectory.shortenSubName(prefixLength, excess, 3)) + nusLength + suffixLength - nameMax) > 0) {
                    suffixLength = TempDirectory.shortenSubName(suffixLength, excess, suffix.indexOf(".") == 0 ? 4 : 0);
                    suffixLength = TempDirectory.shortenSubName(suffixLength, excess, 3);
                    excess = prefixLength + nusLength + suffixLength - nameMax;
                }
                if (excess > 0 && excess <= nusLength - 5) {
                    nusLength = TempDirectory.shortenSubName(nusLength, excess, 5);
                }
                StringBuilder sb = new StringBuilder(prefixLength + nusLength + suffixLength);
                sb.append(prefixLength < prefix.length() ? prefix.substring(0, prefixLength) : prefix);
                sb.append(nusLength < nus.length() ? nus.substring(0, nusLength) : nus);
                sb.append(suffixLength < suffix.length() ? suffix.substring(0, suffixLength) : suffix);
                name = sb.toString();
            }
            name = FS.normalize(name);
            File f = new File(dir, name);
            if (!name.equals(f.getName()) || f.isInvalid()) {
                if (System.getSecurityManager() != null) {
                    throw new IOException("Unable to create temporary file");
                }
                throw new IOException("Unable to create temporary file, " + name);
            }
            return f;
        }
    }
}

