/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Cleaner;
import java.nio.charset.Charset;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipCoder;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipUtils;
import jdk.internal.ref.CleanerFactory;
import org.checkerframework.checker.javari.qual.ReadOnly;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
public class ZipFile
implements ZipConstants,
Closeable {
    private long jzfile;
    private String name;
    private int total;
    private volatile boolean closeRequested;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private static final boolean usemmap;
    private ZipCoder zc;
    private final Map<InputStream, Inflater> streams;
    private Deque<Inflater> inflaterCache;
    private static final int JZENTRY_NAME = 0;
    private static final int JZENTRY_EXTRA = 1;
    private static final int JZENTRY_COMMENT = 2;

    private static native void initIDs();

    public ZipFile(String var1) throws IOException;

    public ZipFile(File var1, int var2) throws IOException;

    public ZipFile(File var1) throws ZipException, IOException;

    public ZipFile(File var1, int var2, Charset var3) throws IOException;

    public ZipFile(String var1, Charset var2) throws IOException;

    public ZipFile(File var1, Charset var2) throws IOException;

    public String getComment(@ReadOnly ZipFile this);

    public ZipEntry getEntry(String var1);

    private static native long getEntry(long var0, byte[] var2, boolean var3);

    private static native void freeEntry(long var0, long var2);

    public InputStream getInputStream(ZipEntry var1) throws IOException;

    private Inflater getInflater();

    private void releaseInflater(Inflater var1);

    public String getName(@ReadOnly ZipFile this);

    public Enumeration<? extends ZipEntry> entries();

    private ZipEntry getZipEntry(String var1, long var2);

    private static native long getNextEntry(long var0, int var2);

    public int size(@ReadOnly ZipFile this);

    @Override
    public void close() throws IOException;

    protected void finalize() throws IOException;

    private static native void close(long var0);

    private void ensureOpen();

    private void ensureOpenOrZipException() throws IOException;

    private static native long open(String var0, int var1, long var2, boolean var4) throws IOException;

    private static native int getTotal(long var0);

    private static native int read(long var0, long var2, long var4, byte[] var6, int var7, int var8);

    private static native long getEntryTime(long var0);

    private static native long getEntryCrc(long var0);

    private static native long getEntryCSize(long var0);

    private static native long getEntrySize(long var0);

    private static native int getEntryMethod(long var0);

    private static native int getEntryFlag(long var0);

    private static native byte[] getCommentBytes(long var0);

    private static native byte[] getEntryBytes(long var0, int var2);

    private static native String getZipMessage(long var0);

    static;

    private class ZipFileInflaterInputStream
    extends InflaterInputStream {
        private volatile boolean closeRequested;
        private boolean eof;
        private final Cleaner.Cleanable cleanable;

        ZipFileInflaterInputStream(ZipFileInputStream zfin, CleanableResource res, int size) {
            this(zfin, res, res.getInflater(), size);
        }

        private ZipFileInflaterInputStream(ZipFileInputStream zfin, CleanableResource res, Inflater inf, int size) {
            super(zfin, inf, size);
            this.eof = false;
            this.cleanable = CleanerFactory.cleaner().register(this, new InflaterCleanupAction(inf, res));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closeRequested) {
                return;
            }
            this.closeRequested = true;
            super.close();
            Set<InputStream> set = ZipFile.this.res.istreams;
            synchronized (set) {
                ZipFile.this.res.istreams.remove(this);
            }
            this.cleanable.clean();
        }

        @Override
        protected void fill() throws IOException {
            if (this.eof) {
                throw new EOFException("Unexpected end of ZLIB input stream");
            }
            this.len = this.in.read(this.buf, 0, this.buf.length);
            if (this.len == -1) {
                this.buf[0] = 0;
                this.len = 1;
                this.eof = true;
            }
            this.inf.setInput(this.buf, 0, this.len);
        }

        @Override
        public int available() throws IOException {
            if (this.closeRequested) {
                return 0;
            }
            long avail = ((ZipFileInputStream)this.in).size() - this.inf.getBytesWritten();
            return avail > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)avail;
        }
    }

    private class ZipFileInputStream
    extends InputStream {
        private volatile boolean closeRequested;
        private long pos;
        private long startingPos;
        protected long rem;
        protected long size;

        ZipFileInputStream(byte[] cen, int cenpos) {
            this.rem = ZipUtils.CENSIZ(cen, cenpos);
            this.size = ZipUtils.CENLEN(cen, cenpos);
            this.pos = ZipUtils.CENOFF(cen, cenpos);
            if (this.rem == 0xFFFFFFFFL || this.size == 0xFFFFFFFFL || this.pos == 0xFFFFFFFFL) {
                this.checkZIP64(cen, cenpos);
            }
            this.pos = -(this.pos + ZipFile.this.res.zsrc.locpos);
        }

        private void checkZIP64(byte[] cen, int cenpos) {
            int off = cenpos + 46 + ZipUtils.CENNAM(cen, cenpos);
            int end = off + ZipUtils.CENEXT(cen, cenpos);
            while (off + 4 < end) {
                int sz;
                int tag = ZipUtils.get16(cen, off);
                if ((off += 4) + (sz = ZipUtils.get16(cen, off + 2)) > end) break;
                if (tag == 1) {
                    if (this.size == 0xFFFFFFFFL) {
                        if (sz < 8 || off + 8 > end) break;
                        this.size = ZipUtils.get64(cen, off);
                        sz -= 8;
                        off += 8;
                    }
                    if (this.rem == 0xFFFFFFFFL) {
                        if (sz < 8 || off + 8 > end) break;
                        this.rem = ZipUtils.get64(cen, off);
                        sz -= 8;
                        off += 8;
                    }
                    if (this.pos != 0xFFFFFFFFL || sz < 8 || off + 8 > end) break;
                    this.pos = ZipUtils.get64(cen, off);
                    sz -= 8;
                    off += 8;
                    break;
                }
                off += sz;
            }
        }

        private long initDataOffset() throws IOException {
            if (this.pos <= 0L) {
                byte[] loc = new byte[30];
                this.pos = -this.pos;
                int len = ZipFile.this.res.zsrc.readFullyAt(loc, 0, loc.length, this.pos);
                if (len != 30) {
                    throw new ZipException("ZipFile error reading zip file");
                }
                if (ZipUtils.LOCSIG(loc) != 67324752L) {
                    throw new ZipException("ZipFile invalid LOC header (bad signature)");
                }
                this.pos += (long)(30 + ZipUtils.LOCNAM(loc) + ZipUtils.LOCEXT(loc));
                this.startingPos = this.pos;
            }
            return this.pos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                ZipFile.this.ensureOpenOrZipException();
                this.initDataOffset();
                if (this.rem == 0L) {
                    return -1;
                }
                if ((long)len > this.rem) {
                    len = (int)this.rem;
                }
                if (len <= 0) {
                    return 0;
                }
                if ((len = ZipFile.this.res.zsrc.readAt(b, off, len, this.pos)) > 0) {
                    this.pos += (long)len;
                    this.rem -= (long)len;
                }
            }
            if (this.rem == 0L) {
                this.close();
            }
            return len;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b, 0, 1) == 1) {
                return b[0] & 0xFF;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long n) throws IOException {
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                this.initDataOffset();
                long newPos = this.pos + n;
                if (n > 0L) {
                    if (newPos < 0L || n > this.rem) {
                        n = this.rem;
                    }
                } else if (newPos < this.startingPos) {
                    n = this.startingPos - this.pos;
                }
                this.pos += n;
                this.rem -= n;
            }
            if (this.rem == 0L) {
                this.close();
            }
            return n;
        }

        @Override
        public int available() {
            return this.rem > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.rem;
        }

        public long size() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.closeRequested) {
                return;
            }
            this.closeRequested = true;
            this.rem = 0L;
            Set<InputStream> set = ZipFile.this.res.istreams;
            synchronized (set) {
                ZipFile.this.res.istreams.remove(this);
            }
        }
    }
}

