/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

/*
 * Exception performing whole class analysis.
 */
@I
public abstract class AbstractList<E>
extends AbstractCollection<E>
implements List<E> {
    protected transient int modCount;

    protected AbstractList();

    @Override
    public boolean add(@Mutable AbstractList<E> this, E var1);

    @Override
    @Pure
    public abstract E get(@org.checkerframework.checker.igj.qual.ReadOnly AbstractList<E> this, int var1);

    @Override
    public E set(@Mutable AbstractList<E> this, int var1, E var2);

    @Override
    public void add(@Mutable AbstractList<E> this, int var1, E var2);

    @Override
    public E remove(@Mutable AbstractList<E> this, int var1);

    @Override
    @Pure
    public int indexOf(@org.checkerframework.checker.igj.qual.ReadOnly AbstractList<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @Pure
    public int lastIndexOf(@org.checkerframework.checker.igj.qual.ReadOnly AbstractList<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    public void clear(@Mutable AbstractList<E> this);

    @Override
    public boolean addAll(@Mutable AbstractList<E> this, int var1, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<? extends E> var2);

    @Override
    public @I @PolyRead Iterator<E> iterator(@org.checkerframework.checker.igj.qual.ReadOnly AbstractList<E> this);

    @Override
    public @I @PolyRead ListIterator<E> listIterator(@org.checkerframework.checker.igj.qual.ReadOnly AbstractList<E> this);

    @Override
    public @I @PolyRead ListIterator<E> listIterator(@org.checkerframework.checker.igj.qual.ReadOnly AbstractList<E> this, int var1);

    @Override
    @SideEffectFree
    public @I @PolyRead List<E> subList(@org.checkerframework.checker.igj.qual.ReadOnly AbstractList<E> this, int var1, int var2);

    @Override
    @Pure
    public boolean equals(@org.checkerframework.checker.igj.qual.ReadOnly AbstractList<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    @Pure
    public int hashCode(@org.checkerframework.checker.igj.qual.ReadOnly AbstractList<E> this);

    protected void removeRange(int var1, int var2);

    private void rangeCheckForAdd(int var1);

    private String outOfBoundsMsg(int var1);

    private class Itr
    implements Iterator<E> {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = AbstractList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != AbstractList.this.size();
        }

        @Override
        public E next() {
            this.checkForComodification();
            try {
                int i = this.cursor;
                Object next = AbstractList.this.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException((Throwable)e);
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AbstractList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = AbstractList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (AbstractList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            try {
                int i = this.cursor - 1;
                Object previous = AbstractList.this.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException((Throwable)e);
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                AbstractList.this.set(this.lastRet, e);
                this.expectedModCount = AbstractList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            try {
                int i = this.cursor;
                AbstractList.this.add(i, e);
                this.lastRet = -1;
                this.cursor = i + 1;
                this.expectedModCount = AbstractList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

