/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ClassCache;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.internal.misc.Unsafe;
import jdk.internal.util.ByteArray;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.SideEffectFree;
import sun.reflect.ReflectionFactory;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
public class ObjectStreamClass
implements Serializable {
    public static final ObjectStreamField[] NO_FIELDS;
    private static final long serialVersionUID = -6120832682080437368L;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final ReflectionFactory reflFactory;
    private Class<?> cl;
    private String name;
    private volatile Long suid;
    private boolean isProxy;
    private boolean isEnum;
    private boolean serializable;
    private boolean externalizable;
    private boolean hasWriteObjectData;
    private boolean hasBlockExternalData;
    private ClassNotFoundException resolveEx;
    private InvalidClassException deserializeEx;
    private InvalidClassException serializeEx;
    private InvalidClassException defaultSerializeEx;
    private ObjectStreamField[] fields;
    private int primDataSize;
    private int numObjFields;
    private FieldReflector fieldRefl;
    private volatile ClassDataSlot[] dataLayout;
    private Constructor cons;
    private Method writeObjectMethod;
    private Method readObjectMethod;
    private Method readObjectNoDataMethod;
    private Method writeReplaceMethod;
    private Method readResolveMethod;
    private ObjectStreamClass localDesc;
    private ObjectStreamClass superDesc;

    private static native void initNative();

    public static @Nullable ObjectStreamClass lookup(Class<?> var0);

    public static ObjectStreamClass lookupAny(Class<?> var0);

    public String getName();

    public long getSerialVersionUID();

    public @Nullable Class<?> forClass();

    public ObjectStreamField[] getFields();

    public @Nullable ObjectStreamField getField(String var1);

    @SideEffectFree
    public String toString();

    static ObjectStreamClass lookup(Class<?> var0, boolean var1);

    private ObjectStreamClass(Class<?> var1);

    ObjectStreamClass();

    void initProxy(Class<?> var1, ClassNotFoundException var2, ObjectStreamClass var3) throws InvalidClassException;

    void initNonProxy(ObjectStreamClass var1, Class<?> var2, ClassNotFoundException var3, ObjectStreamClass var4) throws InvalidClassException;

    void readNonProxy(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    void writeNonProxy(ObjectOutputStream var1) throws IOException;

    ClassNotFoundException getResolveException();

    void checkDeserialize() throws InvalidClassException;

    void checkSerialize() throws InvalidClassException;

    void checkDefaultSerialize() throws InvalidClassException;

    ObjectStreamClass getSuperDesc();

    ObjectStreamClass getLocalDesc();

    ObjectStreamField[] getFields(boolean var1);

    ObjectStreamField getField(String var1, Class<?> var2);

    boolean isProxy();

    boolean isEnum();

    boolean isExternalizable();

    boolean isSerializable();

    boolean hasBlockExternalData();

    boolean hasWriteObjectData();

    boolean isInstantiable();

    boolean hasWriteObjectMethod();

    boolean hasReadObjectMethod();

    boolean hasReadObjectNoDataMethod();

    boolean hasWriteReplaceMethod();

    boolean hasReadResolveMethod();

    Object newInstance() throws InstantiationException, InvocationTargetException, UnsupportedOperationException;

    void invokeWriteObject(Object var1, ObjectOutputStream var2) throws IOException, UnsupportedOperationException;

    void invokeReadObject(Object var1, ObjectInputStream var2) throws ClassNotFoundException, IOException, UnsupportedOperationException;

    void invokeReadObjectNoData(Object var1) throws IOException, UnsupportedOperationException;

    Object invokeWriteReplace(Object var1) throws IOException, UnsupportedOperationException;

    Object invokeReadResolve(Object var1) throws IOException, UnsupportedOperationException;

    ClassDataSlot[] getClassDataLayout() throws InvalidClassException;

    private ClassDataSlot[] getClassDataLayout0() throws InvalidClassException;

    int getPrimDataSize();

    int getNumObjFields();

    void getPrimFieldValues(Object var1, byte[] var2);

    void setPrimFieldValues(Object var1, byte[] var2);

    void getObjFieldValues(Object var1, Object[] var2);

    void setObjFieldValues(Object var1, Object[] var2);

    private void computeFieldOffsets() throws InvalidClassException;

    private ObjectStreamClass getVariantFor(Class<?> var1) throws InvalidClassException;

    private static Constructor getExternalizableConstructor(Class<?> var0);

    private static Constructor getSerializableConstructor(Class<?> var0);

    private static Method getInheritableMethod(Class<?> var0, String var1, Class<?>[] var2, Class<?> var3);

    private static Method getPrivateMethod(Class<?> var0, String var1, Class<?>[] var2, Class<?> var3);

    private static boolean packageEquals(Class<?> var0, Class<?> var1);

    private static String getPackageName(Class<?> var0);

    private static boolean classNamesEqual(String var0, String var1);

    private static String getClassSignature(Class<?> var0);

    private static String getMethodSignature(Class<?>[] var0, Class<?> var1);

    private static void throwMiscException(Throwable var0) throws IOException;

    private static ObjectStreamField[] getSerialFields(Class<?> var0) throws InvalidClassException;

    private static ObjectStreamField[] getDeclaredSerialFields(Class<?> var0) throws InvalidClassException;

    private static ObjectStreamField[] getDefaultSerialFields(Class<?> var0);

    private static Long getDeclaredSUID(Class<?> var0);

    private static long computeDefaultSUID(Class<?> var0);

    private static native boolean hasStaticInitializer(Class<?> var0);

    private static FieldReflector getReflector(ObjectStreamField[] var0, ObjectStreamClass var1) throws InvalidClassException;

    private static ObjectStreamField[] matchFields(ObjectStreamField[] var0, ObjectStreamClass var1) throws InvalidClassException;

    static void processQueue(ReferenceQueue<Class<?>> var0, ConcurrentMap<? extends WeakReference<Class<?>>, ?> var1);

    static;

    private static class Caches {
        static final ClassCache<ObjectStreamClass> localDescs = new ClassCache<ObjectStreamClass>(){

            @Override
            protected ObjectStreamClass computeValue(Class<?> type) {
                return new ObjectStreamClass(type);
            }
        };
        static final ClassCache<Map<FieldReflectorKey, FieldReflector>> reflectors = new ClassCache<Map<FieldReflectorKey, FieldReflector>>(){

            @Override
            protected Map<FieldReflectorKey, FieldReflector> computeValue(Class<?> type) {
                return new ConcurrentHashMap<FieldReflectorKey, FieldReflector>();
            }
        };

        private Caches() {
        }
    }

    static class ClassDataSlot {
        final ObjectStreamClass desc;
        final boolean hasData;

        ClassDataSlot(ObjectStreamClass desc, boolean hasData) {
            this.desc = desc;
            this.hasData = hasData;
        }
    }

    private static final class MemberSignature {
        public final Member member;
        public final String name;
        public final String signature;

        public MemberSignature(Field field) {
            this.member = field;
            this.name = field.getName();
            this.signature = field.getType().descriptorString();
        }

        public MemberSignature(Constructor<?> cons) {
            this.member = cons;
            this.name = cons.getName();
            this.signature = ObjectStreamClass.getMethodSignature(cons.getParameterTypes(), Void.TYPE);
        }

        public MemberSignature(Method meth) {
            this.member = meth;
            this.name = meth.getName();
            this.signature = ObjectStreamClass.getMethodSignature(meth.getParameterTypes(), meth.getReturnType());
        }
    }

    private static final class FieldReflector {
        private static final Unsafe UNSAFE = Unsafe.getUnsafe();
        private final ObjectStreamField[] fields;
        private final int numPrimFields;
        private final long[] readKeys;
        private final long[] writeKeys;
        private final int[] offsets;
        private final char[] typeCodes;
        private final Class<?>[] types;

        FieldReflector(ObjectStreamField[] fields) {
            this.fields = fields;
            int nfields = fields.length;
            this.readKeys = new long[nfields];
            this.writeKeys = new long[nfields];
            this.offsets = new int[nfields];
            this.typeCodes = new char[nfields];
            ArrayList typeList = new ArrayList();
            HashSet<Long> usedKeys = new HashSet<Long>();
            for (int i = 0; i < nfields; ++i) {
                long key;
                ObjectStreamField f = fields[i];
                Field rf = f.getField();
                this.readKeys[i] = key = rf != null ? UNSAFE.objectFieldOffset(rf) : -1L;
                this.writeKeys[i] = usedKeys.add(key) ? key : -1L;
                this.offsets[i] = f.getOffset();
                this.typeCodes[i] = f.getTypeCode();
                if (f.isPrimitive()) continue;
                typeList.add(rf != null ? rf.getType() : null);
            }
            this.types = typeList.toArray(new Class[typeList.size()]);
            this.numPrimFields = nfields - this.types.length;
        }

        ObjectStreamField[] getFields() {
            return this.fields;
        }

        void getPrimFieldValues(Object obj, byte[] buf) {
            if (obj == null) {
                throw new NullPointerException();
            }
            block10: for (int i = 0; i < this.numPrimFields; ++i) {
                long key = this.readKeys[i];
                int off = this.offsets[i];
                switch (this.typeCodes[i]) {
                    case 'Z': {
                        ByteArray.setBoolean(buf, off, UNSAFE.getBoolean(obj, key));
                        continue block10;
                    }
                    case 'B': {
                        buf[off] = UNSAFE.getByte(obj, key);
                        continue block10;
                    }
                    case 'C': {
                        ByteArray.setChar(buf, off, UNSAFE.getChar(obj, key));
                        continue block10;
                    }
                    case 'S': {
                        ByteArray.setShort(buf, off, UNSAFE.getShort(obj, key));
                        continue block10;
                    }
                    case 'I': {
                        ByteArray.setInt(buf, off, UNSAFE.getInt(obj, key));
                        continue block10;
                    }
                    case 'F': {
                        ByteArray.setFloat(buf, off, UNSAFE.getFloat(obj, key));
                        continue block10;
                    }
                    case 'J': {
                        ByteArray.setLong(buf, off, UNSAFE.getLong(obj, key));
                        continue block10;
                    }
                    case 'D': {
                        ByteArray.setDouble(buf, off, UNSAFE.getDouble(obj, key));
                        continue block10;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        void setPrimFieldValues(Object obj, byte[] buf) {
            if (obj == null) {
                throw new NullPointerException();
            }
            block10: for (int i = 0; i < this.numPrimFields; ++i) {
                long key = this.writeKeys[i];
                if (key == -1L) continue;
                int off = this.offsets[i];
                switch (this.typeCodes[i]) {
                    case 'Z': {
                        UNSAFE.putBoolean(obj, key, ByteArray.getBoolean(buf, off));
                        continue block10;
                    }
                    case 'B': {
                        UNSAFE.putByte(obj, key, buf[off]);
                        continue block10;
                    }
                    case 'C': {
                        UNSAFE.putChar(obj, key, ByteArray.getChar(buf, off));
                        continue block10;
                    }
                    case 'S': {
                        UNSAFE.putShort(obj, key, ByteArray.getShort(buf, off));
                        continue block10;
                    }
                    case 'I': {
                        UNSAFE.putInt(obj, key, ByteArray.getInt(buf, off));
                        continue block10;
                    }
                    case 'F': {
                        UNSAFE.putFloat(obj, key, ByteArray.getFloat(buf, off));
                        continue block10;
                    }
                    case 'J': {
                        UNSAFE.putLong(obj, key, ByteArray.getLong(buf, off));
                        continue block10;
                    }
                    case 'D': {
                        UNSAFE.putDouble(obj, key, ByteArray.getDouble(buf, off));
                        continue block10;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        void getObjFieldValues(Object obj, Object[] vals) {
            if (obj == null) {
                throw new NullPointerException();
            }
            for (int i = this.numPrimFields; i < this.fields.length; ++i) {
                switch (this.typeCodes[i]) {
                    case 'L': 
                    case '[': {
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                vals[this.offsets[i]] = UNSAFE.getReference(obj, this.readKeys[i]);
            }
        }

        void checkObjectFieldValueTypes(Object obj, Object[] vals) {
            this.setObjFieldValues(obj, vals, true);
        }

        void setObjFieldValues(Object obj, Object[] vals) {
            this.setObjFieldValues(obj, vals, false);
        }

        private void setObjFieldValues(Object obj, Object[] vals, boolean dryRun) {
            if (obj == null) {
                throw new NullPointerException();
            }
            block3: for (int i = this.numPrimFields; i < this.fields.length; ++i) {
                long key = this.writeKeys[i];
                if (key == -1L) continue;
                switch (this.typeCodes[i]) {
                    case 'L': 
                    case '[': {
                        Object val = vals[this.offsets[i]];
                        if (val != null && !this.types[i - this.numPrimFields].isInstance(val)) {
                            Field f = this.fields[i].getField();
                            throw new ClassCastException("cannot assign instance of " + val.getClass().getName() + " to field " + f.getDeclaringClass().getName() + "." + f.getName() + " of type " + f.getType().getName() + " in instance of " + obj.getClass().getName());
                        }
                        if (dryRun) continue block3;
                        UNSAFE.putReference(obj, key, val);
                        continue block3;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }
    }

    private static class FieldReflectorKey {
        private final String[] sigs;
        private final int hash;

        FieldReflectorKey(ObjectStreamField[] fields) {
            this.sigs = new String[2 * fields.length];
            int j = 0;
            for (int i = 0; i < fields.length; ++i) {
                ObjectStreamField f = fields[i];
                this.sigs[j++] = f.getName();
                this.sigs[j++] = f.getSignature();
            }
            this.hash = Arrays.hashCode(this.sigs);
        }

        public int hashCode() {
            return this.hash;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof FieldReflectorKey)) return false;
            FieldReflectorKey other = (FieldReflectorKey)obj;
            if (!Arrays.equals(this.sigs, other.sigs)) return false;
            return true;
        }
    }
}

