/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeMap;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@I
public class TreeSet<E>
extends AbstractSet<E>
implements NavigableSet<E>,
Cloneable,
Serializable {
    private transient NavigableMap<E, Object> m;
    private static final Object PRESENT = new Object();
    private static final long serialVersionUID = -2479143000061671589L;

    TreeSet(NavigableMap<E, Object> navigableMap) {
        this.m = navigableMap;
    }

    public TreeSet() {
        this(new TreeMap());
    }

    public TreeSet(@org.checkerframework.checker.igj.qual.ReadOnly Comparator<? super E> comparator) {
        this(new TreeMap(comparator));
    }

    public @PolyRead TreeSet(@org.checkerframework.checker.igj.qual.ReadOnly @PolyRead Collection<? extends E> collection) {
        this();
        this.addAll(collection);
    }

    public @PolyRead TreeSet(@org.checkerframework.checker.igj.qual.ReadOnly @PolyRead SortedSet<E> sortedSet) {
        this(sortedSet.comparator());
        this.addAll(sortedSet);
    }

    @Override
    public @I @PolyRead Iterator<E> iterator(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this) {
        return this.m.navigableKeySet().iterator();
    }

    @Override
    public @I @PolyRead Iterator<E> descendingIterator(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this) {
        return this.m.descendingKeySet().iterator();
    }

    @Override
    public @I @PolyRead NavigableSet<E> descendingSet(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this) {
        return new TreeSet<E>(this.m.descendingMap());
    }

    @Override
    @Pure
    public int size(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this) {
        return this.m.size();
    }

    @Override
    @EnsuresNonNullIf(result=false, expression={"pollFirst()", "pollLast()"})
    @Pure
    public boolean isEmpty(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this) {
        return this.m.isEmpty();
    }

    @Override
    @Pure
    public boolean contains(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        return this.m.containsKey(object);
    }

    @Override
    public boolean add(@Mutable TreeSet<E> this, E e) {
        return this.m.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(@Mutable TreeSet<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        return this.m.remove(object) == PRESENT;
    }

    @Override
    public void clear(@Mutable TreeSet<E> this) {
        this.m.clear();
    }

    @Override
    public boolean addAll(@Mutable TreeSet<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<? extends E> collection) {
        if (this.m.size() == 0 && collection.size() > 0 && collection instanceof SortedSet && this.m instanceof TreeMap) {
            Comparator comparator;
            SortedSet sortedSet = (SortedSet)collection;
            TreeMap treeMap = (TreeMap)this.m;
            Comparator comparator2 = sortedSet.comparator();
            if (comparator2 == (comparator = treeMap.comparator()) || comparator2 != null && comparator2.equals(comparator)) {
                treeMap.addAllForTreeSet(sortedSet, PRESENT);
                return true;
            }
        }
        return super.addAll(collection);
    }

    @Override
    @SideEffectFree
    public @I @PolyRead NavigableSet<E> subSet(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this, E e, boolean bl, E e2, boolean bl2) {
        return new TreeSet<E>(this.m.subMap(e, bl, e2, bl2));
    }

    @Override
    @SideEffectFree
    public @I @PolyRead NavigableSet<E> headSet(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this, E e, boolean bl) {
        return new TreeSet<E>(this.m.headMap(e, bl));
    }

    @Override
    @SideEffectFree
    public @I @PolyRead NavigableSet<E> tailSet(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this, E e, boolean bl) {
        return new TreeSet<E>(this.m.tailMap(e, bl));
    }

    @Override
    @SideEffectFree
    public @I @PolyRead SortedSet<E> subSet(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this, E e, E e2) {
        return this.subSet(e, true, e2, false);
    }

    @Override
    @SideEffectFree
    public @I @PolyRead SortedSet<E> headSet(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this, E e) {
        return this.headSet(e, false);
    }

    @Override
    @SideEffectFree
    public @I @PolyRead SortedSet<E> tailSet(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this, E e) {
        return this.tailSet(e, true);
    }

    @Override
    @SideEffectFree
    public @org.checkerframework.checker.igj.qual.ReadOnly @PolyRead Comparator<? super E> comparator(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this) {
        return this.m.comparator();
    }

    @Override
    @SideEffectFree
    public E first(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this) {
        return (E)this.m.firstKey();
    }

    @Override
    @SideEffectFree
    public E last(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this) {
        return (E)this.m.lastKey();
    }

    @Override
    public @Nullable E lower(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this, E e) {
        return this.m.lowerKey(e);
    }

    @Override
    public @Nullable E floor(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this, E e) {
        return this.m.floorKey(e);
    }

    @Override
    public @Nullable E ceiling(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this, E e) {
        return this.m.ceilingKey(e);
    }

    @Override
    public @Nullable E higher(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this, E e) {
        return this.m.higherKey(e);
    }

    @Override
    public @Nullable E pollFirst(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this) {
        Map.Entry<E, Object> entry = this.m.pollFirstEntry();
        return entry == null ? null : (E)entry.getKey();
    }

    @Override
    public @Nullable E pollLast(@org.checkerframework.checker.igj.qual.ReadOnly TreeSet<E> this) {
        Map.Entry<E, Object> entry = this.m.pollLastEntry();
        return entry == null ? null : (E)entry.getKey();
    }

    @SideEffectFree
    public @I(value="N") Object clone() {
        TreeSet treeSet = null;
        try {
            treeSet = (TreeSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        treeSet.m = new TreeMap<E, Object>(this.m);
        return treeSet;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.m.comparator());
        objectOutputStream.writeInt(this.m.size());
        for (Object k : this.m.keySet()) {
            objectOutputStream.writeObject(k);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Comparator comparator = (Comparator)objectInputStream.readObject();
        TreeMap<Object, Object> treeMap = comparator == null ? new TreeMap<E, Object>() : new TreeMap(comparator);
        this.m = treeMap;
        int n = objectInputStream.readInt();
        treeMap.readTreeSet(n, objectInputStream, PRESENT);
    }
}

