/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.JarEntry;
import java.util.spi.ResourceBundleProvider;
import jdk.internal.access.JavaUtilResourceBundleAccess;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import sun.util.locale.BaseLocale;
import sun.util.locale.LocaleObjectCache;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ResourceBundle {
    private static final int INITIAL_CACHE_SIZE = 32;
    private static final ResourceBundle NONEXISTENT_BUNDLE = new JavaUtilResourceBundleAccess(){

        @Override
        public void setParent(ResourceBundle bundle, ResourceBundle parent) {
            bundle.setParent(parent);
        }

        @Override
        public ResourceBundle getParent(ResourceBundle bundle) {
            return bundle.parent;
        }

        @Override
        public void setLocale(ResourceBundle bundle, Locale locale) {
            bundle.locale = locale;
        }

        @Override
        public void setName(ResourceBundle bundle, String name) {
            bundle.name = name;
        }

        @Override
        public ResourceBundle getBundle(String baseName, Locale locale, Module module) {
            return ResourceBundle.getBundleImpl((Module)module, (Module)module, (String)baseName, (Locale)locale, (Control)ResourceBundle.getDefaultControl((Module)module, (String)baseName));
        }

        @Override
        public ResourceBundle newResourceBundle(Class<? extends ResourceBundle> bundleClass) {
            return ResourceBundleProviderHelper.newResourceBundle(bundleClass);
        }
    };
    private static final ConcurrentMap<CacheKey, BundleReference> cacheList = new ConcurrentHashMap<CacheKey, BundleReference>(32);
    private static final ReferenceQueue referenceQueue = new ReferenceQueue();
    protected ResourceBundle parent = null;
    private Locale locale = null;
    private String name;
    private volatile boolean expired;
    private volatile CacheKey cacheKey;
    private volatile Set<String> keySet;

    public final String getString(String string) {
        return (String)this.getObject(string);
    }

    public final String[] getStringArray(String string) {
        return (String[])this.getObject(string);
    }

    public final Object getObject(String string) {
        Object object = this.handleGetObject(string);
        if (object == null) {
            if (this.parent != null) {
                object = this.parent.getObject(string);
            }
            if (object == null) {
                throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key " + string, this.getClass().getName(), string);
            }
        }
        return object;
    }

    public Locale getLocale(@ReadOnly ResourceBundle this) {
        return this.locale;
    }

    private static ClassLoader getLoader() {
        ClassLoader classLoader;
        Class[] classArray = ResourceBundle.getClassContext();
        Class clazz = classArray[2];
        ClassLoader classLoader2 = classLoader = clazz == null ? null : clazz.getClassLoader();
        if (classLoader == null) {
            classLoader = RBClassLoader.access$000();
        }
        return classLoader;
    }

    private static native Class[] getClassContext();

    protected void setParent(ResourceBundle resourceBundle) {
        assert (resourceBundle != NONEXISTENT_BUNDLE);
        this.parent = resourceBundle;
    }

    public static final ResourceBundle getBundle(String string) {
        return ResourceBundle.getBundleImpl(string, Locale.getDefault(), ResourceBundle.getLoader(), Control.access$300());
    }

    public static final ResourceBundle getBundle(String string, Control control) {
        return ResourceBundle.getBundleImpl(string, Locale.getDefault(), ResourceBundle.getLoader(), control);
    }

    public static final ResourceBundle getBundle(String string, Locale locale) {
        return ResourceBundle.getBundleImpl(string, locale, ResourceBundle.getLoader(), Control.access$300());
    }

    public static final ResourceBundle getBundle(String string, Locale locale, Control control) {
        return ResourceBundle.getBundleImpl(string, locale, ResourceBundle.getLoader(), control);
    }

    public static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        return ResourceBundle.getBundleImpl(string, locale, classLoader, Control.access$300());
    }

    public static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader, Control control) {
        if (classLoader == null || control == null) {
            throw new NullPointerException();
        }
        return ResourceBundle.getBundleImpl(string, locale, classLoader, control);
    }

    private static ResourceBundle getBundleImpl(String string, Locale locale, ClassLoader classLoader, Control control) {
        if (locale == null || control == null) {
            throw new NullPointerException();
        }
        CacheKey cacheKey = new CacheKey(string, locale, classLoader);
        ResourceBundle resourceBundle = null;
        BundleReference bundleReference = (BundleReference)cacheList.get(cacheKey);
        if (bundleReference != null) {
            resourceBundle = (ResourceBundle)bundleReference.get();
            bundleReference = null;
        }
        if (ResourceBundle.isValidBundle(resourceBundle) && ResourceBundle.hasValidParentChain(resourceBundle)) {
            return resourceBundle;
        }
        boolean bl = control == Control.access$300() || control instanceof SingleFormatControl;
        List<String> list = control.getFormats(string);
        if (!bl && !ResourceBundle.checkList(list)) {
            throw new IllegalArgumentException("Invalid Control: getFormats");
        }
        ResourceBundle resourceBundle2 = null;
        Locale locale2 = locale;
        while (locale2 != null) {
            List<Locale> list2 = control.getCandidateLocales(string, locale2);
            if (!bl && !ResourceBundle.checkList(list2)) {
                throw new IllegalArgumentException("Invalid Control: getCandidateLocales");
            }
            resourceBundle = ResourceBundle.findBundle(cacheKey, list2, list, 0, control, resourceBundle2);
            if (ResourceBundle.isValidBundle(resourceBundle)) {
                boolean bl2 = Locale.ROOT.equals(resourceBundle.locale);
                if (!bl2 || resourceBundle.locale.equals(locale) || list2.size() == 1 && resourceBundle.locale.equals(list2.get(0))) break;
                if (bl2 && resourceBundle2 == null) {
                    resourceBundle2 = resourceBundle;
                }
            }
            locale2 = control.getFallbackLocale(string, locale2);
        }
        if (resourceBundle == null) {
            if (resourceBundle2 == null) {
                ResourceBundle.throwMissingResourceException(string, locale, CacheKey.access$400((CacheKey)cacheKey));
            }
            resourceBundle = resourceBundle2;
        }
        return resourceBundle;
    }

    private static final boolean checkList(List list) {
        boolean bl;
        boolean bl2 = bl = list != null && list.size() != 0;
        if (bl) {
            int n = list.size();
            for (int i = 0; bl && i < n; ++i) {
                bl = list.get(i) != null;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ResourceBundle findBundle(CacheKey cacheKey, List<Locale> list, List<String> list2, int n, Control control, ResourceBundle resourceBundle) {
        Object object;
        Reference reference;
        Locale locale = list.get(n);
        ResourceBundle resourceBundle2 = null;
        if (n != list.size() - 1) {
            resourceBundle2 = ResourceBundle.findBundle(cacheKey, list, list2, n + 1, control, resourceBundle);
        } else if (resourceBundle != null && Locale.ROOT.equals(locale)) {
            return resourceBundle;
        }
        while ((reference = referenceQueue.poll()) != null) {
            cacheList.remove(((CacheKeyReference)((Object)reference)).getCacheKey());
        }
        boolean bl = false;
        cacheKey.setLocale(locale);
        ResourceBundle resourceBundle3 = ResourceBundle.findBundleInCache(cacheKey, control);
        if (ResourceBundle.isValidBundle(resourceBundle3) && !(bl = resourceBundle3.expired)) {
            if (resourceBundle3.parent == resourceBundle2) {
                return resourceBundle3;
            }
            object = (BundleReference)cacheList.get(cacheKey);
            if (object != null && ((SoftReference)object).get() == resourceBundle3) {
                cacheList.remove(cacheKey, object);
            }
        }
        if (resourceBundle3 != NONEXISTENT_BUNDLE) {
            object = (CacheKey)cacheKey.clone();
            try {
                resourceBundle3 = ResourceBundle.loadBundle(cacheKey, list2, control, bl);
                if (resourceBundle3 != null) {
                    if (resourceBundle3.parent == null) {
                        resourceBundle3.setParent(resourceBundle2);
                    }
                    resourceBundle3.locale = locale;
                    ResourceBundle resourceBundle4 = resourceBundle3 = ResourceBundle.putBundleInCache(cacheKey, resourceBundle3, control);
                    return resourceBundle4;
                }
                ResourceBundle.putBundleInCache(cacheKey, NONEXISTENT_BUNDLE, control);
            }
            finally {
                if (CacheKey.access$400((CacheKey)object) instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return resourceBundle2;
    }

    private static final ResourceBundle loadBundle(CacheKey cacheKey, List<String> list, Control control, boolean bl) {
        Locale locale = cacheKey.getLocale();
        ResourceBundle resourceBundle = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            try {
                resourceBundle = control.newBundle(cacheKey.getName(), locale, string, cacheKey.getLoader(), bl);
            }
            catch (LinkageError linkageError) {
                CacheKey.access$500((CacheKey)cacheKey, (Throwable)linkageError);
            }
            catch (Exception exception) {
                CacheKey.access$500((CacheKey)cacheKey, (Throwable)exception);
            }
            if (resourceBundle == null) continue;
            cacheKey.setFormat(string);
            resourceBundle.name = cacheKey.getName();
            resourceBundle.locale = locale;
            resourceBundle.expired = false;
            break;
        }
        return resourceBundle;
    }

    private static final boolean isValidBundle(ResourceBundle resourceBundle) {
        return resourceBundle != null && resourceBundle != NONEXISTENT_BUNDLE;
    }

    private static final boolean hasValidParentChain(ResourceBundle resourceBundle) {
        long l = System.currentTimeMillis();
        while (resourceBundle != null) {
            long l2;
            if (resourceBundle.expired) {
                return false;
            }
            CacheKey cacheKey = resourceBundle.cacheKey;
            if (cacheKey != null && (l2 = CacheKey.access$600((CacheKey)cacheKey)) >= 0L && l2 <= l) {
                return false;
            }
            resourceBundle = resourceBundle.parent;
        }
        return true;
    }

    private static final void throwMissingResourceException(String string, Locale locale, Throwable throwable) {
        if (throwable instanceof MissingResourceException) {
            throwable = null;
        }
        throw new MissingResourceException("Can't find bundle for base name " + string + ", locale " + locale, string + "_" + locale, "", throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ResourceBundle findBundleInCache(CacheKey cacheKey, Control control) {
        BundleReference bundleReference = (BundleReference)cacheList.get(cacheKey);
        if (bundleReference == null) {
            return null;
        }
        ResourceBundle resourceBundle = (ResourceBundle)bundleReference.get();
        if (resourceBundle == null) {
            return null;
        }
        ResourceBundle resourceBundle2 = resourceBundle.parent;
        assert (resourceBundle2 != NONEXISTENT_BUNDLE);
        if (resourceBundle2 != null && resourceBundle2.expired) {
            assert (resourceBundle != NONEXISTENT_BUNDLE);
            resourceBundle.expired = true;
            resourceBundle.cacheKey = null;
            cacheList.remove(cacheKey, bundleReference);
            resourceBundle = null;
        } else {
            CacheKey cacheKey2 = bundleReference.getCacheKey();
            long l = CacheKey.access$600((CacheKey)cacheKey2);
            if (!resourceBundle.expired && l >= 0L && l <= System.currentTimeMillis()) {
                if (resourceBundle != NONEXISTENT_BUNDLE) {
                    ResourceBundle resourceBundle3 = resourceBundle;
                    synchronized (resourceBundle3) {
                        l = CacheKey.access$600((CacheKey)cacheKey2);
                        if (!resourceBundle.expired && l >= 0L && l <= System.currentTimeMillis()) {
                            try {
                                resourceBundle.expired = control.needsReload(cacheKey2.getName(), cacheKey2.getLocale(), cacheKey2.getFormat(), cacheKey2.getLoader(), resourceBundle, CacheKey.access$700((CacheKey)cacheKey2));
                            }
                            catch (Exception exception) {
                                CacheKey.access$500((CacheKey)cacheKey, (Throwable)exception);
                            }
                            if (resourceBundle.expired) {
                                resourceBundle.cacheKey = null;
                                cacheList.remove(cacheKey, bundleReference);
                            } else {
                                ResourceBundle.setExpirationTime(cacheKey2, control);
                            }
                        }
                    }
                }
                cacheList.remove(cacheKey, bundleReference);
                resourceBundle = null;
            }
        }
        return resourceBundle;
    }

    private static final ResourceBundle putBundleInCache(CacheKey cacheKey, ResourceBundle resourceBundle, Control control) {
        ResourceBundle.setExpirationTime(cacheKey, control);
        if (CacheKey.access$600((CacheKey)cacheKey) != -1L) {
            CacheKey cacheKey2 = (CacheKey)cacheKey.clone();
            BundleReference bundleReference = new BundleReference(resourceBundle, referenceQueue, cacheKey2);
            resourceBundle.cacheKey = cacheKey2;
            BundleReference bundleReference2 = cacheList.putIfAbsent(cacheKey2, bundleReference);
            if (bundleReference2 != null) {
                ResourceBundle resourceBundle2 = (ResourceBundle)bundleReference2.get();
                if (resourceBundle2 != null && !resourceBundle2.expired) {
                    resourceBundle.cacheKey = null;
                    resourceBundle = resourceBundle2;
                    bundleReference.clear();
                } else {
                    cacheList.put(cacheKey2, bundleReference);
                }
            }
        }
        return resourceBundle;
    }

    private static final void setExpirationTime(CacheKey cacheKey, Control control) {
        long l = control.getTimeToLive(cacheKey.getName(), cacheKey.getLocale());
        if (l >= 0L) {
            long l2 = System.currentTimeMillis();
            CacheKey.access$702((CacheKey)cacheKey, (long)l2);
            CacheKey.access$602((CacheKey)cacheKey, (long)(l2 + l));
        } else if (l >= -2L) {
            CacheKey.access$602((CacheKey)cacheKey, (long)l);
        } else {
            throw new IllegalArgumentException("Invalid Control: TTL=" + l);
        }
    }

    public static final void clearCache() {
        ResourceBundle.clearCache(ResourceBundle.getLoader());
    }

    public static final void clearCache(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        Set set = cacheList.keySet();
        for (CacheKey cacheKey : set) {
            if (cacheKey.getLoader() != classLoader) continue;
            set.remove(cacheKey);
        }
    }

    protected abstract Object handleGetObject(String var1);

    @SideEffectFree
    public abstract Enumeration<String> getKeys();

    @Pure
    public boolean containsKey(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        ResourceBundle resourceBundle = this;
        while (resourceBundle != null) {
            if (resourceBundle.handleKeySet().contains(string)) {
                return true;
            }
            resourceBundle = resourceBundle.parent;
        }
        return false;
    }

    @SideEffectFree
    public Set<@KeyFor(value={"this"}) String> keySet() {
        HashSet<String> hashSet = new HashSet<String>();
        ResourceBundle resourceBundle = this;
        while (resourceBundle != null) {
            hashSet.addAll(resourceBundle.handleKeySet());
            resourceBundle = resourceBundle.parent;
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> handleKeySet() {
        if (this.keySet == null) {
            ResourceBundle resourceBundle = this;
            synchronized (resourceBundle) {
                if (this.keySet == null) {
                    HashSet<String> hashSet = new HashSet<String>();
                    Enumeration<String> enumeration = this.getKeys();
                    while (enumeration.hasMoreElements()) {
                        String string = enumeration.nextElement();
                        if (this.handleGetObject(string) == null) continue;
                        hashSet.add(string);
                    }
                    this.keySet = hashSet;
                }
            }
        }
        return this.keySet;
    }

    static /* synthetic */ ReferenceQueue access$200() {
        return referenceQueue;
    }

    private static class BundleReference
    extends SoftReference<ResourceBundle>
    implements CacheKeyReference {
        private final CacheKey cacheKey;

        BundleReference(ResourceBundle referent, ReferenceQueue<Object> q, CacheKey key) {
            super(referent, q);
            this.cacheKey = key;
        }

        @Override
        public CacheKey getCacheKey() {
            return this.cacheKey;
        }
    }

    private static final class CacheKey {
        private final String name;
        private volatile Locale locale;
        private final KeyElementReference<Module> moduleRef;
        private final KeyElementReference<Module> callerRef;
        private final int modulesHash;
        private volatile String format;
        private volatile long loadTime;
        private volatile long expirationTime;
        private volatile Throwable cause;
        private volatile ServiceLoader<ResourceBundleProvider> providers;
        private volatile boolean providersChecked;
        private volatile Boolean callerHasProvider;

        CacheKey(String baseName, Locale locale, Module module, Module caller) {
            Objects.requireNonNull(module);
            Objects.requireNonNull(caller);
            this.name = baseName;
            this.locale = locale;
            this.moduleRef = new KeyElementReference<Module>(module, referenceQueue, this);
            this.callerRef = new KeyElementReference<Module>(caller, referenceQueue, this);
            this.modulesHash = module.hashCode() ^ caller.hashCode();
        }

        CacheKey(CacheKey src) {
            this.moduleRef = new KeyElementReference<Module>(Objects.requireNonNull(src.getModule()), referenceQueue, this);
            this.callerRef = new KeyElementReference<Module>(Objects.requireNonNull(src.getCallerModule()), referenceQueue, this);
            this.name = src.name;
            this.locale = src.locale;
            this.modulesHash = src.modulesHash;
            this.format = src.format;
            this.loadTime = src.loadTime;
            this.expirationTime = src.expirationTime;
        }

        String getName() {
            return this.name;
        }

        Locale getLocale() {
            return this.locale;
        }

        CacheKey setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        Module getModule() {
            return (Module)this.moduleRef.get();
        }

        Module getCallerModule() {
            return (Module)this.callerRef.get();
        }

        ServiceLoader<ResourceBundleProvider> getProviders() {
            if (!this.providersChecked) {
                this.providers = ResourceBundle.getServiceLoader((Module)this.getModule(), (String)this.name);
                this.providersChecked = true;
            }
            return this.providers;
        }

        boolean hasProviders() {
            return this.getProviders() != null;
        }

        boolean callerHasProvider() {
            return this.callerHasProvider == Boolean.TRUE;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            try {
                CacheKey otherEntry = (CacheKey)other;
                if (this.modulesHash != otherEntry.modulesHash) {
                    return false;
                }
                if (!this.name.equals(otherEntry.name)) {
                    return false;
                }
                if (!this.locale.equals(otherEntry.locale)) {
                    return false;
                }
                Module module = this.getModule();
                Module caller = this.getCallerModule();
                return module != null && module.equals(otherEntry.getModule()) && caller != null && caller.equals(otherEntry.getCallerModule());
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                return false;
            }
        }

        public int hashCode() {
            return this.name.hashCode() << 3 ^ this.locale.hashCode() ^ this.modulesHash;
        }

        String getFormat() {
            return this.format;
        }

        void setFormat(String format) {
            this.format = format;
        }

        private void setCause(Throwable cause) {
            if (this.cause == null) {
                this.cause = cause;
            } else if (this.cause instanceof ClassNotFoundException) {
                this.cause = cause;
            }
        }

        private Throwable getCause() {
            return this.cause;
        }

        public String toString() {
            String l = this.locale.toString();
            if (l.isEmpty()) {
                l = !this.locale.getVariant().isEmpty() ? "__" + this.locale.getVariant() : "\"\"";
            }
            return "CacheKey[" + this.name + ", locale=" + l + ", module=" + this.getModule() + ", callerModule=" + this.getCallerModule() + ", format=" + this.format + "]";
        }
    }

    private static interface CacheKeyReference {
        public CacheKey getCacheKey();
    }

    public static class Control {
        public static final List<String> FORMAT_DEFAULT = Collections.unmodifiableList(Arrays.asList("java.class", "java.properties"));
        public static final List<String> FORMAT_CLASS = Collections.unmodifiableList(Arrays.asList("java.class"));
        public static final List<String> FORMAT_PROPERTIES = Collections.unmodifiableList(Arrays.asList("java.properties"));
        public static final long TTL_DONT_CACHE = -1L;
        public static final long TTL_NO_EXPIRATION_CONTROL = -2L;
        private static final Control INSTANCE = new Control();
        private static final CandidateListCache CANDIDATES_CACHE = new CandidateListCache(null);

        protected Control() {
        }

        public static final Control getControl(List<String> list) {
            if (list.equals(FORMAT_PROPERTIES)) {
                return SingleFormatControl.access$800();
            }
            if (list.equals(FORMAT_CLASS)) {
                return SingleFormatControl.access$900();
            }
            if (list.equals(FORMAT_DEFAULT)) {
                return INSTANCE;
            }
            throw new IllegalArgumentException();
        }

        public static final Control getNoFallbackControl(List<String> list) {
            if (list.equals(FORMAT_DEFAULT)) {
                return NoFallbackControl.access$1000();
            }
            if (list.equals(FORMAT_PROPERTIES)) {
                return NoFallbackControl.access$1100();
            }
            if (list.equals(FORMAT_CLASS)) {
                return NoFallbackControl.access$1200();
            }
            throw new IllegalArgumentException();
        }

        public List<String> getFormats(@ReadOnly Control this, String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            return FORMAT_DEFAULT;
        }

        public List<Locale> getCandidateLocales(@ReadOnly Control this, String string, Locale locale) {
            if (string == null) {
                throw new NullPointerException();
            }
            return new ArrayList<Locale>((Collection)CANDIDATES_CACHE.get(locale.getBaseLocale()));
        }

        public Locale getFallbackLocale(@ReadOnly Control this, String string, Locale locale) {
            if (string == null) {
                throw new NullPointerException();
            }
            Locale locale2 = Locale.getDefault();
            return locale.equals(locale2) ? null : locale2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) throws IllegalAccessException, InstantiationException, IOException {
            String string3 = this.toBundleName(string, locale);
            ResourceBundle resourceBundle = null;
            if (string2.equals("java.class")) {
                try {
                    Class<?> clazz = classLoader.loadClass(string3);
                    if (!ResourceBundle.class.isAssignableFrom(clazz)) {
                        throw new ClassCastException(clazz.getName() + " cannot be cast to ResourceBundle");
                    }
                    resourceBundle = (ResourceBundle)clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else if (string2.equals("java.properties")) {
                String string4 = this.toResourceName(string3, "properties");
                ClassLoader classLoader2 = classLoader;
                boolean bl2 = bl;
                InputStream inputStream = null;
                try {
                    inputStream = (InputStream)((Object)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<ResourceBundle>>(this, bl2, classLoader2, string4){
                        final /* synthetic */ Class val$bundleClass;
                        {
                            this.val$bundleClass = clazz;
                        }

                        @Override
                        public Constructor<ResourceBundle> run() throws NoSuchMethodException {
                            return this.val$bundleClass.getDeclaredConstructor(new Class[0]);
                        }
                    }));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
                if (inputStream != null) {
                    try {
                        resourceBundle = new PropertyResourceBundle(inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                }
            } else {
                throw new IllegalArgumentException("unknown format: " + string2);
            }
            return resourceBundle;
        }

        public long getTimeToLive(@ReadOnly Control this, String string, Locale locale) {
            if (string == null || locale == null) {
                throw new NullPointerException();
            }
            return -2L;
        }

        public boolean needsReload(String string, Locale locale, String string2, ClassLoader classLoader, ResourceBundle resourceBundle, long l) {
            if (resourceBundle == null) {
                throw new NullPointerException();
            }
            if (string2.equals("java.class") || string2.equals("java.properties")) {
                string2 = string2.substring(5);
            }
            boolean bl = false;
            try {
                String string3 = this.toResourceName(this.toBundleName(string, locale), string2);
                URL uRL = classLoader.getResource(string3);
                if (uRL != null) {
                    long l2 = 0L;
                    URLConnection uRLConnection = uRL.openConnection();
                    if (uRLConnection != null) {
                        uRLConnection.setUseCaches(false);
                        if (uRLConnection instanceof JarURLConnection) {
                            JarEntry jarEntry = ((JarURLConnection)uRLConnection).getJarEntry();
                            if (jarEntry != null && (l2 = jarEntry.getTime()) == -1L) {
                                l2 = 0L;
                            }
                        } else {
                            l2 = uRLConnection.getLastModified();
                        }
                    }
                    bl = l2 >= l;
                }
            }
            catch (NullPointerException nullPointerException) {
                throw nullPointerException;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bl;
        }

        public String toBundleName(@ReadOnly Control this, String string, Locale locale) {
            if (locale == Locale.ROOT) {
                return string;
            }
            String string2 = locale.getLanguage();
            String string3 = locale.getScript();
            String string4 = locale.getCountry();
            String string5 = locale.getVariant();
            if (string2 == "" && string4 == "" && string5 == "") {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append('_');
            if (string3 != "") {
                if (string5 != "") {
                    stringBuilder.append(string2).append('_').append(string3).append('_').append(string4).append('_').append(string5);
                } else if (string4 != "") {
                    stringBuilder.append(string2).append('_').append(string3).append('_').append(string4);
                } else {
                    stringBuilder.append(string2).append('_').append(string3);
                }
            } else if (string5 != "") {
                stringBuilder.append(string2).append('_').append(string4).append('_').append(string5);
            } else if (string4 != "") {
                stringBuilder.append(string2).append('_').append(string4);
            } else {
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }

        public final String toResourceName(@ReadOnly Control this, String string, String string2) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + 1 + string2.length());
            stringBuilder.append(string.replace('.', '/')).append('.').append(string2);
            return stringBuilder.toString();
        }

        static /* synthetic */ Control access$300() {
            return INSTANCE;
        }

        private static class CandidateListCache
        extends LocaleObjectCache<BaseLocale, List<Locale>> {
            private CandidateListCache() {
            }

            @Override
            protected List<Locale> createObject(BaseLocale base) {
                String language = base.getLanguage();
                String script = base.getScript();
                String region = base.getRegion();
                String variant = base.getVariant();
                boolean isNorwegianBokmal = false;
                boolean isNorwegianNynorsk = false;
                if (language.equals("no")) {
                    if (region.equals("NO") && variant.equals("NY")) {
                        variant = "";
                        isNorwegianNynorsk = true;
                    } else {
                        isNorwegianBokmal = true;
                    }
                }
                if (language.equals("nb") || isNorwegianBokmal) {
                    List<Locale> tmpList = CandidateListCache.getDefaultList("nb", script, region, variant);
                    ArrayList<Locale> bokmalList = new ArrayList<Locale>();
                    for (Locale l_nb : tmpList) {
                        boolean isRoot = l_nb.getLanguage().isEmpty();
                        Locale l_no = Locale.getInstance(isRoot ? "" : "no", l_nb.getScript(), l_nb.getCountry(), l_nb.getVariant(), null);
                        bokmalList.add(isNorwegianBokmal ? l_no : l_nb);
                        if (isRoot) break;
                        bokmalList.add(isNorwegianBokmal ? l_nb : l_no);
                    }
                    return bokmalList;
                }
                if (language.equals("nn") || isNorwegianNynorsk) {
                    List<Locale> nynorskList = CandidateListCache.getDefaultList("nn", script, region, variant);
                    int idx = nynorskList.size() - 1;
                    nynorskList.add(idx++, Locale.getInstance("no", "NO", "NY"));
                    nynorskList.add(idx++, Locale.getInstance("no", "NO", ""));
                    nynorskList.add(idx++, Locale.getInstance("no", "", ""));
                    return nynorskList;
                }
                if (language.equals("zh") && script.isEmpty() && !region.isEmpty()) {
                    switch (region) {
                        case "TW": 
                        case "HK": 
                        case "MO": {
                            script = "Hant";
                            break;
                        }
                        case "CN": 
                        case "SG": {
                            script = "Hans";
                        }
                    }
                }
                return CandidateListCache.getDefaultList(language, script, region, variant);
            }

            private static List<Locale> getDefaultList(String language, String script, String region, String variant) {
                ArrayList<String> variants = null;
                if (!variant.isEmpty()) {
                    variants = new ArrayList<String>();
                    int idx = variant.length();
                    while (idx != -1) {
                        variants.add(variant.substring(0, idx));
                        --idx;
                        idx = variant.lastIndexOf(95, idx);
                    }
                }
                ArrayList<Locale> list = new ArrayList<Locale>();
                if (variants != null) {
                    for (String v : variants) {
                        list.add(Locale.getInstance(language, script, region, v, null));
                    }
                }
                if (!region.isEmpty()) {
                    list.add(Locale.getInstance(language, script, region, "", null));
                }
                if (!script.isEmpty()) {
                    list.add(Locale.getInstance(language, script, "", "", null));
                    if (language.equals("zh") && region.isEmpty()) {
                        switch (script) {
                            case "Hans": {
                                region = "CN";
                                break;
                            }
                            case "Hant": {
                                region = "TW";
                            }
                        }
                    }
                    if (variants != null) {
                        for (String v : variants) {
                            list.add(Locale.getInstance(language, "", region, v, null));
                        }
                    }
                    if (!region.isEmpty()) {
                        list.add(Locale.getInstance(language, "", region, "", null));
                    }
                }
                if (!language.isEmpty()) {
                    list.add(Locale.getInstance(language, "", "", "", null));
                }
                list.add(Locale.ROOT);
                return list;
            }
        }
    }

    private static final class NoFallbackControl
    extends SingleFormatControl {
        private static final Control NO_FALLBACK = new NoFallbackControl(FORMAT_DEFAULT);
        private static final Control PROPERTIES_ONLY_NO_FALLBACK = new NoFallbackControl(FORMAT_PROPERTIES);
        private static final Control CLASS_ONLY_NO_FALLBACK = new NoFallbackControl(FORMAT_CLASS);

        protected NoFallbackControl(List<String> formats) {
            super(formats);
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            if (baseName == null || locale == null) {
                throw new NullPointerException();
            }
            return null;
        }
    }

    private static class SingleFormatControl
    extends Control {
        private static final Control PROPERTIES_ONLY = new SingleFormatControl(FORMAT_PROPERTIES);
        private static final Control CLASS_ONLY = new SingleFormatControl(FORMAT_CLASS);
        private final List<String> formats;

        protected SingleFormatControl(List<String> formats) {
            this.formats = formats;
        }

        @Override
        public List<String> getFormats(String baseName) {
            if (baseName == null) {
                throw new NullPointerException();
            }
            return this.formats;
        }
    }
}

