/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.concurrent.atomic.AtomicLong;
import org.checkerframework.checker.igj.qual.Immutable;
import org.checkerframework.checker.javari.qual.ReadOnly;
import sun.misc.Unsafe;

@Immutable
public class Random
implements Serializable {
    static final long serialVersionUID = 3905348978240129619L;
    private final AtomicLong seed;
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private static final AtomicLong seedUniquifier = new AtomicLong(8682522807148012L);
    private double nextNextGaussian;
    private boolean haveNextNextGaussian = false;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("seed", Long.TYPE), new ObjectStreamField("nextNextGaussian", Double.TYPE), new ObjectStreamField("haveNextNextGaussian", Boolean.TYPE)};
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long seedOffset;

    public Random() {
        this(Random.seedUniquifier() ^ System.nanoTime());
    }

    private static long seedUniquifier() {
        long l;
        long l2;
        while (!seedUniquifier.compareAndSet(l2 = seedUniquifier.get(), l = l2 * 181783497276652981L)) {
        }
        return l;
    }

    public Random(long l) {
        this.seed = new AtomicLong(Random.initialScramble(l));
    }

    private static long initialScramble(long l) {
        return (l ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    public synchronized void setSeed(long l) {
        this.seed.set(Random.initialScramble(l));
        this.haveNextNextGaussian = false;
    }

    protected int next(@ReadOnly Random this, int n) {
        long l;
        long l2;
        AtomicLong atomicLong = this.seed;
        while (!atomicLong.compareAndSet(l2 = atomicLong.get(), l = l2 * 25214903917L + 11L & 0xFFFFFFFFFFFFL)) {
        }
        return (int)(l >>> 48 - n);
    }

    public void nextBytes(@ReadOnly Random this, byte @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] byArray) {
        int n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            int n3 = this.nextInt();
            int n4 = Math.min(n2 - n, 4);
            while (n4-- > 0) {
                byArray[n++] = (byte)n3;
                n3 >>= 8;
            }
        }
    }

    public int nextInt(@ReadOnly Random this) {
        return this.next(32);
    }

    public int nextInt(@ReadOnly Random this, int n) {
        int n2;
        int n3;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.next(31) >> 31);
        }
        while ((n3 = this.next(31)) - (n2 = n3 % n) + (n - 1) < 0) {
        }
        return n2;
    }

    public long nextLong(@ReadOnly Random this) {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    public boolean nextBoolean(@ReadOnly Random this) {
        return this.next(1) != 0;
    }

    public float nextFloat(@ReadOnly Random this) {
        return (float)this.next(24) / 1.6777216E7f;
    }

    public double nextDouble(@ReadOnly Random this) {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) / 9.007199254740992E15;
    }

    public synchronized double nextGaussian(@ReadOnly Random this) {
        double d;
        double d2;
        double d3;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((d3 = (d2 = 2.0 * this.nextDouble() - 1.0) * d2 + (d = 2.0 * this.nextDouble() - 1.0) * d) >= 1.0 || d3 == 0.0) {
        }
        double d4 = StrictMath.sqrt(-2.0 * StrictMath.log(d3) / d3);
        this.nextNextGaussian = d * d4;
        this.haveNextNextGaussian = true;
        return d2 * d4;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        long l = getField.get("seed", -1L);
        if (l < 0L) {
            throw new StreamCorruptedException("Random: invalid seed");
        }
        this.resetSeed(l);
        this.nextNextGaussian = getField.get("nextNextGaussian", 0.0);
        this.haveNextNextGaussian = getField.get("haveNextNextGaussian", false);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("seed", this.seed.get());
        putField.put("nextNextGaussian", this.nextNextGaussian);
        putField.put("haveNextNextGaussian", this.haveNextNextGaussian);
        objectOutputStream.writeFields();
    }

    private void resetSeed(long l) {
        unsafe.putObjectVolatile(this, seedOffset, new AtomicLong(l));
    }

    static {
        try {
            seedOffset = unsafe.objectFieldOffset(Random.class.getDeclaredField("seed"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

