/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

@I
public class LinkedHashMap<K, V>
extends HashMap<K, V>
implements Map<K, V> {
    private static final long serialVersionUID = 3801124242820219131L;
    private transient Entry<K, V> header;
    private final boolean accessOrder;

    public LinkedHashMap(int n, float f) {
        super(n, f);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n) {
        super(n);
        this.accessOrder = false;
    }

    public LinkedHashMap() {
        this.accessOrder = false;
    }

    public LinkedHashMap(@org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Map<? extends K, ? extends V> map) {
        super(map);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n, float f, boolean bl) {
        super(n, f);
        this.accessOrder = bl;
    }

    @Override
    void init() {
        this.header = new Entry(-1, null, null, null);
        this.header.after = this.header;
        this.header.before = this.header.after;
    }

    @Override
    void transfer(HashMap.Entry[] entryArray) {
        int n = entryArray.length;
        Entry entry = this.header.after;
        while (entry != this.header) {
            int n2 = LinkedHashMap.indexFor(entry.hash, n);
            entry.next = entryArray[n2];
            entryArray[n2] = entry;
            entry = entry.after;
        }
    }

    @Override
    @Pure
    public boolean containsValue(@org.checkerframework.checker.igj.qual.ReadOnly LinkedHashMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        if (object == null) {
            Entry entry = this.header.after;
            while (entry != this.header) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.after;
            }
        } else {
            Entry entry = this.header.after;
            while (entry != this.header) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.after;
            }
        }
        return false;
    }

    @Override
    @Pure
    public @Nullable V get(@org.checkerframework.checker.igj.qual.ReadOnly LinkedHashMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        Entry entry = (Entry)this.getEntry(object);
        if (entry == null) {
            return null;
        }
        entry.recordAccess(this);
        return (V)entry.value;
    }

    @Override
    public void clear(@Mutable LinkedHashMap<K, V> this) {
        super.clear();
        this.header.after = this.header;
        this.header.before = this.header.after;
    }

    @Override
    Iterator<K> newKeyIterator() {
        return new KeyIterator(this, null);
    }

    @Override
    Iterator<V> newValueIterator() {
        return new ValueIterator(this, null);
    }

    @Override
    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator(this, null);
    }

    @Override
    void addEntry(int n, K k, V v, int n2) {
        this.createEntry(n, k, v, n2);
        Entry entry = this.header.after;
        if (this.removeEldestEntry(entry)) {
            this.removeEntryForKey(entry.key);
        } else if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    @Override
    void createEntry(int n, K k, V v, int n2) {
        HashMap.Entry entry = this.table[n2];
        Entry entry2 = new Entry(n, k, v, entry);
        this.table[n2] = entry2;
        Entry.access$600((Entry)entry2, this.header);
        ++this.size;
    }

    protected boolean removeEldestEntry(@ReadOnly Map.Entry<K, V> entry) {
        return false;
    }

    static /* synthetic */ boolean access$000(LinkedHashMap linkedHashMap) {
        return linkedHashMap.accessOrder;
    }

    static /* synthetic */ Entry access$100(LinkedHashMap linkedHashMap) {
        return linkedHashMap.header;
    }

    static class Entry<K, V>
    extends HashMap.Node<K, V> {
        Entry<K, V> before;
        Entry<K, V> after;

        Entry(int hash, K key, V value, HashMap.Node<K, V> next) {
            super(hash, key, value, next);
        }
    }

    abstract class LinkedHashIterator {
        Entry<K, V> next;
        Entry<K, V> current;
        int expectedModCount;
        boolean reversed;

        LinkedHashIterator(boolean reversed) {
            this.reversed = reversed;
            this.next = reversed ? LinkedHashMap.this.tail : LinkedHashMap.this.head;
            this.expectedModCount = LinkedHashMap.this.modCount;
            this.current = null;
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<K, V> nextNode() {
            Entry e = this.next;
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.current = e;
            this.next = this.reversed ? e.before : e.after;
            return e;
        }

        public final void remove() {
            Entry p = this.current;
            if (p == null) {
                throw new IllegalStateException();
            }
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.current = null;
            LinkedHashMap.this.removeNode(p.hash, p.key, null, false, false);
            this.expectedModCount = LinkedHashMap.this.modCount;
        }
    }
}

