/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@I
public class HashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    static final long serialVersionUID = -5024744406713321676L;
    private transient HashMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public HashSet() {
        this.map = new HashMap();
    }

    public HashSet(@org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<? extends E> collection) {
        this.map = new HashMap(Math.max((int)((float)collection.size() / 0.75f) + 1, 16));
        this.addAll(collection);
    }

    public HashSet(int n, float f) {
        this.map = new HashMap(n, f);
    }

    public HashSet(int n) {
        this.map = new HashMap(n);
    }

    HashSet(int n, float f, boolean bl) {
        this.map = new LinkedHashMap<E, Object>(n, f);
    }

    @Override
    public @I @PolyRead Iterator<E> iterator(@org.checkerframework.checker.igj.qual.ReadOnly HashSet<E> this) {
        return this.map.keySet().iterator();
    }

    @Override
    @Pure
    public int size(@org.checkerframework.checker.igj.qual.ReadOnly HashSet<E> this) {
        return this.map.size();
    }

    @Override
    @Pure
    public boolean isEmpty(@org.checkerframework.checker.igj.qual.ReadOnly HashSet<E> this) {
        return this.map.isEmpty();
    }

    @Override
    @Pure
    public boolean contains(@org.checkerframework.checker.igj.qual.ReadOnly HashSet<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean add(@Mutable HashSet<E> this, E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(@Mutable HashSet<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        return this.map.remove(object) == PRESENT;
    }

    @Override
    public void clear(@Mutable HashSet<E> this) {
        this.map.clear();
    }

    @SideEffectFree
    public @I(value="N") Object clone(@ReadOnly HashSet<E> this) {
        try {
            HashSet hashSet = (HashSet)super.clone();
            hashSet.map = (HashMap)this.map.clone();
            return hashSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.map.capacity());
        objectOutputStream.writeFloat(this.map.loadFactor());
        objectOutputStream.writeInt(this.map.size());
        for (E e : this.map.keySet()) {
            objectOutputStream.writeObject(e);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        float f = objectInputStream.readFloat();
        this.map = this instanceof LinkedHashSet ? new LinkedHashMap(n, f) : new HashMap(n, f);
        int n2 = objectInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            this.map.put(object, PRESENT);
        }
    }
}

