/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class ByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;

    public ByteArrayOutputStream() {
        this(32);
    }

    public ByteArrayOutputStream(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        this.buf = new byte[n];
    }

    private void ensureCapacity(int n) {
        if (n - this.buf.length > 0) {
            this.grow(n);
        }
    }

    private void grow(int n) {
        int n2 = this.buf.length;
        int n3 = n2 << 1;
        if (n3 - n < 0) {
            n3 = n;
        }
        if (n3 < 0) {
            if (n < 0) {
                throw new OutOfMemoryError();
            }
            n3 = Integer.MAX_VALUE;
        }
        this.buf = Arrays.copyOf(this.buf, n3);
    }

    @Override
    public synchronized void write(int n) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count] = (byte)n;
        ++this.count;
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 - byArray.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + n2);
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public synchronized byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    @Pure
    public synchronized int size() {
        return this.count;
    }

    @SideEffectFree
    public synchronized String toString() {
        return new String(this.buf, 0, this.count);
    }

    @SideEffectFree
    public synchronized String toString(String string) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, string);
    }

    @Deprecated
    @SideEffectFree
    public synchronized String toString(int n) {
        return new String(this.buf, n, 0, this.count);
    }

    @Override
    public void close() throws IOException {
    }
}

