/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.Raw;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import sun.misc.SharedSecrets;
import sun.reflect.ConstantPool;
import sun.reflect.FieldAccessor;
import sun.reflect.Reflection;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.FieldRepository;
import sun.reflect.generics.scope.ClassScope;

public final class Field
extends AccessibleObject
implements Member {
    private Class<?> clazz;
    private int slot;
    private String name;
    private Class<?> type;
    private int modifiers;
    private transient String signature;
    private transient FieldRepository genericInfo;
    private byte[] annotations;
    private FieldAccessor fieldAccessor;
    private FieldAccessor overrideFieldAccessor;
    private Field root;
    private transient Map<Class<? extends Annotation>, Annotation> declaredAnnotations;

    private String getGenericSignature() {
        return this.signature;
    }

    private GenericsFactory getFactory() {
        Class<?> clazz = this.getDeclaringClass();
        return CoreReflectionFactory.make(clazz, ClassScope.make(clazz));
    }

    private FieldRepository getGenericInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = FieldRepository.make(this.getGenericSignature(), this.getFactory());
        }
        return this.genericInfo;
    }

    Field(Class<?> clazz, String string, Class<?> clazz2, int n, int n2, String string2, byte[] byArray) {
        this.clazz = clazz;
        this.name = string;
        this.type = clazz2;
        this.modifiers = n;
        this.slot = n2;
        this.signature = string2;
        this.annotations = byArray;
    }

    Field copy() {
        Field field = new Field(this.clazz, this.name, this.type, this.modifiers, this.slot, this.signature, this.annotations);
        field.root = this;
        field.fieldAccessor = this.fieldAccessor;
        field.overrideFieldAccessor = this.overrideFieldAccessor;
        return field;
    }

    @Override
    @SideEffectFree
    public Class<?> getDeclaringClass(@ReadOnly Field this) {
        return this.clazz;
    }

    @Override
    @SideEffectFree
    public String getName(@ReadOnly Field this) {
        return this.name;
    }

    @Override
    @Pure
    public int getModifiers(@ReadOnly Field this) {
        return this.modifiers;
    }

    @Pure
    public boolean isEnumConstant(@ReadOnly Field this) {
        return (this.getModifiers() & 0x4000) != 0;
    }

    @Override
    @Pure
    public boolean isSynthetic(@ReadOnly Field this) {
        return Modifier.isSynthetic(this.getModifiers());
    }

    @SideEffectFree
    public Class<?> getType(@ReadOnly Field this) {
        return this.type;
    }

    @SideEffectFree
    public Type getGenericType() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getGenericType();
        }
        return this.getType();
    }

    @Pure
    public boolean equals(@ReadOnly Field this, @Nullable @ReadOnly Object object) {
        if (object != null && object instanceof Field) {
            Field field = (Field)object;
            return this.getDeclaringClass() == field.getDeclaringClass() && this.getName() == field.getName() && this.getType() == field.getType();
        }
        return false;
    }

    @Pure
    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    @SideEffectFree
    public String toString() {
        int n = this.getModifiers();
        return (n == 0 ? "" : Modifier.toString(n) + " ") + Field.getTypeName(this.getType()) + " " + Field.getTypeName(this.getDeclaringClass()) + "." + this.getName();
    }

    @SideEffectFree
    public String toGenericString() {
        int n = this.getModifiers();
        Type type = this.getGenericType();
        return (n == 0 ? "" : Modifier.toString(n) + " ") + (type instanceof Class ? Field.getTypeName((Class)type) : type.toString()) + " " + Field.getTypeName(this.getDeclaringClass()) + "." + this.getName();
    }

    @SideEffectFree
    public @Nullable Object get(@UnknownInitialization @Raw @Nullable Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(object).get(object);
    }

    @Pure
    public boolean getBoolean(@UnknownInitialization @Raw @Nullable Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(object).getBoolean(object);
    }

    @Pure
    public byte getByte(@UnknownInitialization @Raw @Nullable Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(object).getByte(object);
    }

    @Pure
    public char getChar(@UnknownInitialization @Raw @Nullable Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(object).getChar(object);
    }

    @Pure
    public short getShort(@UnknownInitialization @Raw @Nullable Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(object).getShort(object);
    }

    @Pure
    public int getInt(@UnknownInitialization @Raw @Nullable Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(object).getInt(object);
    }

    @Pure
    public long getLong(@UnknownInitialization @Raw @Nullable Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(object).getLong(object);
    }

    @Pure
    public float getFloat(@UnknownInitialization @Raw @Nullable Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(object).getFloat(object);
    }

    @Pure
    public double getDouble(@UnknownInitialization @Raw @Nullable Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getFieldAccessor(object).getDouble(object);
    }

    public void set(@UnknownInitialization @Raw @Nullable Object object, @Nullable Object object2) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(object).set(object, object2);
    }

    public void setBoolean(@UnknownInitialization @Raw @Nullable Object object, boolean bl) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(object).setBoolean(object, bl);
    }

    public void setByte(@UnknownInitialization @Raw @Nullable Object object, byte by) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(object).setByte(object, by);
    }

    public void setChar(@UnknownInitialization @Raw @Nullable Object object, char c) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(object).setChar(object, c);
    }

    public void setShort(@UnknownInitialization @Raw @Nullable Object object, short s) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(object).setShort(object, s);
    }

    public void setInt(@UnknownInitialization @Raw @Nullable Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(object).setInt(object, n);
    }

    public void setLong(@UnknownInitialization @Raw @Nullable Object object, long l) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(object).setLong(object, l);
    }

    public void setFloat(@UnknownInitialization @Raw @Nullable Object object, float f) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(object).setFloat(object, f);
    }

    public void setDouble(@UnknownInitialization @Raw @Nullable Object object, double d) throws IllegalArgumentException, IllegalAccessException {
        this.getFieldAccessor(object).setDouble(object, d);
    }

    private FieldAccessor getFieldAccessor(Object object) throws IllegalAccessException {
        this.doSecurityCheck(object);
        boolean bl = this.override;
        FieldAccessor fieldAccessor = bl ? this.overrideFieldAccessor : this.fieldAccessor;
        return fieldAccessor != null ? fieldAccessor : this.acquireFieldAccessor(bl);
    }

    private FieldAccessor acquireFieldAccessor(boolean bl) {
        FieldAccessor fieldAccessor = null;
        if (this.root != null) {
            fieldAccessor = this.root.getFieldAccessor(bl);
        }
        if (fieldAccessor != null) {
            if (bl) {
                this.overrideFieldAccessor = fieldAccessor;
            } else {
                this.fieldAccessor = fieldAccessor;
            }
        } else {
            fieldAccessor = reflectionFactory.newFieldAccessor(this, bl);
            this.setFieldAccessor(fieldAccessor, bl);
        }
        return fieldAccessor;
    }

    private FieldAccessor getFieldAccessor(boolean bl) {
        return bl ? this.overrideFieldAccessor : this.fieldAccessor;
    }

    private void setFieldAccessor(FieldAccessor fieldAccessor, boolean bl) {
        if (bl) {
            this.overrideFieldAccessor = fieldAccessor;
        } else {
            this.fieldAccessor = fieldAccessor;
        }
        if (this.root != null) {
            this.root.setFieldAccessor(fieldAccessor, bl);
        }
    }

    private void doSecurityCheck(Object object) throws IllegalAccessException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, (int)this.modifiers)) {
            Class clazz = Reflection.getCallerClass((int)4);
            this.checkAccess(clazz, this.clazz, object, this.modifiers);
        }
    }

    static String getTypeName(Class<?> clazz) {
        if (clazz.isArray()) {
            try {
                Class<?> clazz2 = clazz;
                int n = 0;
                while (clazz2.isArray()) {
                    ++n;
                    clazz2 = clazz2.getComponentType();
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(clazz2.getName());
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("[]");
                }
                return stringBuffer.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return clazz.getName();
    }

    @Override
    @SideEffectFree
    public <T extends Annotation> @Nullable T getAnnotation(Class<@NonNull T> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        return (T)this.declaredAnnotations().get(clazz);
    }

    @Override
    @SideEffectFree
    public Annotation[] getDeclaredAnnotations() {
        return AnnotationParser.toArray(this.declaredAnnotations());
    }

    private synchronized Map<Class<? extends Annotation>, Annotation> declaredAnnotations() {
        if (this.declaredAnnotations == null) {
            this.declaredAnnotations = AnnotationParser.parseAnnotations((byte[])this.annotations, (ConstantPool)SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
        }
        return this.declaredAnnotations;
    }
}

