/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class SoftReference<T>
extends Reference<T> {
    private static long clock;
    private long timestamp = clock;

    public SoftReference(T t) {
        super(t);
    }

    public SoftReference(T t, ReferenceQueue<? super T> referenceQueue) {
        super(t, referenceQueue);
    }

    @Override
    @SideEffectFree
    public T get() {
        Object t = super.get();
        if (t != null && this.timestamp != clock) {
            this.timestamp = clock;
        }
        return t;
    }
}

