/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import org.checkerframework.checker.nullness.qual.Nullable;

class Shutdown {
    private static final int RUNNING = 0;
    private static final int HOOKS = 1;
    private static final int FINALIZERS = 2;
    private static int state = 0;
    private static boolean runFinalizersOnExit = false;
    private static final int MAX_SYSTEM_HOOKS = 10;
    private static final @Nullable Runnable[] hooks = new Runnable[10];
    private static int currentRunningHook = 0;
    private static Object lock = new Lock();
    private static Object haltLock = new Lock();

    Shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setRunFinalizersOnExit(boolean bl) {
        Object object = lock;
        synchronized (object) {
            runFinalizersOnExit = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void add(int n, boolean bl, Runnable runnable) {
        Object object = lock;
        synchronized (object) {
            if (hooks[n] != null) {
                throw new InternalError("Shutdown hook at slot " + n + " already registered");
            }
            if (!bl ? state > 0 : state > 1 || state == 1 && n <= currentRunningHook) {
                throw new IllegalStateException("Shutdown in progress");
            }
            Shutdown.hooks[n] = runnable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runHooks() {
        for (int i = 0; i < 10; ++i) {
            Object object;
            try {
                Runnable runnable;
                object = lock;
                synchronized (object) {
                    currentRunningHook = i;
                    runnable = hooks[i];
                }
                if (runnable == null) continue;
                runnable.run();
                continue;
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) continue;
                object = (ThreadDeath)throwable;
                throw object;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void halt(int n) {
        Object object = haltLock;
        synchronized (object) {
            Shutdown.halt0(n);
        }
    }

    static native void halt0(int var0);

    private static native void runAllFinalizers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sequence() {
        boolean bl;
        Object object = lock;
        synchronized (object) {
            if (state != 1) {
                return;
            }
        }
        Shutdown.runHooks();
        Object object2 = lock;
        synchronized (object2) {
            state = 2;
            bl = runFinalizersOnExit;
        }
        if (bl) {
            Shutdown.runAllFinalizers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void exit(int n) {
        boolean bl = false;
        Class<Shutdown> clazz = lock;
        synchronized (clazz) {
            if (n != 0) {
                runFinalizersOnExit = false;
            }
            switch (state) {
                case 0: {
                    state = 1;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (n != 0) {
                        Shutdown.halt(n);
                        break;
                    }
                    bl = runFinalizersOnExit;
                }
            }
        }
        if (bl) {
            Shutdown.runAllFinalizers();
            Shutdown.halt(n);
        }
        clazz = Shutdown.class;
        synchronized (Shutdown.class) {
            Shutdown.sequence();
            Shutdown.halt(n);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutdown() {
        Class<Shutdown> clazz = lock;
        synchronized (clazz) {
            switch (state) {
                case 0: {
                    state = 1;
                    break;
                }
            }
        }
        clazz = Shutdown.class;
        synchronized (Shutdown.class) {
            Shutdown.sequence();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static class Lock {
        private Lock() {
        }
    }
}

