/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.SerialCallbackContext;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import jdk.internal.util.ByteArray;
import org.checkerframework.checker.nullness.qual.Nullable;
import sun.security.action.GetBooleanAction;

public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private final BlockDataOutputStream bout;
    private final HandleTable handles;
    private final ReplaceTable subs;
    private int protocol = 2;
    private int depth;
    private byte[] primVals;
    private final boolean enableOverride;
    private boolean enableReplace;
    private SerialCallbackContext curContext;
    private PutFieldImpl curPut;
    private final DebugTraceInfoStack debugInfoStack;
    private static final boolean extendedDebugInfo = AccessController.doPrivileged(new GetBooleanAction("sun.io.serialization.extendedDebugInfo"));

    public ObjectOutputStream(OutputStream outputStream) throws IOException {
        this.verifySubclass();
        this.bout = new BlockDataOutputStream(outputStream);
        this.handles = new HandleTable(10, 3.0f);
        this.subs = new ReplaceTable(10, 3.0f);
        this.enableOverride = false;
        this.writeStreamHeader();
        this.bout.setBlockDataMode(true);
        this.debugInfoStack = extendedDebugInfo ? new DebugTraceInfoStack() : null;
    }

    protected ObjectOutputStream() throws IOException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.bout = null;
        this.handles = null;
        this.subs = null;
        this.enableOverride = true;
        this.debugInfoStack = null;
    }

    public void useProtocolVersion(int n) throws IOException {
        if (this.handles.size() != 0) {
            throw new IllegalStateException("stream non-empty");
        }
        switch (n) {
            case 1: 
            case 2: {
                this.protocol = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown version: " + n);
            }
        }
    }

    @Override
    public final void writeObject(@Nullable Object object) throws IOException {
        if (this.enableOverride) {
            this.writeObjectOverride(object);
            return;
        }
        try {
            this.writeObject0(object, false);
        }
        catch (IOException iOException) {
            if (this.depth == 0) {
                this.writeFatalException(iOException);
            }
            throw iOException;
        }
    }

    protected void writeObjectOverride(Object object) throws IOException {
    }

    public void writeUnshared(Object object) throws IOException {
        try {
            this.writeObject0(object, true);
        }
        catch (IOException iOException) {
            if (this.depth == 0) {
                this.writeFatalException(iOException);
            }
            throw iOException;
        }
    }

    public void defaultWriteObject() throws IOException {
        if (this.curContext == null) {
            throw new NotActiveException("not in call to writeObject");
        }
        Object object = this.curContext.getObj();
        ObjectStreamClass objectStreamClass = this.curContext.getDesc();
        this.bout.setBlockDataMode(false);
        this.defaultWriteFields(object, objectStreamClass);
        this.bout.setBlockDataMode(true);
    }

    public PutField putFields() throws IOException {
        if (this.curPut == null) {
            if (this.curContext == null) {
                throw new NotActiveException("not in call to writeObject");
            }
            Object object = this.curContext.getObj();
            ObjectStreamClass objectStreamClass = this.curContext.getDesc();
            this.curPut = new PutFieldImpl(objectStreamClass);
        }
        return this.curPut;
    }

    public void writeFields() throws IOException {
        if (this.curPut == null) {
            throw new NotActiveException("no current PutField object");
        }
        this.bout.setBlockDataMode(false);
        this.curPut.writeFields();
        this.bout.setBlockDataMode(true);
    }

    public void reset() throws IOException {
        if (this.depth != 0) {
            throw new IOException("stream active");
        }
        this.bout.setBlockDataMode(false);
        this.bout.writeByte(121);
        this.clear();
        this.bout.setBlockDataMode(true);
    }

    protected void annotateClass(Class<?> clazz) throws IOException {
    }

    protected void annotateProxyClass(Class<?> clazz) throws IOException {
    }

    protected Object replaceObject(Object object) throws IOException {
        return object;
    }

    protected boolean enableReplaceObject(boolean bl) throws SecurityException {
        SecurityManager securityManager;
        if (bl == this.enableReplace) {
            return bl;
        }
        if (bl && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(SUBSTITUTION_PERMISSION);
        }
        this.enableReplace = bl;
        return !this.enableReplace;
    }

    protected void writeStreamHeader() throws IOException {
        this.bout.writeShort(-21267);
        this.bout.writeShort(5);
    }

    protected void writeClassDescriptor(ObjectStreamClass objectStreamClass) throws IOException {
        objectStreamClass.writeNonProxy(this);
    }

    @Override
    public void write(int n) throws IOException {
        this.bout.write(n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.bout.write(byArray, 0, byArray.length, false);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        int n3 = n + n2;
        if (n < 0 || n2 < 0 || n3 > byArray.length || n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.bout.write(byArray, n, n2, false);
    }

    @Override
    public void flush() throws IOException {
        this.bout.flush();
    }

    protected void drain() throws IOException {
        this.bout.drain();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.clear();
        this.bout.close();
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        this.bout.writeBoolean(bl);
    }

    @Override
    public void writeByte(int n) throws IOException {
        this.bout.writeByte(n);
    }

    @Override
    public void writeShort(int n) throws IOException {
        this.bout.writeShort(n);
    }

    @Override
    public void writeChar(int n) throws IOException {
        this.bout.writeChar(n);
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.bout.writeInt(n);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.bout.writeLong(l);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.bout.writeFloat(f);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.bout.writeDouble(d);
    }

    @Override
    public void writeBytes(String string) throws IOException {
        this.bout.writeBytes(string);
    }

    @Override
    public void writeChars(String string) throws IOException {
        this.bout.writeChars(string);
    }

    @Override
    public void writeUTF(String string) throws IOException {
        this.bout.writeUTF(string);
    }

    int getProtocolVersion() {
        return this.protocol;
    }

    void writeTypeString(String string) throws IOException {
        if (string == null) {
            this.writeNull();
        } else {
            int n = this.handles.lookup(string);
            if (n != -1) {
                this.writeHandle(n);
            } else {
                this.writeString(string, false);
            }
        }
    }

    private void verifySubclass() {
        Class<?> clazz = this.getClass();
        if (clazz == ObjectOutputStream.class) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        ObjectStreamClass.processQueue(Caches.subclassAuditsQueue, Caches.subclassAudits);
        ObjectStreamClass.WeakClassKey weakClassKey = new ObjectStreamClass.WeakClassKey(clazz, Caches.subclassAuditsQueue);
        Boolean bl = (Boolean)Caches.subclassAudits.get(weakClassKey);
        if (bl == null) {
            bl = ObjectOutputStream.auditSubclass(clazz);
            Caches.subclassAudits.putIfAbsent(weakClassKey, bl);
        }
        if (bl.booleanValue()) {
            return;
        }
        securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
    }

    private static boolean auditSubclass(final Class clazz) {
        Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                for (Class cl = clazz; cl != ObjectOutputStream.class; cl = cl.getSuperclass()) {
                    try {
                        cl.getDeclaredMethod("writeUnshared", Object.class);
                        return Boolean.FALSE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            cl.getDeclaredMethod("putFields", null);
                            return Boolean.FALSE;
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            continue;
                        }
                    }
                }
                return Boolean.TRUE;
            }
        });
        return bl;
    }

    private void clear() {
        this.subs.clear();
        this.handles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject0(Object clazz, boolean bl) throws IOException {
        block28: {
            boolean bl2 = this.bout.setBlockDataMode(false);
            ++this.depth;
            try {
                Class<?> clazz2;
                ObjectStreamClass objectStreamClass;
                int n;
                clazz = this.subs.lookup(clazz);
                if (clazz == null) {
                    this.writeNull();
                    return;
                }
                if (!bl && (n = this.handles.lookup(clazz)) != -1) {
                    this.writeHandle(n);
                    return;
                }
                if (clazz instanceof Class) {
                    this.writeClass(clazz, bl);
                    return;
                }
                if (clazz instanceof ObjectStreamClass) {
                    this.writeClassDesc((ObjectStreamClass)((Object)clazz), bl);
                    return;
                }
                Class<?> clazz3 = clazz;
                Class<?> clazz4 = clazz.getClass();
                while ((objectStreamClass = ObjectStreamClass.lookup(clazz4, true)).hasWriteReplaceMethod() && (clazz = objectStreamClass.invokeWriteReplace(clazz)) != null && (clazz2 = clazz.getClass()) != clazz4) {
                    clazz4 = clazz2;
                }
                if (this.enableReplace) {
                    clazz2 = this.replaceObject(clazz);
                    if (clazz2 != clazz && clazz2 != null) {
                        clazz4 = clazz2.getClass();
                        objectStreamClass = ObjectStreamClass.lookup(clazz4, true);
                    }
                    clazz = clazz2;
                }
                if (clazz != clazz3) {
                    this.subs.assign(clazz3, clazz);
                    if (clazz == null) {
                        this.writeNull();
                        return;
                    }
                    if (!bl && (n = this.handles.lookup(clazz)) != -1) {
                        this.writeHandle(n);
                        return;
                    }
                    if (clazz instanceof Class) {
                        this.writeClass(clazz, bl);
                        return;
                    }
                    if (clazz instanceof ObjectStreamClass) {
                        this.writeClassDesc((ObjectStreamClass)((Object)clazz), bl);
                        return;
                    }
                }
                if (clazz instanceof String) {
                    this.writeString((String)((Object)clazz), bl);
                    break block28;
                }
                if (clazz4.isArray()) {
                    this.writeArray(clazz, objectStreamClass, bl);
                    break block28;
                }
                if (clazz instanceof Enum) {
                    this.writeEnum((Enum)((Object)clazz), objectStreamClass, bl);
                    break block28;
                }
                if (clazz instanceof Serializable) {
                    this.writeOrdinaryObject(clazz, objectStreamClass, bl);
                    break block28;
                }
                if (extendedDebugInfo) {
                    throw new NotSerializableException(clazz4.getName() + "\n" + this.debugInfoStack.toString());
                }
                throw new NotSerializableException(clazz4.getName());
            }
            finally {
                --this.depth;
                this.bout.setBlockDataMode(bl2);
            }
        }
    }

    private void writeNull() throws IOException {
        this.bout.writeByte(112);
    }

    private void writeHandle(int n) throws IOException {
        this.bout.writeByte(113);
        this.bout.writeInt(0x7E0000 + n);
    }

    private void writeClass(Class clazz, boolean bl) throws IOException {
        this.bout.writeByte(118);
        this.writeClassDesc(ObjectStreamClass.lookup(clazz, true), false);
        this.handles.assign(bl ? null : clazz);
    }

    private void writeClassDesc(ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        int n;
        if (objectStreamClass == null) {
            this.writeNull();
        } else if (!bl && (n = this.handles.lookup(objectStreamClass)) != -1) {
            this.writeHandle(n);
        } else if (objectStreamClass.isProxy()) {
            this.writeProxyDesc(objectStreamClass, bl);
        } else {
            this.writeNonProxyDesc(objectStreamClass, bl);
        }
    }

    private void writeProxyDesc(ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        this.bout.writeByte(125);
        this.handles.assign(bl ? null : objectStreamClass);
        Class<?> clazz = objectStreamClass.forClass();
        Class<?>[] classArray = clazz.getInterfaces();
        this.bout.writeInt(classArray.length);
        for (int i = 0; i < classArray.length; ++i) {
            this.bout.writeUTF(classArray[i].getName());
        }
        this.bout.setBlockDataMode(true);
        this.annotateProxyClass(clazz);
        this.bout.setBlockDataMode(false);
        this.bout.writeByte(120);
        this.writeClassDesc(objectStreamClass.getSuperDesc(), false);
    }

    private void writeNonProxyDesc(ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        this.bout.writeByte(114);
        this.handles.assign(bl ? null : objectStreamClass);
        if (this.protocol == 1) {
            objectStreamClass.writeNonProxy(this);
        } else {
            this.writeClassDescriptor(objectStreamClass);
        }
        Class<?> clazz = objectStreamClass.forClass();
        this.bout.setBlockDataMode(true);
        this.annotateClass(clazz);
        this.bout.setBlockDataMode(false);
        this.bout.writeByte(120);
        this.writeClassDesc(objectStreamClass.getSuperDesc(), false);
    }

    private void writeString(String string, boolean bl) throws IOException {
        this.handles.assign(bl ? null : string);
        long l = this.bout.getUTFLength(string);
        if (l <= 65535L) {
            this.bout.writeByte(116);
            this.bout.writeUTF(string, l);
        } else {
            this.bout.writeByte(124);
            this.bout.writeLongUTF(string, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeArray(Object object, ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        this.bout.writeByte(117);
        this.writeClassDesc(objectStreamClass, false);
        this.handles.assign(bl ? null : object);
        Class<?> clazz = objectStreamClass.forClass().getComponentType();
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                int[] nArray = (int[])object;
                this.bout.writeInt(nArray.length);
                this.bout.writeInts(nArray, 0, nArray.length);
                return;
            } else if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                this.bout.writeInt(byArray.length);
                this.bout.write(byArray, 0, byArray.length, true);
                return;
            } else if (clazz == Long.TYPE) {
                long[] lArray = (long[])object;
                this.bout.writeInt(lArray.length);
                this.bout.writeLongs(lArray, 0, lArray.length);
                return;
            } else if (clazz == Float.TYPE) {
                float[] fArray = (float[])object;
                this.bout.writeInt(fArray.length);
                this.bout.writeFloats(fArray, 0, fArray.length);
                return;
            } else if (clazz == Double.TYPE) {
                double[] dArray = (double[])object;
                this.bout.writeInt(dArray.length);
                this.bout.writeDoubles(dArray, 0, dArray.length);
                return;
            } else if (clazz == Short.TYPE) {
                short[] sArray = (short[])object;
                this.bout.writeInt(sArray.length);
                this.bout.writeShorts(sArray, 0, sArray.length);
                return;
            } else if (clazz == Character.TYPE) {
                char[] cArray = (char[])object;
                this.bout.writeInt(cArray.length);
                this.bout.writeChars(cArray, 0, cArray.length);
                return;
            } else {
                if (clazz != Boolean.TYPE) throw new InternalError();
                boolean[] blArray = (boolean[])object;
                this.bout.writeInt(blArray.length);
                this.bout.writeBooleans(blArray, 0, blArray.length);
            }
            return;
        }
        Object[] objectArray = (Object[])object;
        int n = objectArray.length;
        this.bout.writeInt(n);
        if (extendedDebugInfo) {
            this.debugInfoStack.push("array (class \"" + object.getClass().getName() + "\", size: " + n + ")");
        }
        try {
            for (int i = 0; i < n; ++i) {
                if (extendedDebugInfo) {
                    this.debugInfoStack.push("element of array (index: " + i + ")");
                }
                try {
                    this.writeObject0(objectArray[i], false);
                    continue;
                }
                finally {
                    if (extendedDebugInfo) {
                        this.debugInfoStack.pop();
                    }
                }
            }
            return;
        }
        finally {
            if (extendedDebugInfo) {
                this.debugInfoStack.pop();
            }
        }
    }

    private void writeEnum(Enum enum_, ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        this.bout.writeByte(126);
        ObjectStreamClass objectStreamClass2 = objectStreamClass.getSuperDesc();
        this.writeClassDesc(objectStreamClass2.forClass() == Enum.class ? objectStreamClass : objectStreamClass2, false);
        this.handles.assign(bl ? null : enum_);
        this.writeString(enum_.name(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOrdinaryObject(Object object, ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
        if (extendedDebugInfo) {
            this.debugInfoStack.push((this.depth == 1 ? "root " : "") + "object (class \"" + object.getClass().getName() + "\", " + object.toString() + ")");
        }
        try {
            objectStreamClass.checkSerialize();
            this.bout.writeByte(115);
            this.writeClassDesc(objectStreamClass, false);
            this.handles.assign(bl ? null : object);
            if (objectStreamClass.isExternalizable() && !objectStreamClass.isProxy()) {
                this.writeExternalData((Externalizable)object);
            } else {
                this.writeSerialData(object, objectStreamClass);
            }
        }
        finally {
            if (extendedDebugInfo) {
                this.debugInfoStack.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeExternalData(Externalizable externalizable) throws IOException {
        PutFieldImpl putFieldImpl = this.curPut;
        this.curPut = null;
        if (extendedDebugInfo) {
            this.debugInfoStack.push("writeExternal data");
        }
        SerialCallbackContext serialCallbackContext = this.curContext;
        try {
            this.curContext = null;
            if (this.protocol == 1) {
                externalizable.writeExternal(this);
            } else {
                this.bout.setBlockDataMode(true);
                externalizable.writeExternal(this);
                this.bout.setBlockDataMode(false);
                this.bout.writeByte(120);
            }
        }
        finally {
            this.curContext = serialCallbackContext;
            if (extendedDebugInfo) {
                this.debugInfoStack.pop();
            }
        }
        this.curPut = putFieldImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSerialData(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        ObjectStreamClass.ClassDataSlot[] classDataSlotArray = objectStreamClass.getClassDataLayout();
        for (int i = 0; i < classDataSlotArray.length; ++i) {
            ObjectStreamClass objectStreamClass2 = classDataSlotArray[i].desc;
            if (objectStreamClass2.hasWriteObjectMethod()) {
                PutFieldImpl putFieldImpl = this.curPut;
                this.curPut = null;
                SerialCallbackContext serialCallbackContext = this.curContext;
                if (extendedDebugInfo) {
                    this.debugInfoStack.push("custom writeObject data (class \"" + objectStreamClass2.getName() + "\")");
                }
                try {
                    this.curContext = new SerialCallbackContext(object, objectStreamClass2);
                    this.bout.setBlockDataMode(true);
                    objectStreamClass2.invokeWriteObject(object, this);
                    this.bout.setBlockDataMode(false);
                    this.bout.writeByte(120);
                }
                finally {
                    this.curContext.setUsed();
                    this.curContext = serialCallbackContext;
                    if (extendedDebugInfo) {
                        this.debugInfoStack.pop();
                    }
                }
                this.curPut = putFieldImpl;
                continue;
            }
            this.defaultWriteFields(object, objectStreamClass2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultWriteFields(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        objectStreamClass.checkDefaultSerialize();
        int n = objectStreamClass.getPrimDataSize();
        if (this.primVals == null || this.primVals.length < n) {
            this.primVals = new byte[n];
        }
        objectStreamClass.getPrimFieldValues(object, this.primVals);
        this.bout.write(this.primVals, 0, n, false);
        ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFields(false);
        Object[] objectArray = new Object[objectStreamClass.getNumObjFields()];
        int n2 = objectStreamFieldArray.length - objectArray.length;
        objectStreamClass.getObjFieldValues(object, objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            if (extendedDebugInfo) {
                this.debugInfoStack.push("field (class \"" + objectStreamClass.getName() + "\", name: \"" + objectStreamFieldArray[n2 + i].getName() + "\", type: \"" + objectStreamFieldArray[n2 + i].getType() + "\")");
            }
            try {
                this.writeObject0(objectArray[i], objectStreamFieldArray[n2 + i].isUnshared());
                continue;
            }
            finally {
                if (extendedDebugInfo) {
                    this.debugInfoStack.pop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFatalException(IOException iOException) throws IOException {
        this.clear();
        boolean bl = this.bout.setBlockDataMode(false);
        try {
            this.bout.writeByte(123);
            this.writeObject0(iOException, false);
            this.clear();
        }
        finally {
            this.bout.setBlockDataMode(bl);
        }
    }

    private static native void floatsToBytes(float[] var0, int var1, byte[] var2, int var3, int var4);

    private static native void doublesToBytes(double[] var0, int var1, byte[] var2, int var3, int var4);

    static /* synthetic */ BlockDataOutputStream access$000(ObjectOutputStream objectOutputStream) {
        return objectOutputStream.bout;
    }

    static /* synthetic */ boolean access$100() {
        return extendedDebugInfo;
    }

    static /* synthetic */ DebugTraceInfoStack access$200(ObjectOutputStream objectOutputStream) {
        return objectOutputStream.debugInfoStack;
    }

    static /* synthetic */ void access$300(ObjectOutputStream objectOutputStream, Object object, boolean bl) throws IOException {
        objectOutputStream.writeObject0(object, bl);
    }

    static /* synthetic */ void access$400(float[] fArray, int n, byte[] byArray, int n2, int n3) {
        ObjectOutputStream.floatsToBytes(fArray, n, byArray, n2, n3);
    }

    static /* synthetic */ void access$500(double[] dArray, int n, byte[] byArray, int n2, int n3) {
        ObjectOutputStream.doublesToBytes(dArray, n, byArray, n2, n3);
    }

    private static final class BlockDataOutputStream
    extends OutputStream
    implements DataOutput {
        private static final int MAX_BLOCK_SIZE = 1024;
        private static final int MAX_HEADER_SIZE = 5;
        private static final int CHAR_BUF_SIZE = 256;
        private final byte[] buf = new byte[1024];
        private final byte[] hbuf = new byte[5];
        private final char[] cbuf = new char[256];
        private boolean blkmode = false;
        private int pos = 0;
        private final OutputStream out;
        private final DataOutputStream dout;

        BlockDataOutputStream(OutputStream out) {
            this.out = out;
            this.dout = new DataOutputStream(this);
        }

        boolean setBlockDataMode(boolean mode) throws IOException {
            if (this.blkmode == mode) {
                return this.blkmode;
            }
            this.drain();
            this.blkmode = mode;
            return !this.blkmode;
        }

        boolean getBlockDataMode() {
            return this.blkmode;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            this.buf[this.pos++] = (byte)b;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length, false);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.write(b, off, len, false);
        }

        @Override
        public void flush() throws IOException {
            this.drain();
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.out.close();
        }

        void write(byte[] b, int off, int len, boolean copy) throws IOException {
            if (!copy && !this.blkmode) {
                this.drain();
                this.out.write(b, off, len);
                return;
            }
            while (len > 0) {
                if (this.pos >= 1024) {
                    this.drain();
                }
                if (len >= 1024 && !copy && this.pos == 0) {
                    this.writeBlockHeader(1024);
                    this.out.write(b, off, 1024);
                    off += 1024;
                    len -= 1024;
                    continue;
                }
                int wlen = Math.min(len, 1024 - this.pos);
                System.arraycopy(b, off, this.buf, this.pos, wlen);
                this.pos += wlen;
                off += wlen;
                len -= wlen;
            }
        }

        void drain() throws IOException {
            if (this.pos == 0) {
                return;
            }
            if (this.blkmode) {
                this.writeBlockHeader(this.pos);
            }
            this.out.write(this.buf, 0, this.pos);
            this.pos = 0;
        }

        private void writeBlockHeader(int len) throws IOException {
            if (len <= 255) {
                this.hbuf[0] = 119;
                this.hbuf[1] = (byte)len;
                this.out.write(this.hbuf, 0, 2);
            } else {
                this.hbuf[0] = 122;
                ByteArray.setInt(this.hbuf, 1, len);
                this.out.write(this.hbuf, 0, 5);
            }
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            ByteArray.setBoolean(this.buf, this.pos++, v);
        }

        @Override
        public void writeByte(int v) throws IOException {
            if (this.pos >= 1024) {
                this.drain();
            }
            this.buf[this.pos++] = (byte)v;
        }

        @Override
        public void writeChar(int v) throws IOException {
            if (this.pos + 2 <= 1024) {
                ByteArray.setChar(this.buf, this.pos, (char)v);
                this.pos += 2;
            } else {
                this.dout.writeChar(v);
            }
        }

        @Override
        public void writeShort(int v) throws IOException {
            if (this.pos + 2 <= 1024) {
                ByteArray.setShort(this.buf, this.pos, (short)v);
                this.pos += 2;
            } else {
                this.dout.writeShort(v);
            }
        }

        @Override
        public void writeInt(int v) throws IOException {
            if (this.pos + 4 <= 1024) {
                ByteArray.setInt(this.buf, this.pos, v);
                this.pos += 4;
            } else {
                this.dout.writeInt(v);
            }
        }

        @Override
        public void writeFloat(float v) throws IOException {
            if (this.pos + 4 <= 1024) {
                ByteArray.setFloat(this.buf, this.pos, v);
                this.pos += 4;
            } else {
                this.dout.writeFloat(v);
            }
        }

        @Override
        public void writeLong(long v) throws IOException {
            if (this.pos + 8 <= 1024) {
                ByteArray.setLong(this.buf, this.pos, v);
                this.pos += 8;
            } else {
                this.dout.writeLong(v);
            }
        }

        @Override
        public void writeDouble(double v) throws IOException {
            if (this.pos + 8 <= 1024) {
                ByteArray.setDouble(this.buf, this.pos, v);
                this.pos += 8;
            } else {
                this.dout.writeDouble(v);
            }
        }

        @Override
        public void writeBytes(String s) throws IOException {
            int n;
            int endoff = s.length();
            int cpos = 0;
            int csize = 0;
            for (int off = 0; off < endoff; off += n) {
                if (cpos >= csize) {
                    cpos = 0;
                    csize = Math.min(endoff - off, 256);
                    s.getChars(off, off + csize, this.cbuf, 0);
                }
                if (this.pos >= 1024) {
                    this.drain();
                }
                n = Math.min(csize - cpos, 1024 - this.pos);
                int stop = this.pos + n;
                while (this.pos < stop) {
                    this.buf[this.pos++] = (byte)this.cbuf[cpos++];
                }
            }
        }

        @Override
        public void writeChars(String s) throws IOException {
            int csize;
            int endoff = s.length();
            for (int off = 0; off < endoff; off += csize) {
                csize = Math.min(endoff - off, 256);
                s.getChars(off, off + csize, this.cbuf, 0);
                this.writeChars(this.cbuf, 0, csize);
            }
        }

        @Override
        public void writeUTF(String s) throws IOException {
            this.writeUTF(s, this.getUTFLength(s));
        }

        void writeBooleans(boolean[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos >= 1024) {
                    this.drain();
                }
                int stop = Math.min(endoff, off + (1024 - this.pos));
                while (off < stop) {
                    ByteArray.setBoolean(this.buf, this.pos++, v[off++]);
                }
            }
        }

        void writeChars(char[] v, int off, int len) throws IOException {
            int limit = 1022;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 1;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        ByteArray.setChar(this.buf, this.pos, v[off++]);
                        this.pos += 2;
                    }
                    continue;
                }
                this.dout.writeChar(v[off++]);
            }
        }

        void writeShorts(short[] v, int off, int len) throws IOException {
            int limit = 1022;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 1;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        ByteArray.setShort(this.buf, this.pos, v[off++]);
                        this.pos += 2;
                    }
                    continue;
                }
                this.dout.writeShort(v[off++]);
            }
        }

        void writeInts(int[] v, int off, int len) throws IOException {
            int limit = 1020;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 2;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        ByteArray.setInt(this.buf, this.pos, v[off++]);
                        this.pos += 4;
                    }
                    continue;
                }
                this.dout.writeInt(v[off++]);
            }
        }

        void writeFloats(float[] v, int off, int len) throws IOException {
            int limit = 1020;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 2;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        ByteArray.setFloat(this.buf, this.pos, v[off++]);
                        this.pos += 4;
                    }
                    continue;
                }
                this.dout.writeFloat(v[off++]);
            }
        }

        void writeLongs(long[] v, int off, int len) throws IOException {
            int limit = 1016;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 3;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        ByteArray.setLong(this.buf, this.pos, v[off++]);
                        this.pos += 8;
                    }
                    continue;
                }
                this.dout.writeLong(v[off++]);
            }
        }

        void writeDoubles(double[] v, int off, int len) throws IOException {
            int limit = 1016;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = 1024 - this.pos >> 3;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        ByteArray.setDouble(this.buf, this.pos, v[off++]);
                        this.pos += 8;
                    }
                    continue;
                }
                this.dout.writeDouble(v[off++]);
            }
        }

        long getUTFLength(String s) {
            int csize;
            int len = s.length();
            long utflen = 0L;
            for (int off = 0; off < len; off += csize) {
                csize = Math.min(len - off, 256);
                s.getChars(off, off + csize, this.cbuf, 0);
                for (int cpos = 0; cpos < csize; ++cpos) {
                    char c = this.cbuf[cpos];
                    if (c >= '\u0001' && c <= '\u007f') {
                        ++utflen;
                        continue;
                    }
                    if (c > '\u07ff') {
                        utflen += 3L;
                        continue;
                    }
                    utflen += 2L;
                }
            }
            return utflen;
        }

        void writeUTF(String s, long utflen) throws IOException {
            if (utflen > 65535L) {
                throw new UTFDataFormatException();
            }
            this.writeShort((int)utflen);
            if (utflen == (long)s.length()) {
                this.writeBytes(s);
            } else {
                this.writeUTFBody(s);
            }
        }

        void writeLongUTF(String s) throws IOException {
            this.writeLongUTF(s, this.getUTFLength(s));
        }

        void writeLongUTF(String s, long utflen) throws IOException {
            this.writeLong(utflen);
            if (utflen == (long)s.length()) {
                this.writeBytes(s);
            } else {
                this.writeUTFBody(s);
            }
        }

        private void writeUTFBody(String s) throws IOException {
            int csize;
            int limit = 1021;
            int len = s.length();
            for (int off = 0; off < len; off += csize) {
                csize = Math.min(len - off, 256);
                s.getChars(off, off + csize, this.cbuf, 0);
                for (int cpos = 0; cpos < csize; ++cpos) {
                    char c = this.cbuf[cpos];
                    if (this.pos <= limit) {
                        if (c <= '\u007f' && c != '\u0000') {
                            this.buf[this.pos++] = (byte)c;
                            continue;
                        }
                        if (c > '\u07ff') {
                            this.buf[this.pos + 2] = (byte)(0x80 | c >> 0 & 0x3F);
                            this.buf[this.pos + 1] = (byte)(0x80 | c >> 6 & 0x3F);
                            this.buf[this.pos + 0] = (byte)(0xE0 | c >> 12 & 0xF);
                            this.pos += 3;
                            continue;
                        }
                        this.buf[this.pos + 1] = (byte)(0x80 | c >> 0 & 0x3F);
                        this.buf[this.pos + 0] = (byte)(0xC0 | c >> 6 & 0x1F);
                        this.pos += 2;
                        continue;
                    }
                    if (c <= '\u007f' && c != '\u0000') {
                        this.write(c);
                        continue;
                    }
                    if (c > '\u07ff') {
                        this.write(0xE0 | c >> 12 & 0xF);
                        this.write(0x80 | c >> 6 & 0x3F);
                        this.write(0x80 | c >> 0 & 0x3F);
                        continue;
                    }
                    this.write(0xC0 | c >> 6 & 0x1F);
                    this.write(0x80 | c >> 0 & 0x3F);
                }
            }
        }
    }

    private static class Caches {
        static final ClassValue<Boolean> subclassAudits = new ClassValue<Boolean>(){

            @Override
            protected Boolean computeValue(Class<?> type) {
                return ObjectOutputStream.auditSubclass(type);
            }
        };

        private Caches() {
        }
    }

    private static final class DebugTraceInfoStack {
        private final List<String> stack = new ArrayList<String>();

        DebugTraceInfoStack() {
        }

        void clear() {
            this.stack.clear();
        }

        void pop() {
            this.stack.remove(this.stack.size() - 1);
        }

        void push(String entry) {
            this.stack.add("\t- " + entry);
        }

        public String toString() {
            StringJoiner sj = new StringJoiner("\n");
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                sj.add(this.stack.get(i));
            }
            return sj.toString();
        }
    }

    private static final class HandleTable {
        private int size;
        private int threshold;
        private final float loadFactor;
        private int[] spine;
        private int[] next;
        private Object[] objs;

        HandleTable(int initialCapacity, float loadFactor) {
            this.loadFactor = loadFactor;
            this.spine = new int[initialCapacity];
            this.next = new int[initialCapacity];
            this.objs = new Object[initialCapacity];
            this.threshold = (int)((float)initialCapacity * loadFactor);
            this.clear();
        }

        int assign(Object obj) {
            if (this.size >= this.next.length) {
                this.growEntries();
            }
            if (this.size >= this.threshold) {
                this.growSpine();
            }
            this.insert(obj, this.size);
            return this.size++;
        }

        int lookup(Object obj) {
            if (this.size == 0) {
                return -1;
            }
            int index = this.hash(obj) % this.spine.length;
            int i = this.spine[index];
            while (i >= 0) {
                if (this.objs[i] == obj) {
                    return i;
                }
                i = this.next[i];
            }
            return -1;
        }

        void clear() {
            Arrays.fill(this.spine, -1);
            Arrays.fill(this.objs, 0, this.size, null);
            this.size = 0;
        }

        int size() {
            return this.size;
        }

        private void insert(Object obj, int handle) {
            int index = this.hash(obj) % this.spine.length;
            this.objs[handle] = obj;
            this.next[handle] = this.spine[index];
            this.spine[index] = handle;
        }

        private void growSpine() {
            this.spine = new int[(this.spine.length << 1) + 1];
            this.threshold = (int)((float)this.spine.length * this.loadFactor);
            Arrays.fill(this.spine, -1);
            for (int i = 0; i < this.size; ++i) {
                this.insert(this.objs[i], i);
            }
        }

        private void growEntries() {
            int newLength = (this.next.length << 1) + 1;
            int[] newNext = new int[newLength];
            System.arraycopy(this.next, 0, newNext, 0, this.size);
            this.next = newNext;
            Object[] newObjs = new Object[newLength];
            System.arraycopy(this.objs, 0, newObjs, 0, this.size);
            this.objs = newObjs;
        }

        private int hash(Object obj) {
            return System.identityHashCode(obj) & Integer.MAX_VALUE;
        }
    }

    public static abstract class PutField {
        public abstract void put(String var1, boolean var2);

        public abstract void put(String var1, byte var2);

        public abstract void put(String var1, char var2);

        public abstract void put(String var1, short var2);

        public abstract void put(String var1, int var2);

        public abstract void put(String var1, long var2);

        public abstract void put(String var1, float var2);

        public abstract void put(String var1, double var2);

        public abstract void put(String var1, @Nullable Object var2);

        @Deprecated
        public abstract void write(ObjectOutput var1) throws IOException;
    }

    private class PutFieldImpl
    extends PutField {
        private final ObjectStreamClass desc;
        private final byte[] primVals;
        private final Object[] objVals;

        PutFieldImpl(ObjectStreamClass desc) {
            this.desc = desc;
            this.primVals = new byte[desc.getPrimDataSize()];
            this.objVals = new Object[desc.getNumObjFields()];
        }

        @Override
        public void put(String name, boolean val) {
            ByteArray.setBoolean(this.primVals, this.getFieldOffset(name, Boolean.TYPE), val);
        }

        @Override
        public void put(String name, byte val) {
            this.primVals[this.getFieldOffset((String)name, Byte.TYPE)] = val;
        }

        @Override
        public void put(String name, char val) {
            ByteArray.setChar(this.primVals, this.getFieldOffset(name, Character.TYPE), val);
        }

        @Override
        public void put(String name, short val) {
            ByteArray.setShort(this.primVals, this.getFieldOffset(name, Short.TYPE), val);
        }

        @Override
        public void put(String name, int val) {
            ByteArray.setInt(this.primVals, this.getFieldOffset(name, Integer.TYPE), val);
        }

        @Override
        public void put(String name, float val) {
            ByteArray.setFloat(this.primVals, this.getFieldOffset(name, Float.TYPE), val);
        }

        @Override
        public void put(String name, long val) {
            ByteArray.setLong(this.primVals, this.getFieldOffset(name, Long.TYPE), val);
        }

        @Override
        public void put(String name, double val) {
            ByteArray.setDouble(this.primVals, this.getFieldOffset(name, Double.TYPE), val);
        }

        @Override
        public void put(String name, Object val) {
            this.objVals[this.getFieldOffset((String)name, Object.class)] = val;
        }

        @Override
        public void write(ObjectOutput out) throws IOException {
            if (ObjectOutputStream.this != out) {
                throw new IllegalArgumentException("wrong stream");
            }
            out.write(this.primVals, 0, this.primVals.length);
            ObjectStreamField[] fields = this.desc.getFields(false);
            int numPrimFields = fields.length - this.objVals.length;
            for (int i = 0; i < this.objVals.length; ++i) {
                if (fields[numPrimFields + i].isUnshared()) {
                    throw new IOException("cannot write unshared object");
                }
                out.writeObject(this.objVals[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeFields() throws IOException {
            ObjectOutputStream.this.bout.write(this.primVals, 0, this.primVals.length, false);
            ObjectStreamField[] fields = this.desc.getFields(false);
            int numPrimFields = fields.length - this.objVals.length;
            for (int i = 0; i < this.objVals.length; ++i) {
                if (extendedDebugInfo) {
                    ObjectOutputStream.this.debugInfoStack.push("field (class \"" + this.desc.getName() + "\", name: \"" + fields[numPrimFields + i].getName() + "\", type: \"" + fields[numPrimFields + i].getType() + "\")");
                }
                try {
                    ObjectOutputStream.this.writeObject0(this.objVals[i], fields[numPrimFields + i].isUnshared());
                    continue;
                }
                finally {
                    if (extendedDebugInfo) {
                        ObjectOutputStream.this.debugInfoStack.pop();
                    }
                }
            }
        }

        private int getFieldOffset(String name, Class<?> type) {
            ObjectStreamField field = this.desc.getField(name, type);
            if (field == null) {
                throw new IllegalArgumentException("no such field " + name + " with type " + type);
            }
            return field.getOffset();
        }
    }

    private static final class ReplaceTable {
        private final HandleTable htab;
        private Object[] reps;

        ReplaceTable(int initialCapacity, float loadFactor) {
            this.htab = new HandleTable(initialCapacity, loadFactor);
            this.reps = new Object[initialCapacity];
        }

        void assign(Object obj, Object rep) {
            int index = this.htab.assign(obj);
            while (index >= this.reps.length) {
                this.grow();
            }
            this.reps[index] = rep;
        }

        Object lookup(Object obj) {
            int index = this.htab.lookup(obj);
            return index >= 0 ? this.reps[index] : obj;
        }

        void clear() {
            Arrays.fill(this.reps, 0, this.htab.size(), null);
            this.htab.clear();
        }

        int size() {
            return this.htab.size();
        }

        private void grow() {
            Object[] newReps = new Object[(this.reps.length << 1) + 1];
            System.arraycopy(this.reps, 0, newReps, 0, this.reps.length);
            this.reps = newReps;
        }
    }
}

