/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.EmptyStackException;
import java.util.Vector;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.ReadOnly;

@I
public class Stack<E>
extends Vector<E> {
    private static final long serialVersionUID = 1224463164541339165L;

    public E push(@Mutable Stack<E> this, E e) {
        this.addElement(e);
        return e;
    }

    public synchronized E pop(@Mutable Stack<E> this) {
        int n = this.size();
        E e = this.peek();
        this.removeElementAt(n - 1);
        return e;
    }

    public synchronized E peek(@org.checkerframework.checker.igj.qual.ReadOnly Stack<E> this) {
        int n = this.size();
        if (n == 0) {
            throw new EmptyStackException();
        }
        return this.elementAt(n - 1);
    }

    public boolean empty(@org.checkerframework.checker.igj.qual.ReadOnly Stack<E> this) {
        return this.size() == 0;
    }

    public synchronized int search(@org.checkerframework.checker.igj.qual.ReadOnly Stack<E> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        int n = this.lastIndexOf(object);
        if (n >= 0) {
            return this.size() - n;
        }
        return -1;
    }
}

