/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.javacutil;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import java.util.List;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.javacutil.SystemUtil;
import org.checkerframework.javacutil.TreeUtilsAfterJava11;

public abstract class SwitchExpressionScanner<R, P>
extends TreeScanner<R, P> {
    protected final YieldVisitor yieldVisitor = new YieldVisitor();

    protected abstract R visitSwitchResultExpression(ExpressionTree var1, P var2);

    protected abstract R combineResults(@Nullable R var1, @Nullable R var2);

    public R scanSwitchExpression(Tree switchExpression, P p) {
        assert (SystemUtil.jreVersion >= 14 && switchExpression.getKind().name().equals("SWITCH_EXPRESSION"));
        List<? extends CaseTree> caseTrees = TreeUtilsAfterJava11.SwitchExpressionUtils.getCases(switchExpression);
        Object result = null;
        for (CaseTree caseTree : caseTrees) {
            if (caseTree.getStatements() != null) {
                result = this.combineResults(result, this.yieldVisitor.scan(caseTree.getStatements(), p));
                continue;
            }
            @NonNull Tree body = TreeUtilsAfterJava11.CaseUtils.getBody(caseTree);
            if (body instanceof BlockTree) {
                result = this.combineResults(result, this.yieldVisitor.scan(((BlockTree)body).getStatements(), p));
                continue;
            }
            if (body instanceof ThrowTree) continue;
            ExpressionTree expressionTree = (ExpressionTree)body;
            result = this.combineResults(result, this.visitSwitchResultExpression(expressionTree, p));
        }
        @NonNull Object nonNullResult = result;
        return nonNullResult;
    }

    protected class YieldVisitor
    extends TreeScanner<R, P> {
        protected YieldVisitor() {
        }

        @Override
        public @Nullable R scan(Tree tree, P p) {
            if (tree == null) {
                return null;
            }
            if (tree.getKind().name().equals("SWITCH_EXPRESSION")) {
                return null;
            }
            if (tree.getKind().name().equals("YIELD")) {
                ExpressionTree value = TreeUtilsAfterJava11.YieldUtils.getValue(tree);
                return SwitchExpressionScanner.this.visitSwitchResultExpression(value, p);
            }
            return super.scan(tree, p);
        }

        @Override
        public R reduce(R r1, R r2) {
            return SwitchExpressionScanner.this.combineResults(r1, r2);
        }
    }

    public static class FunctionalSwitchExpressionScanner<R1, P1>
    extends SwitchExpressionScanner<R1, P1> {
        private final BiFunction<ExpressionTree, P1, R1> switchValueExpressionFunction;
        private final BiFunction<@Nullable R1, @Nullable R1, R1> combineResultFunc;

        public FunctionalSwitchExpressionScanner(BiFunction<ExpressionTree, P1, R1> switchValueExpressionFunc, BiFunction<@Nullable R1, @Nullable R1, R1> combineResultFunc) {
            this.switchValueExpressionFunction = switchValueExpressionFunc;
            this.combineResultFunc = combineResultFunc;
        }

        @Override
        protected R1 visitSwitchResultExpression(ExpressionTree resultExpressionTree, P1 p1) {
            return this.switchValueExpressionFunction.apply(resultExpressionTree, p1);
        }

        @Override
        protected R1 combineResults(@Nullable R1 r1, @Nullable R1 r2) {
            return this.combineResultFunc.apply(r1, r2);
        }
    }
}

