/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.javacutil;

import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Options;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.javacutil.UserError;

public class SystemUtil {
    public static int getJreVersion() {
        String jreVersionStr = System.getProperty("java.version");
        Pattern oldVersionPattern = Pattern.compile("^1\\.(\\d+)\\..*$");
        Matcher oldVersionMatcher = oldVersionPattern.matcher(jreVersionStr);
        if (oldVersionMatcher.matches()) {
            String v = oldVersionMatcher.group(1);
            assert (v != null) : "@AssumeAssertion(nullness): inspection";
            return Integer.parseInt(v);
        }
        Pattern newVersionPattern = Pattern.compile("^(\\d+).*$");
        Matcher newVersionMatcher = newVersionPattern.matcher(jreVersionStr);
        if (newVersionMatcher.matches()) {
            String v = newVersionMatcher.group(1);
            assert (v != null) : "@AssumeAssertion(nullness): inspection";
            return Integer.parseInt(v);
        }
        Pattern eaVersionPattern = Pattern.compile("^(\\d+)-ea$");
        Matcher eaVersionMatcher = eaVersionPattern.matcher(jreVersionStr);
        if (eaVersionMatcher.matches()) {
            String v = eaVersionMatcher.group(1);
            assert (v != null) : "@AssumeAssertion(nullness): inspection";
            return Integer.parseInt(v);
        }
        throw new RuntimeException("Could not determine version from property java.version=" + jreVersionStr);
    }

    public static @Nullable String getReleaseValue(ProcessingEnvironment env) {
        Context ctx = ((JavacProcessingEnvironment)env).getContext();
        Options options = Options.instance(ctx);
        return options.get(Option.RELEASE);
    }

    public static @Nullable String getToolsJar() {
        String toolsJarFilename;
        if (SystemUtil.getJreVersion() > 8) {
            return null;
        }
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome == null) {
            String javaHomeProperty = System.getProperty("java.home");
            if (javaHomeProperty.endsWith(File.separator + "jre")) {
                javaHome = javaHomeProperty.substring(javaHomeProperty.length() - 4);
            } else {
                throw new Error("Can't infer Java home; java.home=" + javaHomeProperty);
            }
        }
        if (!new File(toolsJarFilename = javaHome + File.separator + "lib" + File.separator + "tools.jar").exists()) {
            throw new Error(String.format("File does not exist: %s ; JAVA_HOME=%s ; java.home=%s", toolsJarFilename, javaHome, System.getProperty("java.home")));
        }
        return javaHome + File.separator + "lib" + File.separator + "tools.jar";
    }

    public static <T> List<T> union(List<T> list1, List<T> list2) {
        ArrayList result = new ArrayList(list1.size() + list2.size());
        SystemUtil.addWithoutDuplicates(result, list1);
        SystemUtil.addWithoutDuplicates(result, list2);
        return result;
    }

    public static <T> void addWithoutDuplicates(List<T> dest, List<? extends T> source) {
        for (T elt : source) {
            if (dest.contains(elt)) continue;
            dest.add(elt);
        }
    }

    public static <T> List<T> intersection(List<? extends T> list1, List<? extends T> list2) {
        ArrayList<T> result = new ArrayList<T>(list1);
        result.retainAll(list2);
        return result;
    }

    @Deprecated
    public static List<String> readFile(File argFile) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(argFile));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            lines.add(line);
        }
        br.close();
        return lines;
    }

    @Deprecated
    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    @Deprecated
    public static <T> T[] concatenate(T firstElt, T[] array, T lastElt) {
        T[] result = Arrays.copyOf(array, array.length + 2);
        result[0] = firstElt;
        System.arraycopy(array, 0, result, 1, array.length);
        result[result.length - 1] = lastElt;
        return result;
    }

    @Deprecated
    public static boolean getBooleanSystemProperty(String key) {
        return Boolean.parseBoolean(System.getProperty(key, "false"));
    }

    @Deprecated
    public static boolean getBooleanSystemProperty(String key, boolean defaultValue) {
        String value = System.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw new UserError(String.format("Value for system property %s should be boolean, but is \"%s\".", key, value));
    }

    @Deprecated
    public static <T> T[] concatenate(T[] array1, T ... array2) {
        T[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    @Deprecated
    public static int mapCapacity(int numElements) {
        return numElements * 4 / 3 + 1;
    }

    @Deprecated
    public static int mapCapacity(Collection<?> c) {
        return SystemUtil.mapCapacity(c.size());
    }

    @Deprecated
    public static int mapCapacity(Map<?, ?> m) {
        return SystemUtil.mapCapacity(m.size());
    }
}

