/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.builder;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.ReferenceType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.checkerframework.checker.interning.qual.FindDistinct;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.builder.ConditionalJump;
import org.checkerframework.dataflow.cfg.builder.ExtendedNode;
import org.checkerframework.dataflow.cfg.builder.Label;
import org.checkerframework.dataflow.cfg.builder.LabelCell;
import org.checkerframework.dataflow.cfg.builder.NodeHolder;
import org.checkerframework.dataflow.cfg.builder.NodeWithExceptionsHolder;
import org.checkerframework.dataflow.cfg.builder.PhaseOneResult;
import org.checkerframework.dataflow.cfg.builder.TreeInfo;
import org.checkerframework.dataflow.cfg.builder.TryCatchFrame;
import org.checkerframework.dataflow.cfg.builder.TryFinallyFrame;
import org.checkerframework.dataflow.cfg.builder.TryFinallyScopeMap;
import org.checkerframework.dataflow.cfg.builder.TryStack;
import org.checkerframework.dataflow.cfg.builder.UnconditionalJump;
import org.checkerframework.dataflow.cfg.node.AnyPatternNode;
import org.checkerframework.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.dataflow.cfg.node.ArrayTypeNode;
import org.checkerframework.dataflow.cfg.node.AssertionErrorNode;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.dataflow.cfg.node.BitwiseAndNode;
import org.checkerframework.dataflow.cfg.node.BitwiseComplementNode;
import org.checkerframework.dataflow.cfg.node.BitwiseOrNode;
import org.checkerframework.dataflow.cfg.node.BitwiseXorNode;
import org.checkerframework.dataflow.cfg.node.BooleanLiteralNode;
import org.checkerframework.dataflow.cfg.node.CaseNode;
import org.checkerframework.dataflow.cfg.node.CatchMarkerNode;
import org.checkerframework.dataflow.cfg.node.CharacterLiteralNode;
import org.checkerframework.dataflow.cfg.node.ClassDeclarationNode;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.ConditionalAndNode;
import org.checkerframework.dataflow.cfg.node.ConditionalNotNode;
import org.checkerframework.dataflow.cfg.node.ConditionalOrNode;
import org.checkerframework.dataflow.cfg.node.DeconstructorPatternNode;
import org.checkerframework.dataflow.cfg.node.DoubleLiteralNode;
import org.checkerframework.dataflow.cfg.node.EqualToNode;
import org.checkerframework.dataflow.cfg.node.ExplicitThisNode;
import org.checkerframework.dataflow.cfg.node.ExpressionStatementNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.FloatLiteralNode;
import org.checkerframework.dataflow.cfg.node.FloatingDivisionNode;
import org.checkerframework.dataflow.cfg.node.FloatingRemainderNode;
import org.checkerframework.dataflow.cfg.node.FunctionalInterfaceNode;
import org.checkerframework.dataflow.cfg.node.GreaterThanNode;
import org.checkerframework.dataflow.cfg.node.GreaterThanOrEqualNode;
import org.checkerframework.dataflow.cfg.node.ImplicitThisNode;
import org.checkerframework.dataflow.cfg.node.InstanceOfNode;
import org.checkerframework.dataflow.cfg.node.IntegerDivisionNode;
import org.checkerframework.dataflow.cfg.node.IntegerLiteralNode;
import org.checkerframework.dataflow.cfg.node.IntegerRemainderNode;
import org.checkerframework.dataflow.cfg.node.LambdaResultExpressionNode;
import org.checkerframework.dataflow.cfg.node.LeftShiftNode;
import org.checkerframework.dataflow.cfg.node.LessThanNode;
import org.checkerframework.dataflow.cfg.node.LessThanOrEqualNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.LongLiteralNode;
import org.checkerframework.dataflow.cfg.node.MarkerNode;
import org.checkerframework.dataflow.cfg.node.MethodAccessNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.NarrowingConversionNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NotEqualNode;
import org.checkerframework.dataflow.cfg.node.NullChkNode;
import org.checkerframework.dataflow.cfg.node.NullLiteralNode;
import org.checkerframework.dataflow.cfg.node.NumericalAdditionNode;
import org.checkerframework.dataflow.cfg.node.NumericalMinusNode;
import org.checkerframework.dataflow.cfg.node.NumericalMultiplicationNode;
import org.checkerframework.dataflow.cfg.node.NumericalPlusNode;
import org.checkerframework.dataflow.cfg.node.NumericalSubtractionNode;
import org.checkerframework.dataflow.cfg.node.ObjectCreationNode;
import org.checkerframework.dataflow.cfg.node.PackageNameNode;
import org.checkerframework.dataflow.cfg.node.ParameterizedTypeNode;
import org.checkerframework.dataflow.cfg.node.PrimitiveTypeNode;
import org.checkerframework.dataflow.cfg.node.ReturnNode;
import org.checkerframework.dataflow.cfg.node.SignedRightShiftNode;
import org.checkerframework.dataflow.cfg.node.StringConcatenateNode;
import org.checkerframework.dataflow.cfg.node.StringConversionNode;
import org.checkerframework.dataflow.cfg.node.StringLiteralNode;
import org.checkerframework.dataflow.cfg.node.SuperNode;
import org.checkerframework.dataflow.cfg.node.SwitchExpressionNode;
import org.checkerframework.dataflow.cfg.node.SynchronizedNode;
import org.checkerframework.dataflow.cfg.node.TernaryExpressionNode;
import org.checkerframework.dataflow.cfg.node.ThisNode;
import org.checkerframework.dataflow.cfg.node.ThrowNode;
import org.checkerframework.dataflow.cfg.node.TypeCastNode;
import org.checkerframework.dataflow.cfg.node.UnaryOperationNode;
import org.checkerframework.dataflow.cfg.node.UnsignedRightShiftNode;
import org.checkerframework.dataflow.cfg.node.ValueLiteralNode;
import org.checkerframework.dataflow.cfg.node.VariableDeclarationNode;
import org.checkerframework.dataflow.cfg.node.WideningConversionNode;
import org.checkerframework.dataflow.qual.AssertMethod;
import org.checkerframework.dataflow.qual.TerminatesExecution;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.SystemUtil;
import org.checkerframework.javacutil.TreePathUtil;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TreeUtilsAfterJava11;
import org.checkerframework.javacutil.TypeAnnotationUtils;
import org.checkerframework.javacutil.TypeKindUtils;
import org.checkerframework.javacutil.TypesUtils;
import org.checkerframework.javacutil.trees.TreeBuilder;
import org.plumelib.util.ArrayMap;
import org.plumelib.util.ArraySet;
import org.plumelib.util.CollectionsPlume;
import org.plumelib.util.IPair;
import org.plumelib.util.IdentityArraySet;

public class CFGTranslationPhaseOne
extends TreeScanner<Node, Void> {
    private TreePath path;
    protected final ProcessingEnvironment env;
    protected final Elements elements;
    protected final Types types;
    protected final Trees trees;
    protected final TreeBuilder treeBuilder;
    protected final AnnotationProvider annotationProvider;
    protected final boolean assumeAssertionsDisabled;
    protected final boolean assumeAssertionsEnabled;
    private final Label regularExitLabel;
    private final Label exceptionalExitLabel;
    private @Nullable LabelCell returnTargetLC;
    private @Nullable LabelCell breakTargetLC;
    private Map<Name, Label> breakLabels;
    private @Nullable LabelCell continueTargetLC;
    private Map<Name, Label> continueLabels;
    private final TryStack tryStack;
    private SwitchBuilder switchBuilder;
    private final IdentityHashMap<Tree, Set<Node>> treeToCfgNodes;
    private final IdentityHashMap<Tree, Set<Node>> treeToConvertedCfgNodes;
    private final IdentityHashMap<UnaryTree, BinaryTree> postfixTreeToCfgNodes;
    private final ArrayList<ExtendedNode> nodeList;
    private final Map<Label, Integer> bindings;
    private final Set<Integer> leaders;
    private final List<ReturnNode> returnNodes;
    private final List<ClassTree> declaredClasses;
    private final List<LambdaExpressionTree> declaredLambdas;
    protected final TypeMirror arithmeticExceptionType;
    protected final TypeMirror arrayIndexOutOfBoundsExceptionType;
    protected final TypeMirror assertionErrorType;
    protected final TypeMirror classCastExceptionType;
    protected final TypeMirror iterableType;
    protected final TypeMirror negativeArraySizeExceptionType;
    protected final TypeMirror nullPointerExceptionType;
    protected final @Nullable TypeMirror outOfMemoryErrorType;
    protected final @Nullable TypeMirror classCircularityErrorType;
    protected final @Nullable TypeMirror classFormatErrorType;
    protected final @Nullable TypeMirror noClassDefFoundErrorType;
    protected final TypeMirror stringType;
    protected final TypeMirror throwableType;
    protected final Set<TypeMirror> uncheckedExceptionTypes;
    protected final Set<TypeMirror> newArrayExceptionTypes;
    protected final Set<TypeMirror> arrayAccessExceptionTypes;
    protected long uid = 0L;
    protected VariableTree ea = null;
    private final Map<Tree, ParenthesizedTree> parenMapping = new HashMap<Tree, ParenthesizedTree>();

    public CFGTranslationPhaseOne(TreeBuilder treeBuilder, AnnotationProvider annotationProvider, boolean assumeAssertionsEnabled, boolean assumeAssertionsDisabled, ProcessingEnvironment env) {
        this.env = env;
        this.treeBuilder = treeBuilder;
        this.annotationProvider = annotationProvider;
        assert (!assumeAssertionsDisabled || !assumeAssertionsEnabled);
        this.assumeAssertionsEnabled = assumeAssertionsEnabled;
        this.assumeAssertionsDisabled = assumeAssertionsDisabled;
        this.elements = env.getElementUtils();
        this.types = env.getTypeUtils();
        this.trees = Trees.instance(env);
        this.treeToCfgNodes = new IdentityHashMap();
        this.treeToConvertedCfgNodes = new IdentityHashMap();
        this.postfixTreeToCfgNodes = new IdentityHashMap();
        this.nodeList = new ArrayList();
        this.bindings = new HashMap<Label, Integer>();
        this.leaders = new HashSet<Integer>();
        this.regularExitLabel = new Label();
        this.exceptionalExitLabel = new Label();
        this.tryStack = new TryStack(this.exceptionalExitLabel);
        this.returnTargetLC = new LabelCell(this.regularExitLabel);
        this.breakLabels = new HashMap<Name, Label>(4);
        this.continueLabels = new HashMap<Name, Label>(4);
        this.returnNodes = new ArrayList<ReturnNode>();
        this.declaredClasses = new ArrayList<ClassTree>();
        this.declaredLambdas = new ArrayList<LambdaExpressionTree>();
        this.arithmeticExceptionType = this.getTypeMirror(ArithmeticException.class);
        this.arrayIndexOutOfBoundsExceptionType = this.getTypeMirror(ArrayIndexOutOfBoundsException.class);
        this.assertionErrorType = this.getTypeMirror(AssertionError.class);
        this.classCastExceptionType = this.getTypeMirror(ClassCastException.class);
        this.iterableType = this.types.erasure(this.getTypeMirror(Iterable.class));
        this.negativeArraySizeExceptionType = this.getTypeMirror(NegativeArraySizeException.class);
        this.nullPointerExceptionType = this.getTypeMirror(NullPointerException.class);
        this.outOfMemoryErrorType = this.maybeGetTypeMirror(OutOfMemoryError.class);
        this.classCircularityErrorType = this.maybeGetTypeMirror(ClassCircularityError.class);
        this.classFormatErrorType = this.maybeGetTypeMirror(ClassFormatError.class);
        this.noClassDefFoundErrorType = this.maybeGetTypeMirror(NoClassDefFoundError.class);
        this.stringType = this.getTypeMirror(String.class);
        this.throwableType = this.getTypeMirror(Throwable.class);
        this.uncheckedExceptionTypes = new ArraySet(2);
        this.uncheckedExceptionTypes.add(this.getTypeMirror(RuntimeException.class));
        this.uncheckedExceptionTypes.add(this.getTypeMirror(Error.class));
        this.newArrayExceptionTypes = new ArraySet(2);
        this.newArrayExceptionTypes.add(this.negativeArraySizeExceptionType);
        if (this.outOfMemoryErrorType != null) {
            this.newArrayExceptionTypes.add(this.outOfMemoryErrorType);
        }
        this.arrayAccessExceptionTypes = new ArraySet(2);
        this.arrayAccessExceptionTypes.add(this.arrayIndexOutOfBoundsExceptionType);
        this.arrayAccessExceptionTypes.add(this.nullPointerExceptionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhaseOneResult process(TreePath bodyPath, UnderlyingAST underlyingAST) {
        this.path = bodyPath;
        try {
            LambdaExpressionTree lambdaTree;
            Node finalNode = this.scan(this.path.getLeaf(), null);
            if (underlyingAST.getKind() == UnderlyingAST.Kind.LAMBDA && (lambdaTree = ((UnderlyingAST.CFGLambda)underlyingAST).getLambdaTree()).getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                LambdaResultExpressionNode resultNode = new LambdaResultExpressionNode((ExpressionTree)lambdaTree.getBody(), finalNode);
                this.extendWithNode(resultNode);
            }
            this.nodeList.add(new UnconditionalJump(this.regularExitLabel));
            PhaseOneResult phaseOneResult = new PhaseOneResult(underlyingAST, this.treeToCfgNodes, this.treeToConvertedCfgNodes, this.postfixTreeToCfgNodes, this.nodeList, this.bindings, this.leaders, this.returnNodes, this.regularExitLabel, this.exceptionalExitLabel, this.declaredClasses, this.declaredLambdas, this.types);
            return phaseOneResult;
        }
        finally {
            this.path = null;
        }
    }

    public PhaseOneResult process(CompilationUnitTree root, UnderlyingAST underlyingAST) {
        TreePath bodyPath = this.trees.getPath(root, underlyingAST.getCode());
        assert (bodyPath != null);
        return this.process(bodyPath, underlyingAST);
    }

    public void handleArtificialTree(Tree tree) {
    }

    public TreePath getCurrentPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node scan(Tree tree, Void p) {
        boolean treeIsLeaf;
        if (tree == null) {
            return null;
        }
        TreePath prev = this.path;
        boolean bl = treeIsLeaf = this.path.getLeaf() != tree;
        if (treeIsLeaf) {
            this.path = new TreePath(this.path, tree);
        }
        try {
            if (SystemUtil.jreVersion >= 14) {
                switch (tree.getKind().name()) {
                    case "BINDING_PATTERN": {
                        Node node = this.visitBindingPattern17(this.path.getLeaf(), p);
                        return node;
                    }
                    case "SWITCH_EXPRESSION": {
                        Node node = this.visitSwitchExpression17(tree, p);
                        return node;
                    }
                    case "YIELD": {
                        Node node = this.visitYield17(tree, p);
                        return node;
                    }
                    case "DECONSTRUCTION_PATTERN": {
                        Node node = this.visitDeconstructionPattern21(tree, p);
                        return node;
                    }
                    case "ANY_PATTERN": {
                        Node node = this.visitAnyPattern22(tree, p);
                        return node;
                    }
                }
            }
            Object object = tree.accept(this, p);
            return object;
        }
        finally {
            this.path = prev;
        }
    }

    private Node visitAnyPattern22(Tree anyPatternTree, Void unused) {
        AnyPatternNode anyPatternNode = new AnyPatternNode(TreeUtils.typeOf((Tree)anyPatternTree), anyPatternTree);
        this.extendWithNode(anyPatternNode);
        return anyPatternNode;
    }

    public Node visitYield17(Tree yieldTree, Void p) {
        ExpressionTree resultExpression = TreeUtilsAfterJava11.YieldUtils.getValue((Tree)yieldTree);
        this.switchBuilder.buildSwitchExpressionResult(resultExpression);
        return null;
    }

    public Node visitSwitchExpression17(Tree switchExpressionTree, Void p) {
        SwitchBuilder oldSwitchBuilder = this.switchBuilder;
        this.switchBuilder = new SwitchBuilder(switchExpressionTree);
        SwitchExpressionNode result = this.switchBuilder.build();
        this.switchBuilder = oldSwitchBuilder;
        return result;
    }

    public Node visitBindingPattern17(Tree bindingPatternTree, Void p) {
        ClassTree enclosingClass = TreePathUtil.enclosingClass((TreePath)this.getCurrentPath());
        TypeElement classElem = TreeUtils.elementFromDeclaration((ClassTree)enclosingClass);
        ImplicitThisNode receiver = new ImplicitThisNode(classElem.asType());
        VariableTree varTree = TreeUtilsAfterJava11.BindingPatternUtils.getVariable((Tree)bindingPatternTree);
        VariableDeclarationNode variableDeclarationNode = new VariableDeclarationNode(varTree);
        this.extendWithNode(variableDeclarationNode);
        LocalVariableNode varNode = new LocalVariableNode(varTree, receiver);
        this.extendWithNode(varNode);
        return varNode;
    }

    public Node visitDeconstructionPattern21(Tree deconstructionPatternTree, Void p) {
        List nestedPatternTrees = TreeUtilsAfterJava11.DeconstructionPatternUtils.getNestedPatterns((Tree)deconstructionPatternTree);
        ArrayList<Node> nestedPatterns = new ArrayList<Node>(nestedPatternTrees.size());
        for (Tree pattern : nestedPatternTrees) {
            nestedPatterns.add(this.scan(pattern, p));
        }
        DeconstructorPatternNode dcpN = new DeconstructorPatternNode(TreeUtils.typeOf((Tree)deconstructionPatternTree), deconstructionPatternTree, nestedPatterns);
        this.extendWithNode(dcpN);
        return dcpN;
    }

    protected void addToLookupMap(Node node) {
        Tree tree = node.getTree();
        if (tree == null) {
            return;
        }
        Set<Node> existing = this.treeToCfgNodes.get(tree);
        if (existing == null) {
            IdentityArraySet newSet = new IdentityArraySet(1);
            newSet.add(node);
            this.treeToCfgNodes.put(tree, (Set<Node>)newSet);
        } else {
            existing.add(node);
        }
        Tree enclosingParens = this.parenMapping.get(tree);
        while (enclosingParens != null) {
            Set exp = this.treeToCfgNodes.computeIfAbsent(enclosingParens, k -> new IdentityArraySet(1));
            exp.add(node);
            enclosingParens = this.parenMapping.get(enclosingParens);
        }
    }

    protected void addToConvertedLookupMap(Node node) {
        Tree tree = node.getTree();
        this.addToConvertedLookupMap(tree, node);
    }

    protected void addToConvertedLookupMap(Tree tree, Node node) {
        assert (tree != null);
        assert (this.treeToCfgNodes.containsKey(tree));
        Set<Node> existing = this.treeToConvertedCfgNodes.get(tree);
        if (existing == null) {
            IdentityArraySet newSet = new IdentityArraySet(1);
            newSet.add(node);
            this.treeToConvertedCfgNodes.put(tree, (Set<Node>)newSet);
        } else {
            existing.add(node);
        }
    }

    protected void extendWithNode(Node node) {
        this.addToLookupMap(node);
        this.extendWithExtendedNode(new NodeHolder(node));
    }

    protected NodeWithExceptionsHolder extendWithNodeWithException(Node node, TypeMirror cause) {
        this.addToLookupMap(node);
        return this.extendWithNodeWithExceptions(node, Collections.singleton(cause));
    }

    protected NodeWithExceptionsHolder extendWithNodeWithExceptions(Node node, Set<TypeMirror> causes) {
        this.addToLookupMap(node);
        ArrayMap exceptions = new ArrayMap(causes.size());
        for (TypeMirror cause : causes) {
            exceptions.put(cause, this.tryStack.possibleLabels(cause));
        }
        NodeWithExceptionsHolder exNode = new NodeWithExceptionsHolder(node, (Map<TypeMirror, Set<Label>>)exceptions);
        this.extendWithExtendedNode(exNode);
        return exNode;
    }

    protected NodeWithExceptionsHolder extendWithClassNameNode(ClassNameNode node) {
        ArraySet thrownSet = new ArraySet(4);
        if (this.classCircularityErrorType != null) {
            thrownSet.add(this.classCircularityErrorType);
        }
        if (this.classFormatErrorType != null) {
            thrownSet.add(this.classFormatErrorType);
        }
        if (this.noClassDefFoundErrorType != null) {
            thrownSet.add(this.noClassDefFoundErrorType);
        }
        if (this.outOfMemoryErrorType != null) {
            thrownSet.add(this.outOfMemoryErrorType);
        }
        return this.extendWithNodeWithExceptions(node, (Set<TypeMirror>)thrownSet);
    }

    protected <T extends Node> T insertNodeAfter(T node, Node pred) {
        this.addToLookupMap(node);
        this.insertExtendedNodeAfter(new NodeHolder(node), pred);
        return node;
    }

    protected NodeWithExceptionsHolder insertNodeWithExceptionsAfter(Node node, Set<TypeMirror> causes, Node pred) {
        this.addToLookupMap(node);
        ArrayMap exceptions = new ArrayMap(causes.size());
        for (TypeMirror cause : causes) {
            exceptions.put(cause, this.tryStack.possibleLabels(cause));
        }
        NodeWithExceptionsHolder exNode = new NodeWithExceptionsHolder(node, (Map<TypeMirror, Set<Label>>)exceptions);
        this.insertExtendedNodeAfter(exNode, pred);
        return exNode;
    }

    protected void extendWithExtendedNode(ExtendedNode n) {
        this.nodeList.add(n);
    }

    protected void insertExtendedNodeAfter(ExtendedNode n, @FindDistinct Node pred) {
        int index = -1;
        for (int i = 0; i < this.nodeList.size(); ++i) {
            ExtendedNode inList = this.nodeList.get(i);
            if (!(inList instanceof NodeHolder) && !(inList instanceof NodeWithExceptionsHolder) || inList.getNode() != pred) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.nodeList.add(index + 1, n);
            for (Map.Entry<Label, Integer> e : this.bindings.entrySet()) {
                if (e.getValue() < index + 1) continue;
                this.bindings.put(e.getKey(), e.getValue() + 1);
            }
            HashSet<Integer> oldLeaders = new HashSet<Integer>(this.leaders);
            this.leaders.clear();
            for (Integer l : oldLeaders) {
                if (l >= index + 1) {
                    this.leaders.add(l + 1);
                    continue;
                }
                this.leaders.add(l);
            }
        } else {
            this.nodeList.add(n);
        }
    }

    protected void addLabelForNextNode(Label l) {
        if (this.bindings.containsKey(l)) {
            throw new BugInCF("bindings already contains key %s: %s", new Object[]{l, this.bindings});
        }
        this.leaders.add(this.nodeList.size());
        this.bindings.put(l, this.nodeList.size());
    }

    protected String uniqueName(String prefix) {
        return prefix + "#num" + this.uid++;
    }

    protected Node box(Node node) {
        if (TypesUtils.isPrimitive((TypeMirror)node.getType())) {
            PrimitiveType primitive = this.types.getPrimitiveType(node.getType().getKind());
            DeclaredType boxedType = this.types.getDeclaredType(this.types.boxedClass(primitive), new TypeMirror[0]);
            TypeElement boxedElement = (TypeElement)boxedType.asElement();
            IdentifierTree classTree = this.treeBuilder.buildClassUse((Element)boxedElement);
            this.handleArtificialTree(classTree);
            ClassNameNode className = new ClassNameNode(classTree);
            className.setInSource(false);
            this.insertNodeAfter(className, node);
            MemberSelectTree valueOfSelect = this.treeBuilder.buildValueOfMethodAccess((Tree)classTree);
            this.handleArtificialTree(valueOfSelect);
            MethodAccessNode valueOfAccess = new MethodAccessNode(valueOfSelect, className);
            valueOfAccess.setInSource(false);
            this.insertNodeAfter(valueOfAccess, className);
            MethodInvocationTree valueOfCall = this.treeBuilder.buildMethodInvocation((ExpressionTree)valueOfSelect, (ExpressionTree)node.getTree());
            this.handleArtificialTree(valueOfCall);
            MethodInvocationNode boxed = new MethodInvocationNode(valueOfCall, valueOfAccess, Collections.singletonList(node), this.getCurrentPath());
            boxed.setInSource(false);
            this.addToConvertedLookupMap(node.getTree(), boxed);
            this.insertNodeWithExceptionsAfter(boxed, this.uncheckedExceptionTypes, valueOfAccess);
            return boxed;
        }
        return node;
    }

    protected Node unbox(Node node) {
        if (TypesUtils.isBoxedPrimitive((TypeMirror)node.getType())) {
            MemberSelectTree primValueSelect = this.treeBuilder.buildPrimValueMethodAccess(node.getTree());
            this.handleArtificialTree(primValueSelect);
            MethodAccessNode primValueAccess = new MethodAccessNode(primValueSelect, node);
            primValueAccess.setInSource(false);
            this.insertNodeWithExceptionsAfter(primValueAccess, Collections.singleton(this.nullPointerExceptionType), node);
            MethodInvocationTree primValueCall = this.treeBuilder.buildMethodInvocation((ExpressionTree)primValueSelect);
            this.handleArtificialTree(primValueCall);
            MethodInvocationNode unboxed = new MethodInvocationNode(primValueCall, primValueAccess, Collections.emptyList(), this.getCurrentPath());
            unboxed.setInSource(false);
            this.addToConvertedLookupMap(node.getTree(), unboxed);
            this.insertNodeWithExceptionsAfter(unboxed, this.uncheckedExceptionTypes, primValueAccess);
            return unboxed;
        }
        return node;
    }

    private TreeInfo getTreeInfo(Tree tree) {
        TypeMirror type = TreeUtils.typeOf((Tree)tree);
        final boolean boxed = TypesUtils.isBoxedPrimitive((TypeMirror)type);
        final TypeMirror unboxedType = boxed ? this.types.unboxedType(type) : type;
        final boolean bool = TypesUtils.isBooleanType((TypeMirror)type);
        final boolean numeric = TypesUtils.isNumeric((TypeMirror)unboxedType);
        return new TreeInfo(){

            @Override
            public boolean isNumeric() {
                return numeric;
            }

            @Override
            public boolean isBoxed() {
                return boxed;
            }

            @Override
            public boolean isBoolean() {
                return bool;
            }

            @Override
            public TypeMirror unboxedType() {
                return unboxedType;
            }
        };
    }

    private Node unboxAsNeeded(Node node, boolean boxed) {
        return boxed ? this.unbox(node) : node;
    }

    protected Node stringConversion(Node node) {
        if (!TypesUtils.isString((TypeMirror)node.getType())) {
            StringConversionNode converted = new StringConversionNode(node.getTree(), node, this.stringType);
            this.addToConvertedLookupMap(converted);
            this.insertNodeAfter(converted, node);
            return converted;
        }
        return node;
    }

    protected Node unaryNumericPromotion(Node node) {
        node = this.unbox(node);
        switch (node.getType().getKind()) {
            case BYTE: 
            case CHAR: 
            case SHORT: {
                PrimitiveType intType = this.types.getPrimitiveType(TypeKind.INT);
                WideningConversionNode widened = new WideningConversionNode(node.getTree(), node, intType);
                this.addToConvertedLookupMap(widened);
                this.insertNodeAfter(widened, node);
                return widened;
            }
        }
        return node;
    }

    protected boolean isNumericOrBoxed(TypeMirror type) {
        if (TypesUtils.isBoxedPrimitive((TypeMirror)type)) {
            type = this.types.unboxedType(type);
        }
        return TypesUtils.isNumeric((TypeMirror)type);
    }

    protected TypeMirror binaryPromotedType(TypeMirror left, TypeMirror right) {
        if (!left.getKind().isPrimitive()) {
            left = TypesUtils.isCapturedTypeVariable((TypeMirror)left) ? this.types.unboxedType(TypesUtils.upperBound((TypeMirror)left)) : this.types.unboxedType(left);
        }
        if (!right.getKind().isPrimitive()) {
            right = TypesUtils.isCapturedTypeVariable((TypeMirror)right) ? this.types.unboxedType(TypesUtils.upperBound((TypeMirror)right)) : this.types.unboxedType(right);
        }
        TypeKind promotedTypeKind = TypeKindUtils.widenedNumericType((TypeMirror)left, (TypeMirror)right);
        return this.types.getPrimitiveType(promotedTypeKind);
    }

    protected Node binaryNumericPromotion(Node node, TypeMirror exprType) {
        if (!this.types.isSameType((node = this.unbox(node)).getType(), exprType)) {
            WideningConversionNode widened = new WideningConversionNode(node.getTree(), node, exprType);
            this.addToConvertedLookupMap(widened);
            this.insertNodeAfter(widened, node);
            return widened;
        }
        return node;
    }

    protected Node widen(Node node, TypeMirror destType) {
        assert (TypesUtils.isPrimitive((TypeMirror)node.getType()) && TypesUtils.isPrimitive((TypeMirror)destType)) : "widening must be applied to primitive types";
        if (this.types.isSubtype(node.getType(), destType) && !this.types.isSameType(node.getType(), destType)) {
            WideningConversionNode widened = new WideningConversionNode(node.getTree(), node, destType);
            this.addToConvertedLookupMap(widened);
            this.insertNodeAfter(widened, node);
            return widened;
        }
        return node;
    }

    protected Node narrow(Node node, TypeMirror destType) {
        assert (TypesUtils.isPrimitive((TypeMirror)node.getType()) && TypesUtils.isPrimitive((TypeMirror)destType)) : "narrowing must be applied to primitive types";
        if (this.types.isSubtype(destType, node.getType()) && !this.types.isSameType(destType, node.getType())) {
            NarrowingConversionNode narrowed = new NarrowingConversionNode(node.getTree(), node, destType);
            this.addToConvertedLookupMap(narrowed);
            this.insertNodeAfter(narrowed, node);
            return narrowed;
        }
        return node;
    }

    protected Node narrowAndBox(Node node, TypeMirror destType) {
        if (TypesUtils.isBoxedPrimitive((TypeMirror)destType)) {
            return this.box(this.narrow(node, this.types.unboxedType(destType)));
        }
        return this.narrow(node, destType);
    }

    protected boolean conversionRequiresNarrowing(TypeMirror varType, Node node) {
        TypeMirror unboxedVarType = TypesUtils.isBoxedPrimitive((TypeMirror)varType) ? this.types.unboxedType(varType) : varType;
        TypeKind unboxedVarKind = unboxedVarType.getKind();
        boolean isLeftNarrowableTo = unboxedVarKind == TypeKind.BYTE || unboxedVarKind == TypeKind.SHORT || unboxedVarKind == TypeKind.CHAR;
        boolean isRightConstant = node instanceof ValueLiteralNode;
        return isLeftNarrowableTo && isRightConstant;
    }

    protected Node commonConvert(Node node, TypeMirror varType, boolean contextAllowsNarrowing) {
        TypeMirror nodeType = node.getType();
        boolean isSameType = this.types.isSameType(nodeType, varType);
        if (isSameType) {
            return node;
        }
        boolean isRightNumeric = TypesUtils.isNumeric((TypeMirror)nodeType);
        boolean isRightPrimitive = TypesUtils.isPrimitive((TypeMirror)nodeType);
        boolean isRightBoxed = TypesUtils.isBoxedPrimitive((TypeMirror)nodeType);
        boolean isRightReference = nodeType instanceof ReferenceType;
        boolean isLeftNumeric = TypesUtils.isNumeric((TypeMirror)varType);
        boolean isLeftPrimitive = TypesUtils.isPrimitive((TypeMirror)varType);
        boolean isLeftReference = varType instanceof ReferenceType;
        boolean isSubtype = this.types.isSubtype(nodeType, varType);
        if (isRightNumeric && isLeftNumeric && isSubtype) {
            node = this.widen(node, varType);
        } else if (!(isRightReference && isLeftReference && isSubtype)) {
            if (isRightPrimitive && isLeftReference) {
                node = contextAllowsNarrowing && this.conversionRequiresNarrowing(varType, node) ? this.narrowAndBox(node, varType) : this.box(node);
            } else if (isRightBoxed && isLeftPrimitive) {
                nodeType = (node = this.unbox(node)).getType();
                if (this.types.isSubtype(nodeType, varType) && !this.types.isSameType(nodeType, varType)) {
                    node = this.widen(node, varType);
                }
            } else if (isRightPrimitive && isLeftPrimitive && contextAllowsNarrowing && this.conversionRequiresNarrowing(varType, node)) {
                node = this.narrow(node, varType);
            }
        }
        return node;
    }

    protected Node assignConvert(Node node, TypeMirror varType) {
        return this.commonConvert(node, varType, true);
    }

    protected Node methodInvocationConvert(Node node, TypeMirror formalType) {
        return this.commonConvert(node, formalType, false);
    }

    protected List<Node> convertCallArguments(ExpressionTree tree, ExecutableElement method, ExecutableType methodType, List<? extends ExpressionTree> actualExprs) {
        List<? extends TypeMirror> formals = methodType.getParameterTypes();
        int numFormals = formals.size();
        ArrayList<Node> convertedNodes = new ArrayList<Node>(numFormals);
        AssertMethodTuple assertMethodTuple = this.getAssertMethodTuple(method);
        int numActuals = actualExprs.size();
        if (method.isVarArgs()) {
            int lastArgIndex = numFormals - 1;
            TypeMirror lastParamType = formals.get(lastArgIndex);
            if (numActuals == numFormals && this.types.isAssignable(TreeUtils.typeOf((Tree)actualExprs.get(numActuals - 1)), lastParamType)) {
                for (int i = 0; i < numActuals; ++i) {
                    Node actualVal = this.scan((Tree)actualExprs.get(i), null);
                    if (i == assertMethodTuple.booleanParam) {
                        this.treatMethodAsAssert((MethodInvocationTree)tree, assertMethodTuple, actualVal);
                    }
                    if (actualVal == null) {
                        throw new BugInCF("CFGBuilder: scan returned null for %s [%s]", new Object[]{actualExprs.get(i), actualExprs.get(i).getClass()});
                    }
                    convertedNodes.add(this.methodInvocationConvert(actualVal, formals.get(i)));
                }
            } else {
                assert (lastParamType instanceof ArrayType) : "variable argument formal must be an array";
                for (int i = 0; i < lastArgIndex; ++i) {
                    Node actualVal = this.scan((Tree)actualExprs.get(i), null);
                    if (i == assertMethodTuple.booleanParam) {
                        this.treatMethodAsAssert((MethodInvocationTree)tree, assertMethodTuple, actualVal);
                    }
                    convertedNodes.add(this.methodInvocationConvert(actualVal, formals.get(i)));
                }
                TypeMirror elemType = ((ArrayType)lastParamType).getComponentType();
                ArrayList<ExpressionTree> inits = new ArrayList<ExpressionTree>(numActuals - lastArgIndex);
                ArrayList<Node> initializers = new ArrayList<Node>(numActuals - lastArgIndex);
                for (int i = lastArgIndex; i < numActuals; ++i) {
                    inits.add(actualExprs.get(i));
                    Node actualVal = this.scan((Tree)actualExprs.get(i), null);
                    initializers.add(this.assignConvert(actualVal, elemType));
                }
                NewArrayTree wrappedVarargs = this.treeBuilder.buildNewArray(elemType, inits);
                this.handleArtificialTree(wrappedVarargs);
                ArrayCreationNode lastArgument = new ArrayCreationNode(wrappedVarargs, lastParamType, Collections.emptyList(), initializers);
                this.extendWithNode(lastArgument);
                convertedNodes.add(lastArgument);
            }
        } else {
            for (int i = 0; i < numActuals; ++i) {
                Node actualVal = this.scan((Tree)actualExprs.get(i), null);
                if (i == assertMethodTuple.booleanParam) {
                    this.treatMethodAsAssert((MethodInvocationTree)tree, assertMethodTuple, actualVal);
                }
                convertedNodes.add(this.methodInvocationConvert(actualVal, formals.get(i)));
            }
        }
        return convertedNodes;
    }

    protected AssertMethodTuple getAssertMethodTuple(ExecutableElement method) {
        AnnotationMirror assertMethodAnno = this.annotationProvider.getDeclAnnotation((Element)method, AssertMethod.class);
        if (assertMethodAnno == null) {
            return AssertMethodTuple.NONE;
        }
        int booleanParam = (Integer)AnnotationUtils.getElementValueNotOnClasspath((AnnotationMirror)assertMethodAnno, (CharSequence)"parameter", Integer.class, (Object)1) - 1;
        TypeMirror exceptionType = (TypeMirror)AnnotationUtils.getElementValueNotOnClasspath((AnnotationMirror)assertMethodAnno, (CharSequence)"value", Type.ClassType.class, (Object)((Type.ClassType)this.assertionErrorType));
        boolean isAssertFalse = (Boolean)AnnotationUtils.getElementValueNotOnClasspath((AnnotationMirror)assertMethodAnno, (CharSequence)"isAssertFalse", Boolean.class, (Object)false);
        return new AssertMethodTuple(booleanParam, exceptionType, isAssertFalse);
    }

    protected Node conditionalExprPromotion(Node node, TypeMirror destType) {
        TypeMirror unboxedDestType;
        TypeMirror nodeType = node.getType();
        if (this.types.isSameType(nodeType, destType)) {
            return node;
        }
        if (TypesUtils.isPrimitive((TypeMirror)nodeType) && TypesUtils.isBoxedPrimitive((TypeMirror)destType)) {
            return this.box(node);
        }
        boolean isBoxedPrimitive = TypesUtils.isBoxedPrimitive((TypeMirror)nodeType);
        TypeMirror unboxedNodeType = isBoxedPrimitive ? this.types.unboxedType(nodeType) : nodeType;
        TypeMirror typeMirror = unboxedDestType = TypesUtils.isBoxedPrimitive((TypeMirror)destType) ? this.types.unboxedType(destType) : destType;
        if (TypesUtils.isNumeric((TypeMirror)unboxedNodeType) && TypesUtils.isNumeric((TypeMirror)unboxedDestType)) {
            if (unboxedNodeType.getKind() == TypeKind.BYTE && destType.getKind() == TypeKind.SHORT) {
                if (isBoxedPrimitive) {
                    node = this.unbox(node);
                }
                return this.widen(node, destType);
            }
            TypeKind destKind = destType.getKind();
            if (destKind == TypeKind.BYTE || destKind == TypeKind.CHAR || destKind == TypeKind.SHORT) {
                if (isBoxedPrimitive) {
                    return this.unbox(node);
                }
                if (nodeType.getKind() == TypeKind.INT) {
                    return this.narrow(node, destType);
                }
            }
            return this.binaryNumericPromotion(node, destType);
        }
        if (TypesUtils.isPrimitive((TypeMirror)nodeType) && (destType.getKind() == TypeKind.DECLARED || destType.getKind() == TypeKind.UNION || destType.getKind() == TypeKind.INTERSECTION)) {
            return this.box(node);
        }
        return node;
    }

    protected @Nullable Name getLabel(TreePath path) {
        Tree parent;
        if (path.getParentPath() != null && (parent = path.getParentPath().getLeaf()) instanceof LabeledStatementTree) {
            return ((LabeledStatementTree)parent).getLabel();
        }
        return null;
    }

    @Override
    public Node visitAnnotatedType(AnnotatedTypeTree tree, Void p) {
        return this.scan((Tree)tree.getUnderlyingType(), p);
    }

    @Override
    public Node visitAnnotation(AnnotationTree tree, Void p) {
        throw new BugInCF("AnnotationTree is unexpected in AST to CFG translation");
    }

    @Override
    public MethodInvocationNode visitMethodInvocation(MethodInvocationTree tree, Void p) {
        boolean terminatesExecution;
        ExecutableElement method = TreeUtils.elementFromUse((MethodInvocationTree)tree);
        if (method == null) {
            return null;
        }
        ExpressionTree methodSelect = tree.getMethodSelect();
        assert (TreeUtils.isMethodAccess((Tree)methodSelect)) : "Expected a method access, but got: " + methodSelect;
        List<? extends ExpressionTree> actualExprs = tree.getArguments();
        Node receiver = this.getReceiver(methodSelect);
        MethodAccessNode target = new MethodAccessNode(methodSelect, method, receiver);
        if (ElementUtils.isStatic((Element)method) || receiver instanceof ThisNode) {
            this.extendWithNode(target);
        } else {
            this.extendWithNodeWithException(target, this.nullPointerExceptionType);
        }
        List<Node> arguments = TreeUtils.isEnumSuperCall((MethodInvocationTree)tree) ? Collections.emptyList() : this.convertCallArguments(tree, method, TreeUtils.typeFromUse((MethodInvocationTree)tree), actualExprs);
        MethodInvocationNode node = new MethodInvocationNode(tree, target, arguments, this.getCurrentPath());
        ExtendedNode extendedNode = this.extendWithMethodInvocationNode(method, node);
        boolean bl = terminatesExecution = this.annotationProvider.getDeclAnnotation((Element)method, TerminatesExecution.class) != null;
        if (terminatesExecution) {
            extendedNode.setTerminatesExecution(true);
        }
        return node;
    }

    private ExtendedNode extendWithMethodInvocationNode(ExecutableElement method, MethodInvocationNode node) {
        List<? extends TypeMirror> thrownTypes = method.getThrownTypes();
        LinkedHashSet<TypeMirror> thrownSet = new LinkedHashSet<TypeMirror>(thrownTypes.size() + this.uncheckedExceptionTypes.size());
        thrownSet.addAll(thrownTypes);
        thrownSet.addAll(this.uncheckedExceptionTypes);
        return this.extendWithNodeWithExceptions(node, thrownSet);
    }

    @Override
    public Node visitAssert(AssertTree tree, Void p) {
        if (this.assumeAssertionsEnabled || this.assumeAssertionsEnabledFor(tree)) {
            this.translateAssertWithAssertionsEnabled(tree);
            return null;
        }
        if (this.assumeAssertionsDisabled) {
            return null;
        }
        VariableTree ea = this.getAssertionsEnabledVariable();
        Label assertionEnabled = new Label();
        Label assertionDisabled = new Label();
        this.extendWithNode(new LocalVariableNode(ea));
        this.extendWithExtendedNode(new ConditionalJump(assertionEnabled, assertionDisabled));
        this.addLabelForNextNode(assertionEnabled);
        this.translateAssertWithAssertionsEnabled(tree);
        this.addLabelForNextNode(assertionDisabled);
        return null;
    }

    protected boolean assumeAssertionsEnabledFor(AssertTree tree) {
        return false;
    }

    protected VariableTree getAssertionsEnabledVariable() {
        if (this.ea == null) {
            String name = this.uniqueName("assertionsEnabled");
            Element owner = TreePathUtil.findNearestEnclosingElement((TreePath)this.getCurrentPath());
            ExpressionTree initializer = null;
            this.ea = this.treeBuilder.buildVariableDecl((TypeMirror)this.types.getPrimitiveType(TypeKind.BOOLEAN), name, owner, initializer);
            this.handleArtificialTree(this.ea);
        }
        return this.ea;
    }

    protected void translateAssertWithAssertionsEnabled(AssertTree tree) {
        Label assertEnd = new Label();
        Label elseEntry = new Label();
        Node condition = this.unbox(this.scan((Tree)tree.getCondition(), null));
        ConditionalJump cjump = new ConditionalJump(assertEnd, elseEntry);
        this.extendWithExtendedNode(cjump);
        Node detail = null;
        this.addLabelForNextNode(elseEntry);
        if (tree.getDetail() != null) {
            detail = this.scan((Tree)tree.getDetail(), null);
        }
        AssertionErrorNode assertNode = new AssertionErrorNode(tree, condition, detail, this.assertionErrorType);
        this.extendWithNode(assertNode);
        NodeWithExceptionsHolder exNode = this.extendWithNodeWithException(new ThrowNode(null, assertNode, this.env.getTypeUtils()), this.assertionErrorType);
        exNode.setTerminatesExecution(true);
        this.addLabelForNextNode(assertEnd);
    }

    protected void treatMethodAsAssert(MethodInvocationTree tree, AssertMethodTuple assertMethodTuple, Node condition) {
        Label thenLabel = new Label();
        Label elseLabel = new Label();
        ConditionalJump cjump = new ConditionalJump(thenLabel, elseLabel);
        this.extendWithExtendedNode(cjump);
        this.addLabelForNextNode(assertMethodTuple.isAssertFalse ? thenLabel : elseLabel);
        AssertionErrorNode assertNode = new AssertionErrorNode(tree, condition, null, assertMethodTuple.exceptionType);
        this.extendWithNode(assertNode);
        NodeWithExceptionsHolder exNode = this.extendWithNodeWithException(new ThrowNode(null, assertNode, this.env.getTypeUtils()), assertMethodTuple.exceptionType);
        exNode.setTerminatesExecution(true);
        this.addLabelForNextNode(assertMethodTuple.isAssertFalse ? elseLabel : thenLabel);
    }

    @Override
    public Node visitAssignment(AssignmentTree tree, Void p) {
        AssignmentNode assignmentNode;
        ExpressionTree variable = tree.getVariable();
        TypeMirror varType = TreeUtils.typeOf((Tree)variable);
        if (TreeUtils.isFieldAccess((Tree)variable)) {
            Node receiver = this.getReceiver(variable);
            Node expression = this.scan((Tree)tree.getExpression(), p);
            expression = this.assignConvert(expression, varType);
            FieldAccessNode target = new FieldAccessNode(variable, receiver);
            target.setLValue();
            Element element = TreeUtils.elementFromUse((ExpressionTree)variable);
            if (ElementUtils.isStatic((Element)element) || receiver instanceof ThisNode) {
                this.extendWithNode(target);
            } else {
                this.extendWithNodeWithException(target, this.nullPointerExceptionType);
            }
            assignmentNode = new AssignmentNode(tree, target, expression);
            this.extendWithNode(assignmentNode);
        } else {
            Node target = this.scan((Tree)variable, p);
            target.setLValue();
            assignmentNode = this.translateAssignment((Tree)tree, target, tree.getExpression());
        }
        return assignmentNode;
    }

    protected AssignmentNode translateAssignment(Tree tree, Node target, ExpressionTree rhs) {
        Node expression = this.scan((Tree)rhs, null);
        return this.translateAssignment(tree, target, expression);
    }

    protected AssignmentNode translateAssignment(Tree tree, Node target, Node expression) {
        assert (tree instanceof AssignmentTree || tree instanceof VariableTree);
        target.setLValue();
        expression = this.assignConvert(expression, target.getType());
        AssignmentNode assignmentNode = new AssignmentNode(tree, target, expression);
        this.extendWithNode(assignmentNode);
        return assignmentNode;
    }

    private Node getReceiver(ExpressionTree tree) {
        assert (TreeUtils.isFieldAccess((Tree)tree) || TreeUtils.isMethodAccess((Tree)tree));
        if (tree instanceof MemberSelectTree) {
            MemberSelectTree mtree = (MemberSelectTree)tree;
            return this.scan((Tree)mtree.getExpression(), null);
        }
        Element ele = TreeUtils.elementFromUse((ExpressionTree)tree);
        TypeElement declaringClass = ElementUtils.enclosingTypeElement((Element)ele);
        TypeMirror typeOfDeclaringClass = ElementUtils.getType((Element)declaringClass);
        if (ElementUtils.isStatic((Element)ele)) {
            ClassNameNode node = new ClassNameNode(typeOfDeclaringClass, declaringClass);
            this.extendWithClassNameNode(node);
            return node;
        }
        ClassTree classTree = TreePathUtil.enclosingClass((TreePath)this.getCurrentPath());
        TypeElement classEle = TreeUtils.elementFromDeclaration((ClassTree)classTree);
        while (!TypesUtils.isErasedSubtype((TypeMirror)classEle.asType(), (TypeMirror)typeOfDeclaringClass, (Types)this.types)) {
            Element enclosing = classEle.getEnclosingElement();
            while (!(enclosing instanceof TypeElement)) {
                enclosing = enclosing.getEnclosingElement();
            }
            classEle = (TypeElement)enclosing;
        }
        ImplicitThisNode node = new ImplicitThisNode(classEle.asType());
        this.extendWithNode(node);
        return node;
    }

    protected Tree.Kind withoutAssignment(Tree.Kind kind) {
        switch (kind) {
            case DIVIDE_ASSIGNMENT: {
                return Tree.Kind.DIVIDE;
            }
            case MULTIPLY_ASSIGNMENT: {
                return Tree.Kind.MULTIPLY;
            }
            case REMAINDER_ASSIGNMENT: {
                return Tree.Kind.REMAINDER;
            }
            case MINUS_ASSIGNMENT: {
                return Tree.Kind.MINUS;
            }
            case PLUS_ASSIGNMENT: {
                return Tree.Kind.PLUS;
            }
            case LEFT_SHIFT_ASSIGNMENT: {
                return Tree.Kind.LEFT_SHIFT;
            }
            case RIGHT_SHIFT_ASSIGNMENT: {
                return Tree.Kind.RIGHT_SHIFT;
            }
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                return Tree.Kind.UNSIGNED_RIGHT_SHIFT;
            }
            case AND_ASSIGNMENT: {
                return Tree.Kind.AND;
            }
            case OR_ASSIGNMENT: {
                return Tree.Kind.OR;
            }
            case XOR_ASSIGNMENT: {
                return Tree.Kind.XOR;
            }
        }
        return Tree.Kind.ERRONEOUS;
    }

    @Override
    public Node visitCompoundAssignment(CompoundAssignmentTree tree, Void p) {
        Tree.Kind kind = tree.getKind();
        switch (kind) {
            case DIVIDE_ASSIGNMENT: 
            case MULTIPLY_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: {
                BinaryOperationNode operNode;
                Node targetLHS = this.scan((Tree)tree.getVariable(), p);
                Node value = this.scan((Tree)tree.getExpression(), p);
                TypeMirror exprType = TreeUtils.typeOf((Tree)tree);
                TypeMirror leftType = TreeUtils.typeOf((Tree)tree.getVariable());
                TypeMirror rightType = TreeUtils.typeOf((Tree)tree.getExpression());
                TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                Node targetRHS = this.binaryNumericPromotion(targetLHS, promotedType);
                value = this.binaryNumericPromotion(value, promotedType);
                BinaryTree operTree = this.treeBuilder.buildBinary(promotedType, this.withoutAssignment(kind), tree.getVariable(), tree.getExpression());
                this.handleArtificialTree(operTree);
                if (kind == Tree.Kind.MULTIPLY_ASSIGNMENT) {
                    operNode = new NumericalMultiplicationNode(operTree, targetRHS, value);
                } else if (kind == Tree.Kind.DIVIDE_ASSIGNMENT) {
                    if (TypesUtils.isIntegralPrimitive((TypeMirror)exprType)) {
                        operNode = new IntegerDivisionNode(operTree, targetRHS, value);
                        this.extendWithNodeWithException(operNode, this.arithmeticExceptionType);
                    } else {
                        operNode = new FloatingDivisionNode(operTree, targetRHS, value);
                    }
                } else {
                    assert (kind == Tree.Kind.REMAINDER_ASSIGNMENT);
                    if (TypesUtils.isIntegralPrimitive((TypeMirror)exprType)) {
                        operNode = new IntegerRemainderNode(operTree, targetRHS, value);
                        this.extendWithNodeWithException(operNode, this.arithmeticExceptionType);
                    } else {
                        operNode = new FloatingRemainderNode(operTree, targetRHS, value);
                    }
                }
                this.extendWithNode(operNode);
                Type castType = TypeAnnotationUtils.unannotatedType((TypeMirror)leftType);
                TypeCastTree castTree = this.treeBuilder.buildTypeCast((TypeMirror)castType, (ExpressionTree)operTree);
                this.handleArtificialTree(castTree);
                TypeCastNode castNode = new TypeCastNode(castTree, operNode, castType, this.types);
                castNode.setInSource(false);
                this.extendWithNode(castNode);
                AssignmentNode assignNode = new AssignmentNode(tree, targetLHS, castNode);
                this.extendWithNode(assignNode);
                return assignNode;
            }
            case MINUS_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: {
                BinaryOperationNode operNode;
                Node targetLHS = this.scan((Tree)tree.getVariable(), p);
                Node value = this.scan((Tree)tree.getExpression(), p);
                TypeMirror leftType = TreeUtils.typeOf((Tree)tree.getVariable());
                TypeMirror rightType = TreeUtils.typeOf((Tree)tree.getExpression());
                if (TypesUtils.isString((TypeMirror)leftType) || TypesUtils.isString((TypeMirror)rightType)) {
                    assert (kind == Tree.Kind.PLUS_ASSIGNMENT);
                    Node targetRHS = this.stringConversion(targetLHS);
                    value = this.stringConversion(value);
                    BinaryTree operTree = this.treeBuilder.buildBinary(leftType, this.withoutAssignment(kind), tree.getVariable(), tree.getExpression());
                    this.handleArtificialTree(operTree);
                    StringConcatenateNode operNode2 = new StringConcatenateNode(operTree, targetRHS, value);
                    this.extendWithNode(operNode2);
                    AssignmentNode assignNode = new AssignmentNode(tree, targetLHS, operNode2);
                    this.extendWithNode(assignNode);
                    return assignNode;
                }
                TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                Node targetRHS = this.binaryNumericPromotion(targetLHS, promotedType);
                value = this.binaryNumericPromotion(value, promotedType);
                BinaryTree operTree = this.treeBuilder.buildBinary(promotedType, this.withoutAssignment(kind), tree.getVariable(), tree.getExpression());
                this.handleArtificialTree(operTree);
                if (kind == Tree.Kind.PLUS_ASSIGNMENT) {
                    operNode = new NumericalAdditionNode(operTree, targetRHS, value);
                } else {
                    assert (kind == Tree.Kind.MINUS_ASSIGNMENT);
                    operNode = new NumericalSubtractionNode(operTree, targetRHS, value);
                }
                this.extendWithNode(operNode);
                Type castType = TypeAnnotationUtils.unannotatedType((TypeMirror)leftType);
                TypeCastTree castTree = this.treeBuilder.buildTypeCast((TypeMirror)castType, (ExpressionTree)operTree);
                this.handleArtificialTree(castTree);
                TypeCastNode castNode = new TypeCastNode(castTree, operNode, castType, this.types);
                castNode.setInSource(false);
                this.extendWithNode(castNode);
                AssignmentNode assignNode = new AssignmentNode(tree, targetLHS, castNode);
                this.extendWithNode(assignNode);
                return assignNode;
            }
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                BinaryOperationNode operNode;
                Node targetLHS = this.scan((Tree)tree.getVariable(), p);
                Node value = this.scan((Tree)tree.getExpression(), p);
                TypeMirror leftType = TreeUtils.typeOf((Tree)tree.getVariable());
                Node targetRHS = this.unaryNumericPromotion(targetLHS);
                value = this.unaryNumericPromotion(value);
                BinaryTree operTree = this.treeBuilder.buildBinary(leftType, this.withoutAssignment(kind), tree.getVariable(), tree.getExpression());
                this.handleArtificialTree(operTree);
                if (kind == Tree.Kind.LEFT_SHIFT_ASSIGNMENT) {
                    operNode = new LeftShiftNode(operTree, targetRHS, value);
                } else if (kind == Tree.Kind.RIGHT_SHIFT_ASSIGNMENT) {
                    operNode = new SignedRightShiftNode(operTree, targetRHS, value);
                } else {
                    assert (kind == Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT);
                    operNode = new UnsignedRightShiftNode(operTree, targetRHS, value);
                }
                this.extendWithNode(operNode);
                Type castType = TypeAnnotationUtils.unannotatedType((TypeMirror)leftType);
                TypeCastTree castTree = this.treeBuilder.buildTypeCast((TypeMirror)castType, (ExpressionTree)operTree);
                this.handleArtificialTree(castTree);
                TypeCastNode castNode = new TypeCastNode(castTree, operNode, castType, this.types);
                castNode.setInSource(false);
                this.extendWithNode(castNode);
                AssignmentNode assignNode = new AssignmentNode(tree, targetLHS, castNode);
                this.extendWithNode(assignNode);
                return assignNode;
            }
            case AND_ASSIGNMENT: 
            case OR_ASSIGNMENT: 
            case XOR_ASSIGNMENT: {
                BinaryOperationNode operNode;
                Node targetLHS = this.scan((Tree)tree.getVariable(), p);
                Node value = this.scan((Tree)tree.getExpression(), p);
                TypeMirror leftType = TreeUtils.typeOf((Tree)tree.getVariable());
                TypeMirror rightType = TreeUtils.typeOf((Tree)tree.getExpression());
                Node targetRHS = null;
                if (this.isNumericOrBoxed(leftType) && this.isNumericOrBoxed(rightType)) {
                    TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                    targetRHS = this.binaryNumericPromotion(targetLHS, promotedType);
                    value = this.binaryNumericPromotion(value, promotedType);
                } else if (TypesUtils.isBooleanType((TypeMirror)leftType) && TypesUtils.isBooleanType((TypeMirror)rightType)) {
                    targetRHS = this.unbox(targetLHS);
                    value = this.unbox(value);
                } else {
                    throw new BugInCF("Both arguments to logical operation must be numeric or boolean");
                }
                BinaryTree operTree = this.treeBuilder.buildBinary(leftType, this.withoutAssignment(kind), tree.getVariable(), tree.getExpression());
                this.handleArtificialTree(operTree);
                if (kind == Tree.Kind.AND_ASSIGNMENT) {
                    operNode = new BitwiseAndNode(operTree, targetRHS, value);
                } else if (kind == Tree.Kind.OR_ASSIGNMENT) {
                    operNode = new BitwiseOrNode(operTree, targetRHS, value);
                } else {
                    assert (kind == Tree.Kind.XOR_ASSIGNMENT);
                    operNode = new BitwiseXorNode(operTree, targetRHS, value);
                }
                this.extendWithNode(operNode);
                Type castType = TypeAnnotationUtils.unannotatedType((TypeMirror)leftType);
                TypeCastTree castTree = this.treeBuilder.buildTypeCast((TypeMirror)castType, (ExpressionTree)operTree);
                this.handleArtificialTree(castTree);
                TypeCastNode castNode = new TypeCastNode(castTree, operNode, castType, this.types);
                castNode.setInSource(false);
                this.extendWithNode(castNode);
                AssignmentNode assignNode = new AssignmentNode(tree, targetLHS, castNode);
                this.extendWithNode(assignNode);
                return assignNode;
            }
        }
        throw new BugInCF("unexpected compound assignment type");
    }

    @Override
    public Node visitBinary(BinaryTree tree, Void p) {
        BinaryOperationNode r;
        ExpressionTree leftTree = tree.getLeftOperand();
        ExpressionTree rightTree = tree.getRightOperand();
        Tree.Kind kind = tree.getKind();
        switch (kind) {
            case DIVIDE: 
            case MULTIPLY: 
            case REMAINDER: {
                TypeMirror exprType = TreeUtils.typeOf((Tree)tree);
                TypeMirror leftType = TreeUtils.typeOf((Tree)leftTree);
                TypeMirror rightType = TreeUtils.typeOf((Tree)rightTree);
                TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                Node left = this.binaryNumericPromotion(this.scan((Tree)leftTree, p), promotedType);
                Node right = this.binaryNumericPromotion(this.scan((Tree)rightTree, p), promotedType);
                if (kind == Tree.Kind.MULTIPLY) {
                    r = new NumericalMultiplicationNode(tree, left, right);
                    break;
                }
                if (kind == Tree.Kind.DIVIDE) {
                    if (TypesUtils.isIntegralPrimitive((TypeMirror)exprType)) {
                        r = new IntegerDivisionNode(tree, left, right);
                        this.extendWithNodeWithException(r, this.arithmeticExceptionType);
                        break;
                    }
                    r = new FloatingDivisionNode(tree, left, right);
                    break;
                }
                assert (kind == Tree.Kind.REMAINDER);
                if (TypesUtils.isIntegralPrimitive((TypeMirror)exprType)) {
                    r = new IntegerRemainderNode(tree, left, right);
                    this.extendWithNodeWithException(r, this.arithmeticExceptionType);
                    break;
                }
                r = new FloatingRemainderNode(tree, left, right);
                break;
            }
            case MINUS: 
            case PLUS: {
                TypeMirror leftType = TreeUtils.typeOf((Tree)leftTree);
                TypeMirror rightType = TreeUtils.typeOf((Tree)rightTree);
                if (TypesUtils.isString((TypeMirror)leftType) || TypesUtils.isString((TypeMirror)rightType)) {
                    assert (kind == Tree.Kind.PLUS);
                    Node left = this.stringConversion(this.scan((Tree)leftTree, p));
                    Node right = this.stringConversion(this.scan((Tree)rightTree, p));
                    r = new StringConcatenateNode(tree, left, right);
                    break;
                }
                TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                Node left = this.binaryNumericPromotion(this.scan((Tree)leftTree, p), promotedType);
                Node right = this.binaryNumericPromotion(this.scan((Tree)rightTree, p), promotedType);
                if (kind == Tree.Kind.PLUS) {
                    r = new NumericalAdditionNode(tree, left, right);
                    break;
                }
                assert (kind == Tree.Kind.MINUS);
                r = new NumericalSubtractionNode(tree, left, right);
                break;
            }
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: {
                Node left = this.unaryNumericPromotion(this.scan((Tree)leftTree, p));
                Node right = this.unaryNumericPromotion(this.scan((Tree)rightTree, p));
                if (kind == Tree.Kind.LEFT_SHIFT) {
                    r = new LeftShiftNode(tree, left, right);
                    break;
                }
                if (kind == Tree.Kind.RIGHT_SHIFT) {
                    r = new SignedRightShiftNode(tree, left, right);
                    break;
                }
                assert (kind == Tree.Kind.UNSIGNED_RIGHT_SHIFT);
                r = new UnsignedRightShiftNode(tree, left, right);
                break;
            }
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: {
                TypeMirror rightType;
                TypeMirror leftType = TreeUtils.typeOf((Tree)leftTree);
                if (TypesUtils.isBoxedPrimitive((TypeMirror)leftType)) {
                    leftType = this.types.unboxedType(leftType);
                }
                if (TypesUtils.isBoxedPrimitive((TypeMirror)(rightType = TreeUtils.typeOf((Tree)rightTree)))) {
                    rightType = this.types.unboxedType(rightType);
                }
                TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                Node left = this.binaryNumericPromotion(this.scan((Tree)leftTree, p), promotedType);
                Node right = this.binaryNumericPromotion(this.scan((Tree)rightTree, p), promotedType);
                if (kind == Tree.Kind.GREATER_THAN) {
                    r = new GreaterThanNode(tree, left, right);
                    break;
                }
                if (kind == Tree.Kind.GREATER_THAN_EQUAL) {
                    r = new GreaterThanOrEqualNode(tree, left, right);
                    break;
                }
                if (kind == Tree.Kind.LESS_THAN) {
                    r = new LessThanNode(tree, left, right);
                    break;
                }
                assert (kind == Tree.Kind.LESS_THAN_EQUAL);
                r = new LessThanOrEqualNode(tree, left, right);
                break;
            }
            case EQUAL_TO: 
            case NOT_EQUAL_TO: {
                TreeInfo leftInfo = this.getTreeInfo(leftTree);
                TreeInfo rightInfo = this.getTreeInfo(rightTree);
                Node left = this.scan((Tree)leftTree, p);
                Node right = this.scan((Tree)rightTree, p);
                if (leftInfo.isNumeric() && rightInfo.isNumeric() && (!leftInfo.isBoxed() || !rightInfo.isBoxed())) {
                    TypeMirror promotedType = this.binaryPromotedType(leftInfo.unboxedType(), rightInfo.unboxedType());
                    left = this.binaryNumericPromotion(left, promotedType);
                    right = this.binaryNumericPromotion(right, promotedType);
                } else if (leftInfo.isBoolean() && rightInfo.isBoolean() && (!leftInfo.isBoxed() || !rightInfo.isBoxed())) {
                    left = this.unboxAsNeeded(left, leftInfo.isBoxed());
                    right = this.unboxAsNeeded(right, rightInfo.isBoxed());
                }
                if (kind == Tree.Kind.EQUAL_TO) {
                    r = new EqualToNode(tree, left, right);
                    break;
                }
                assert (kind == Tree.Kind.NOT_EQUAL_TO);
                r = new NotEqualNode(tree, left, right);
                break;
            }
            case AND: 
            case OR: 
            case XOR: {
                Node right;
                Node left;
                boolean isBooleanOp;
                TypeMirror leftType = TreeUtils.typeOf((Tree)leftTree);
                TypeMirror rightType = TreeUtils.typeOf((Tree)rightTree);
                boolean bl = isBooleanOp = TypesUtils.isBooleanType((TypeMirror)leftType) && TypesUtils.isBooleanType((TypeMirror)rightType);
                if (isBooleanOp) {
                    left = this.unbox(this.scan((Tree)leftTree, p));
                    right = this.unbox(this.scan((Tree)rightTree, p));
                } else if (this.isNumericOrBoxed(leftType) && this.isNumericOrBoxed(rightType)) {
                    TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                    left = this.binaryNumericPromotion(this.scan((Tree)leftTree, p), promotedType);
                    right = this.binaryNumericPromotion(this.scan((Tree)rightTree, p), promotedType);
                } else {
                    left = this.unbox(this.scan((Tree)leftTree, p));
                    right = this.unbox(this.scan((Tree)rightTree, p));
                }
                if (kind == Tree.Kind.AND) {
                    r = new BitwiseAndNode(tree, left, right);
                    break;
                }
                if (kind == Tree.Kind.OR) {
                    r = new BitwiseOrNode(tree, left, right);
                    break;
                }
                assert (kind == Tree.Kind.XOR);
                r = new BitwiseXorNode(tree, left, right);
                break;
            }
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: {
                ConditionalJump cjump;
                Label rightStartLabel = new Label();
                Label shortCircuitLabel = new Label();
                Node left = this.scan((Tree)leftTree, p);
                if (kind == Tree.Kind.CONDITIONAL_AND) {
                    cjump = new ConditionalJump(rightStartLabel, shortCircuitLabel);
                    cjump.setFalseFlowRule(Store.FlowRule.ELSE_TO_ELSE);
                } else {
                    cjump = new ConditionalJump(shortCircuitLabel, rightStartLabel);
                    cjump.setTrueFlowRule(Store.FlowRule.THEN_TO_THEN);
                }
                this.extendWithExtendedNode(cjump);
                this.addLabelForNextNode(rightStartLabel);
                Node right = this.scan((Tree)rightTree, p);
                this.addLabelForNextNode(shortCircuitLabel);
                if (kind == Tree.Kind.CONDITIONAL_AND) {
                    r = new ConditionalAndNode(tree, left, right);
                    break;
                }
                r = new ConditionalOrNode(tree, left, right);
                break;
            }
            default: {
                throw new BugInCF("unexpected binary tree: " + (Object)((Object)kind));
            }
        }
        assert (r != null) : "unexpected binary tree";
        this.extendWithNode(r);
        return r;
    }

    @Override
    public Node visitBlock(BlockTree tree, Void p) {
        for (StatementTree statementTree : tree.getStatements()) {
            this.scan((Tree)statementTree, null);
        }
        return null;
    }

    @Override
    public Node visitBreak(BreakTree tree, Void p) {
        Name label = tree.getLabel();
        if (label == null) {
            assert (this.breakTargetLC != null) : "no target for break statement";
            this.extendWithExtendedNode(new UnconditionalJump(this.breakTargetLC.accessLabel()));
        } else {
            assert (this.breakLabels.containsKey(label));
            this.extendWithExtendedNode(new UnconditionalJump(this.breakLabels.get(label)));
        }
        return null;
    }

    @Override
    public Node visitSwitch(SwitchTree tree, Void p) {
        SwitchBuilder builder = new SwitchBuilder(tree);
        builder.build();
        return null;
    }

    @Override
    public Node visitCase(CaseTree tree, Void p) {
        throw new AssertionError((Object)"case visitor is implemented in SwitchBuilder");
    }

    @Override
    public Node visitCatch(CatchTree tree, Void p) {
        this.scan((Tree)tree.getParameter(), p);
        this.scan((Tree)tree.getBlock(), p);
        return null;
    }

    @Override
    public Node visitClass(ClassTree tree, Void p) {
        this.declaredClasses.add(tree);
        ClassDeclarationNode classbody = new ClassDeclarationNode(tree);
        this.extendWithNode(classbody);
        return classbody;
    }

    @Override
    public Node visitConditionalExpression(ConditionalExpressionTree tree, Void p) {
        TypeMirror exprType = TreeUtils.typeOf((Tree)tree);
        if (exprType.getKind() == TypeKind.NULL) {
            Tree parent = TreePathUtil.getContextForPolyExpression((TreePath)this.getCurrentPath());
            if (parent != null) {
                exprType = TreeUtils.typeOf((Tree)parent);
            }
            if (parent == null || exprType == null) {
                exprType = TypesUtils.getObjectTypeMirror((ProcessingEnvironment)this.env);
            }
        }
        Label trueStart = new Label();
        Label falseStart = new Label();
        Label merge = new Label();
        VariableTree condExprVarTree = this.treeBuilder.buildVariableDecl(exprType, this.uniqueName("condExpr"), TreePathUtil.findNearestEnclosingElement((TreePath)this.getCurrentPath()), null);
        this.handleArtificialTree(condExprVarTree);
        VariableDeclarationNode condExprVarNode = new VariableDeclarationNode(condExprVarTree);
        condExprVarNode.setInSource(false);
        this.extendWithNode(condExprVarNode);
        Node condition = this.unbox(this.scan((Tree)tree.getCondition(), p));
        ConditionalJump cjump = new ConditionalJump(trueStart, falseStart);
        this.extendWithExtendedNode(cjump);
        this.addLabelForNextNode(trueStart);
        ExpressionTree trueExprTree = tree.getTrueExpression();
        Node trueExprNode = this.scan((Tree)trueExprTree, p);
        trueExprNode = this.conditionalExprPromotion(trueExprNode, exprType);
        this.extendWithAssignmentForConditionalExpr(condExprVarTree, trueExprTree, trueExprNode);
        this.extendWithExtendedNode(new UnconditionalJump(merge));
        this.addLabelForNextNode(falseStart);
        ExpressionTree falseExprTree = tree.getFalseExpression();
        Node falseExprNode = this.scan((Tree)falseExprTree, p);
        falseExprNode = this.conditionalExprPromotion(falseExprNode, exprType);
        this.extendWithAssignmentForConditionalExpr(condExprVarTree, falseExprTree, falseExprNode);
        this.extendWithExtendedNode(new UnconditionalJump(merge));
        this.addLabelForNextNode(merge);
        IPair<IdentifierTree, LocalVariableNode> treeAndLocalVarNode = this.buildVarUseNode(condExprVarTree);
        TernaryExpressionNode node = new TernaryExpressionNode(tree, condition, trueExprNode, falseExprNode, (LocalVariableNode)treeAndLocalVarNode.second);
        this.extendWithNode(node);
        return node;
    }

    private void extendWithAssignmentForConditionalExpr(VariableTree condExprVarTree, ExpressionTree caseExprTree, Node caseExprNode) {
        IPair<IdentifierTree, LocalVariableNode> treeAndLocalVarNode = this.buildVarUseNode(condExprVarTree);
        AssignmentTree assign = this.treeBuilder.buildAssignment((ExpressionTree)treeAndLocalVarNode.first, caseExprTree);
        this.handleArtificialTree(assign);
        AssignmentNode assignmentNode = new AssignmentNode(assign, (Node)treeAndLocalVarNode.second, caseExprNode, true);
        assignmentNode.setInSource(false);
        this.extendWithNode(assignmentNode);
    }

    private IPair<IdentifierTree, LocalVariableNode> buildVarUseNode(VariableTree varTree) {
        IdentifierTree condExprVarUseTree = this.treeBuilder.buildVariableUse(varTree);
        this.handleArtificialTree(condExprVarUseTree);
        LocalVariableNode condExprVarUseNode = new LocalVariableNode(condExprVarUseTree);
        condExprVarUseNode.setInSource(false);
        return IPair.of((Object)condExprVarUseTree, (Object)condExprVarUseNode);
    }

    @Override
    public Node visitContinue(ContinueTree tree, Void p) {
        UnconditionalJump uj;
        Name label = tree.getLabel();
        if (label == null) {
            assert (this.continueTargetLC != null) : "no target for continue statement";
            uj = new UnconditionalJump(this.continueTargetLC.accessLabel());
        } else {
            assert (this.continueLabels.containsKey(label));
            uj = new UnconditionalJump(this.continueLabels.get(label));
        }
        this.extendWithExtendedNode(uj);
        return null;
    }

    @Override
    public Node visitDoWhileLoop(DoWhileLoopTree tree, Void p) {
        Name parentLabel = this.getLabel(this.getCurrentPath());
        Label loopEntry = new Label();
        Label loopExit = new Label();
        Label conditionStart = parentLabel != null ? this.continueLabels.get(parentLabel) : new Label();
        LabelCell oldBreakTargetLC = this.breakTargetLC;
        this.breakTargetLC = new LabelCell(loopExit);
        LabelCell oldContinueTargetLC = this.continueTargetLC;
        this.continueTargetLC = new LabelCell(conditionStart);
        this.addLabelForNextNode(loopEntry);
        assert (tree.getStatement() != null);
        this.scan((Tree)tree.getStatement(), p);
        this.addLabelForNextNode(conditionStart);
        assert (tree.getCondition() != null);
        this.unbox(this.scan((Tree)tree.getCondition(), p));
        ConditionalJump cjump = new ConditionalJump(loopEntry, loopExit);
        this.extendWithExtendedNode(cjump);
        this.addLabelForNextNode(loopExit);
        this.breakTargetLC = oldBreakTargetLC;
        this.continueTargetLC = oldContinueTargetLC;
        return null;
    }

    @Override
    public Node visitErroneous(ErroneousTree tree, Void p) {
        throw new BugInCF("ErroneousTree is unexpected in AST to CFG translation: " + tree);
    }

    @Override
    public Node visitExpressionStatement(ExpressionStatementTree tree, Void p) {
        ExpressionTree exprTree = tree.getExpression();
        this.scan((Tree)exprTree, p);
        this.extendWithNode(new ExpressionStatementNode(exprTree));
        return null;
    }

    @Override
    public Node visitEnhancedForLoop(EnhancedForLoopTree tree, Void p) {
        Name parentLabel = this.getLabel(this.getCurrentPath());
        Label conditionStart = new Label();
        Label loopEntry = new Label();
        Label loopExit = new Label();
        Label updateStart = parentLabel != null ? this.continueLabels.get(parentLabel) : new Label();
        LabelCell oldBreakTargetLC = this.breakTargetLC;
        this.breakTargetLC = new LabelCell(loopExit);
        LabelCell oldContinueTargetLC = this.continueTargetLC;
        this.continueTargetLC = new LabelCell(updateStart);
        VariableTree variable = tree.getVariable();
        VariableElement variableElement = TreeUtils.elementFromDeclaration((VariableTree)variable);
        ExpressionTree expression = tree.getExpression();
        StatementTree statement = tree.getStatement();
        TypeMirror exprType = TreeUtils.typeOf((Tree)expression);
        if (this.types.isSubtype(exprType, this.iterableType)) {
            exprType = TypesUtils.upperBound((TypeMirror)exprType);
            assert (exprType instanceof DeclaredType) : "an Iterable must be a DeclaredType";
            DeclaredType declaredExprType = (DeclaredType)exprType;
            declaredExprType.getTypeArguments();
            MemberSelectTree iteratorSelect = this.treeBuilder.buildIteratorMethodAccess(expression);
            this.handleArtificialTree(iteratorSelect);
            MethodInvocationTree iteratorCall = this.treeBuilder.buildMethodInvocation((ExpressionTree)iteratorSelect);
            this.handleArtificialTree(iteratorCall);
            VariableTree iteratorVariable = this.createEnhancedForLoopIteratorVariable(iteratorCall, variableElement);
            this.handleArtificialTree(iteratorVariable);
            VariableDeclarationNode iteratorVariableDecl = new VariableDeclarationNode(iteratorVariable);
            iteratorVariableDecl.setInSource(false);
            this.extendWithNode(iteratorVariableDecl);
            Node expressionNode = this.scan((Tree)expression, p);
            MethodAccessNode iteratorAccessNode = new MethodAccessNode(iteratorSelect, expressionNode);
            iteratorAccessNode.setInSource(false);
            this.extendWithNode(iteratorAccessNode);
            MethodInvocationNode iteratorCallNode = new MethodInvocationNode(iteratorCall, iteratorAccessNode, Collections.emptyList(), this.getCurrentPath());
            iteratorCallNode.setInSource(false);
            this.extendWithNode(iteratorCallNode);
            this.translateAssignment((Tree)iteratorVariable, (Node)new LocalVariableNode(iteratorVariable), iteratorCallNode);
            this.addLabelForNextNode(conditionStart);
            IdentifierTree iteratorUse1 = this.treeBuilder.buildVariableUse(iteratorVariable);
            this.handleArtificialTree(iteratorUse1);
            LocalVariableNode iteratorReceiverNode = new LocalVariableNode(iteratorUse1);
            iteratorReceiverNode.setInSource(false);
            this.extendWithNode(iteratorReceiverNode);
            MemberSelectTree hasNextSelect = this.treeBuilder.buildHasNextMethodAccess((ExpressionTree)iteratorUse1);
            this.handleArtificialTree(hasNextSelect);
            MethodAccessNode hasNextAccessNode = new MethodAccessNode(hasNextSelect, iteratorReceiverNode);
            hasNextAccessNode.setInSource(false);
            this.extendWithNode(hasNextAccessNode);
            MethodInvocationTree hasNextCall = this.treeBuilder.buildMethodInvocation((ExpressionTree)hasNextSelect);
            this.handleArtificialTree(hasNextCall);
            MethodInvocationNode hasNextCallNode = new MethodInvocationNode(hasNextCall, hasNextAccessNode, Collections.emptyList(), this.getCurrentPath());
            hasNextCallNode.setInSource(false);
            this.extendWithNode(hasNextCallNode);
            this.extendWithExtendedNode(new ConditionalJump(loopEntry, loopExit));
            this.addLabelForNextNode(loopEntry);
            this.extendWithNode(new VariableDeclarationNode(variable));
            IdentifierTree iteratorUse2 = this.treeBuilder.buildVariableUse(iteratorVariable);
            this.handleArtificialTree(iteratorUse2);
            LocalVariableNode iteratorReceiverNode2 = new LocalVariableNode(iteratorUse2);
            iteratorReceiverNode2.setInSource(false);
            this.extendWithNode(iteratorReceiverNode2);
            MemberSelectTree nextSelect = this.treeBuilder.buildNextMethodAccess((ExpressionTree)iteratorUse2);
            this.handleArtificialTree(nextSelect);
            MethodAccessNode nextAccessNode = new MethodAccessNode(nextSelect, iteratorReceiverNode2);
            nextAccessNode.setInSource(false);
            this.extendWithNode(nextAccessNode);
            MethodInvocationTree nextCall = this.treeBuilder.buildMethodInvocation((ExpressionTree)nextSelect);
            this.handleArtificialTree(nextCall);
            MethodInvocationNode nextCallNode = new MethodInvocationNode(nextCall, nextAccessNode, Collections.emptyList(), this.getCurrentPath());
            nextCallNode.setIterableExpression(expression);
            nextCallNode.setEnhancedForLoop(tree);
            nextCallNode.setInSource(false);
            this.extendWithNode(nextCallNode);
            AssignmentNode assignNode = this.translateAssignment((Tree)variable, (Node)new LocalVariableNode(variable), nextCall);
            ((MethodInvocationNode)assignNode.getExpression()).setIterableExpression(expression);
            ((MethodInvocationNode)assignNode.getExpression()).setEnhancedForLoop(tree);
            assert (statement != null);
            this.scan((Tree)statement, p);
            this.addLabelForNextNode(updateStart);
            this.extendWithExtendedNode(new UnconditionalJump(conditionStart));
        } else {
            VariableTree arrayVariable = this.createEnhancedForLoopArrayVariable(expression, variableElement);
            this.handleArtificialTree(arrayVariable);
            VariableDeclarationNode arrayVariableNode = new VariableDeclarationNode(arrayVariable);
            arrayVariableNode.setInSource(false);
            this.extendWithNode(arrayVariableNode);
            Node expressionNode = this.scan((Tree)expression, p);
            this.translateAssignment((Tree)arrayVariable, (Node)new LocalVariableNode(arrayVariable), expressionNode).setDesugaredFromEnhancedArrayForLoop();
            PrimitiveType intType = this.types.getPrimitiveType(TypeKind.INT);
            LiteralTree zero = this.treeBuilder.buildLiteral((Object)0);
            this.handleArtificialTree(zero);
            VariableTree indexVariable = this.treeBuilder.buildVariableDecl((TypeMirror)intType, this.uniqueName("index"), variableElement.getEnclosingElement(), (ExpressionTree)zero);
            this.handleArtificialTree(indexVariable);
            VariableDeclarationNode indexVariableNode = new VariableDeclarationNode(indexVariable);
            indexVariableNode.setInSource(false);
            this.extendWithNode(indexVariableNode);
            IntegerLiteralNode zeroNode = new IntegerLiteralNode(zero);
            this.extendWithNode(zeroNode);
            this.translateAssignment((Tree)indexVariable, (Node)new LocalVariableNode(indexVariable), zeroNode);
            this.addLabelForNextNode(conditionStart);
            IdentifierTree indexUse1 = this.treeBuilder.buildVariableUse(indexVariable);
            this.handleArtificialTree(indexUse1);
            LocalVariableNode indexNode1 = new LocalVariableNode(indexUse1);
            indexNode1.setInSource(false);
            this.extendWithNode(indexNode1);
            IdentifierTree arrayUse1 = this.treeBuilder.buildVariableUse(arrayVariable);
            this.handleArtificialTree(arrayUse1);
            LocalVariableNode arrayNode1 = new LocalVariableNode(arrayUse1);
            this.extendWithNode(arrayNode1);
            MemberSelectTree lengthSelect = this.treeBuilder.buildArrayLengthAccess((ExpressionTree)arrayUse1);
            this.handleArtificialTree(lengthSelect);
            FieldAccessNode lengthAccessNode = new FieldAccessNode(lengthSelect, arrayNode1);
            lengthAccessNode.setInSource(false);
            this.extendWithNodeWithException(lengthAccessNode, this.nullPointerExceptionType);
            BinaryTree lessThan = this.treeBuilder.buildLessThan((ExpressionTree)indexUse1, (ExpressionTree)lengthSelect);
            this.handleArtificialTree(lessThan);
            LessThanNode lessThanNode = new LessThanNode(lessThan, indexNode1, lengthAccessNode);
            lessThanNode.setInSource(false);
            this.extendWithNode(lessThanNode);
            this.extendWithExtendedNode(new ConditionalJump(loopEntry, loopExit));
            this.addLabelForNextNode(loopEntry);
            this.extendWithNode(new VariableDeclarationNode(variable));
            IdentifierTree arrayUse2 = this.treeBuilder.buildVariableUse(arrayVariable);
            this.handleArtificialTree(arrayUse2);
            LocalVariableNode arrayNode2 = new LocalVariableNode(arrayUse2);
            arrayNode2.setInSource(false);
            this.extendWithNode(arrayNode2);
            IdentifierTree indexUse2 = this.treeBuilder.buildVariableUse(indexVariable);
            this.handleArtificialTree(indexUse2);
            LocalVariableNode indexNode2 = new LocalVariableNode(indexUse2);
            indexNode2.setInSource(false);
            this.extendWithNode(indexNode2);
            ArrayAccessTree arrayAccess = this.treeBuilder.buildArrayAccess((ExpressionTree)arrayUse2, (ExpressionTree)indexUse2);
            this.handleArtificialTree(arrayAccess);
            ArrayAccessNode arrayAccessNode = new ArrayAccessNode(arrayAccess, arrayNode2, indexNode2);
            arrayAccessNode.setArrayExpression(expression);
            arrayAccessNode.setEnhancedForLoop(tree);
            arrayAccessNode.setInSource(false);
            this.extendWithNode(arrayAccessNode);
            AssignmentNode arrayAccessAssignNode = this.translateAssignment((Tree)variable, (Node)new LocalVariableNode(variable), arrayAccessNode);
            Node arrayAccessAssignNodeExpr = arrayAccessAssignNode.getExpression();
            if (arrayAccessAssignNodeExpr instanceof ArrayAccessNode) {
                ((ArrayAccessNode)arrayAccessAssignNodeExpr).setArrayExpression(expression);
                ((ArrayAccessNode)arrayAccessAssignNodeExpr).setEnhancedForLoop(tree);
            } else if (arrayAccessAssignNodeExpr instanceof MethodInvocationNode) {
                MethodInvocationNode boxingNode = (MethodInvocationNode)arrayAccessAssignNodeExpr;
                boxingNode.setIterableExpression(expression);
                boxingNode.setEnhancedForLoop(tree);
            }
            assert (statement != null);
            this.scan((Tree)statement, p);
            this.addLabelForNextNode(updateStart);
            IdentifierTree indexUse3 = this.treeBuilder.buildVariableUse(indexVariable);
            this.handleArtificialTree(indexUse3);
            LocalVariableNode indexNode3 = new LocalVariableNode(indexUse3);
            indexNode3.setInSource(false);
            this.extendWithNode(indexNode3);
            LiteralTree oneTree = this.treeBuilder.buildLiteral((Object)1);
            this.handleArtificialTree(oneTree);
            IntegerLiteralNode one = new IntegerLiteralNode(oneTree);
            one.setInSource(false);
            this.extendWithNode(one);
            BinaryTree addOneTree = this.treeBuilder.buildBinary((TypeMirror)intType, Tree.Kind.PLUS, (ExpressionTree)indexUse3, (ExpressionTree)oneTree);
            this.handleArtificialTree(addOneTree);
            NumericalAdditionNode addOneNode = new NumericalAdditionNode(addOneTree, indexNode3, one);
            addOneNode.setInSource(false);
            this.extendWithNode(addOneNode);
            AssignmentTree assignTree = this.treeBuilder.buildAssignment((ExpressionTree)indexUse3, (ExpressionTree)addOneTree);
            this.handleArtificialTree(assignTree);
            AssignmentNode assignNode = new AssignmentNode(assignTree, indexNode3, addOneNode);
            assignNode.setInSource(false);
            this.extendWithNode(assignNode);
            this.extendWithExtendedNode(new UnconditionalJump(conditionStart));
        }
        this.addLabelForNextNode(loopExit);
        this.breakTargetLC = oldBreakTargetLC;
        this.continueTargetLC = oldContinueTargetLC;
        return null;
    }

    protected VariableTree createEnhancedForLoopIteratorVariable(MethodInvocationTree iteratorCall, VariableElement variableElement) {
        TypeMirror iteratorType = TreeUtils.typeOf((Tree)iteratorCall);
        VariableTree iteratorVariable = this.treeBuilder.buildVariableDecl(iteratorType, this.uniqueName("iter"), variableElement.getEnclosingElement(), (ExpressionTree)iteratorCall);
        return iteratorVariable;
    }

    protected VariableTree createEnhancedForLoopArrayVariable(ExpressionTree expression, VariableElement variableElement) {
        TypeMirror arrayType = TreeUtils.typeOf((Tree)expression);
        VariableTree arrayVariable = this.treeBuilder.buildVariableDecl(arrayType, this.uniqueName("array"), variableElement.getEnclosingElement(), expression);
        return arrayVariable;
    }

    @Override
    public Node visitForLoop(ForLoopTree tree, Void p) {
        Name parentLabel = this.getLabel(this.getCurrentPath());
        Label conditionStart = new Label();
        Label loopEntry = new Label();
        Label loopExit = new Label();
        Label updateStart = parentLabel != null ? this.continueLabels.get(parentLabel) : new Label();
        LabelCell oldBreakTargetLC = this.breakTargetLC;
        this.breakTargetLC = new LabelCell(loopExit);
        LabelCell oldContinueTargetLC = this.continueTargetLC;
        this.continueTargetLC = new LabelCell(updateStart);
        for (StatementTree statementTree : tree.getInitializer()) {
            this.scan((Tree)statementTree, p);
        }
        this.addLabelForNextNode(conditionStart);
        if (tree.getCondition() != null) {
            this.unbox(this.scan((Tree)tree.getCondition(), p));
            ConditionalJump cjump = new ConditionalJump(loopEntry, loopExit);
            this.extendWithExtendedNode(cjump);
        }
        this.addLabelForNextNode(loopEntry);
        assert (tree.getStatement() != null);
        this.scan((Tree)tree.getStatement(), p);
        this.addLabelForNextNode(updateStart);
        for (ExpressionStatementTree expressionStatementTree : tree.getUpdate()) {
            this.scan((Tree)expressionStatementTree, p);
        }
        this.extendWithExtendedNode(new UnconditionalJump(conditionStart));
        this.addLabelForNextNode(loopExit);
        this.breakTargetLC = oldBreakTargetLC;
        this.continueTargetLC = oldContinueTargetLC;
        return null;
    }

    @Override
    public Node visitIdentifier(IdentifierTree tree, Void p) {
        Node node;
        if (TreeUtils.isFieldAccess((Tree)tree)) {
            Node receiver = this.getReceiver(tree);
            node = new FieldAccessNode(tree, receiver);
        } else {
            Element element = TreeUtils.elementFromUse((ExpressionTree)tree);
            switch (element.getKind()) {
                case FIELD: {
                    if (element.getSimpleName().contentEquals("this")) {
                        node = new ExplicitThisNode(tree);
                        break;
                    }
                    node = new SuperNode(tree);
                    break;
                }
                case EXCEPTION_PARAMETER: 
                case LOCAL_VARIABLE: 
                case RESOURCE_VARIABLE: 
                case PARAMETER: {
                    node = new LocalVariableNode(tree);
                    break;
                }
                case PACKAGE: {
                    node = new PackageNameNode(tree);
                    break;
                }
                default: {
                    if (ElementUtils.isTypeDeclaration((Element)element)) {
                        node = new ClassNameNode(tree);
                        break;
                    }
                    if (ElementUtils.isBindingVariable((Element)element)) {
                        node = new LocalVariableNode(tree);
                        break;
                    }
                    throw new BugInCF("bad element kind " + (Object)((Object)element.getKind()));
                }
            }
        }
        if (node instanceof ClassNameNode) {
            this.extendWithClassNameNode((ClassNameNode)node);
        } else {
            this.extendWithNode(node);
        }
        return node;
    }

    @Override
    public Node visitIf(IfTree tree, Void p) {
        Label thenEntry = new Label();
        Label elseEntry = new Label();
        Label endIf = new Label();
        this.unbox(this.scan((Tree)tree.getCondition(), p));
        ConditionalJump cjump = new ConditionalJump(thenEntry, elseEntry);
        this.extendWithExtendedNode(cjump);
        this.addLabelForNextNode(thenEntry);
        StatementTree thenStatement = tree.getThenStatement();
        this.scan((Tree)thenStatement, p);
        this.extendWithExtendedNode(new UnconditionalJump(endIf));
        this.addLabelForNextNode(elseEntry);
        StatementTree elseStatement = tree.getElseStatement();
        if (elseStatement != null) {
            this.scan((Tree)elseStatement, p);
        }
        this.addLabelForNextNode(endIf);
        return null;
    }

    @Override
    public Node visitImport(ImportTree tree, Void p) {
        throw new BugInCF("ImportTree is unexpected in AST to CFG translation: " + tree);
    }

    @Override
    public Node visitArrayAccess(ArrayAccessTree tree, Void p) {
        Node array = this.scan((Tree)tree.getExpression(), p);
        Node index = this.unaryNumericPromotion(this.scan((Tree)tree.getIndex(), p));
        ArrayAccessNode arrayAccess = new ArrayAccessNode(tree, array, index);
        this.extendWithNodeWithExceptions(arrayAccess, this.arrayAccessExceptionTypes);
        return arrayAccess;
    }

    @Override
    public Node visitLabeledStatement(LabeledStatementTree tree, Void p) {
        Name labelName = tree.getLabel();
        Label breakLabel = new Label(labelName + "_break");
        Label continueLabel = new Label(labelName + "_continue");
        this.breakLabels.put(labelName, breakLabel);
        this.continueLabels.put(labelName, continueLabel);
        this.scan((Tree)tree.getStatement(), p);
        this.addLabelForNextNode(breakLabel);
        this.breakLabels.remove(labelName);
        this.continueLabels.remove(labelName);
        return null;
    }

    @Override
    public Node visitLiteral(LiteralTree tree, Void p) {
        ValueLiteralNode r;
        switch (tree.getKind()) {
            case BOOLEAN_LITERAL: {
                r = new BooleanLiteralNode(tree);
                break;
            }
            case CHAR_LITERAL: {
                r = new CharacterLiteralNode(tree);
                break;
            }
            case DOUBLE_LITERAL: {
                r = new DoubleLiteralNode(tree);
                break;
            }
            case FLOAT_LITERAL: {
                r = new FloatLiteralNode(tree);
                break;
            }
            case INT_LITERAL: {
                r = new IntegerLiteralNode(tree);
                break;
            }
            case LONG_LITERAL: {
                r = new LongLiteralNode(tree);
                break;
            }
            case NULL_LITERAL: {
                r = new NullLiteralNode(tree);
                break;
            }
            case STRING_LITERAL: {
                r = new StringLiteralNode(tree);
                break;
            }
            default: {
                throw new BugInCF("unexpected literal tree: " + tree);
            }
        }
        this.extendWithNode(r);
        return r;
    }

    @Override
    public Node visitMethod(MethodTree tree, Void p) {
        throw new BugInCF("MethodTree is unexpected in AST to CFG translation");
    }

    @Override
    public Node visitModifiers(ModifiersTree tree, Void p) {
        throw new BugInCF("ModifiersTree is unexpected in AST to CFG translation");
    }

    @Override
    public Node visitNewArray(NewArrayTree tree, Void p) {
        ArrayType type = (ArrayType)TreeUtils.typeOf((Tree)tree);
        TypeMirror elemType = type.getComponentType();
        List<? extends ExpressionTree> dimensions = tree.getDimensions();
        List<? extends ExpressionTree> initializers = tree.getInitializers();
        assert (dimensions != null);
        List dimensionNodes = CollectionsPlume.mapList(dim -> this.unaryNumericPromotion(this.scan((Tree)dim, p)), dimensions);
        List initializerNodes = initializers == null ? Collections.emptyList() : CollectionsPlume.mapList(init -> this.assignConvert(this.scan((Tree)init, p), elemType), initializers);
        ArrayCreationNode node = new ArrayCreationNode(tree, type, dimensionNodes, initializerNodes);
        this.extendWithNodeWithExceptions(node, this.newArrayExceptionTypes);
        return node;
    }

    @Override
    public Node visitNewClass(NewClassTree tree, Void p) {
        Node enclosingExprNode;
        DeclaredType classType = (DeclaredType)TreeUtils.typeOf((Tree)tree);
        TypeMirror enclosingType = classType.getEnclosingType();
        ExpressionTree enclosingExpr = tree.getEnclosingExpression();
        if (enclosingExpr != null) {
            enclosingExprNode = this.scan((Tree)enclosingExpr, p);
        } else if (enclosingType.getKind() == TypeKind.DECLARED) {
            enclosingExprNode = new ImplicitThisNode(enclosingType);
            this.extendWithNode(enclosingExprNode);
        } else {
            enclosingExprNode = null;
        }
        ExecutableElement constructor = TreeUtils.elementFromUse((NewClassTree)tree);
        List<? extends ExpressionTree> actualExprs = tree.getArguments();
        List<Node> arguments = this.convertCallArguments(tree, constructor, TreeUtils.typeFromUse((NewClassTree)tree), actualExprs);
        Node constructorNode = this.scan((Tree)tree.getIdentifier(), p);
        ClassDeclarationNode classbody = (ClassDeclarationNode)this.scan((Tree)tree.getClassBody(), p);
        ObjectCreationNode node = new ObjectCreationNode(tree, enclosingExprNode, constructorNode, arguments, classbody);
        List<? extends TypeMirror> thrownTypes = constructor.getThrownTypes();
        Set thrownSet = ArraySet.newArraySetOrLinkedHashSet((int)(thrownTypes.size() + this.uncheckedExceptionTypes.size()));
        thrownSet.addAll(thrownTypes);
        thrownSet.addAll(this.uncheckedExceptionTypes);
        this.extendWithNodeWithExceptions(node, thrownSet);
        return node;
    }

    @Override
    public Node visitParenthesized(ParenthesizedTree tree, Void p) {
        this.parenMapping.put(tree.getExpression(), tree);
        return this.scan((Tree)tree.getExpression(), p);
    }

    @Override
    public Node visitReturn(ReturnTree tree, Void p) {
        ExpressionTree ret = tree.getExpression();
        ReturnNode result = null;
        if (ret != null) {
            Node node = this.scan((Tree)ret, p);
            result = new ReturnNode(tree, node, this.env.getTypeUtils());
            this.returnNodes.add(result);
            this.extendWithNode(result);
        }
        this.extendWithExtendedNode(new UnconditionalJump(this.returnTargetLC.accessLabel()));
        return result;
    }

    @Override
    public Node visitMemberSelect(MemberSelectTree tree, Void p) {
        Node expr = this.scan((Tree)tree.getExpression(), p);
        if (!TreeUtils.isFieldAccess((Tree)tree)) {
            Element element = TreeUtils.elementFromUse((MemberSelectTree)tree);
            if (ElementUtils.isTypeElement((Element)element)) {
                ClassNameNode result = new ClassNameNode(tree, expr);
                this.extendWithClassNameNode(result);
                return result;
            }
            if (element.getKind() == ElementKind.PACKAGE) {
                PackageNameNode result = new PackageNameNode(tree, (PackageNameNode)expr);
                this.extendWithNode(result);
                return result;
            }
            throw new BugInCF("Unexpected element kind: " + (Object)((Object)element.getKind()));
        }
        FieldAccessNode node = new FieldAccessNode(tree, expr);
        Element element = TreeUtils.elementFromUse((MemberSelectTree)tree);
        if (ElementUtils.isStatic((Element)element) || expr instanceof ImplicitThisNode || expr instanceof ExplicitThisNode) {
            this.extendWithNode(node);
        } else {
            this.extendWithNodeWithException(node, this.nullPointerExceptionType);
        }
        return node;
    }

    @Override
    public Node visitEmptyStatement(EmptyStatementTree tree, Void p) {
        return null;
    }

    @Override
    public Node visitSynchronized(SynchronizedTree tree, Void p) {
        Node synchronizedExpr = this.scan((Tree)tree.getExpression(), p);
        SynchronizedNode synchronizedStartNode = new SynchronizedNode(tree, synchronizedExpr, true, this.env.getTypeUtils());
        this.extendWithNode(synchronizedStartNode);
        this.scan((Tree)tree.getBlock(), p);
        SynchronizedNode synchronizedEndNode = new SynchronizedNode(tree, synchronizedExpr, false, this.env.getTypeUtils());
        this.extendWithNode(synchronizedEndNode);
        return null;
    }

    @Override
    public Node visitThrow(ThrowTree tree, Void p) {
        Node expression = this.scan((Tree)tree.getExpression(), p);
        TypeMirror exception = expression.getType();
        ThrowNode throwsNode = new ThrowNode(tree, expression, this.env.getTypeUtils());
        NodeWithExceptionsHolder exNode = this.extendWithNodeWithException(throwsNode, exception);
        exNode.setTerminatesExecution(true);
        return throwsNode;
    }

    @Override
    public Node visitCompilationUnit(CompilationUnitTree tree, Void p) {
        throw new BugInCF("CompilationUnitTree is unexpected in AST to CFG translation");
    }

    private static <A> A firstNonNull(A first, A second) {
        if (first != null) {
            return first;
        }
        if (second != null) {
            return second;
        }
        throw new NullPointerException();
    }

    @Override
    public Node visitTry(TryTree tree, Void p) {
        List<? extends CatchTree> catches = tree.getCatches();
        BlockTree finallyBlock = tree.getFinallyBlock();
        this.extendWithNode(new MarkerNode(tree, "start of try statement #" + TreeUtils.treeUids.get((Object)tree), this.env.getTypeUtils()));
        List catchLabels = CollectionsPlume.mapList(c -> IPair.of((Object)TreeUtils.typeOf((Tree)c.getParameter().getType()), (Object)new Label()), catches);
        LabelCell oldReturnTargetLC = this.returnTargetLC;
        LabelCell oldBreakTargetLC = this.breakTargetLC;
        Map<Name, Label> oldBreakLabels = this.breakLabels;
        LabelCell oldContinueTargetLC = this.continueTargetLC;
        Map<Name, Label> oldContinueLabels = this.continueLabels;
        Label finallyLabel = null;
        Label exceptionalFinallyLabel = null;
        if (finallyBlock != null) {
            finallyLabel = new Label();
            exceptionalFinallyLabel = new Label();
            this.tryStack.pushFrame(new TryFinallyFrame(exceptionalFinallyLabel));
            this.returnTargetLC = new LabelCell();
            this.breakTargetLC = new LabelCell();
            this.breakLabels = new TryFinallyScopeMap();
            this.continueTargetLC = new LabelCell();
            this.continueLabels = new TryFinallyScopeMap();
        }
        Label doneLabel = new Label();
        this.tryStack.pushFrame(new TryCatchFrame(this.types, catchLabels));
        this.extendWithNode(new MarkerNode(tree, "start of try block #" + TreeUtils.treeUids.get((Object)tree), this.env.getTypeUtils()));
        this.handleTryResourcesAndBlock(tree, p, tree.getResources());
        this.extendWithNode(new MarkerNode(tree, "end of try block #" + TreeUtils.treeUids.get((Object)tree), this.env.getTypeUtils()));
        this.extendWithExtendedNode(new UnconditionalJump(CFGTranslationPhaseOne.firstNonNull(finallyLabel, doneLabel)));
        this.tryStack.popFrame();
        int catchIndex = 0;
        for (CatchTree catchTree : catches) {
            this.addLabelForNextNode((Label)((IPair)catchLabels.get((int)catchIndex)).second);
            TypeMirror catchType = TreeUtils.typeOf((Tree)catchTree.getParameter().getType());
            this.extendWithNode(new CatchMarkerNode(tree, "start", catchType, this.env.getTypeUtils()));
            this.scan((Tree)catchTree, p);
            this.extendWithNode(new CatchMarkerNode(tree, "end", catchType, this.env.getTypeUtils()));
            ++catchIndex;
            this.extendWithExtendedNode(new UnconditionalJump(CFGTranslationPhaseOne.firstNonNull(finallyLabel, doneLabel)));
        }
        if (finallyLabel != null) {
            this.handleFinally(tree, doneLabel, finallyLabel, exceptionalFinallyLabel, () -> this.scan((Tree)finallyBlock, p), oldReturnTargetLC, oldBreakTargetLC, oldBreakLabels, oldContinueTargetLC, oldContinueLabels);
        }
        this.addLabelForNextNode(doneLabel);
        return null;
    }

    private void handleTryResourcesAndBlock(TryTree tryTree, Void p, List<? extends Tree> resources) {
        if (resources.isEmpty()) {
            this.scan((Tree)tryTree.getBlock(), p);
            return;
        }
        Tree resourceDeclarationTree = resources.get(0);
        this.extendWithNode(new MarkerNode(resourceDeclarationTree, "start of try for resource #" + TreeUtils.treeUids.get((Object)resourceDeclarationTree), this.env.getTypeUtils()));
        LabelCell oldReturnTargetLC = this.returnTargetLC;
        LabelCell oldBreakTargetLC = this.breakTargetLC;
        Map<Name, Label> oldBreakLabels = this.breakLabels;
        LabelCell oldContinueTargetLC = this.continueTargetLC;
        Map<Name, Label> oldContinueLabels = this.continueLabels;
        Node resourceCloseNode = this.scan(resourceDeclarationTree, p);
        Label doneLabel = new Label();
        Label finallyLabel = new Label();
        Label exceptionalFinallyLabel = new Label();
        this.tryStack.pushFrame(new TryFinallyFrame(exceptionalFinallyLabel));
        this.returnTargetLC = new LabelCell();
        this.breakTargetLC = new LabelCell();
        this.breakLabels = new TryFinallyScopeMap();
        this.continueTargetLC = new LabelCell();
        this.continueLabels = new TryFinallyScopeMap();
        this.extendWithNode(new MarkerNode(resourceDeclarationTree, "start of try block for resource #" + TreeUtils.treeUids.get((Object)resourceDeclarationTree), this.env.getTypeUtils()));
        this.handleTryResourcesAndBlock(tryTree, p, resources.subList(1, resources.size()));
        this.extendWithNode(new MarkerNode(resourceDeclarationTree, "end of try block for resource #" + TreeUtils.treeUids.get((Object)resourceDeclarationTree), this.env.getTypeUtils()));
        this.extendWithExtendedNode(new UnconditionalJump(finallyLabel));
        this.handleFinally(resourceDeclarationTree, doneLabel, finallyLabel, exceptionalFinallyLabel, () -> this.addCloseCallForResource(resourceDeclarationTree, resourceCloseNode), oldReturnTargetLC, oldBreakTargetLC, oldBreakLabels, oldContinueTargetLC, oldContinueLabels);
        this.addLabelForNextNode(doneLabel);
    }

    private void addCloseCallForResource(Tree resourceDeclarationTree, Node resourceToCloseNode) {
        Tree receiverTree = resourceDeclarationTree;
        if (receiverTree instanceof VariableTree) {
            receiverTree = this.treeBuilder.buildVariableUse((VariableTree)receiverTree);
            this.handleArtificialTree(receiverTree);
        }
        MemberSelectTree closeSelect = this.treeBuilder.buildCloseMethodAccess((ExpressionTree)receiverTree);
        this.handleArtificialTree(closeSelect);
        MethodInvocationTree closeCall = this.treeBuilder.buildMethodInvocation((ExpressionTree)closeSelect);
        this.handleArtificialTree(closeCall);
        Node receiverNode = resourceToCloseNode;
        if (receiverNode instanceof AssignmentNode) {
            receiverNode = ((AssignmentNode)resourceToCloseNode).getTarget();
        }
        MethodAccessNode closeAccessNode = new MethodAccessNode(closeSelect, receiverNode);
        closeAccessNode.setInSource(false);
        this.extendWithNode(closeAccessNode);
        MethodInvocationNode closeCallNode = new MethodInvocationNode(closeCall, closeAccessNode, Collections.emptyList(), this.getCurrentPath());
        closeCallNode.setInSource(false);
        this.extendWithMethodInvocationNode(TreeUtils.elementFromUse((MethodInvocationTree)closeCall), closeCallNode);
    }

    private void handleFinally(Tree markerTree, Label doneLabel, Label finallyLabel, Label exceptionalFinallyLabel, Runnable finallyBlockCFGGenerator, LabelCell oldReturnTargetLC, LabelCell oldBreakTargetLC, Map<Name, Label> oldBreakLabels, LabelCell oldContinueTargetLC, Map<Name, Label> oldContinueLabels) {
        this.tryStack.popFrame();
        this.addLabelForNextNode(finallyLabel);
        this.extendWithNode(new MarkerNode(markerTree, "start of finally block #" + TreeUtils.treeUids.get((Object)markerTree), this.env.getTypeUtils()));
        finallyBlockCFGGenerator.run();
        this.extendWithNode(new MarkerNode(markerTree, "end of finally block #" + TreeUtils.treeUids.get((Object)markerTree), this.env.getTypeUtils()));
        this.extendWithExtendedNode(new UnconditionalJump(doneLabel));
        if (this.hasExceptionalPath(exceptionalFinallyLabel)) {
            this.addLabelForNextNode(exceptionalFinallyLabel);
            this.extendWithNode(new MarkerNode(markerTree, "start of finally block for Throwable #" + TreeUtils.treeUids.get((Object)markerTree), this.env.getTypeUtils()));
            finallyBlockCFGGenerator.run();
            NodeWithExceptionsHolder throwing = this.extendWithNodeWithException(new MarkerNode(markerTree, "end of finally block for Throwable #" + TreeUtils.treeUids.get((Object)markerTree), this.env.getTypeUtils()), this.throwableType);
            throwing.setTerminatesExecution(true);
        }
        if (this.returnTargetLC.wasAccessed()) {
            this.addLabelForNextNode(this.returnTargetLC.peekLabel());
            this.returnTargetLC = oldReturnTargetLC;
            this.extendWithNode(new MarkerNode(markerTree, "start of finally block for return #" + TreeUtils.treeUids.get((Object)markerTree), this.env.getTypeUtils()));
            finallyBlockCFGGenerator.run();
            this.extendWithNode(new MarkerNode(markerTree, "end of finally block for return #" + TreeUtils.treeUids.get((Object)markerTree), this.env.getTypeUtils()));
            this.extendWithExtendedNode(new UnconditionalJump(this.returnTargetLC.accessLabel()));
        } else {
            this.returnTargetLC = oldReturnTargetLC;
        }
        if (this.breakTargetLC.wasAccessed()) {
            this.addLabelForNextNode(this.breakTargetLC.peekLabel());
            this.breakTargetLC = oldBreakTargetLC;
            this.extendWithNode(new MarkerNode(markerTree, "start of finally block for break #" + TreeUtils.treeUids.get((Object)markerTree), this.env.getTypeUtils()));
            finallyBlockCFGGenerator.run();
            this.extendWithNode(new MarkerNode(markerTree, "end of finally block for break #" + TreeUtils.treeUids.get((Object)markerTree), this.env.getTypeUtils()));
            this.extendWithExtendedNode(new UnconditionalJump(this.breakTargetLC.accessLabel()));
        } else {
            this.breakTargetLC = oldBreakTargetLC;
        }
        Map<Name, Label> accessedBreakLabels = ((TryFinallyScopeMap)this.breakLabels).getAccessedNames();
        if (!accessedBreakLabels.isEmpty()) {
            this.breakLabels = oldBreakLabels;
            for (Map.Entry<Name, Label> access : accessedBreakLabels.entrySet()) {
                this.addLabelForNextNode(access.getValue());
                this.extendWithNode(new MarkerNode(markerTree, "start of finally block for break label " + access.getKey() + " #" + TreeUtils.treeUids.get((Object)markerTree), this.env.getTypeUtils()));
                finallyBlockCFGGenerator.run();
                this.extendWithNode(new MarkerNode(markerTree, "end of finally block for break label " + access.getKey() + " #" + TreeUtils.treeUids.get((Object)markerTree), this.env.getTypeUtils()));
                this.extendWithExtendedNode(new UnconditionalJump(this.breakLabels.get(access.getKey())));
            }
        } else {
            this.breakLabels = oldBreakLabels;
        }
        if (this.continueTargetLC.wasAccessed()) {
            this.addLabelForNextNode(this.continueTargetLC.peekLabel());
            this.continueTargetLC = oldContinueTargetLC;
            this.extendWithNode(new MarkerNode(markerTree, "start of finally block for continue #" + TreeUtils.treeUids.get((Object)markerTree), this.env.getTypeUtils()));
            finallyBlockCFGGenerator.run();
            this.extendWithNode(new MarkerNode(markerTree, "end of finally block for continue #" + TreeUtils.treeUids.get((Object)markerTree), this.env.getTypeUtils()));
            this.extendWithExtendedNode(new UnconditionalJump(this.continueTargetLC.accessLabel()));
        } else {
            this.continueTargetLC = oldContinueTargetLC;
        }
        Map<Name, Label> accessedContinueLabels = ((TryFinallyScopeMap)this.continueLabels).getAccessedNames();
        if (!accessedContinueLabels.isEmpty()) {
            this.continueLabels = oldContinueLabels;
            for (Map.Entry<Name, Label> access : accessedContinueLabels.entrySet()) {
                this.addLabelForNextNode(access.getValue());
                this.extendWithNode(new MarkerNode(markerTree, "start of finally block for continue label " + access.getKey() + " #" + TreeUtils.treeUids.get((Object)markerTree), this.env.getTypeUtils()));
                finallyBlockCFGGenerator.run();
                this.extendWithNode(new MarkerNode(markerTree, "end of finally block for continue label " + access.getKey() + " #" + TreeUtils.treeUids.get((Object)markerTree), this.env.getTypeUtils()));
                this.extendWithExtendedNode(new UnconditionalJump(this.continueLabels.get(access.getKey())));
            }
        } else {
            this.continueLabels = oldContinueLabels;
        }
    }

    private boolean hasExceptionalPath(Label target) {
        for (ExtendedNode node : this.nodeList) {
            if (!(node instanceof NodeWithExceptionsHolder)) continue;
            NodeWithExceptionsHolder exceptionalNode = (NodeWithExceptionsHolder)node;
            for (Set<Label> labels : exceptionalNode.getExceptions().values()) {
                if (!labels.contains(target)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Node visitParameterizedType(ParameterizedTypeTree tree, Void p) {
        ParameterizedTypeNode result = new ParameterizedTypeNode(tree);
        this.extendWithNode(result);
        return result;
    }

    @Override
    public Node visitUnionType(UnionTypeTree tree, Void p) {
        throw new BugInCF("UnionTypeTree is unexpected in AST to CFG translation: " + tree);
    }

    @Override
    public Node visitArrayType(ArrayTypeTree tree, Void p) {
        ArrayTypeNode result = new ArrayTypeNode(tree, this.types);
        this.extendWithNode(result);
        return result;
    }

    @Override
    public Node visitTypeCast(TypeCastTree tree, Void p) {
        Node operand = this.scan((Tree)tree.getExpression(), p);
        TypeMirror type = TreeUtils.typeOf((Tree)tree.getType());
        TypeCastNode node = new TypeCastNode(tree, operand, type, this.types);
        this.extendWithNodeWithException(node, this.classCastExceptionType);
        return node;
    }

    @Override
    public Node visitPrimitiveType(PrimitiveTypeTree tree, Void p) {
        PrimitiveTypeNode result = new PrimitiveTypeNode(tree, this.types);
        this.extendWithNode(result);
        return result;
    }

    @Override
    public Node visitTypeParameter(TypeParameterTree tree, Void p) {
        throw new BugInCF("TypeParameterTree is unexpected in AST to CFG translation");
    }

    @Override
    public Node visitInstanceOf(InstanceOfTree tree, Void p) {
        InstanceOfNode instanceOfNode;
        Node operand = this.scan((Tree)tree.getExpression(), p);
        Tree patternTree = TreeUtilsAfterJava11.InstanceOfUtils.getPattern((InstanceOfTree)tree);
        if (patternTree != null) {
            Node pattern = this.scan(patternTree, p);
            instanceOfNode = new InstanceOfNode(tree, operand, pattern, pattern.getType(), this.types);
        } else {
            TypeMirror refType = TreeUtils.typeOf((Tree)tree.getType());
            instanceOfNode = new InstanceOfNode(tree, operand, refType, this.types);
        }
        this.extendWithNode(instanceOfNode);
        return instanceOfNode;
    }

    @Override
    public Node visitUnary(UnaryTree tree, Void p) {
        Tree.Kind kind = tree.getKind();
        switch (kind) {
            case BITWISE_COMPLEMENT: 
            case UNARY_MINUS: 
            case UNARY_PLUS: {
                UnaryOperationNode result;
                Node expr = this.scan((Tree)tree.getExpression(), p);
                expr = this.unaryNumericPromotion(expr);
                switch (kind) {
                    case BITWISE_COMPLEMENT: {
                        result = new BitwiseComplementNode(tree, expr);
                        break;
                    }
                    case UNARY_MINUS: {
                        result = new NumericalMinusNode(tree, expr);
                        break;
                    }
                    case UNARY_PLUS: {
                        result = new NumericalPlusNode(tree, expr);
                        break;
                    }
                    default: {
                        throw new BugInCF("Unexpected unary tree kind: " + (Object)((Object)kind));
                    }
                }
                this.extendWithNode(result);
                return result;
            }
            case LOGICAL_COMPLEMENT: {
                Node expr = this.scan((Tree)tree.getExpression(), p);
                ConditionalNotNode result = new ConditionalNotNode(tree, this.unbox(expr));
                this.extendWithNode(result);
                return result;
            }
            case POSTFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case PREFIX_INCREMENT: {
                ExpressionTree exprTree = tree.getExpression();
                Node expr = this.scan((Tree)exprTree, p);
                boolean isIncrement = kind == Tree.Kind.POSTFIX_INCREMENT || kind == Tree.Kind.PREFIX_INCREMENT;
                boolean isPostfix = kind == Tree.Kind.POSTFIX_INCREMENT || kind == Tree.Kind.POSTFIX_DECREMENT;
                Node result = null;
                if (isPostfix) {
                    TypeMirror exprType = TreeUtils.typeOf((Tree)exprTree);
                    VariableTree tempVarDecl = this.treeBuilder.buildVariableDecl(exprType, this.uniqueName("tempPostfix"), TreePathUtil.findNearestEnclosingElement((TreePath)this.getCurrentPath()), tree.getExpression());
                    this.handleArtificialTree(tempVarDecl);
                    VariableDeclarationNode tempVarDeclNode = new VariableDeclarationNode(tempVarDecl);
                    tempVarDeclNode.setInSource(false);
                    this.extendWithNode(tempVarDeclNode);
                    IdentifierTree tempVar = this.treeBuilder.buildVariableUse(tempVarDecl);
                    this.handleArtificialTree(tempVar);
                    LocalVariableNode tempVarNode = new LocalVariableNode(tempVar);
                    tempVarNode.setInSource(false);
                    this.extendWithNode(tempVarNode);
                    AssignmentNode tempAssignNode = new AssignmentNode(tree, tempVarNode, expr);
                    tempAssignNode.setInSource(false);
                    this.extendWithNode(tempAssignNode);
                    IdentifierTree resultExpr = this.treeBuilder.buildVariableUse(tempVarDecl);
                    this.handleArtificialTree(resultExpr);
                    result = new LocalVariableNode(resultExpr);
                    result.setInSource(false);
                    this.extendWithNode(result);
                }
                AssignmentNode unaryAssign = this.createIncrementOrDecrementAssign(tree, expr, isIncrement, isPostfix);
                if (!isPostfix) {
                    result = unaryAssign;
                }
                return result;
            }
        }
        if (tree.toString().startsWith("<*nullchk*>")) {
            Node expr = this.scan((Tree)tree.getExpression(), p);
            NullChkNode result = new NullChkNode(tree, expr);
            this.extendWithNode(result);
            return result;
        }
        throw new BugInCF("Unknown kind (" + (Object)((Object)kind) + ") of unary expression: " + tree);
    }

    private AssignmentNode createIncrementOrDecrementAssign(UnaryTree unaryTree, Node expr, boolean isIncrement, boolean isPostfix) {
        ExpressionTree target;
        ExpressionTree exprTree = (ExpressionTree)expr.getTree();
        TypeMirror exprType = expr.getType();
        PrimitiveType oneType = this.types.getPrimitiveType(TypeKind.INT);
        TypeMirror promotedType = this.binaryPromotedType(exprType, oneType);
        LiteralTree oneTree = this.treeBuilder.buildLiteral((Object)1);
        this.handleArtificialTree(oneTree);
        Node exprRHS = this.binaryNumericPromotion(expr, promotedType);
        Node one = new IntegerLiteralNode(oneTree);
        one.setInSource(false);
        this.extendWithNode(one);
        one = this.binaryNumericPromotion(one, promotedType);
        BinaryTree operTree = this.treeBuilder.buildBinary(promotedType, isIncrement ? Tree.Kind.PLUS : Tree.Kind.MINUS, exprTree, (ExpressionTree)oneTree);
        if (isPostfix) {
            this.postfixTreeToCfgNodes.put(unaryTree, operTree);
        }
        this.handleArtificialTree(operTree);
        BinaryOperationNode operNode = isIncrement ? new NumericalAdditionNode(operTree, exprRHS, one) : new NumericalSubtractionNode(operTree, exprRHS, one);
        operNode.setInSource(false);
        this.extendWithNode(operNode);
        Node narrowed = this.narrowAndBox(operNode, exprType);
        if (isPostfix) {
            target = this.treeBuilder.buildAssignment(exprTree, (ExpressionTree)narrowed.getTree());
            this.handleArtificialTree(target);
        } else {
            target = unaryTree;
        }
        AssignmentNode assignNode = new AssignmentNode(target, expr, narrowed);
        assignNode.setInSource(false);
        this.extendWithNode(assignNode);
        return assignNode;
    }

    @Override
    public Node visitVariable(VariableTree tree, Void p) {
        Tree.Kind kind;
        boolean isField = false;
        if (this.getCurrentPath().getParentPath() != null && ((kind = TreeUtils.getKindRecordAsClass((Tree)this.getCurrentPath().getParentPath().getLeaf())) == Tree.Kind.CLASS || kind == Tree.Kind.INTERFACE || kind == Tree.Kind.ENUM)) {
            isField = true;
        }
        AssignmentNode node = null;
        ClassTree enclosingClass = TreePathUtil.enclosingClass((TreePath)this.getCurrentPath());
        TypeElement classElem = TreeUtils.elementFromDeclaration((ClassTree)enclosingClass);
        ImplicitThisNode receiver = new ImplicitThisNode(classElem.asType());
        if (isField) {
            ExpressionTree initializer = tree.getInitializer();
            assert (initializer != null);
            node = this.translateAssignment((Tree)tree, (Node)new FieldAccessNode(tree, TreeUtils.elementFromDeclaration((VariableTree)tree), receiver), initializer);
        } else {
            VariableDeclarationNode decl = new VariableDeclarationNode(tree);
            this.extendWithNode(decl);
            ExpressionTree initializer = tree.getInitializer();
            if (initializer != null) {
                node = this.translateAssignment((Tree)tree, (Node)new LocalVariableNode(tree, receiver), initializer);
            }
        }
        return node;
    }

    @Override
    public Node visitWhileLoop(WhileLoopTree tree, Void p) {
        Name parentLabel = this.getLabel(this.getCurrentPath());
        Label loopEntry = new Label();
        Label loopExit = new Label();
        Label conditionStart = parentLabel != null ? this.continueLabels.get(parentLabel) : new Label();
        LabelCell oldBreakTargetLC = this.breakTargetLC;
        this.breakTargetLC = new LabelCell(loopExit);
        LabelCell oldContinueTargetLC = this.continueTargetLC;
        this.continueTargetLC = new LabelCell(conditionStart);
        this.addLabelForNextNode(conditionStart);
        assert (tree.getCondition() != null);
        boolean isCondConstTrue = TreeUtils.isExprConstTrue((ExpressionTree)tree.getCondition());
        this.unbox(this.scan((Tree)tree.getCondition(), p));
        if (!isCondConstTrue) {
            ConditionalJump cjump = new ConditionalJump(loopEntry, loopExit);
            this.extendWithExtendedNode(cjump);
        }
        this.addLabelForNextNode(loopEntry);
        assert (tree.getStatement() != null);
        this.scan((Tree)tree.getStatement(), p);
        if (isCondConstTrue) {
            this.extendWithExtendedNode(new UnconditionalJump(loopEntry));
        } else {
            this.extendWithExtendedNode(new UnconditionalJump(conditionStart));
        }
        this.addLabelForNextNode(loopExit);
        this.breakTargetLC = oldBreakTargetLC;
        this.continueTargetLC = oldContinueTargetLC;
        return null;
    }

    @Override
    public Node visitLambdaExpression(LambdaExpressionTree tree, Void p) {
        this.declaredLambdas.add(tree);
        FunctionalInterfaceNode node = new FunctionalInterfaceNode(tree);
        this.extendWithNode(node);
        return node;
    }

    @Override
    public Node visitMemberReference(MemberReferenceTree tree, Void p) {
        ExpressionTree enclosingExpr = tree.getQualifierExpression();
        if (enclosingExpr != null) {
            this.scan((Tree)enclosingExpr, p);
        }
        FunctionalInterfaceNode node = new FunctionalInterfaceNode(tree);
        this.extendWithNode(node);
        return node;
    }

    @Override
    public Node visitWildcard(WildcardTree tree, Void p) {
        throw new BugInCF("WildcardTree is unexpected in AST to CFG translation");
    }

    @Override
    public Node visitOther(Tree tree, Void p) {
        throw new BugInCF("Unknown AST element encountered in AST to CFG translation.");
    }

    protected TypeMirror getTypeMirror(Class<?> clazz) {
        return TypesUtils.typeFromClass(clazz, (Types)this.types, (Elements)this.elements);
    }

    protected @Nullable TypeMirror maybeGetTypeMirror(Class<?> clazz) {
        String name = clazz.getCanonicalName();
        assert (name != null) : clazz + " does not have a canonical name";
        TypeElement element = this.elements.getTypeElement(name);
        if (element == null) {
            return null;
        }
        return element.asType();
    }

    private class SwitchBuilder {
        private final Tree switchTree;
        private final List<? extends CaseTree> caseTrees;
        private final ExpressionTree selectorExprTree;
        private final Label[] caseBodyLabels;
        private AssignmentNode selectorExprAssignment;
        private @Nullable VariableTree switchExprVarTree;

        private SwitchBuilder(Tree switchTree) {
            this.switchTree = switchTree;
            if (TreeUtils.isSwitchStatement((Tree)switchTree)) {
                SwitchTree switchStatementTree = (SwitchTree)switchTree;
                this.caseTrees = switchStatementTree.getCases();
                this.selectorExprTree = switchStatementTree.getExpression();
            } else {
                this.caseTrees = TreeUtilsAfterJava11.SwitchExpressionUtils.getCases((Tree)switchTree);
                this.selectorExprTree = TreeUtilsAfterJava11.SwitchExpressionUtils.getExpression((Tree)switchTree);
            }
            this.caseBodyLabels = new Label[this.caseTrees.size() + 1];
        }

        public @Nullable SwitchExpressionNode build() {
            LabelCell oldBreakTargetLC = CFGTranslationPhaseOne.this.breakTargetLC;
            CFGTranslationPhaseOne.this.breakTargetLC = new LabelCell(new Label());
            int numCases = this.caseTrees.size();
            for (int i = 0; i < numCases; ++i) {
                this.caseBodyLabels[i] = new Label();
            }
            this.caseBodyLabels[numCases] = CFGTranslationPhaseOne.this.breakTargetLC.peekLabel();
            this.buildSelector();
            this.buildSwitchExpressionVar();
            if (TreeUtils.isSwitchStatement((Tree)this.switchTree)) {
                CFGTranslationPhaseOne.this.extendWithNode(new MarkerNode(this.switchTree, "start of switch statement #" + TreeUtils.treeUids.get((Object)this.switchTree), CFGTranslationPhaseOne.this.env.getTypeUtils()));
            }
            boolean switchExprOrEnhanced = !TreeUtils.isSwitchStatement((Tree)this.switchTree) || TreeUtils.isEnhancedSwitchStatement((SwitchTree)((SwitchTree)this.switchTree));
            int defaultIndex = -1;
            for (int i = 0; i < numCases; ++i) {
                CaseTree caseTree = this.caseTrees.get(i);
                if (TreeUtilsAfterJava11.CaseUtils.isDefaultCaseTree((CaseTree)caseTree)) {
                    defaultIndex = i;
                    continue;
                }
                if (i == numCases - 1 && defaultIndex == -1) {
                    this.buildCase(caseTree, i, switchExprOrEnhanced);
                    continue;
                }
                this.buildCase(caseTree, i, false);
            }
            if (defaultIndex != -1) {
                this.buildCase(this.caseTrees.get(defaultIndex), defaultIndex, false);
            }
            CFGTranslationPhaseOne.this.addLabelForNextNode(CFGTranslationPhaseOne.this.breakTargetLC.peekLabel());
            CFGTranslationPhaseOne.this.breakTargetLC = oldBreakTargetLC;
            if (TreeUtils.isSwitchStatement((Tree)this.switchTree)) {
                CFGTranslationPhaseOne.this.extendWithNode(new MarkerNode(this.switchTree, "end of switch statement #" + TreeUtils.treeUids.get((Object)this.switchTree), CFGTranslationPhaseOne.this.env.getTypeUtils()));
            }
            if (!TreeUtils.isSwitchStatement((Tree)this.switchTree)) {
                IdentifierTree switchExprVarUseTree = CFGTranslationPhaseOne.this.treeBuilder.buildVariableUse(this.switchExprVarTree);
                CFGTranslationPhaseOne.this.handleArtificialTree(switchExprVarUseTree);
                LocalVariableNode switchExprVarUseNode = new LocalVariableNode(switchExprVarUseTree);
                switchExprVarUseNode.setInSource(false);
                CFGTranslationPhaseOne.this.extendWithNode(switchExprVarUseNode);
                SwitchExpressionNode switchExpressionNode = new SwitchExpressionNode(TreeUtils.typeOf((Tree)this.switchTree), this.switchTree, switchExprVarUseNode);
                CFGTranslationPhaseOne.this.extendWithNode(switchExpressionNode);
                return switchExpressionNode;
            }
            return null;
        }

        private void buildSelector() {
            TypeMirror selectorExprType = TreeUtils.typeOf((Tree)this.selectorExprTree);
            VariableTree selectorVarTree = CFGTranslationPhaseOne.this.treeBuilder.buildVariableDecl(selectorExprType, CFGTranslationPhaseOne.this.uniqueName("switch"), TreePathUtil.findNearestEnclosingElement((TreePath)CFGTranslationPhaseOne.this.getCurrentPath()), null);
            CFGTranslationPhaseOne.this.handleArtificialTree(selectorVarTree);
            VariableDeclarationNode selectorVarNode = new VariableDeclarationNode(selectorVarTree);
            selectorVarNode.setInSource(false);
            CFGTranslationPhaseOne.this.extendWithNode(selectorVarNode);
            IdentifierTree selectorVarUseTree = CFGTranslationPhaseOne.this.treeBuilder.buildVariableUse(selectorVarTree);
            CFGTranslationPhaseOne.this.handleArtificialTree(selectorVarUseTree);
            LocalVariableNode selectorVarUseNode = new LocalVariableNode(selectorVarUseTree);
            selectorVarUseNode.setInSource(false);
            CFGTranslationPhaseOne.this.extendWithNode(selectorVarUseNode);
            Node selectorExprNode = CFGTranslationPhaseOne.this.unbox(CFGTranslationPhaseOne.this.scan((Tree)this.selectorExprTree, null));
            AssignmentTree assign = CFGTranslationPhaseOne.this.treeBuilder.buildAssignment((ExpressionTree)selectorVarUseTree, this.selectorExprTree);
            CFGTranslationPhaseOne.this.handleArtificialTree(assign);
            this.selectorExprAssignment = new AssignmentNode(assign, selectorVarUseNode, selectorExprNode);
            this.selectorExprAssignment.setInSource(false);
            CFGTranslationPhaseOne.this.extendWithNode(this.selectorExprAssignment);
        }

        private void buildSwitchExpressionVar() {
            if (TreeUtils.isSwitchStatement((Tree)this.switchTree)) {
                return;
            }
            TypeMirror switchExprType = TreeUtils.typeOf((Tree)this.switchTree);
            this.switchExprVarTree = CFGTranslationPhaseOne.this.treeBuilder.buildVariableDecl(switchExprType, CFGTranslationPhaseOne.this.uniqueName("switchExpr"), TreePathUtil.findNearestEnclosingElement((TreePath)CFGTranslationPhaseOne.this.getCurrentPath()), null);
            CFGTranslationPhaseOne.this.handleArtificialTree(this.switchExprVarTree);
            VariableDeclarationNode switchExprVarNode = new VariableDeclarationNode(this.switchExprVarTree);
            switchExprVarNode.setInSource(false);
            CFGTranslationPhaseOne.this.extendWithNode(switchExprVarNode);
        }

        private void buildCase(CaseTree caseTree, int index, boolean isLastCaseOfExhaustive) {
            boolean isDefaultCase = TreeUtilsAfterJava11.CaseUtils.isDefaultCaseTree((CaseTree)caseTree);
            boolean isTerminalCase = isDefaultCase || isLastCaseOfExhaustive;
            Label thisBodyLabel = this.caseBodyLabels[index];
            Label nextBodyLabel = this.caseBodyLabels[index + 1];
            Label nextCaseLabel = new Label();
            if (!isTerminalCase) {
                ArrayList exprs = new ArrayList();
                for (Tree exprTree : TreeUtilsAfterJava11.CaseUtils.getLabels((CaseTree)caseTree)) {
                    exprs.add(CFGTranslationPhaseOne.this.scan(exprTree, null));
                }
                ExpressionTree expressionTree = TreeUtilsAfterJava11.CaseUtils.getGuard((CaseTree)caseTree);
                Node guard = expressionTree == null ? null : CFGTranslationPhaseOne.this.scan((Tree)expressionTree, null);
                CaseNode test = new CaseNode(caseTree, this.selectorExprAssignment, exprs, guard, CFGTranslationPhaseOne.this.env.getTypeUtils());
                CFGTranslationPhaseOne.this.extendWithNode(test);
                CFGTranslationPhaseOne.this.extendWithExtendedNode(new ConditionalJump(thisBodyLabel, nextCaseLabel));
            }
            CFGTranslationPhaseOne.this.addLabelForNextNode(thisBodyLabel);
            if (caseTree.getStatements() != null) {
                for (StatementTree statementTree : caseTree.getStatements()) {
                    CFGTranslationPhaseOne.this.scan((Tree)statementTree, null);
                }
                if (!isTerminalCase) {
                    CFGTranslationPhaseOne.this.extendWithExtendedNode(new UnconditionalJump(nextBodyLabel));
                }
            } else {
                Tree bodyTree = TreeUtilsAfterJava11.CaseUtils.getBody((CaseTree)caseTree);
                if (!TreeUtils.isSwitchStatement((Tree)this.switchTree) && bodyTree instanceof ExpressionTree) {
                    this.buildSwitchExpressionResult((ExpressionTree)bodyTree);
                } else {
                    CFGTranslationPhaseOne.this.scan(bodyTree, null);
                    assert (CFGTranslationPhaseOne.this.breakTargetLC != null) : "no target for case statement";
                    CFGTranslationPhaseOne.this.extendWithExtendedNode(new UnconditionalJump(CFGTranslationPhaseOne.this.breakTargetLC.accessLabel()));
                }
            }
            if (!isTerminalCase) {
                CFGTranslationPhaseOne.this.addLabelForNextNode(nextCaseLabel);
            }
        }

        void buildSwitchExpressionResult(ExpressionTree resultExpression) {
            IdentifierTree switchExprVarUseTree = CFGTranslationPhaseOne.this.treeBuilder.buildVariableUse(this.switchExprVarTree);
            CFGTranslationPhaseOne.this.handleArtificialTree(switchExprVarUseTree);
            LocalVariableNode switchExprVarUseNode = new LocalVariableNode(switchExprVarUseTree);
            switchExprVarUseNode.setInSource(false);
            CFGTranslationPhaseOne.this.extendWithNode(switchExprVarUseNode);
            Node resultExprNode = CFGTranslationPhaseOne.this.scan((Tree)resultExpression, null);
            AssignmentTree assign = CFGTranslationPhaseOne.this.treeBuilder.buildAssignment((ExpressionTree)switchExprVarUseTree, resultExpression);
            CFGTranslationPhaseOne.this.handleArtificialTree(assign);
            AssignmentNode assignmentNode = new AssignmentNode(assign, switchExprVarUseNode, resultExprNode);
            assignmentNode.setInSource(false);
            CFGTranslationPhaseOne.this.extendWithNode(assignmentNode);
            assert (CFGTranslationPhaseOne.this.breakTargetLC != null) : "no target for case statement";
            CFGTranslationPhaseOne.this.extendWithExtendedNode(new UnconditionalJump(CFGTranslationPhaseOne.this.breakTargetLC.accessLabel()));
        }
    }

    protected static class AssertMethodTuple {
        protected static final AssertMethodTuple NONE = new AssertMethodTuple(-1, null, false);
        public final int booleanParam;
        public final TypeMirror exceptionType;
        public final boolean isAssertFalse;

        public AssertMethodTuple(int booleanParam, TypeMirror exceptionType, boolean isAssertFalse) {
            this.booleanParam = booleanParam;
            this.exceptionType = exceptionType;
            this.isAssertFalse = isAssertFalse;
        }
    }
}

