/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.expression;

import com.sun.source.tree.Tree;
import java.util.Objects;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.cfg.node.UnaryOperationNode;
import org.checkerframework.dataflow.expression.JavaExpression;
import org.checkerframework.dataflow.expression.JavaExpressionVisitor;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.BugInCF;

public class UnaryOperation
extends JavaExpression {
    protected final Tree.Kind operationKind;
    protected final JavaExpression operand;

    public UnaryOperation(TypeMirror type, Tree.Kind operationKind, JavaExpression operand) {
        super(operand.type);
        this.operationKind = operationKind;
        this.operand = operand;
    }

    public UnaryOperation(UnaryOperationNode node, JavaExpression operand) {
        this(node.getType(), node.getTree().getKind(), operand);
    }

    public Tree.Kind getOperationKind() {
        return this.operationKind;
    }

    public JavaExpression getOperand() {
        return this.operand;
    }

    @Override
    public <T extends JavaExpression> @Nullable T containedOfClass(Class<T> clazz) {
        if (this.getClass() == clazz) {
            return (T)this;
        }
        return this.operand.containedOfClass(clazz);
    }

    @Override
    public boolean isDeterministic(AnnotationProvider provider) {
        return this.operand.isDeterministic(provider);
    }

    @Override
    public boolean isAssignableByOtherCode() {
        return this.operand.isAssignableByOtherCode();
    }

    @Override
    public boolean isModifiableByOtherCode() {
        return this.operand.isModifiableByOtherCode();
    }

    @Override
    public boolean syntacticEquals(JavaExpression je) {
        if (!(je instanceof UnaryOperation)) {
            return false;
        }
        UnaryOperation other = (UnaryOperation)je;
        return this.operationKind == other.getOperationKind() && this.operand.syntacticEquals(other.operand);
    }

    @Override
    public boolean containsSyntacticEqualJavaExpression(JavaExpression other) {
        return this.syntacticEquals(other) || this.operand.containsSyntacticEqualJavaExpression(other);
    }

    @Override
    public boolean containsModifiableAliasOf(Store<?> store, JavaExpression other) {
        return this.operand.containsModifiableAliasOf(store, other);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operationKind, this.operand});
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof UnaryOperation)) {
            return false;
        }
        UnaryOperation unOp = (UnaryOperation)other;
        return this.operationKind == unOp.getOperationKind() && this.operand.equals(unOp.operand);
    }

    public String toString() {
        String operandString = this.operand.toString();
        switch (this.operationKind) {
            case BITWISE_COMPLEMENT: {
                return "~" + operandString;
            }
            case LOGICAL_COMPLEMENT: {
                return "!" + operandString;
            }
            case POSTFIX_DECREMENT: {
                return operandString + "--";
            }
            case POSTFIX_INCREMENT: {
                return operandString + "++";
            }
            case PREFIX_DECREMENT: {
                return "--" + operandString;
            }
            case PREFIX_INCREMENT: {
                return "++" + operandString;
            }
            case UNARY_MINUS: {
                return "-" + operandString;
            }
            case UNARY_PLUS: {
                return "+" + operandString;
            }
        }
        throw new BugInCF("Unrecognized unary operation kind " + (Object)((Object)this.operationKind));
    }

    @Override
    public <R, P> R accept(JavaExpressionVisitor<R, P> visitor, P p) {
        return visitor.visitUnaryOperation(this, p);
    }
}

