/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.util;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.util.PurityUtils;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TreePathUtil;
import org.checkerframework.javacutil.TreeUtils;
import org.plumelib.util.IPair;

public class PurityChecker {
    public static PurityResult checkPurity(TreePath statement, AnnotationProvider annoProvider, boolean assumeSideEffectFree, boolean assumeDeterministic, boolean assumePureGetters) {
        PurityCheckerHelper helper = new PurityCheckerHelper(annoProvider, assumeSideEffectFree, assumeDeterministic, assumePureGetters);
        helper.scan(statement, null);
        return helper.purityResult;
    }

    protected static class PurityCheckerHelper
    extends TreePathScanner<Void, Void> {
        PurityResult purityResult = new PurityResult();
        protected final AnnotationProvider annoProvider;
        private final boolean assumeSideEffectFree;
        private final boolean assumeDeterministic;
        private final boolean assumePureGetters;
        private static final EnumSet<Pure.Kind> detAndSeFree = EnumSet.of(Pure.Kind.DETERMINISTIC, Pure.Kind.SIDE_EFFECT_FREE);

        public PurityCheckerHelper(AnnotationProvider annoProvider, boolean assumeSideEffectFree, boolean assumeDeterministic, boolean assumePureGetters) {
            this.annoProvider = annoProvider;
            this.assumeSideEffectFree = assumeSideEffectFree;
            this.assumeDeterministic = assumeDeterministic;
            this.assumePureGetters = assumePureGetters;
        }

        @Override
        public Void visitCatch(CatchTree tree, Void ignore) {
            this.purityResult.addNotDetReason(tree, "catch");
            return (Void)super.visitCatch(tree, ignore);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, Void ignore) {
            ExecutableElement elt = TreeUtils.elementFromUse((MethodInvocationTree)tree);
            if (!PurityUtils.hasPurityAnnotation(this.annoProvider, elt)) {
                this.purityResult.addNotBothReason(tree, "call");
            } else {
                boolean seFree;
                EnumSet<Pure.Kind> purityKinds = this.assumeDeterministic && this.assumeSideEffectFree || this.assumePureGetters && ElementUtils.isGetter((ExecutableElement)elt) ? detAndSeFree : PurityUtils.getPurityKinds(this.annoProvider, elt);
                boolean det = this.assumeDeterministic || purityKinds.contains(Pure.Kind.DETERMINISTIC);
                boolean bl = seFree = this.assumeSideEffectFree || purityKinds.contains(Pure.Kind.SIDE_EFFECT_FREE);
                if (!det && !seFree) {
                    this.purityResult.addNotBothReason(tree, "call");
                } else if (!det) {
                    this.purityResult.addNotDetReason(tree, "call");
                } else if (!seFree) {
                    this.purityResult.addNotSEFreeReason(tree, "call");
                }
            }
            return (Void)super.visitMethodInvocation(tree, ignore);
        }

        @Override
        public Void visitNewClass(NewClassTree tree, Void ignore) {
            boolean sideEffectFree;
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            boolean okThrowDeterministic = parent.getKind() == Tree.Kind.THROW;
            ExecutableElement ctorElement = TreeUtils.elementFromUse((NewClassTree)tree);
            boolean deterministic = this.assumeDeterministic || okThrowDeterministic || PurityUtils.isDeterministic(this.annoProvider, ctorElement);
            boolean bl = sideEffectFree = this.assumeSideEffectFree || PurityUtils.isSideEffectFree(this.annoProvider, ctorElement);
            if (!deterministic) {
                this.purityResult.addNotDetReason(tree, "object.creation");
            }
            if (!sideEffectFree) {
                this.purityResult.addNotSEFreeReason(tree, "call");
            }
            return (Void)super.visitNewClass(tree, ignore);
        }

        @Override
        public Void visitAssignment(AssignmentTree tree, Void ignore) {
            ExpressionTree variable = tree.getVariable();
            this.assignmentCheck(variable);
            return (Void)super.visitAssignment(tree, ignore);
        }

        @Override
        public Void visitUnary(UnaryTree tree, Void ignore) {
            switch (tree.getKind()) {
                case POSTFIX_DECREMENT: 
                case POSTFIX_INCREMENT: 
                case PREFIX_DECREMENT: 
                case PREFIX_INCREMENT: {
                    ExpressionTree expression = tree.getExpression();
                    this.assignmentCheck(expression);
                    break;
                }
            }
            return (Void)super.visitUnary(tree, ignore);
        }

        protected void assignmentCheck(ExpressionTree variable) {
            VariableElement fieldElt = TreeUtils.asFieldAccess((Tree)(variable = TreeUtils.withoutParens((ExpressionTree)variable)));
            if (fieldElt != null && this.isFieldInCurrentClass(fieldElt) && TreePathUtil.inConstructor((TreePath)this.getCurrentPath())) {
                return;
            }
            if (TreeUtils.isFieldAccess((Tree)variable)) {
                this.purityResult.addNotBothReason(variable, "assign.field");
            } else if (variable instanceof ArrayAccessTree) {
                this.purityResult.addNotBothReason(variable, "assign.array");
            } else assert (this.isLocalVariable(variable));
        }

        private boolean isFieldInCurrentClass(VariableElement fieldElt) {
            ClassTree currentTypeTree = TreePathUtil.enclosingClass((TreePath)this.getCurrentPath());
            assert (currentTypeTree != null) : "@AssumeAssertion(nullness)";
            TypeElement currentType = TreeUtils.elementFromDeclaration((ClassTree)currentTypeTree);
            assert (currentType != null) : "@AssumeAssertion(nullness)";
            TypeElement definesField = ElementUtils.enclosingTypeElement((Element)fieldElt);
            assert (definesField != null) : "@AssumeAssertion(nullness)";
            return currentType.equals(definesField);
        }

        protected boolean isLocalVariable(ExpressionTree variable) {
            return variable instanceof IdentifierTree && !TreeUtils.isFieldAccess((Tree)variable);
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree tree, Void ignore) {
            ExpressionTree variable = tree.getVariable();
            this.assignmentCheck(variable);
            return (Void)super.visitCompoundAssignment(tree, ignore);
        }
    }

    public static class PurityResult {
        protected final List<IPair<Tree, String>> notSEFreeReasons = new ArrayList<IPair<Tree, String>>(1);
        protected final List<IPair<Tree, String>> notDetReasons = new ArrayList<IPair<Tree, String>>(1);
        protected final List<IPair<Tree, String>> notBothReasons = new ArrayList<IPair<Tree, String>>(1);
        protected EnumSet<Pure.Kind> kinds = EnumSet.allOf(Pure.Kind.class);

        public EnumSet<Pure.Kind> getKinds() {
            return this.kinds;
        }

        public boolean isPure(EnumSet<Pure.Kind> otherKinds) {
            return this.kinds.containsAll(otherKinds);
        }

        public List<IPair<Tree, String>> getNotSEFreeReasons() {
            return this.notSEFreeReasons;
        }

        public void addNotSEFreeReason(Tree t, String msgId) {
            this.notSEFreeReasons.add((IPair<Tree, String>)IPair.of((Object)t, (Object)msgId));
            this.kinds.remove(Pure.Kind.SIDE_EFFECT_FREE);
        }

        public List<IPair<Tree, String>> getNotDetReasons() {
            return this.notDetReasons;
        }

        public void addNotDetReason(Tree t, String msgId) {
            this.notDetReasons.add((IPair<Tree, String>)IPair.of((Object)t, (Object)msgId));
            this.kinds.remove(Pure.Kind.DETERMINISTIC);
        }

        public List<IPair<Tree, String>> getNotBothReasons() {
            return this.notBothReasons;
        }

        public void addNotBothReason(Tree t, String msgId) {
            this.notBothReasons.add((IPair<Tree, String>)IPair.of((Object)t, (Object)msgId));
            this.kinds.remove(Pure.Kind.DETERMINISTIC);
            this.kinds.remove(Pure.Kind.SIDE_EFFECT_FREE);
        }

        public String toString() {
            return String.join((CharSequence)System.lineSeparator(), "PurityResult{", "  notSEF: " + this.notSEFreeReasons, "  notDet: " + this.notDetReasons, "  notBoth: " + this.notBothReasons, "}");
        }
    }
}

