/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.analysis;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.Node;
import org.plumelib.util.StringsPlume;
import org.plumelib.util.UniqueId;

public class TransferInput<V extends AbstractValue<V>, S extends Store<S>>
implements UniqueId {
    protected @Nullable Node node;
    protected final @Nullable S store;
    protected final @Nullable S thenStore;
    protected final @Nullable S elseStore;
    protected final Analysis<V, S, ?> analysis;
    static final AtomicLong nextUid = new AtomicLong(0L);
    final transient long uid = nextUid.getAndIncrement();

    public long getUid(@UnknownInitialization TransferInput<V, S> this) {
        return this.uid;
    }

    private TransferInput(@Nullable Node node, @Nullable S store, @Nullable S thenStore, @Nullable S elseStore, Analysis<V, S, ?> analysis) {
        if (store == null ? !$assertionsDisabled && (thenStore == null || elseStore == null) : !$assertionsDisabled && (thenStore != null || elseStore != null)) {
            throw new AssertionError();
        }
        this.node = node;
        this.store = store;
        this.thenStore = thenStore;
        this.elseStore = elseStore;
        this.analysis = analysis;
    }

    public TransferInput(Node n, Analysis<V, S, ?> analysis, TransferResult<V, S> to) {
        this(n, (to.containsTwoStores() ? null : (S)to.getRegularStore()), (to.containsTwoStores() ? (S)to.getThenStore() : null), (to.containsTwoStores() ? (S)to.getElseStore() : null), (Analysis<V, Object, ?>)analysis);
    }

    public TransferInput(@Nullable Node n, Analysis<V, S, ?> analysis, S s) {
        this(n, s, null, null, (Analysis<V, Object, ?>)analysis);
    }

    public TransferInput(@Nullable Node n, Analysis<V, S, ?> analysis, S s1, S s2) {
        this(n, null, s1, s2, (Analysis<V, Object, ?>)analysis);
    }

    protected TransferInput(TransferInput<V, S> from) {
        this(from.node, (from.store == null ? null : (S)from.store.copy()), (from.store == null ? (S)from.thenStore.copy() : null), (from.store == null ? (S)from.elseStore.copy() : null), (Analysis<V, Object, ?>)from.analysis);
    }

    public @Nullable Node getNode() {
        return this.node;
    }

    public @Nullable V getValueOfSubNode(Node n) {
        return this.analysis.getValue(n);
    }

    public S getRegularStore() {
        if (this.store == null) {
            assert (this.thenStore != null && this.elseStore != null) : "@AssumeAssertion(nullness): invariant";
            return this.thenStore.leastUpperBound(this.elseStore);
        }
        return this.store;
    }

    public S getThenStore() {
        if (this.store == null) {
            assert (this.thenStore != null) : "@AssumeAssertion(nullness): invariant";
            return this.thenStore;
        }
        return this.store;
    }

    public S getElseStore() {
        if (this.store == null) {
            assert (this.elseStore != null) : "@AssumeAssertion(nullness): invariant";
            return this.elseStore;
        }
        return this.store.copy();
    }

    public boolean containsTwoStores() {
        return this.store == null;
    }

    public TransferInput<V, S> copy() {
        return new TransferInput<V, S>(this);
    }

    public TransferInput<V, S> leastUpperBound(TransferInput<V, S> other) {
        if (this.store == null) {
            S newThenStore = this.getThenStore().leastUpperBound(other.getThenStore());
            S newElseStore = this.getElseStore().leastUpperBound(other.getElseStore());
            return new TransferInput<V, S>(this.node, this.analysis, newThenStore, newElseStore);
        }
        if (other.store == null) {
            return other.leastUpperBound(this);
        }
        return new TransferInput<V, S>(this.node, this.analysis, this.store.leastUpperBound(other.getRegularStore()));
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof TransferInput) {
            TransferInput other = (TransferInput)o;
            if (this.containsTwoStores()) {
                if (other.containsTwoStores()) {
                    return this.getThenStore().equals(other.getThenStore()) && this.getElseStore().equals(other.getElseStore());
                }
            } else if (!other.containsTwoStores()) {
                return this.getRegularStore().equals(other.getRegularStore());
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.analysis, this.node, this.store, this.thenStore, this.elseStore);
    }

    public String toString() {
        if (this.store == null) {
            return "[then=" + StringsPlume.indentLinesExceptFirst((int)2, this.thenStore) + "," + System.lineSeparator() + "  else=" + StringsPlume.indentLinesExceptFirst((int)2, this.elseStore) + "]";
        }
        return "[" + this.store + "]";
    }
}

