/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.com.google.common.base;

import javax.annotation.CheckForNull;
import org.checkerframework.shaded.checker.index.qual.LessThanUnknown;
import org.checkerframework.shaded.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.shaded.checker.index.qual.SameLenUnknown;
import org.checkerframework.shaded.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.shaded.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.shaded.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.shaded.checker.initialization.qual.Initialized;
import org.checkerframework.shaded.checker.nullness.qual.NonNull;
import org.checkerframework.shaded.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.shaded.checker.signedness.qual.Signed;
import org.checkerframework.shaded.com.google.common.annotations.GwtIncompatible;
import org.checkerframework.shaded.com.google.common.annotations.J2ktIncompatible;
import org.checkerframework.shaded.com.google.common.base.ElementTypesAreNonnullByDefault;
import org.checkerframework.shaded.com.google.common.base.Preconditions;
import org.checkerframework.shaded.common.value.qual.UnknownVal;

@ElementTypesAreNonnullByDefault
@J2ktIncompatible
@GwtIncompatible
public final class Defaults {
    private static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Double DOUBLE_DEFAULT = 0.0;
    private static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Float FLOAT_DEFAULT = Float.valueOf(0.0f);

    private Defaults() {
    }

    @CheckForNull
    public static <T> @Nullable T defaultValue(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Class<T> type) {
        Preconditions.checkNotNull(type);
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return (T)Boolean.FALSE;
            }
            if (type == Character.TYPE) {
                return (T)Character.valueOf('\u0000');
            }
            if (type == Byte.TYPE) {
                return (T)Byte.valueOf((byte)0);
            }
            if (type == Short.TYPE) {
                return (T)Short.valueOf((short)0);
            }
            if (type == Integer.TYPE) {
                return (T)Integer.valueOf(0);
            }
            if (type == Long.TYPE) {
                return (T)Long.valueOf(0L);
            }
            if (type == Float.TYPE) {
                return (T)FLOAT_DEFAULT;
            }
            if (type == Double.TYPE) {
                return (T)DOUBLE_DEFAULT;
            }
        }
        return null;
    }
}

