/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.com.google.common.graph;

import org.checkerframework.shaded.checker.index.qual.LessThanUnknown;
import org.checkerframework.shaded.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.shaded.checker.index.qual.SameLenUnknown;
import org.checkerframework.shaded.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.shaded.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.shaded.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.shaded.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.shaded.checker.initialization.qual.Initialized;
import org.checkerframework.shaded.checker.nullness.qual.NonNull;
import org.checkerframework.shaded.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.shaded.checker.signedness.qual.Signed;
import org.checkerframework.shaded.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.shaded.com.google.common.annotations.Beta;
import org.checkerframework.shaded.com.google.common.base.Optional;
import org.checkerframework.shaded.com.google.common.base.Preconditions;
import org.checkerframework.shaded.com.google.common.graph.AbstractGraphBuilder;
import org.checkerframework.shaded.com.google.common.graph.ElementOrder;
import org.checkerframework.shaded.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.checkerframework.shaded.com.google.common.graph.Graphs;
import org.checkerframework.shaded.com.google.common.graph.ImmutableNetwork;
import org.checkerframework.shaded.com.google.common.graph.MutableNetwork;
import org.checkerframework.shaded.com.google.common.graph.Network;
import org.checkerframework.shaded.com.google.common.graph.StandardMutableNetwork;
import org.checkerframework.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.checkerframework.shaded.common.value.qual.UnknownVal;

@ElementTypesAreNonnullByDefault
@Beta
public final class NetworkBuilder<@SubstringIndexBottom N, @SubstringIndexBottom E>
extends AbstractGraphBuilder<N> {
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean allowsParallelEdges = false;
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ElementOrder<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @UnknownSignedness ? super E> edgeOrder = ElementOrder.insertion();
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Optional<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Integer> expectedEdgeCount = Optional.absent();

    private NetworkBuilder(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean directed) {
        super(directed);
    }

    public static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed NetworkBuilder<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Object, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Object> directed() {
        return new NetworkBuilder<Object, Object>(true);
    }

    public static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed NetworkBuilder<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Object, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Object> undirected() {
        return new NetworkBuilder<Object, Object>(false);
    }

    public static <N, E> @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed NetworkBuilder<N, E> from(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Network<N, E> network) {
        return new NetworkBuilder<N, E>(network.isDirected()).allowsParallelEdges(network.allowsParallelEdges()).allowsSelfLoops(network.allowsSelfLoops()).nodeOrder(network.nodeOrder()).edgeOrder(network.edgeOrder());
    }

    public <N1 extends N, E1 extends E> @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ImmutableNetwork.Builder<N1, E1> immutable() {
        NetworkBuilder<N1, E1> castBuilder = this.cast();
        return new ImmutableNetwork.Builder<N1, E1>(castBuilder);
    }

    @CanIgnoreReturnValue
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed NetworkBuilder<N, E> allowsParallelEdges(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean allowsParallelEdges) {
        this.allowsParallelEdges = allowsParallelEdges;
        return this;
    }

    @CanIgnoreReturnValue
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed NetworkBuilder<N, E> allowsSelfLoops(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean allowsSelfLoops) {
        this.allowsSelfLoops = allowsSelfLoops;
        return this;
    }

    @CanIgnoreReturnValue
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed NetworkBuilder<N, E> expectedNodeCount(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int expectedNodeCount) {
        this.expectedNodeCount = Optional.of(Graphs.checkNonNegative(expectedNodeCount));
        return this;
    }

    @CanIgnoreReturnValue
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed NetworkBuilder<N, E> expectedEdgeCount(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int expectedEdgeCount) {
        this.expectedEdgeCount = Optional.of(Graphs.checkNonNegative(expectedEdgeCount));
        return this;
    }

    public <N1 extends N> @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed NetworkBuilder<N1, E> nodeOrder(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ElementOrder<N1> nodeOrder) {
        NetworkBuilder newBuilder = this.cast();
        newBuilder.nodeOrder = Preconditions.checkNotNull(nodeOrder);
        return newBuilder;
    }

    public <E1 extends E> @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed NetworkBuilder<N, E1> edgeOrder(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ElementOrder<E1> edgeOrder) {
        NetworkBuilder newBuilder = this.cast();
        newBuilder.edgeOrder = Preconditions.checkNotNull(edgeOrder);
        return newBuilder;
    }

    public <N1 extends N, E1 extends E> @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed MutableNetwork<N1, E1> build() {
        return new StandardMutableNetwork(this);
    }

    private <N1 extends N, E1 extends E> @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed NetworkBuilder<N1, E1> cast() {
        return this;
    }
}

