/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.javacutil;

import com.sun.source.tree.Tree;
import org.checkerframework.shaded.checker.formatter.qual.FormatMethod;
import org.checkerframework.shaded.checker.nullness.qual.Nullable;

public class BugInCF
extends RuntimeException {
    private @Nullable Tree location;

    public BugInCF(String message) {
        this(message, new Throwable());
    }

    @FormatMethod
    public BugInCF(String fmt, Object ... args) {
        this(String.format(fmt, args), new Throwable());
    }

    public BugInCF(Throwable cause) {
        this((Tree)null, cause);
    }

    public BugInCF(@Nullable Tree location, Throwable cause) {
        this(location, cause.getMessage() != null ? cause.getMessage() : cause.getClass().getSimpleName(), cause);
    }

    @FormatMethod
    public BugInCF(Throwable cause, String fmt, Object ... args) {
        this(String.format(fmt, args), cause);
    }

    public BugInCF(String message, Throwable cause) {
        this(null, message, cause);
    }

    public BugInCF(@Nullable Tree location, String message, Throwable cause) {
        super(message, cause);
        this.location = cause instanceof BugInCF && ((BugInCF)cause).getLocation() != null ? ((BugInCF)cause).getLocation() : location;
        if (message == null) {
            throw new BugInCF("Must have a detail message.");
        }
        if (cause == null) {
            throw new BugInCF("Must have a cause throwable.");
        }
    }

    public @Nullable Tree getLocation() {
        return this.location;
    }

    public static BugInCF addLocation(Tree location, Throwable throwable) {
        if (throwable instanceof BugInCF) {
            BugInCF bugInCF = (BugInCF)throwable;
            if (bugInCF.location == null) {
                bugInCF.location = location;
            }
            return bugInCF;
        }
        return new BugInCF(location, throwable);
    }
}

