/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.org.plumelib.util;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.checkerframework.shaded.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.shaded.checker.formatter.qual.UnknownFormat;
import org.checkerframework.shaded.checker.index.qual.LessThanUnknown;
import org.checkerframework.shaded.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.shaded.checker.index.qual.SameLenUnknown;
import org.checkerframework.shaded.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.shaded.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.shaded.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.shaded.checker.initialization.qual.Initialized;
import org.checkerframework.shaded.checker.interning.qual.Interned;
import org.checkerframework.shaded.checker.interning.qual.UnknownInterned;
import org.checkerframework.shaded.checker.lock.qual.GuardedBy;
import org.checkerframework.shaded.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.shaded.checker.mustcall.qual.MustCall;
import org.checkerframework.shaded.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.shaded.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.shaded.checker.nullness.qual.NonNull;
import org.checkerframework.shaded.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.shaded.checker.regex.qual.UnknownRegex;
import org.checkerframework.shaded.checker.signature.qual.SignatureUnknown;
import org.checkerframework.shaded.checker.signedness.qual.Signed;
import org.checkerframework.shaded.common.initializedfields.qual.InitializedFields;
import org.checkerframework.shaded.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.shaded.common.value.qual.UnknownVal;

public class DumpHeap {
    private static volatile @MonotonicNonNull @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) Object hotspotMBean;
    private static @MonotonicNonNull @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) Method dumpHeapMethod;

    private DumpHeap() {
        throw new Error("Do not instantiate");
    }

    @EnsuresNonNull(value={"hotspotMBean", "dumpHeapMethod"})
    private static synchronized void initializeFields() {
        try {
            Class<?> mxbeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            hotspotMBean = ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), "com.sun.management:type=HotSpotDiagnostic", mxbeanClass);
            dumpHeapMethod = mxbeanClass.getMethod("dumpHeap", String.class, Boolean.TYPE);
        }
        catch (IOException | ClassNotFoundException | NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    public static void dumpHeap(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) String fileName) {
        DumpHeap.dumpHeap(fileName, true);
    }

    public static void dumpHeap(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) String fileName, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @UnknownThis @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @InitializedFields(value={}) boolean live) {
        DumpHeap.initializeFields();
        File heapFile = new File(fileName);
        if (heapFile.exists()) {
            heapFile.delete();
        }
        try {
            dumpHeapMethod.invoke(hotspotMBean, fileName, live);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Error(e);
        }
    }
}

