/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.expression;

import java.util.List;
import java.util.Objects;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.dataflow.expression.JavaExpression;
import org.checkerframework.nullaway.dataflow.expression.JavaExpressionVisitor;
import org.checkerframework.nullaway.javacutil.AnnotationProvider;
import org.checkerframework.nullaway.javacutil.TypesUtils;
import org.checkerframework.nullaway.org.plumelib.util.StringsPlume;

public class ArrayCreation
extends JavaExpression {
    protected final List<@Nullable JavaExpression> dimensions;
    protected final List<JavaExpression> initializers;

    public ArrayCreation(TypeMirror type, List<@Nullable JavaExpression> dimensions, List<JavaExpression> initializers) {
        super(type);
        assert (type.getKind() == TypeKind.ARRAY);
        this.dimensions = dimensions;
        this.initializers = initializers;
    }

    public List<@Nullable JavaExpression> getDimensions() {
        return this.dimensions;
    }

    public List<JavaExpression> getInitializers() {
        return this.initializers;
    }

    @Override
    public <T extends JavaExpression> @Nullable T containedOfClass(Class<T> clazz) {
        for (JavaExpression n : this.dimensions) {
            if (n == null || n.getClass() != clazz) continue;
            return (T)n;
        }
        for (JavaExpression n : this.initializers) {
            if (n.getClass() != clazz) continue;
            return (T)n;
        }
        return null;
    }

    @Override
    public boolean isDeterministic(AnnotationProvider provider) {
        return ArrayCreation.listIsDeterministic(this.dimensions, provider) && ArrayCreation.listIsDeterministic(this.initializers, provider);
    }

    @Override
    public boolean isAssignableByOtherCode() {
        return true;
    }

    @Override
    public boolean isModifiableByOtherCode() {
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.dimensions, this.initializers, this.getType().toString());
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ArrayCreation)) {
            return false;
        }
        ArrayCreation other = (ArrayCreation)obj;
        return this.dimensions.equals(other.getDimensions()) && this.initializers.equals(other.getInitializers()) && this.getType().toString().equals(other.getType().toString());
    }

    @Override
    public boolean syntacticEquals(JavaExpression je) {
        if (!(je instanceof ArrayCreation)) {
            return false;
        }
        ArrayCreation other = (ArrayCreation)je;
        return JavaExpression.syntacticEqualsList(this.dimensions, other.dimensions) && JavaExpression.syntacticEqualsList(this.initializers, other.initializers) && this.getType().toString().equals(other.getType().toString());
    }

    @Override
    public boolean containsSyntacticEqualJavaExpression(JavaExpression other) {
        return this.syntacticEquals(other) || JavaExpression.listContainsSyntacticEqualJavaExpression(this.dimensions, other) || JavaExpression.listContainsSyntacticEqualJavaExpression(this.initializers, other);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.dimensions.isEmpty()) {
            sb.append("new " + this.type);
        } else {
            sb.append("new " + TypesUtils.getInnermostComponentType((ArrayType)this.type));
            for (JavaExpression dim : this.dimensions) {
                sb.append("[");
                sb.append(dim == null ? "" : dim);
                sb.append("]");
            }
        }
        if (!this.initializers.isEmpty() || this.dimensions.isEmpty()) {
            sb.append(" {");
            sb.append(StringsPlume.join((CharSequence)", ", this.initializers));
            sb.append("}");
        }
        return sb.toString();
    }

    @Override
    public String toStringDebug() {
        return "\"" + super.toStringDebug() + "\" type=" + this.type + " dimensions=" + this.dimensions + " initializers=" + this.initializers;
    }

    @Override
    public <R, P> R accept(JavaExpressionVisitor<R, P> visitor, P p) {
        return visitor.visitArrayCreation(this, p);
    }
}

