/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.cfg.block;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.checkerframework.nullaway.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.nullaway.dataflow.cfg.block.Block;
import org.checkerframework.nullaway.org.plumelib.util.ArraySet;

public abstract class BlockImpl
implements Block {
    protected final Block.BlockType type;
    protected final Set<BlockImpl> predecessors;
    private static final AtomicLong nextUid = new AtomicLong(0L);
    private final transient long uid = nextUid.getAndIncrement();

    @Override
    public long getUid(@UnknownInitialization BlockImpl this) {
        return this.uid;
    }

    protected BlockImpl(Block.BlockType type) {
        this.type = type;
        this.predecessors = new ArraySet<BlockImpl>(2);
    }

    @Override
    public Block.BlockType getType() {
        return this.type;
    }

    @Override
    public Set<Block> getPredecessors() {
        return new ArraySet<Block>(this.predecessors);
    }

    public void addPredecessor(BlockImpl pred) {
        this.predecessors.add(pred);
    }

    public void removePredecessor(BlockImpl pred) {
        this.predecessors.remove(pred);
    }
}

