/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.com.google.common.hash;

import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.shaded.checker.index.qual.LessThanUnknown;
import org.checkerframework.shaded.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.shaded.checker.index.qual.NonNegative;
import org.checkerframework.shaded.checker.index.qual.SameLenUnknown;
import org.checkerframework.shaded.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.shaded.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.shaded.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.shaded.checker.initialization.qual.Initialized;
import org.checkerframework.shaded.checker.nullness.qual.NonNull;
import org.checkerframework.shaded.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.shaded.checker.signedness.qual.Signed;
import org.checkerframework.shaded.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.shaded.com.google.common.base.Preconditions;
import org.checkerframework.shaded.com.google.common.hash.AbstractNonStreamingHashFunction;
import org.checkerframework.shaded.com.google.common.hash.ElementTypesAreNonnullByDefault;
import org.checkerframework.shaded.com.google.common.hash.HashCode;
import org.checkerframework.shaded.com.google.common.hash.HashFunction;
import org.checkerframework.shaded.com.google.common.hash.LittleEndianByteArray;
import org.checkerframework.shaded.common.value.qual.UnknownVal;

@ElementTypesAreNonnullByDefault
final class Fingerprint2011
extends AbstractNonStreamingHashFunction {
    static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed HashFunction FINGERPRINT_2011 = new Fingerprint2011();
    private static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long K0 = -6505348102511208375L;
    private static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long K1 = -8261664234251669945L;
    private static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long K2 = -4288712594273399085L;
    private static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long K3 = -4132994306676758123L;

    Fingerprint2011() {
    }

    @Override
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed HashCode hashBytes(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed byte @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] input, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int off, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int len) {
        Preconditions.checkPositionIndexes(off, off + len, input.length);
        return HashCode.fromLong(Fingerprint2011.fingerprint(input, off, len));
    }

    @Override
    public @NonNegative @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int bits() {
        return 64;
    }

    @SideEffectFree
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed String toString() {
        return "Hashing.fingerprint2011()";
    }

    @VisibleForTesting
    static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long fingerprint(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed byte @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] bytes, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int offset, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int length) {
        long result = length <= 32 ? Fingerprint2011.murmurHash64WithSeed(bytes, offset, length, -1397348546323613475L) : (length <= 64 ? Fingerprint2011.hashLength33To64(bytes, offset, length) : Fingerprint2011.fullFingerprint(bytes, offset, length));
        long u = length >= 8 ? LittleEndianByteArray.load64(bytes, offset) : -6505348102511208375L;
        long v = length >= 9 ? LittleEndianByteArray.load64(bytes, offset + length - 8) : -6505348102511208375L;
        result = Fingerprint2011.hash128to64(result + v, u);
        return result == 0L || result == 1L ? result + -2L : result;
    }

    private static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long shiftMix(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long val) {
        return val ^ val >>> 47;
    }

    @VisibleForTesting
    static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long hash128to64(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long high, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long low) {
        long a = (low ^ high) * -4132994306676758123L;
        a ^= a >>> 47;
        long b = (high ^ a) * -4132994306676758123L;
        b ^= b >>> 47;
        return b *= -4132994306676758123L;
    }

    private static void weakHashLength32WithSeeds(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed byte @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] bytes, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int offset, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long seedA, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long seedB, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] output) {
        long part1 = LittleEndianByteArray.load64(bytes, offset);
        long part2 = LittleEndianByteArray.load64(bytes, offset + 8);
        long part3 = LittleEndianByteArray.load64(bytes, offset + 16);
        long part4 = LittleEndianByteArray.load64(bytes, offset + 24);
        seedB = Long.rotateRight(seedB + (seedA += part1) + part4, 51);
        long c = seedA;
        seedA += part2;
        output[0] = seedA + part4;
        output[1] = (seedB += Long.rotateRight(seedA += part3, 23)) + c;
    }

    private static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long fullFingerprint(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed byte @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] bytes, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int offset, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int length) {
        long x = LittleEndianByteArray.load64(bytes, offset);
        long y = LittleEndianByteArray.load64(bytes, offset + length - 16) ^ 0x8D58AC26AFE12E47L;
        long z = LittleEndianByteArray.load64(bytes, offset + length - 56) ^ 0xA5B85C5E198ED849L;
        long[] v = new long[2];
        long[] w = new long[2];
        Fingerprint2011.weakHashLength32WithSeeds(bytes, offset + length - 64, length, y, v);
        Fingerprint2011.weakHashLength32WithSeeds(bytes, offset + length - 32, (long)length * -8261664234251669945L, -6505348102511208375L, w);
        x = Long.rotateRight((z += Fingerprint2011.shiftMix(v[1]) * -8261664234251669945L) + x, 39) * -8261664234251669945L;
        y = Long.rotateRight(y, 33) * -8261664234251669945L;
        length = length - 1 & 0xFFFFFFC0;
        do {
            x = Long.rotateRight(x + y + v[0] + LittleEndianByteArray.load64(bytes, offset + 16), 37) * -8261664234251669945L;
            y = Long.rotateRight(y + v[1] + LittleEndianByteArray.load64(bytes, offset + 48), 42) * -8261664234251669945L;
            z = Long.rotateRight(z ^ w[0], 33);
            Fingerprint2011.weakHashLength32WithSeeds(bytes, offset, v[1] * -8261664234251669945L, (x ^= w[1]) + w[0], v);
            Fingerprint2011.weakHashLength32WithSeeds(bytes, offset + 32, z + w[1], y ^= v[0], w);
            long tmp = z;
            z = x;
            x = tmp;
            offset += 64;
        } while ((length -= 64) != 0);
        return Fingerprint2011.hash128to64(Fingerprint2011.hash128to64(v[0], w[0]) + Fingerprint2011.shiftMix(y) * -8261664234251669945L + z, Fingerprint2011.hash128to64(v[1], w[1]) + x);
    }

    private static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long hashLength33To64(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed byte @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] bytes, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int offset, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int length) {
        long z = LittleEndianByteArray.load64(bytes, offset + 24);
        long a = LittleEndianByteArray.load64(bytes, offset) + ((long)length + LittleEndianByteArray.load64(bytes, offset + length - 16)) * -6505348102511208375L;
        long b = Long.rotateRight(a + z, 52);
        long c = Long.rotateRight(a, 37);
        long vf = (a += LittleEndianByteArray.load64(bytes, offset + 16)) + z;
        long vs = b + Long.rotateRight(a, 31) + (c += Long.rotateRight(a += LittleEndianByteArray.load64(bytes, offset + 8), 7));
        a = LittleEndianByteArray.load64(bytes, offset + 16) + LittleEndianByteArray.load64(bytes, offset + length - 32);
        z = LittleEndianByteArray.load64(bytes, offset + length - 8);
        b = Long.rotateRight(a + z, 52);
        c = Long.rotateRight(a, 37);
        long wf = (a += LittleEndianByteArray.load64(bytes, offset + length - 16)) + z;
        long ws = b + Long.rotateRight(a, 31) + (c += Long.rotateRight(a += LittleEndianByteArray.load64(bytes, offset + length - 24), 7));
        long r = Fingerprint2011.shiftMix((vf + ws) * -4288712594273399085L + (wf + vs) * -6505348102511208375L);
        return Fingerprint2011.shiftMix(r * -6505348102511208375L + vs) * -4288712594273399085L;
    }

    @VisibleForTesting
    static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long murmurHash64WithSeed(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed byte @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] bytes, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int offset, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int length, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long seed) {
        long mul = -4132994306676758123L;
        int topBit = 7;
        int lengthAligned = length & ~topBit;
        int lengthRemainder = length & topBit;
        long hash = seed ^ (long)length * mul;
        for (int i = 0; i < lengthAligned; i += 8) {
            long loaded = LittleEndianByteArray.load64(bytes, offset + i);
            long data = Fingerprint2011.shiftMix(loaded * mul) * mul;
            hash ^= data;
            hash *= mul;
        }
        if (lengthRemainder != 0) {
            long data = LittleEndianByteArray.load64Safely(bytes, offset + lengthAligned, lengthRemainder);
            hash ^= data;
            hash *= mul;
        }
        hash = Fingerprint2011.shiftMix(hash) * mul;
        hash = Fingerprint2011.shiftMix(hash);
        return hash;
    }
}

