/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.cfg.node;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.dataflow.cfg.node.Node;
import org.checkerframework.nullaway.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.nullaway.javacutil.ElementUtils;
import org.checkerframework.nullaway.javacutil.TreeUtils;

public class MethodAccessNode
extends Node {
    protected final ExpressionTree tree;
    protected final ExecutableElement method;
    protected final Node receiver;

    public MethodAccessNode(ExpressionTree tree, Node receiver) {
        this(tree, (ExecutableElement)TreeUtils.elementFromUse(tree), receiver);
    }

    public MethodAccessNode(ExpressionTree tree, ExecutableElement method, Node receiver) {
        super(TreeUtils.typeOf(tree));
        assert (TreeUtils.isMethodAccess(tree));
        this.tree = tree;
        assert (TreeUtils.isUseOfElement(tree)) : "@AssumeAssertion(nullness): tree kind";
        this.method = method;
        this.receiver = receiver;
    }

    public ExecutableElement getMethod() {
        return this.method;
    }

    public Node getReceiver() {
        return this.receiver;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitMethodAccess(this, p);
    }

    public String toString() {
        return this.getReceiver() + "." + this.method.getSimpleName();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof MethodAccessNode)) {
            return false;
        }
        MethodAccessNode other = (MethodAccessNode)obj;
        return this.getReceiver().equals(other.getReceiver()) && this.getMethod().equals(other.getMethod());
    }

    public int hashCode() {
        return Objects.hash(this.getReceiver(), this.getMethod());
    }

    @Override
    @SideEffectFree
    public Collection<Node> getOperands() {
        return Collections.singletonList(this.receiver);
    }

    public boolean isStatic() {
        return ElementUtils.isStatic(this.getMethod());
    }
}

