/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.cfg.builder;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.TreePath;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.nullaway.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.nullaway.dataflow.cfg.UnderlyingAST;
import org.checkerframework.nullaway.dataflow.cfg.block.Block;
import org.checkerframework.nullaway.dataflow.cfg.block.ConditionalBlockImpl;
import org.checkerframework.nullaway.dataflow.cfg.block.ExceptionBlockImpl;
import org.checkerframework.nullaway.dataflow.cfg.block.SingleSuccessorBlockImpl;
import org.checkerframework.nullaway.dataflow.cfg.builder.CFGTranslationPhaseOne;
import org.checkerframework.nullaway.dataflow.cfg.builder.CFGTranslationPhaseThree;
import org.checkerframework.nullaway.dataflow.cfg.builder.CFGTranslationPhaseTwo;
import org.checkerframework.nullaway.dataflow.cfg.builder.ExtendedNode;
import org.checkerframework.nullaway.dataflow.cfg.builder.PhaseOneResult;
import org.checkerframework.nullaway.javacutil.BasicAnnotationProvider;
import org.checkerframework.nullaway.javacutil.trees.TreeBuilder;

public abstract class CFGBuilder {
    protected CFGBuilder() {
    }

    public static ControlFlowGraph build(CompilationUnitTree root, UnderlyingAST underlyingAST, boolean assumeAssertionsEnabled, boolean assumeAssertionsDisabled, ProcessingEnvironment env) {
        TreeBuilder builder = new TreeBuilder(env);
        BasicAnnotationProvider annotationProvider = new BasicAnnotationProvider();
        PhaseOneResult phase1result = new CFGTranslationPhaseOne(builder, annotationProvider, assumeAssertionsEnabled, assumeAssertionsDisabled, env).process(root, underlyingAST);
        ControlFlowGraph phase2result = CFGTranslationPhaseTwo.process(phase1result);
        ControlFlowGraph phase3result = CFGTranslationPhaseThree.process(phase2result);
        return phase3result;
    }

    public static ControlFlowGraph build(TreePath bodyPath, UnderlyingAST underlyingAST, boolean assumeAssertionsEnabled, boolean assumeAssertionsDisabled, ProcessingEnvironment env) {
        TreeBuilder builder = new TreeBuilder(env);
        BasicAnnotationProvider annotationProvider = new BasicAnnotationProvider();
        PhaseOneResult phase1result = new CFGTranslationPhaseOne(builder, annotationProvider, assumeAssertionsEnabled, assumeAssertionsDisabled, env).process(bodyPath, underlyingAST);
        ControlFlowGraph phase2result = CFGTranslationPhaseTwo.process(phase1result);
        ControlFlowGraph phase3result = CFGTranslationPhaseThree.process(phase2result);
        return phase3result;
    }

    public static ControlFlowGraph build(CompilationUnitTree root, UnderlyingAST underlyingAST, ProcessingEnvironment env) {
        return CFGBuilder.build(root, underlyingAST, false, false, env);
    }

    public static ControlFlowGraph build(CompilationUnitTree root, MethodTree tree, ClassTree classTree, ProcessingEnvironment env) {
        UnderlyingAST.CFGMethod underlyingAST = new UnderlyingAST.CFGMethod(tree, classTree);
        return CFGBuilder.build(root, (UnderlyingAST)underlyingAST, false, false, env);
    }

    public static String extendedNodeCollectionToStringDebug(Collection<? extends ExtendedNode> nodes) {
        StringJoiner result = new StringJoiner(", ", "[", "]");
        for (ExtendedNode extendedNode : nodes) {
            result.add(extendedNode.toStringDebug());
        }
        return result.toString();
    }

    protected static void printBlocks(Set<Block> blocks) {
        for (Block b : blocks) {
            System.out.print(b.getUid() + ": " + b);
            switch (b.getType()) {
                case REGULAR_BLOCK: 
                case SPECIAL_BLOCK: {
                    Block succ = ((SingleSuccessorBlockImpl)b).getSuccessor();
                    System.out.println(" -> " + (succ != null ? Long.valueOf(succ.getUid()) : "||"));
                    break;
                }
                case EXCEPTION_BLOCK: {
                    Block succ = ((SingleSuccessorBlockImpl)b).getSuccessor();
                    System.out.print(" -> " + (succ != null ? Long.valueOf(succ.getUid()) : "||") + " {");
                    for (Map.Entry<TypeMirror, Set<Block>> entry : ((ExceptionBlockImpl)b).getExceptionalSuccessors().entrySet()) {
                        System.out.print(entry.getKey() + " : " + entry.getValue() + ", ");
                    }
                    System.out.println("}");
                    break;
                }
                case CONDITIONAL_BLOCK: {
                    Block tSucc = ((ConditionalBlockImpl)b).getThenSuccessor();
                    Block eSucc = ((ConditionalBlockImpl)b).getElseSuccessor();
                    System.out.println(" -> T " + (tSucc != null ? Long.valueOf(tSucc.getUid()) : "||") + " F " + (eSucc != null ? Long.valueOf(eSucc.getUid()) : "||"));
                    break;
                }
            }
        }
    }
}

