/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.analysis;

import java.util.Map;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.dataflow.analysis.AbstractValue;
import org.checkerframework.nullaway.dataflow.analysis.Store;

public abstract class TransferResult<V extends AbstractValue<V>, S extends Store<S>> {
    protected @Nullable V resultValue;
    protected final @Nullable Map<TypeMirror, S> exceptionalStores;

    protected TransferResult(@Nullable V resultValue, @Nullable Map<TypeMirror, S> exceptionalStores) {
        this.resultValue = resultValue;
        this.exceptionalStores = exceptionalStores;
    }

    public @Nullable V getResultValue() {
        return this.resultValue;
    }

    public void setResultValue(V resultValue) {
        this.resultValue = resultValue;
    }

    public abstract S getRegularStore();

    public abstract S getThenStore();

    public abstract S getElseStore();

    public @Nullable S getExceptionalStore(TypeMirror exception) {
        if (this.exceptionalStores == null) {
            return null;
        }
        return (S)((Store)this.exceptionalStores.get(exception));
    }

    public @Nullable Map<TypeMirror, S> getExceptionalStores() {
        return this.exceptionalStores;
    }

    public abstract boolean containsTwoStores();

    public abstract boolean storeChanged();
}

