/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.com.google.common.collect;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import javax.annotation.CheckForNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.errorprone.checker.index.qual.LessThanBottom;
import org.checkerframework.errorprone.checker.index.qual.LessThanUnknown;
import org.checkerframework.errorprone.checker.index.qual.LowerBoundBottom;
import org.checkerframework.errorprone.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.errorprone.checker.index.qual.SameLenBottom;
import org.checkerframework.errorprone.checker.index.qual.SameLenUnknown;
import org.checkerframework.errorprone.checker.index.qual.SearchIndexBottom;
import org.checkerframework.errorprone.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.errorprone.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.UpperBoundBottom;
import org.checkerframework.errorprone.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.errorprone.checker.initialization.qual.Initialized;
import org.checkerframework.errorprone.checker.nullness.qual.KeyForBottom;
import org.checkerframework.errorprone.checker.nullness.qual.NonNull;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.checker.nullness.qual.PolyNull;
import org.checkerframework.errorprone.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.errorprone.checker.signedness.qual.PolySigned;
import org.checkerframework.errorprone.checker.signedness.qual.Signed;
import org.checkerframework.errorprone.checker.signedness.qual.SignednessBottom;
import org.checkerframework.errorprone.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.errorprone.com.google.common.annotations.GwtCompatible;
import org.checkerframework.errorprone.com.google.common.annotations.GwtIncompatible;
import org.checkerframework.errorprone.com.google.common.annotations.J2ktIncompatible;
import org.checkerframework.errorprone.com.google.common.base.Preconditions;
import org.checkerframework.errorprone.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.checkerframework.errorprone.com.google.common.collect.ImmutableList;
import org.checkerframework.errorprone.com.google.common.collect.ObjectArrays;
import org.checkerframework.errorprone.com.google.common.collect.Platform;
import org.checkerframework.errorprone.com.google.common.collect.RegularImmutableAsList;
import org.checkerframework.errorprone.com.google.common.collect.UnmodifiableIterator;
import org.checkerframework.errorprone.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.checkerframework.errorprone.com.google.errorprone.annotations.DoNotCall;
import org.checkerframework.errorprone.com.google.errorprone.annotations.DoNotMock;
import org.checkerframework.errorprone.common.value.qual.BottomVal;
import org.checkerframework.errorprone.common.value.qual.UnknownVal;

@DoNotMock(value="Use ImmutableList.of or another implementation")
@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public abstract class ImmutableCollection<@SubstringIndexBottom E>
extends AbstractCollection<E>
implements Serializable {
    static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int SPLITERATOR_CHARACTERISTICS = 1296;
    private static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Object @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] EMPTY_ARRAY = new Object[0];
    private static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long serialVersionUID = -889275714L;

    ImmutableCollection() {
    }

    @Override
    @SideEffectFree
    public abstract @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed UnmodifiableIterator<E> iterator();

    @Override
    @SideEffectFree
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 1296);
    }

    @Override
    @SideEffectFree
    @J2ktIncompatible
    public final @PolyNull @PolySigned @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Initialized Object @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] toArray() {
        return this.toArray(EMPTY_ARRAY);
    }

    @Override
    @SideEffectFree
    @CanIgnoreReturnValue
    public final <T> T @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] toArray(@PolyNull T @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] other) {
        Preconditions.checkNotNull(other);
        int size = this.size();
        if (other.length < size) {
            Object[] internal = this.internalArray();
            if (internal != null) {
                return Platform.copy(internal, this.internalArrayStart(), this.internalArrayEnd(), other);
            }
            other = ObjectArrays.newArray(other, size);
        } else if (other.length > size) {
            other[size] = null;
        }
        this.copyIntoArray(other, 0);
        return other;
    }

    @CheckForNull
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Object @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @Signed [] internalArray() {
        return null;
    }

    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int internalArrayStart() {
        throw new UnsupportedOperationException();
    }

    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int internalArrayEnd() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Pure
    public abstract @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean contains(@CheckForNull @UnknownSignedness @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized Object var1);

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean remove(@CheckForNull @UnknownSignedness @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean addAll(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Collection<@SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @KeyForBottom @NonNull @Initialized @SignednessBottom ? extends E> newElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean removeAll(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Collection<@SubstringIndexUnknown @SubstringIndexBottom @UnknownVal @BottomVal @SearchIndexUnknown @SearchIndexBottom @SameLenUnknown @SameLenBottom @LessThanUnknown @LessThanBottom @LowerBoundUnknown @LowerBoundBottom @UpperBoundUnknown @UpperBoundBottom @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized @UnknownSignedness @SignednessBottom ?> oldElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean removeIf(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Predicate<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @UnknownSignedness ? super E> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean retainAll(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Collection<@SubstringIndexUnknown @SubstringIndexBottom @UnknownVal @BottomVal @SearchIndexUnknown @SearchIndexBottom @SameLenUnknown @SameLenBottom @LessThanUnknown @LessThanBottom @LowerBoundUnknown @LowerBoundBottom @UpperBoundUnknown @UpperBoundBottom @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized @UnknownSignedness @SignednessBottom ?> elementsToKeep) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ImmutableList<E> asList() {
        switch (this.size()) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return ImmutableList.of(this.iterator().next());
            }
        }
        return new RegularImmutableAsList(this, this.toArray());
    }

    abstract @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean isPartialView();

    @CanIgnoreReturnValue
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int copyIntoArray(@Nullable @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Initialized @Signed Object @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] dst, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int offset) {
        for (Object e : this) {
            dst[offset++] = e;
        }
        return offset;
    }

    @J2ktIncompatible
    @GwtIncompatible
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Object writeReplace() {
        return new ImmutableList.SerializedForm(this.toArray());
    }

    @J2ktIncompatible
    private void readObject(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ObjectInputStream stream) throws @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    @DoNotMock
    public static abstract class Builder<@SubstringIndexBottom E> {
        static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int DEFAULT_INITIAL_CAPACITY = 4;

        static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int expandedCapacity(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int oldCapacity, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int minCapacity) {
            if (minCapacity < 0) {
                throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
            }
            int newCapacity = oldCapacity + (oldCapacity >> 1) + 1;
            if (newCapacity < minCapacity) {
                newCapacity = Integer.highestOneBit(minCapacity - 1) << 1;
            }
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            return newCapacity;
        }

        Builder() {
        }

        @CanIgnoreReturnValue
        public abstract @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Builder<E> add(E var1);

        @CanIgnoreReturnValue
        public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Builder<E> add(E ... elements) {
            for (E element : elements) {
                this.add(element);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Builder<E> addAll(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Iterable<@SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @KeyForBottom @NonNull @Initialized @SignednessBottom ? extends E> elements) {
            for (E element : elements) {
                this.add(element);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Builder<E> addAll(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Iterator<@SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @KeyForBottom @NonNull @Initialized @SignednessBottom ? extends E> elements) {
            while (elements.hasNext()) {
                this.add(elements.next());
            }
            return this;
        }

        public abstract @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ImmutableCollection<E> build();
    }
}

