/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.expression;

import java.util.Arrays;
import org.checkerframework.errorprone.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.javacutil.BugInCF;

public class JavaExpressionParseException
extends Exception {
    private static final long serialVersionUID = 2L;
    private final @CompilerMessageKey String errorKey;
    public final Object[] args;

    public JavaExpressionParseException(@CompilerMessageKey String errorKey, Object ... args) {
        this(null, errorKey, args);
    }

    public JavaExpressionParseException(@Nullable Throwable cause, @CompilerMessageKey String errorKey, Object ... args) {
        super(cause);
        this.errorKey = errorKey;
        this.args = args;
    }

    public static JavaExpressionParseException construct(String exprString, String explanation) {
        if (exprString == null) {
            throw new BugInCF("Must have an expression.");
        }
        if (explanation == null) {
            throw new BugInCF("Must have an explanation.");
        }
        JavaExpressionParseException result = new JavaExpressionParseException((Throwable)null, "flowexpr.parse.error", "Invalid '" + exprString + "' because " + explanation);
        return result;
    }

    public @CompilerMessageKey String getErrorKey() {
        return this.errorKey;
    }

    public Object[] getArgs() {
        return this.args;
    }

    @Override
    public String getMessage() {
        return this.errorKey + " " + Arrays.toString(this.args);
    }

    public boolean isFlowParseError() {
        return this.errorKey.startsWith("flowexpr.parse.error");
    }

    @Override
    public String toString() {
        Throwable cause = this.getCause();
        if (cause == null) {
            return String.format("JavaExpressionParseException([null cause]: %s)", this.getMessage());
        }
        return String.format("JavaExpressionParseException(%s [%s]: %s)", cause.toString(), cause.getClass(), this.getMessage());
    }

    static class JavaExpressionParseExceptionUnchecked
    extends RuntimeException {
        private static final long serialVersionUID = 20250820L;
        private final JavaExpressionParseException exception;

        public JavaExpressionParseExceptionUnchecked(JavaExpressionParseException exception) {
            this.exception = exception;
        }

        public JavaExpressionParseException getCheckedException() {
            return this.exception;
        }

        @Override
        public String getMessage() {
            return "JavaExpressionParseException(" + this.exception + ")";
        }
    }
}

