/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.cfg.node;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.errorprone.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.errorprone.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;
import org.checkerframework.errorprone.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.errorprone.javacutil.TreeUtils;

public class AssignmentNode
extends Node {
    protected final Tree tree;
    protected final Node lhs;
    protected final Node rhs;
    protected final boolean synthetic;
    protected boolean desugaredFromEnhancedArrayForLoop;

    public AssignmentNode(Tree tree, Node target, Node expression) {
        this(tree, target, expression, false);
    }

    public AssignmentNode(Tree tree, Node target, Node expression, boolean synthetic) {
        super(TreeUtils.typeOf(tree));
        assert (tree instanceof AssignmentTree || tree instanceof VariableTree || tree instanceof CompoundAssignmentTree || tree instanceof UnaryTree);
        assert (target instanceof FieldAccessNode || target instanceof LocalVariableNode || target instanceof ArrayAccessNode);
        this.tree = tree;
        this.lhs = target;
        this.rhs = expression;
        this.synthetic = synthetic;
        this.desugaredFromEnhancedArrayForLoop = false;
    }

    @Pure
    public Node getTarget() {
        return this.lhs;
    }

    @Pure
    public Node getExpression() {
        return this.rhs;
    }

    @Override
    @Pure
    public Tree getTree() {
        return this.tree;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public boolean isDesugaredFromEnhancedArrayForLoop() {
        return this.desugaredFromEnhancedArrayForLoop;
    }

    public void setDesugaredFromEnhancedArrayForLoop() {
        this.desugaredFromEnhancedArrayForLoop = true;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitAssignment(this, p);
    }

    @Pure
    public String toString() {
        return this.getTarget() + " = " + this.getExpression() + (this.synthetic ? " (synthetic)" : "");
    }

    @Pure
    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof AssignmentNode)) {
            return false;
        }
        AssignmentNode other = (AssignmentNode)obj;
        return this.getTarget().equals(other.getTarget()) && this.getExpression().equals(other.getExpression());
    }

    @Pure
    public int hashCode() {
        return Objects.hash(this.getTarget(), this.getExpression());
    }

    @Override
    @SideEffectFree
    public Collection<Node> getOperands() {
        return Arrays.asList(this.getTarget(), this.getExpression());
    }
}

