/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.javacutil.javacparse;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.checkerframework.shaded.javacutil.javacparse.FileJavaFileObject;
import org.checkerframework.shaded.javacutil.javacparse.JavacParseResult;
import org.checkerframework.shaded.javacutil.javacparse.StringJavaFileObject;

public final class JavacParse {
    private JavacParse() {
        throw new Error("Do not instantiate.");
    }

    public static JavacParseResult<CompilationUnitTree> parseFile(String filename) throws IOException {
        return JavacParse.parseCompilationUnit(new FileJavaFileObject(filename));
    }

    public static JavacParseResult<CompilationUnitTree> parseCompilationUnit(String javaCode) {
        try {
            return JavacParse.parseCompilationUnit(new StringJavaFileObject(javaCode));
        }
        catch (IOException e) {
            throw new Error("This can't happen", e);
        }
    }

    public static JavacParseResult<ClassTree> parseTypeDeclaration(String classSource) {
        JavacParseResult<CompilationUnitTree> parsedCU = JavacParse.parseCompilationUnit(classSource);
        CompilationUnitTree cu = parsedCU.getTree();
        if (!cu.getImports().isEmpty()) {
            throw new IllegalArgumentException("Type declaration source code has imports: " + classSource);
        }
        if (cu.getPackage() != null) {
            throw new IllegalArgumentException("Type declaration source code has a package declaration: " + classSource);
        }
        List<? extends Tree> decls = cu.getTypeDecls();
        for (Tree tree : decls) {
            if (!(tree instanceof EmptyStatementTree)) continue;
            throw new IllegalArgumentException("Type declaration source code contains a top-level `;`: " + classSource);
        }
        if (decls.size() != 1) {
            throw new IllegalArgumentException(String.format("Type declaration source code has %d top-level forms, not 1: %s", decls.size(), classSource));
        }
        Tree decl = decls.get(0);
        if (decl instanceof ClassTree) {
            return new JavacParseResult<ClassTree>((ClassTree)decl, parsedCU.getDiagnostics());
        }
        throw new IllegalArgumentException("source code should be a type declaration but is " + decl.getClass().getSimpleName() + ":" + classSource);
    }

    public static JavacParseResult<MethodTree> parseMethod(String methodSource) {
        throw new Error("to implement");
    }

    public static JavacParseResult<ExpressionTree> parseExpression(String expressionSource) {
        String dummySource = "class ParseExpression { Object expression = " + expressionSource + "; }";
        JavacParseResult<CompilationUnitTree> cuParse = JavacParse.parseCompilationUnit(dummySource);
        if (cuParse.hasParseError()) {
            String msg = cuParse.getParseErrorMessages();
            if (msg.isEmpty()) {
                throw new Error("Has parse errors, but empty message: " + cuParse.getDiagnostics());
            }
            throw new IllegalArgumentException("Invalid expression (" + msg + "): " + expressionSource);
        }
        CompilationUnitTree cu = cuParse.getTree();
        ClassTree classDecl = (ClassTree)cu.getTypeDecls().get(0);
        List<? extends Tree> members = classDecl.getMembers();
        if (members.size() != 1) {
            throw new IllegalArgumentException("Invalid expression: " + expressionSource);
        }
        ExpressionTree expr = ((VariableTree)members.get(0)).getInitializer();
        return new JavacParseResult<ExpressionTree>(expr, Collections.emptyList());
    }

    public static JavacParseResult<ExpressionTree> parseTypeUse(String typeUseSource) {
        try {
            return JavacParse.parseTypeUse(new StringJavaFileObject(typeUseSource));
        }
        catch (IOException e) {
            throw new Error("This can't happen", e);
        }
    }

    public static JavacParseResult<CompilationUnitTree> parseCompilationUnit(JavaFileObject source) throws IOException {
        Context context = new Context();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        context.put(DiagnosticListener.class, diagnostics);
        try (JavacFileManager fileManagerUnused = new JavacFileManager(context, true, StandardCharsets.UTF_8);){
            Log.instance(context).useSource(source);
            ParserFactory parserFactory = ParserFactory.instance(context);
            JavacParser parser = parserFactory.newParser(source.getCharContent(false), true, true, true);
            JCTree.JCCompilationUnit cu = parser.parseCompilationUnit();
            cu.sourcefile = source;
            JavacParseResult<CompilationUnitTree> javacParseResult = new JavacParseResult<CompilationUnitTree>(cu, diagnostics.getDiagnostics());
            return javacParseResult;
        }
    }

    @Deprecated
    public static JavacParseResult<ExpressionTree> parseExpression(JavaFileObject source) throws IOException {
        Context context = new Context();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        context.put(DiagnosticListener.class, diagnostics);
        try (JavacFileManager fileManagerUnused = new JavacFileManager(context, true, StandardCharsets.UTF_8);){
            Log.instance(context).useSource(source);
            ParserFactory parserFactory = ParserFactory.instance(context);
            JavacParser parser = parserFactory.newParser(source.getCharContent(false), true, true, true);
            JCTree.JCExpression eTree = parser.parseExpression();
            JavacParseResult<ExpressionTree> javacParseResult = new JavacParseResult<ExpressionTree>(eTree, diagnostics.getDiagnostics());
            return javacParseResult;
        }
    }

    public static JavacParseResult<ExpressionTree> parseTypeUse(JavaFileObject source) throws IOException {
        Context context = new Context();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        context.put(DiagnosticListener.class, diagnostics);
        try (JavacFileManager fileManagerUnused = new JavacFileManager(context, true, StandardCharsets.UTF_8);){
            Log.instance(context).useSource(source);
            ParserFactory parserFactory = ParserFactory.instance(context);
            JavacParser parser = parserFactory.newParser(source.getCharContent(false), true, true, true);
            JCTree.JCExpression eTree = parser.parseType();
            JavacParseResult<ExpressionTree> javacParseResult = new JavacParseResult<ExpressionTree>(eTree, diagnostics.getDiagnostics());
            return javacParseResult;
        }
    }
}

