/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.cfg.node;

import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;
import org.checkerframework.errorprone.dataflow.cfg.node.NodeVisitor;

public class StringConversionNode
extends Node {
    protected final Tree tree;
    protected final Node operand;

    public StringConversionNode(Tree tree, Node operand, TypeMirror type) {
        super(type);
        this.tree = tree;
        this.operand = operand;
    }

    public Node getOperand() {
        return this.operand;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitStringConversion(this, p);
    }

    public String toString() {
        return "StringConversion(" + this.getOperand() + ")";
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof StringConversionNode)) {
            return false;
        }
        StringConversionNode other = (StringConversionNode)obj;
        return this.getOperand().equals(other.getOperand());
    }

    public int hashCode() {
        return Objects.hash(StringConversionNode.class, this.getOperand());
    }

    @Override
    @SideEffectFree
    public Collection<Node> getOperands() {
        return Collections.singletonList(this.getOperand());
    }
}

