/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.analysis;

import java.util.Map;
import java.util.StringJoiner;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.analysis.AbstractValue;
import org.checkerframework.errorprone.dataflow.analysis.Store;
import org.checkerframework.errorprone.dataflow.analysis.TransferResult;
import org.checkerframework.errorprone.org.plumelib.util.StringsPlume;

public class ConditionalTransferResult<V extends AbstractValue<V>, S extends Store<S>>
extends TransferResult<V, S> {
    private final boolean storeChanged;
    protected final S thenStore;
    protected final S elseStore;

    public ConditionalTransferResult(@Nullable V value, S thenStore, S elseStore, boolean storeChanged) {
        this(value, thenStore, elseStore, null, storeChanged);
    }

    public ConditionalTransferResult(@Nullable V value, S thenStore, S elseStore) {
        this(value, thenStore, elseStore, false);
    }

    public ConditionalTransferResult(V value, S thenStore, S elseStore, @Nullable Map<TypeMirror, S> exceptionalStores) {
        this(value, thenStore, elseStore, exceptionalStores, false);
    }

    public ConditionalTransferResult(@Nullable V value, S thenStore, S elseStore, @Nullable Map<TypeMirror, S> exceptionalStores, boolean storeChanged) {
        super(value, exceptionalStores);
        this.thenStore = thenStore;
        this.elseStore = elseStore;
        this.storeChanged = storeChanged;
    }

    @Override
    public S getRegularStore() {
        return this.thenStore.leastUpperBound(this.elseStore);
    }

    @Override
    public S getThenStore() {
        return this.thenStore;
    }

    @Override
    public S getElseStore() {
        return this.elseStore;
    }

    @Override
    public boolean containsTwoStores() {
        return true;
    }

    public String toString() {
        StringJoiner result = new StringJoiner(System.lineSeparator());
        result.add("RegularTransferResult(");
        result.add("  resultValue = " + StringsPlume.indentLinesExceptFirst(2, this.resultValue));
        result.add("  thenStore = " + StringsPlume.indentLinesExceptFirst(2, this.thenStore));
        result.add("  elseStore = " + StringsPlume.indentLinesExceptFirst(2, this.elseStore));
        result.add(")");
        return result.toString();
    }

    @Override
    public boolean storeChanged() {
        return this.storeChanged;
    }

    @Override
    public ConditionalTransferResult<V, S> withExceptionalStores(Map<TypeMirror, S> exceptionalStores) {
        return new ConditionalTransferResult<AbstractValue, S>(this.resultValue, this.thenStore, this.elseStore, exceptionalStores, this.storeChanged);
    }
}

