/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Lower;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class LambdaToMethod
extends TreeTranslator {
    private Attr attr;
    private JCDiagnostic.Factory diags;
    private Log log;
    private Lower lower;
    private Names names;
    private Symtab syms;
    private Resolve rs;
    private TreeMaker make;
    private Types types;
    private TransTypes transTypes;
    private Env<AttrContext> attrEnv;
    private LambdaAnalyzerPreprocessor analyzer;
    private Map<JCTree, LambdaAnalyzerPreprocessor.TranslationContext<?>> contextMap;
    private LambdaAnalyzerPreprocessor.TranslationContext<?> context;
    private KlassInfo kInfo;
    private boolean dumpLambdaToMethodStats;
    private final boolean forceSerializable;
    public static final int FLAG_SERIALIZABLE = 1;
    public static final int FLAG_MARKERS = 2;
    public static final int FLAG_BRIDGES = 4;
    protected static final Context.Key<LambdaToMethod> unlambdaKey = new Context.Key();

    public static LambdaToMethod instance(Context context) {
        LambdaToMethod instance = context.get(unlambdaKey);
        if (instance == null) {
            instance = new LambdaToMethod(context);
        }
        return instance;
    }

    private LambdaToMethod(Context context) {
        context.put(unlambdaKey, this);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.log = Log.instance(context);
        this.lower = Lower.instance(context);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.rs = Resolve.instance(context);
        this.make = TreeMaker.instance(context);
        this.types = Types.instance(context);
        this.transTypes = TransTypes.instance(context);
        this.analyzer = new LambdaAnalyzerPreprocessor();
        Options options = Options.instance(context);
        this.dumpLambdaToMethodStats = options.isSet("dumpLambdaToMethodStats");
        this.attr = Attr.instance(context);
        this.forceSerializable = options.isSet("forceSerializable");
    }

    @Override
    public <T extends JCTree> T translate(T tree) {
        LambdaAnalyzerPreprocessor.TranslationContext<?> newContext = this.contextMap.get(tree);
        return this.translate(tree, newContext != null ? newContext : this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends JCTree> T translate(T tree, LambdaAnalyzerPreprocessor.TranslationContext<?> newContext) {
        LambdaAnalyzerPreprocessor.TranslationContext<?> prevContext = this.context;
        try {
            this.context = newContext;
            T t = super.translate(tree);
            return t;
        }
        finally {
            this.context = prevContext;
        }
    }

    <T extends JCTree> List<T> translate(List<T> trees, LambdaAnalyzerPreprocessor.TranslationContext<?> newContext) {
        ListBuffer<JCTree> buf = new ListBuffer<JCTree>();
        for (JCTree tree : trees) {
            buf.append(this.translate(tree, newContext));
        }
        return buf.toList();
    }

    public JCTree translateTopLevelClass(Env<AttrContext> env, JCTree cdef, TreeMaker make) {
        this.make = make;
        this.attrEnv = env;
        this.context = null;
        this.contextMap = new HashMap();
        return this.translate(cdef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        if (tree.sym.owner.kind == 1) {
            tree = this.analyzer.analyzeAndPreprocessClass(tree);
        }
        KlassInfo prevKlassInfo = this.kInfo;
        try {
            this.kInfo = new KlassInfo(tree);
            super.visitClassDef(tree);
            if (!this.kInfo.deserializeCases.isEmpty()) {
                int prevPos = this.make.pos;
                try {
                    this.make.at(tree);
                    this.kInfo.addMethod(this.makeDeserializeMethod(tree.sym));
                }
                finally {
                    this.make.at(prevPos);
                }
            }
            List newMethods = this.kInfo.appendedMethodList.toList();
            tree.defs = tree.defs.appendList(newMethods);
            for (JCTree lambda : newMethods) {
                tree.sym.members().enter(((JCTree.JCMethodDecl)lambda).sym);
            }
            this.result = tree;
        }
        finally {
            this.kInfo = prevKlassInfo;
        }
    }

    @Override
    public void visitLambda(JCTree.JCLambda tree) {
        JCTree.JCExpression captured_local;
        LambdaAnalyzerPreprocessor.LambdaTranslationContext localContext = (LambdaAnalyzerPreprocessor.LambdaTranslationContext)this.context;
        Symbol.MethodSymbol sym = localContext.translatedSym;
        Type.MethodType lambdaType = (Type.MethodType)sym.type;
        Symbol owner = localContext.owner;
        ListBuffer<Attribute.TypeCompound> ownerTypeAnnos = new ListBuffer<Attribute.TypeCompound>();
        Iterator<Symbol> lambdaTypeAnnos = new ListBuffer<Attribute.TypeCompound>();
        for (Attribute.TypeCompound tc : owner.getRawTypeAttributes()) {
            if (tc.position.onLambda == tree) {
                ((ListBuffer)((Object)lambdaTypeAnnos)).append(tc);
                continue;
            }
            ownerTypeAnnos.append(tc);
        }
        if (((ListBuffer)((Object)lambdaTypeAnnos)).nonEmpty()) {
            owner.setTypeAttributes(ownerTypeAnnos.toList());
            sym.setTypeAttributes(((ListBuffer)((Object)lambdaTypeAnnos)).toList());
        }
        JCTree.JCMethodDecl lambdaDecl = this.make.MethodDef(this.make.Modifiers(sym.flags_field), sym.name, this.make.QualIdent(lambdaType.getReturnType().tsym), List.nil(), localContext.syntheticParams, lambdaType.getThrownTypes() == null ? List.nil() : this.make.Types((List<Type>)lambdaType.getThrownTypes()), null, null);
        lambdaDecl.sym = sym;
        lambdaDecl.type = lambdaType;
        lambdaDecl.body = this.translate(this.makeLambdaBody(tree, lambdaDecl));
        this.kInfo.addMethod(lambdaDecl);
        ListBuffer<JCTree.JCExpression> syntheticInits = new ListBuffer<JCTree.JCExpression>();
        if (localContext.methodReferenceReceiver != null) {
            syntheticInits.append(localContext.methodReferenceReceiver);
        } else if (!sym.isStatic()) {
            syntheticInits.append(this.makeThis((Type)sym.owner.enclClass().asType(), localContext.owner.enclClass()));
        }
        for (Symbol fv : localContext.getSymbolMap(LambdaSymbolKind.CAPTURED_VAR).keySet()) {
            if (fv == localContext.self) continue;
            captured_local = this.make.Ident(fv).setType(fv.type);
            syntheticInits.append(captured_local);
        }
        for (Symbol fv : localContext.getSymbolMap(LambdaSymbolKind.CAPTURED_OUTER_THIS).keySet()) {
            captured_local = this.make.QualThis(fv.type);
            syntheticInits.append(captured_local);
        }
        List<JCTree.JCExpression> indy_args = this.translate(syntheticInits.toList(), localContext.prev);
        int refKind = this.referenceKind(sym);
        this.result = this.makeMetafactoryIndyCall(this.context, refKind, sym, indy_args);
    }

    private JCTree.JCIdent makeThis(Type type, Symbol owner) {
        Symbol.VarSymbol _this = new Symbol.VarSymbol(0x200001010L, this.names._this, type, owner);
        return this.make.Ident(_this);
    }

    @Override
    public void visitReference(JCTree.JCMemberReference tree) {
        JCTree.JCExpression init;
        LambdaAnalyzerPreprocessor.ReferenceTranslationContext localContext = (LambdaAnalyzerPreprocessor.ReferenceTranslationContext)this.context;
        Symbol refSym = localContext.isSignaturePolymorphic() ? localContext.sigPolySym : tree.sym;
        switch (tree.kind) {
            case IMPLICIT_INNER: 
            case SUPER: {
                init = this.makeThis((Type)localContext.owner.enclClass().asType(), localContext.owner.enclClass());
                break;
            }
            case BOUND: {
                init = tree.getQualifierExpression();
                init = this.attr.makeNullCheck(init);
                break;
            }
            case UNBOUND: 
            case STATIC: 
            case TOPLEVEL: 
            case ARRAY_CTOR: {
                init = null;
                break;
            }
            default: {
                throw new InternalError("Should not have an invalid kind");
            }
        }
        List<JCTree.JCExpression> indy_args = init == null ? List.nil() : this.translate(List.of(init), localContext.prev);
        this.result = this.makeMetafactoryIndyCall(localContext, localContext.referenceKind(), refSym, indy_args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        if (this.context == null || !this.analyzer.lambdaIdentSymbolFilter(tree.sym)) {
            super.visitIdent(tree);
        } else {
            int prevPos = this.make.pos;
            try {
                this.make.at(tree);
                LambdaAnalyzerPreprocessor.LambdaTranslationContext lambdaContext = (LambdaAnalyzerPreprocessor.LambdaTranslationContext)this.context;
                JCTree ltree = lambdaContext.translate(tree);
                if (ltree != null) {
                    this.result = ltree;
                } else {
                    super.visitIdent(tree);
                }
            }
            finally {
                this.make.at(prevPos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        if (this.context == null || !this.analyzer.lambdaFieldAccessFilter(tree)) {
            super.visitSelect(tree);
        } else {
            int prevPos = this.make.pos;
            try {
                this.make.at(tree);
                LambdaAnalyzerPreprocessor.LambdaTranslationContext lambdaContext = (LambdaAnalyzerPreprocessor.LambdaTranslationContext)this.context;
                JCTree ltree = lambdaContext.translate(tree);
                if (ltree != null) {
                    this.result = ltree;
                } else {
                    super.visitSelect(tree);
                }
            }
            finally {
                this.make.at(prevPos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        LambdaAnalyzerPreprocessor.LambdaTranslationContext lambdaContext = (LambdaAnalyzerPreprocessor.LambdaTranslationContext)this.context;
        if (this.context != null && lambdaContext.getSymbolMap(LambdaSymbolKind.LOCAL_VAR).containsKey(tree.sym)) {
            tree.init = this.translate(tree.init);
            tree.sym = (Symbol.VarSymbol)lambdaContext.getSymbolMap(LambdaSymbolKind.LOCAL_VAR).get(tree.sym);
            this.result = tree;
        } else if (this.context != null && lambdaContext.getSymbolMap(LambdaSymbolKind.TYPE_VAR).containsKey(tree.sym)) {
            JCTree.JCExpression init = this.translate(tree.init);
            Symbol.VarSymbol xsym = (Symbol.VarSymbol)lambdaContext.getSymbolMap(LambdaSymbolKind.TYPE_VAR).get(tree.sym);
            int prevPos = this.make.pos;
            try {
                this.result = this.make.at(tree).VarDef(xsym, init);
            }
            finally {
                this.make.at(prevPos);
            }
            Scope sc = tree.sym.owner.members();
            if (sc != null) {
                sc.remove(tree.sym);
                sc.enter(xsym);
            }
        } else {
            super.visitVarDef(tree);
        }
    }

    private JCTree.JCBlock makeLambdaBody(JCTree.JCLambda tree, JCTree.JCMethodDecl lambdaMethodDecl) {
        return tree.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION ? this.makeLambdaExpressionBody((JCTree.JCExpression)tree.body, lambdaMethodDecl) : this.makeLambdaStatementBody((JCTree.JCBlock)tree.body, lambdaMethodDecl, tree.canCompleteNormally);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCTree.JCBlock makeLambdaExpressionBody(JCTree.JCExpression expr, JCTree.JCMethodDecl lambdaMethodDecl) {
        Type restype = lambdaMethodDecl.type.getReturnType();
        boolean isLambda_void = expr.type.hasTag(TypeTag.VOID);
        boolean isTarget_void = restype.hasTag(TypeTag.VOID);
        boolean isTarget_Void = this.types.isSameType(restype, this.types.boxedClass((Type)this.syms.voidType).type);
        int prevPos = this.make.pos;
        try {
            if (isTarget_void) {
                JCTree.JCExpressionStatement stat = this.make.at(expr).Exec(expr);
                JCTree.JCBlock jCBlock = this.make.Block(0L, List.of(stat));
                return jCBlock;
            }
            if (isLambda_void && isTarget_Void) {
                ListBuffer<JCTree.JCStatement> stats = new ListBuffer<JCTree.JCStatement>();
                stats.append(this.make.at(expr).Exec(expr));
                stats.append(this.make.Return(this.make.Literal(TypeTag.BOT, null).setType(this.syms.botType)));
                JCTree.JCBlock jCBlock = this.make.Block(0L, stats.toList());
                return jCBlock;
            }
            JCTree.JCExpression retExpr = this.transTypes.coerce(this.attrEnv, expr, restype);
            JCTree.JCBlock jCBlock = this.make.at(retExpr).Block(0L, List.of(this.make.Return(retExpr)));
            return jCBlock;
        }
        finally {
            this.make.at(prevPos);
        }
    }

    private JCTree.JCBlock makeLambdaStatementBody(JCTree.JCBlock block, final JCTree.JCMethodDecl lambdaMethodDecl, boolean completeNormally) {
        final Type restype = lambdaMethodDecl.type.getReturnType();
        final boolean isTarget_void = restype.hasTag(TypeTag.VOID);
        boolean isTarget_Void = this.types.isSameType(restype, this.types.boxedClass((Type)this.syms.voidType).type);
        class LambdaBodyTranslator
        extends TreeTranslator {
            LambdaBodyTranslator() {
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl tree) {
                this.result = tree;
            }

            @Override
            public void visitLambda(JCTree.JCLambda tree) {
                this.result = tree;
            }

            @Override
            public void visitReturn(JCTree.JCReturn tree) {
                boolean isLambda_void;
                boolean bl = isLambda_void = tree.expr == null;
                if (isTarget_void && !isLambda_void) {
                    Symbol.VarSymbol loc = LambdaToMethod.this.makeSyntheticVar(0L, LambdaToMethod.this.names.fromString("$loc"), tree.expr.type, lambdaMethodDecl.sym);
                    JCTree.JCVariableDecl varDef = LambdaToMethod.this.make.VarDef(loc, tree.expr);
                    this.result = LambdaToMethod.this.make.Block(0L, List.of(varDef, LambdaToMethod.this.make.Return(null)));
                } else if (!isTarget_void || !isLambda_void) {
                    tree.expr = LambdaToMethod.this.transTypes.coerce(LambdaToMethod.this.attrEnv, tree.expr, restype);
                    this.result = tree;
                } else {
                    this.result = tree;
                }
            }
        }
        JCTree.JCBlock trans_block = new LambdaBodyTranslator().translate(block);
        if (completeNormally && isTarget_Void) {
            trans_block.stats = trans_block.stats.append(this.make.Return(this.make.Literal(TypeTag.BOT, null).setType(this.syms.botType)));
        }
        return trans_block;
    }

    private JCTree.JCMethodDecl makeDeserializeMethod(Symbol kSym) {
        ListBuffer<JCTree.JCCase> cases = new ListBuffer<JCTree.JCCase>();
        ListBuffer<JCTree.JCBreak> breaks = new ListBuffer<JCTree.JCBreak>();
        for (Map.Entry entry : this.kInfo.deserializeCases.entrySet()) {
            JCTree.JCBreak br = this.make.Break(null);
            breaks.add(br);
            List<JCTree.JCStatement> stmts = ((ListBuffer)entry.getValue()).append(br).toList();
            cases.add(this.make.Case(this.make.Literal(entry.getKey()), stmts));
        }
        JCTree.JCSwitch sw = this.make.Switch(this.deserGetter("getImplMethodName", this.syms.stringType), cases.toList());
        for (JCTree.JCBreak br : breaks) {
            br.target = sw;
        }
        JCTree.JCBlock jCBlock = this.make.Block(0L, List.of(sw, this.make.Throw(this.makeNewClass(this.syms.illegalArgumentExceptionType, List.of(this.make.Literal("Invalid lambda deserialization"))))));
        JCTree.JCMethodDecl deser = this.make.MethodDef(this.make.Modifiers(this.kInfo.deserMethodSym.flags()), this.names.deserializeLambda, this.make.QualIdent(((KlassInfo)this.kInfo).deserMethodSym.getReturnType().tsym), List.nil(), List.of(this.make.VarDef(this.kInfo.deserParamSym, null)), List.nil(), jCBlock, null);
        deser.sym = this.kInfo.deserMethodSym;
        deser.type = ((KlassInfo)this.kInfo).deserMethodSym.type;
        return deser;
    }

    JCTree.JCNewClass makeNewClass(Type ctype, List<JCTree.JCExpression> args, Symbol cons) {
        JCTree.JCNewClass tree = this.make.NewClass(null, null, this.make.QualIdent(ctype.tsym), args, null);
        tree.constructor = cons;
        tree.type = ctype;
        return tree;
    }

    JCTree.JCNewClass makeNewClass(Type ctype, List<JCTree.JCExpression> args) {
        return this.makeNewClass(ctype, args, this.rs.resolveConstructor(null, this.attrEnv, ctype, TreeInfo.types(args), List.nil()));
    }

    private void addDeserializationCase(int implMethodKind, Symbol refSym, Type targetType, Symbol.MethodSymbol samSym, JCDiagnostic.DiagnosticPosition pos, List<Object> staticArgs, Type.MethodType indyType) {
        String functionalInterfaceClass = this.classSig(targetType);
        String functionalInterfaceMethodName = ((Name)samSym.getSimpleName()).toString();
        String functionalInterfaceMethodSignature = this.typeSig(this.types.erasure(samSym.type));
        String implClass = this.classSig(this.types.erasure(refSym.owner.type));
        String implMethodName = refSym.getQualifiedName().toString();
        String implMethodSignature = this.typeSig(this.types.erasure(refSym.type));
        JCTree.JCExpression kindTest = this.eqTest(this.syms.intType, this.deserGetter("getImplMethodKind", this.syms.intType), this.make.Literal(implMethodKind));
        ListBuffer<JCTree.JCTypeCast> serArgs = new ListBuffer<JCTree.JCTypeCast>();
        int i = 0;
        for (Type t : indyType.getParameterTypes()) {
            List<JCTree.JCExpression> indexAsArg = new ListBuffer<JCTree.JCLiteral>().append(this.make.Literal(i)).toList();
            List<Type> argTypes = new ListBuffer<Type.JCPrimitiveType>().append(this.syms.intType).toList();
            serArgs.add(this.make.TypeCast(this.types.erasure(t), this.deserGetter("getCapturedArg", this.syms.objectType, argTypes, indexAsArg)));
            ++i;
        }
        JCTree.JCIf stmt = this.make.If(this.deserTest(this.deserTest(this.deserTest(this.deserTest(this.deserTest(kindTest, "getFunctionalInterfaceClass", functionalInterfaceClass), "getFunctionalInterfaceMethodName", functionalInterfaceMethodName), "getFunctionalInterfaceMethodSignature", functionalInterfaceMethodSignature), "getImplClass", implClass), "getImplMethodSignature", implMethodSignature), this.make.Return(this.makeIndyCall(pos, this.syms.lambdaMetafactory, this.names.altMetafactory, staticArgs, indyType, serArgs.toList(), samSym.name)), null);
        ListBuffer<JCTree.JCIf> stmts = (ListBuffer<JCTree.JCIf>)this.kInfo.deserializeCases.get(implMethodName);
        if (stmts == null) {
            stmts = new ListBuffer<JCTree.JCIf>();
            this.kInfo.deserializeCases.put(implMethodName, stmts);
        }
        stmts.append(stmt);
    }

    private JCTree.JCExpression eqTest(Type argType, JCTree.JCExpression arg1, JCTree.JCExpression arg2) {
        JCTree.JCBinary testExpr = this.make.Binary(JCTree.Tag.EQ, arg1, arg2);
        testExpr.operator = this.rs.resolveBinaryOperator(null, JCTree.Tag.EQ, this.attrEnv, argType, argType);
        testExpr.setType(this.syms.booleanType);
        return testExpr;
    }

    private JCTree.JCExpression deserTest(JCTree.JCExpression prev, String func, String lit) {
        Type.MethodType eqmt = new Type.MethodType(List.of(this.syms.objectType), this.syms.booleanType, List.nil(), this.syms.methodClass);
        Symbol eqsym = this.rs.resolveQualifiedMethod(null, this.attrEnv, this.syms.objectType, this.names.equals, List.of(this.syms.objectType), List.nil());
        JCTree.JCMethodInvocation eqtest = this.make.Apply(List.nil(), this.make.Select(this.deserGetter(func, this.syms.stringType), eqsym).setType(eqmt), List.of(this.make.Literal(lit)));
        eqtest.setType(this.syms.booleanType);
        JCTree.JCBinary compound = this.make.Binary(JCTree.Tag.AND, prev, eqtest);
        compound.operator = this.rs.resolveBinaryOperator(null, JCTree.Tag.AND, this.attrEnv, this.syms.booleanType, this.syms.booleanType);
        compound.setType(this.syms.booleanType);
        return compound;
    }

    private JCTree.JCExpression deserGetter(String func, Type type) {
        return this.deserGetter(func, type, List.nil(), List.nil());
    }

    private JCTree.JCExpression deserGetter(String func, Type type, List<Type> argTypes, List<JCTree.JCExpression> args) {
        Type.MethodType getmt = new Type.MethodType(argTypes, type, List.nil(), this.syms.methodClass);
        Symbol getsym = this.rs.resolveQualifiedMethod(null, this.attrEnv, this.syms.serializedLambdaType, this.names.fromString(func), argTypes, List.nil());
        return this.make.Apply(List.nil(), this.make.Select(this.make.Ident(this.kInfo.deserParamSym).setType(this.syms.serializedLambdaType), getsym).setType(getmt), args).setType(type);
    }

    private Symbol.MethodSymbol makePrivateSyntheticMethod(long flags, Name name, Type type, Symbol owner) {
        return new Symbol.MethodSymbol(flags | 0x1000L | 2L, name, type, owner);
    }

    private Symbol.VarSymbol makeSyntheticVar(long flags, String name, Type type, Symbol owner) {
        return this.makeSyntheticVar(flags, this.names.fromString(name), type, owner);
    }

    private Symbol.VarSymbol makeSyntheticVar(long flags, Name name, Type type, Symbol owner) {
        return new Symbol.VarSymbol(flags | 0x1000L, name, type, owner);
    }

    private void setVarargsIfNeeded(JCTree tree, Type varargsElement) {
        if (varargsElement != null) {
            switch (tree.getTag()) {
                case APPLY: {
                    ((JCTree.JCMethodInvocation)tree).varargsElement = varargsElement;
                    break;
                }
                case NEWCLASS: {
                    ((JCTree.JCNewClass)tree).varargsElement = varargsElement;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    private List<JCTree.JCExpression> convertArgs(Symbol meth, List<JCTree.JCExpression> args, Type varargsElement) {
        Assert.check(meth.kind == 16);
        List<Type> formals = this.types.erasure(meth.type).getParameterTypes();
        if (varargsElement != null) {
            Assert.check((meth.flags() & 0x400000000L) != 0L);
        }
        return this.transTypes.translateArgs(args, formals, varargsElement, this.attrEnv);
    }

    private Type.MethodType typeToMethodType(Type mt) {
        Type type = this.types.erasure(mt);
        return new Type.MethodType(type.getParameterTypes(), type.getReturnType(), type.getThrownTypes(), this.syms.methodClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCTree.JCExpression makeMetafactoryIndyCall(LambdaAnalyzerPreprocessor.TranslationContext<?> context, int refKind, Symbol refSym, List<JCTree.JCExpression> indy_args) {
        Name metafactoryName;
        Object tree = context.tree;
        Symbol.MethodSymbol samSym = (Symbol.MethodSymbol)this.types.findDescriptorSymbol(((JCTree.JCFunctionalExpression)tree).type.tsym);
        List<Object> staticArgs = List.of(this.typeToMethodType(samSym.type), new Pool.MethodHandle(refKind, refSym, this.types), this.typeToMethodType(((JCTree.JCFunctionalExpression)tree).getDescriptorType(this.types)));
        ListBuffer<Type> indy_args_types = new ListBuffer<Type>();
        for (JCTree.JCExpression arg : indy_args) {
            indy_args_types.append(arg.type);
        }
        Type.MethodType indyType = new Type.MethodType(indy_args_types.toList(), ((JCTree.JCFunctionalExpression)tree).type, List.nil(), this.syms.methodClass);
        Name name = metafactoryName = context.needsAltMetafactory() ? this.names.altMetafactory : this.names.metafactory;
        if (context.needsAltMetafactory()) {
            ListBuffer<Symbol.TypeSymbol> markers = new ListBuffer<Symbol.TypeSymbol>();
            for (Type t : ((JCTree.JCFunctionalExpression)tree).targets.tail) {
                if (t.tsym == this.syms.serializableType.tsym) continue;
                markers.append(t.tsym);
            }
            int flags = context.isSerializable() ? 1 : 0;
            boolean hasMarkers = markers.nonEmpty();
            boolean hasBridges = context.bridges.nonEmpty();
            if (hasMarkers) {
                flags |= 2;
            }
            if (hasBridges) {
                flags |= 4;
            }
            staticArgs = staticArgs.append(flags);
            if (hasMarkers) {
                staticArgs = staticArgs.append(markers.length());
                staticArgs = staticArgs.appendList(markers.toList());
            }
            if (hasBridges) {
                staticArgs = staticArgs.append(context.bridges.length() - 1);
                for (Symbol s : context.bridges) {
                    Type s_erasure = s.erasure(this.types);
                    if (this.types.isSameType(s_erasure, samSym.erasure(this.types))) continue;
                    staticArgs = staticArgs.append(s.erasure(this.types));
                }
            }
            if (context.isSerializable()) {
                int prevPos = this.make.pos;
                try {
                    this.make.at(this.kInfo.clazz);
                    this.addDeserializationCase(refKind, refSym, ((JCTree.JCFunctionalExpression)tree).type, samSym, (JCDiagnostic.DiagnosticPosition)tree, staticArgs, indyType);
                }
                finally {
                    this.make.at(prevPos);
                }
            }
        }
        return this.makeIndyCall((JCDiagnostic.DiagnosticPosition)tree, this.syms.lambdaMetafactory, metafactoryName, staticArgs, indyType, indy_args, samSym.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCTree.JCExpression makeIndyCall(JCDiagnostic.DiagnosticPosition pos, Type site, Name bsmName, List<Object> staticArgs, Type.MethodType indyType, List<JCTree.JCExpression> indyArgs, Name methName) {
        int prevPos = this.make.pos;
        try {
            this.make.at(pos);
            List<Type> bsm_staticArgs = List.of(this.syms.methodHandleLookupType, this.syms.stringType, this.syms.methodTypeType).appendList(this.bsmStaticArgToTypes(staticArgs));
            Symbol.MethodSymbol bsm = this.rs.resolveInternalMethod(pos, this.attrEnv, site, bsmName, bsm_staticArgs, List.nil());
            Symbol.DynamicMethodSymbol dynSym = new Symbol.DynamicMethodSymbol(methName, this.syms.noSymbol, bsm.isStatic() ? 6 : 5, bsm, indyType, staticArgs.toArray());
            JCTree.JCFieldAccess qualifier = this.make.Select(this.make.QualIdent(site.tsym), bsmName);
            qualifier.sym = dynSym;
            qualifier.type = indyType.getReturnType();
            JCTree.JCMethodInvocation proxyCall = this.make.Apply(List.nil(), qualifier, indyArgs);
            proxyCall.type = indyType.getReturnType();
            JCTree.JCMethodInvocation jCMethodInvocation = proxyCall;
            return jCMethodInvocation;
        }
        finally {
            this.make.at(prevPos);
        }
    }

    private List<Type> bsmStaticArgToTypes(List<Object> args) {
        ListBuffer<Type> argtypes = new ListBuffer<Type>();
        for (Object arg : args) {
            argtypes.append(this.bsmStaticArgToType(arg));
        }
        return argtypes.toList();
    }

    private Type bsmStaticArgToType(Object arg) {
        Assert.checkNonNull(arg);
        if (arg instanceof Symbol.ClassSymbol) {
            return this.syms.classType;
        }
        if (arg instanceof Integer) {
            return this.syms.intType;
        }
        if (arg instanceof Long) {
            return this.syms.longType;
        }
        if (arg instanceof Float) {
            return this.syms.floatType;
        }
        if (arg instanceof Double) {
            return this.syms.doubleType;
        }
        if (arg instanceof String) {
            return this.syms.stringType;
        }
        if (arg instanceof Pool.MethodHandle) {
            return this.syms.methodHandleType;
        }
        if (arg instanceof Type.MethodType) {
            return this.syms.methodTypeType;
        }
        Assert.error("bad static arg " + arg.getClass());
        return null;
    }

    private int referenceKind(Symbol refSym) {
        if (refSym.isConstructor()) {
            return 8;
        }
        if (refSym.isStatic()) {
            return 6;
        }
        if ((refSym.flags() & 2L) != 0L) {
            return 7;
        }
        if (refSym.enclClass().isInterface()) {
            return 9;
        }
        return 5;
    }

    private String typeSig(Type type) {
        L2MSignatureGenerator sg = new L2MSignatureGenerator();
        sg.assembleSig(type);
        return sg.toString();
    }

    private String classSig(Type type) {
        L2MSignatureGenerator sg = new L2MSignatureGenerator();
        sg.assembleClassSig(type);
        return sg.toString();
    }

    private class L2MSignatureGenerator
    extends Types.SignatureGenerator {
        StringBuilder sb;

        L2MSignatureGenerator() {
            super(LambdaToMethod.this.types);
            this.sb = new StringBuilder();
        }

        @Override
        protected void append(char ch) {
            this.sb.append(ch);
        }

        @Override
        protected void append(byte[] ba) {
            this.sb.append(new String(ba));
        }

        @Override
        protected void append(Name name) {
            this.sb.append(name.toString());
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    static enum LambdaSymbolKind {
        PARAM,
        LOCAL_VAR,
        CAPTURED_VAR,
        CAPTURED_THIS,
        CAPTURED_OUTER_THIS,
        TYPE_VAR;


        boolean propagateAnnotations() {
            switch (this) {
                case CAPTURED_THIS: 
                case CAPTURED_VAR: 
                case CAPTURED_OUTER_THIS: {
                    return false;
                }
            }
            return true;
        }
    }

    class LambdaAnalyzerPreprocessor
    extends TreeTranslator {
        private List<Frame> frameStack;
        private int lambdaCount = 0;
        private List<Symbol.ClassSymbol> typesUnderConstruction;
        private SyntheticMethodNameCounter syntheticMethodNameCounts = new SyntheticMethodNameCounter();
        private Map<Symbol, JCTree.JCClassDecl> localClassDefs;
        private Map<Symbol.ClassSymbol, Symbol> clinits = new HashMap<Symbol.ClassSymbol, Symbol>();

        LambdaAnalyzerPreprocessor() {
        }

        private JCTree.JCClassDecl analyzeAndPreprocessClass(JCTree.JCClassDecl tree) {
            this.frameStack = List.nil();
            this.typesUnderConstruction = List.nil();
            this.localClassDefs = new HashMap<Symbol, JCTree.JCClassDecl>();
            return this.translate(tree);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitApply(JCTree.JCMethodInvocation tree) {
            List<Symbol.ClassSymbol> previousNascentTypes = this.typesUnderConstruction;
            try {
                Name methName = TreeInfo.name(tree.meth);
                if (methName == ((LambdaToMethod)LambdaToMethod.this).names._this || methName == ((LambdaToMethod)LambdaToMethod.this).names._super) {
                    this.typesUnderConstruction = this.typesUnderConstruction.prepend(this.currentClass());
                }
                super.visitApply(tree);
            }
            finally {
                this.typesUnderConstruction = previousNascentTypes;
            }
        }

        private Symbol.ClassSymbol currentClass() {
            for (Frame frame : this.frameStack) {
                if (!frame.tree.hasTag(JCTree.Tag.CLASSDEF)) continue;
                JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)frame.tree;
                return cdef.sym;
            }
            return null;
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
            List<Frame> prevStack = this.frameStack;
            try {
                if (this.frameStack.nonEmpty() && ((Frame)this.frameStack.head).tree.hasTag(JCTree.Tag.CLASSDEF)) {
                    this.frameStack = this.frameStack.prepend(new Frame(tree));
                }
                super.visitBlock(tree);
            }
            finally {
                this.frameStack = prevStack;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            List<Frame> prevStack = this.frameStack;
            int prevLambdaCount = this.lambdaCount;
            SyntheticMethodNameCounter prevSyntheticMethodNameCounts = this.syntheticMethodNameCounts;
            Map<Symbol.ClassSymbol, Symbol> prevClinits = this.clinits;
            DiagnosticSource prevSource = LambdaToMethod.this.log.currentSource();
            try {
                LambdaToMethod.this.log.useSource(tree.sym.sourcefile);
                this.lambdaCount = 0;
                this.syntheticMethodNameCounts = new SyntheticMethodNameCounter();
                prevClinits = new HashMap<Symbol.ClassSymbol, Symbol>();
                if (tree.sym.owner.kind == 16) {
                    this.localClassDefs.put(tree.sym, tree);
                }
                if (this.directlyEnclosingLambda() != null) {
                    tree.sym.owner = this.owner();
                    if (tree.sym.hasOuterInstance()) {
                        TranslationContext<?> localContext = this.context();
                        while (localContext != null) {
                            if (((JCTree)localContext.tree).getTag() == JCTree.Tag.LAMBDA) {
                                ((LambdaTranslationContext)localContext).addSymbol(tree.sym.type.getEnclosingType().tsym, LambdaSymbolKind.CAPTURED_THIS);
                            }
                            localContext = localContext.prev;
                        }
                    }
                }
                this.frameStack = this.frameStack.prepend(new Frame(tree));
                super.visitClassDef(tree);
            }
            finally {
                LambdaToMethod.this.log.useSource(prevSource.getFile());
                this.frameStack = prevStack;
                this.lambdaCount = prevLambdaCount;
                this.syntheticMethodNameCounts = prevSyntheticMethodNameCounts;
                this.clinits = prevClinits;
            }
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            if (this.context() != null && this.lambdaIdentSymbolFilter(tree.sym)) {
                if (tree.sym.kind == 4 && tree.sym.owner.kind == 16 && tree.type.constValue() == null) {
                    TranslationContext<?> localContext = this.context();
                    while (localContext != null) {
                        if (((JCTree)localContext.tree).getTag() == JCTree.Tag.LAMBDA) {
                            JCTree block = this.capturedDecl(localContext.depth, tree.sym);
                            if (block == null) break;
                            ((LambdaTranslationContext)localContext).addSymbol(tree.sym, LambdaSymbolKind.CAPTURED_VAR);
                        }
                        localContext = localContext.prev;
                    }
                } else if (tree.sym.owner.kind == 2) {
                    TranslationContext<?> localContext = this.context();
                    while (localContext != null) {
                        if (((JCTree)localContext.tree).hasTag(JCTree.Tag.LAMBDA)) {
                            JCTree block = this.capturedDecl(localContext.depth, tree.sym);
                            if (block == null) break;
                            switch (block.getTag()) {
                                case CLASSDEF: {
                                    JCTree.JCClassDecl cdecl = (JCTree.JCClassDecl)block;
                                    ((LambdaTranslationContext)localContext).addSymbol(cdecl.sym, LambdaSymbolKind.CAPTURED_THIS);
                                    break;
                                }
                                default: {
                                    Assert.error("bad block kind");
                                }
                            }
                        }
                        localContext = localContext.prev;
                    }
                }
            }
            super.visitIdent(tree);
        }

        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            this.analyzeLambda(tree, "lambda.stat");
        }

        private void analyzeLambda(JCTree.JCLambda tree, JCTree.JCExpression methodReferenceReceiver) {
            JCTree.JCExpression rcvr = this.translate(methodReferenceReceiver);
            LambdaTranslationContext context = this.analyzeLambda(tree, "mref.stat.1");
            if (rcvr != null) {
                context.methodReferenceReceiver = rcvr;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LambdaTranslationContext analyzeLambda(JCTree.JCLambda tree, String statKey) {
            List<Frame> prevStack = this.frameStack;
            try {
                LambdaTranslationContext context = new LambdaTranslationContext(tree);
                if (LambdaToMethod.this.dumpLambdaToMethodStats) {
                    LambdaToMethod.this.log.note(tree, statKey, context.needsAltMetafactory(), context.translatedSym);
                }
                this.frameStack = this.frameStack.prepend(new Frame(tree));
                for (JCTree.JCVariableDecl param : tree.params) {
                    context.addSymbol(param.sym, LambdaSymbolKind.PARAM);
                    ((Frame)this.frameStack.head).addLocal(param.sym);
                }
                LambdaToMethod.this.contextMap.put(tree, context);
                super.visitLambda(tree);
                context.complete();
                LambdaTranslationContext lambdaTranslationContext = context;
                return lambdaTranslationContext;
            }
            finally {
                this.frameStack = prevStack;
            }
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            List<Frame> prevStack = this.frameStack;
            try {
                this.frameStack = this.frameStack.prepend(new Frame(tree));
                super.visitMethodDef(tree);
            }
            finally {
                this.frameStack = prevStack;
            }
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass tree) {
            Symbol.TypeSymbol def = tree.type.tsym;
            boolean inReferencedClass = this.currentlyInClass(def);
            boolean isLocal = def.isLocal();
            if (inReferencedClass && isLocal || this.lambdaNewClassFilter(this.context(), tree)) {
                TranslationContext<?> localContext = this.context();
                while (localContext != null) {
                    if (((JCTree)localContext.tree).getTag() == JCTree.Tag.LAMBDA) {
                        ((LambdaTranslationContext)localContext).addSymbol(tree.type.getEnclosingType().tsym, LambdaSymbolKind.CAPTURED_THIS);
                    }
                    localContext = localContext.prev;
                }
            }
            if (this.context() != null && !inReferencedClass && isLocal) {
                LambdaTranslationContext lambdaContext = (LambdaTranslationContext)this.context();
                this.captureLocalClassDefs(def, lambdaContext);
            }
            super.visitNewClass(tree);
        }

        void captureLocalClassDefs(Symbol csym, final LambdaTranslationContext lambdaContext) {
            JCTree.JCClassDecl localCDef = this.localClassDefs.get(csym);
            if (localCDef != null && lambdaContext.freeVarProcessedLocalClasses.add(csym)) {
                Lower lower = LambdaToMethod.this.lower;
                lower.getClass();
                Lower.BasicFreeVarCollector fvc = new Lower.BasicFreeVarCollector(lower){

                    @Override
                    void addFreeVars(Symbol.ClassSymbol c) {
                        LambdaAnalyzerPreprocessor.this.captureLocalClassDefs(c, lambdaContext);
                    }

                    @Override
                    void visitSymbol(Symbol sym) {
                        if (sym.kind == 4 && sym.owner.kind == 16 && ((Symbol.VarSymbol)sym).getConstValue() == null) {
                            TranslationContext<?> localContext = LambdaAnalyzerPreprocessor.this.context();
                            while (localContext != null) {
                                if (((JCTree)localContext.tree).getTag() == JCTree.Tag.LAMBDA) {
                                    JCTree block = LambdaAnalyzerPreprocessor.this.capturedDecl(localContext.depth, sym);
                                    if (block == null) break;
                                    ((LambdaTranslationContext)localContext).addSymbol(sym, LambdaSymbolKind.CAPTURED_VAR);
                                }
                                localContext = localContext.prev;
                            }
                        }
                    }
                };
                fvc.scan(localCDef);
            }
        }

        boolean currentlyInClass(Symbol csym) {
            for (Frame frame : this.frameStack) {
                if (!frame.tree.hasTag(JCTree.Tag.CLASSDEF)) continue;
                JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)frame.tree;
                if (cdef.sym != csym) continue;
                return true;
            }
            return false;
        }

        @Override
        public void visitReference(JCTree.JCMemberReference tree) {
            ReferenceTranslationContext rcontext = new ReferenceTranslationContext(tree);
            LambdaToMethod.this.contextMap.put(tree, rcontext);
            if (rcontext.needsConversionToLambda()) {
                MemberReferenceToLambda conv = new MemberReferenceToLambda(tree, rcontext, this.owner());
                this.analyzeLambda(conv.lambda(), conv.getReceiverExpression());
            } else {
                super.visitReference(tree);
                if (LambdaToMethod.this.dumpLambdaToMethodStats) {
                    LambdaToMethod.this.log.note(tree, "mref.stat", rcontext.needsAltMetafactory(), null);
                }
            }
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            if (this.context() != null && tree.sym.kind == 4 && (tree.sym.name == ((LambdaToMethod)LambdaToMethod.this).names._this || tree.sym.name == ((LambdaToMethod)LambdaToMethod.this).names._super)) {
                TranslationContext<?> localContext = this.context();
                while (localContext != null) {
                    if (((JCTree)localContext.tree).hasTag(JCTree.Tag.LAMBDA)) {
                        JCTree.JCClassDecl clazz = (JCTree.JCClassDecl)this.capturedDecl(localContext.depth, tree.sym);
                        if (clazz == null) break;
                        ((LambdaTranslationContext)localContext).addSymbol(clazz.sym, LambdaSymbolKind.CAPTURED_THIS);
                    }
                    localContext = localContext.prev;
                }
            }
            super.visitSelect(tree);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            LambdaTranslationContext ltc;
            TranslationContext<?> context = this.context();
            LambdaTranslationContext lambdaTranslationContext = ltc = context != null && context instanceof LambdaTranslationContext ? (LambdaTranslationContext)context : null;
            if (ltc != null) {
                if (((Frame)this.frameStack.head).tree.hasTag(JCTree.Tag.LAMBDA)) {
                    ltc.addSymbol(tree.sym, LambdaSymbolKind.LOCAL_VAR);
                }
                TypeMirror type = tree.sym.asType();
                if (this.inClassWithinLambda() && !LambdaToMethod.this.types.isSameType(LambdaToMethod.this.types.erasure((Type)type), (Type)type)) {
                    ltc.addSymbol(tree.sym, LambdaSymbolKind.TYPE_VAR);
                }
            }
            List<Frame> prevStack = this.frameStack;
            try {
                if (tree.sym.owner.kind == 16) {
                    ((Frame)this.frameStack.head).addLocal(tree.sym);
                }
                this.frameStack = this.frameStack.prepend(new Frame(tree));
                super.visitVarDef(tree);
            }
            finally {
                this.frameStack = prevStack;
            }
        }

        private Symbol owner() {
            return this.owner(false);
        }

        private Symbol owner(boolean skipLambda) {
            List<Frame> frameStack2 = this.frameStack;
            block7: while (frameStack2.nonEmpty()) {
                switch (((Frame)frameStack2.head).tree.getTag()) {
                    case VARDEF: {
                        if (((JCTree.JCVariableDecl)((Frame)frameStack2.head).tree).sym.isLocal()) {
                            frameStack2 = frameStack2.tail;
                            continue block7;
                        }
                        JCTree.JCClassDecl cdecl = (JCTree.JCClassDecl)((Frame)frameStack2.tail.head).tree;
                        return this.initSym(cdecl.sym, ((JCTree.JCVariableDecl)((Frame)frameStack2.head).tree).sym.flags() & 8L);
                    }
                    case BLOCK: {
                        JCTree.JCClassDecl cdecl2 = (JCTree.JCClassDecl)((Frame)frameStack2.tail.head).tree;
                        return this.initSym(cdecl2.sym, ((JCTree.JCBlock)((Frame)frameStack2.head).tree).flags & 8L);
                    }
                    case CLASSDEF: {
                        return ((JCTree.JCClassDecl)((Frame)frameStack2.head).tree).sym;
                    }
                    case METHODDEF: {
                        return ((JCTree.JCMethodDecl)((Frame)frameStack2.head).tree).sym;
                    }
                    case LAMBDA: {
                        if (skipLambda) break;
                        return ((LambdaTranslationContext)((LambdaToMethod)LambdaToMethod.this).contextMap.get((Object)((Frame)frameStack2.head).tree)).translatedSym;
                    }
                }
                frameStack2 = frameStack2.tail;
            }
            Assert.error();
            return null;
        }

        private Symbol initSym(Symbol.ClassSymbol csym, long flags) {
            boolean isStatic;
            boolean bl = isStatic = (flags & 8L) != 0L;
            if (isStatic) {
                Symbol.MethodSymbol clinit = LambdaToMethod.this.attr.removeClinit(csym);
                if (clinit != null) {
                    this.clinits.put(csym, clinit);
                    return clinit;
                }
                clinit = (Symbol.MethodSymbol)this.clinits.get(csym);
                if (clinit == null) {
                    clinit = LambdaToMethod.this.makePrivateSyntheticMethod(8L, ((LambdaToMethod)LambdaToMethod.this).names.clinit, new Type.MethodType(List.nil(), ((LambdaToMethod)LambdaToMethod.this).syms.voidType, List.nil(), ((LambdaToMethod)LambdaToMethod.this).syms.methodClass), csym);
                    this.clinits.put(csym, clinit);
                }
                return clinit;
            }
            Iterator<Symbol> iterator = csym.members_field.getElementsByName(((LambdaToMethod)LambdaToMethod.this).names.init).iterator();
            if (iterator.hasNext()) {
                Symbol s = iterator.next();
                return s;
            }
            Assert.error("init not found");
            return null;
        }

        private JCTree directlyEnclosingLambda() {
            if (this.frameStack.isEmpty()) {
                return null;
            }
            List<Frame> frameStack2 = this.frameStack;
            while (frameStack2.nonEmpty()) {
                switch (((Frame)frameStack2.head).tree.getTag()) {
                    case CLASSDEF: 
                    case METHODDEF: {
                        return null;
                    }
                    case LAMBDA: {
                        return ((Frame)frameStack2.head).tree;
                    }
                }
                frameStack2 = frameStack2.tail;
            }
            Assert.error();
            return null;
        }

        private boolean inClassWithinLambda() {
            if (this.frameStack.isEmpty()) {
                return false;
            }
            List<Frame> frameStack2 = this.frameStack;
            boolean classFound = false;
            block4: while (frameStack2.nonEmpty()) {
                switch (((Frame)frameStack2.head).tree.getTag()) {
                    case LAMBDA: {
                        return classFound;
                    }
                    case CLASSDEF: {
                        classFound = true;
                        frameStack2 = frameStack2.tail;
                        continue block4;
                    }
                }
                frameStack2 = frameStack2.tail;
            }
            return false;
        }

        private JCTree capturedDecl(int depth, Symbol sym) {
            int currentDepth = this.frameStack.size() - 1;
            for (Frame block : this.frameStack) {
                switch (block.tree.getTag()) {
                    case CLASSDEF: {
                        Symbol.ClassSymbol clazz = ((JCTree.JCClassDecl)block.tree).sym;
                        if (!sym.isMemberOf(clazz, LambdaToMethod.this.types)) break;
                        return currentDepth > depth ? null : block.tree;
                    }
                    case VARDEF: {
                        if (((JCTree.JCVariableDecl)block.tree).sym != sym || sym.owner.kind != 16) break;
                        return currentDepth > depth ? null : block.tree;
                    }
                    case BLOCK: 
                    case METHODDEF: 
                    case LAMBDA: {
                        if (block.locals == null || !block.locals.contains(sym)) break;
                        return currentDepth > depth ? null : block.tree;
                    }
                    default: {
                        Assert.error("bad decl kind " + (Object)((Object)block.tree.getTag()));
                    }
                }
                --currentDepth;
            }
            return null;
        }

        private TranslationContext<?> context() {
            for (Frame frame : this.frameStack) {
                TranslationContext context = (TranslationContext)LambdaToMethod.this.contextMap.get(frame.tree);
                if (context == null) continue;
                return context;
            }
            return null;
        }

        private boolean lambdaIdentSymbolFilter(Symbol sym) {
            return (sym.kind == 4 || sym.kind == 16) && !sym.isStatic() && sym.name != ((LambdaToMethod)LambdaToMethod.this).names.init;
        }

        private boolean lambdaFieldAccessFilter(JCTree.JCFieldAccess fAccess) {
            LambdaTranslationContext lambdaContext = LambdaToMethod.this.context instanceof LambdaTranslationContext ? (LambdaTranslationContext)LambdaToMethod.this.context : null;
            return lambdaContext != null && !fAccess.sym.isStatic() && fAccess.name == ((LambdaToMethod)LambdaToMethod.this).names._this && fAccess.sym.owner.kind == 2 && !lambdaContext.translatedSymbols.get((Object)LambdaSymbolKind.CAPTURED_OUTER_THIS).isEmpty();
        }

        private boolean lambdaNewClassFilter(TranslationContext<?> context, JCTree.JCNewClass tree) {
            if (context != null && tree.encl == null && tree.def == null && !tree.type.getEnclosingType().hasTag(TypeTag.NONE)) {
                Type encl = tree.type.getEnclosingType();
                Type current = context.owner.enclClass().type;
                while (!current.hasTag(TypeTag.NONE)) {
                    if (current.tsym.isSubClass(encl.tsym, LambdaToMethod.this.types)) {
                        return true;
                    }
                    current = current.getEnclosingType();
                }
                return false;
            }
            return false;
        }

        final class ReferenceTranslationContext
        extends TranslationContext<JCTree.JCMemberReference> {
            final boolean isSuper;
            final Symbol sigPolySym;

            ReferenceTranslationContext(JCTree.JCMemberReference tree) {
                super(LambdaAnalyzerPreprocessor.this, (JCTree.JCFunctionalExpression)tree);
                this.isSuper = tree.hasKind(JCTree.JCMemberReference.ReferenceKind.SUPER);
                this.sigPolySym = this.isSignaturePolymorphic() ? LambdaToMethod.this.makePrivateSyntheticMethod(tree.sym.flags(), tree.sym.name, this.bridgedRefSig(), tree.sym.enclClass()) : null;
            }

            int referenceKind() {
                return LambdaToMethod.this.referenceKind(((JCTree.JCMemberReference)this.tree).sym);
            }

            boolean needsVarArgsConversion() {
                return ((JCTree.JCMemberReference)this.tree).varargsElement != null;
            }

            boolean isArrayOp() {
                return ((JCTree.JCMemberReference)this.tree).sym.owner == ((LambdaToMethod)LambdaToMethod.this).syms.arrayClass;
            }

            boolean receiverAccessible() {
                return ((JCTree.JCMemberReference)this.tree).ownerAccessible;
            }

            boolean isPrivateInOtherClass() {
                return (((JCTree.JCMemberReference)this.tree).sym.flags() & 2L) != 0L && !LambdaToMethod.this.types.isSameType(LambdaToMethod.this.types.erasure((Type)((JCTree.JCMemberReference)this.tree).sym.enclClass().asType()), LambdaToMethod.this.types.erasure((Type)this.owner.enclClass().asType()));
            }

            final boolean isSignaturePolymorphic() {
                return ((JCTree.JCMemberReference)this.tree).sym.kind == 16 && LambdaToMethod.this.types.isSignaturePolymorphic((Symbol.MethodSymbol)((JCTree.JCMemberReference)this.tree).sym);
            }

            boolean interfaceParameterIsIntersectionType() {
                List<Type> tl = ((JCTree.JCMemberReference)this.tree).getDescriptorType(LambdaToMethod.this.types).getParameterTypes();
                if (((JCTree.JCMemberReference)this.tree).kind == JCTree.JCMemberReference.ReferenceKind.UNBOUND) {
                    tl = tl.tail;
                }
                while (tl.nonEmpty()) {
                    Type pt = (Type)tl.head;
                    if (pt.getKind() == TypeKind.TYPEVAR) {
                        Type.TypeVar tv = (Type.TypeVar)pt;
                        if (tv.bound.getKind() == TypeKind.INTERSECTION) {
                            return true;
                        }
                    }
                    tl = tl.tail;
                }
                return false;
            }

            final boolean needsConversionToLambda() {
                return this.interfaceParameterIsIntersectionType() || this.isSuper || this.needsVarArgsConversion() || this.isArrayOp() || this.isPrivateInOtherClass() || !this.receiverAccessible() || ((JCTree.JCMemberReference)this.tree).getMode() == MemberReferenceTree.ReferenceMode.NEW && ((JCTree.JCMemberReference)this.tree).kind != JCTree.JCMemberReference.ReferenceKind.ARRAY_CTOR && (((JCTree.JCMemberReference)this.tree).sym.owner.isLocal() || ((JCTree.JCMemberReference)this.tree).sym.owner.isInner());
            }

            Type generatedRefSig() {
                return LambdaToMethod.this.types.erasure(((JCTree.JCMemberReference)this.tree).sym.type);
            }

            Type bridgedRefSig() {
                return LambdaToMethod.this.types.erasure(((LambdaToMethod)LambdaToMethod.this).types.findDescriptorSymbol((Symbol.TypeSymbol)((Type)((JCTree.JCMemberReference)this.tree).targets.head).tsym).type);
            }
        }

        class LambdaTranslationContext
        extends TranslationContext<JCTree.JCLambda> {
            final Symbol self;
            final Symbol assignedTo;
            Map<LambdaSymbolKind, Map<Symbol, Symbol>> translatedSymbols;
            Symbol.MethodSymbol translatedSym;
            List<JCTree.JCVariableDecl> syntheticParams;
            final Set<Symbol> freeVarProcessedLocalClasses;
            JCTree.JCExpression methodReferenceReceiver;

            LambdaTranslationContext(JCTree.JCLambda tree) {
                super(LambdaAnalyzerPreprocessor.this, (JCTree.JCFunctionalExpression)tree);
                Frame frame = (Frame)((LambdaAnalyzerPreprocessor)LambdaAnalyzerPreprocessor.this).frameStack.head;
                switch (frame.tree.getTag()) {
                    case VARDEF: {
                        this.assignedTo = this.self = ((JCTree.JCVariableDecl)frame.tree).sym;
                        break;
                    }
                    case ASSIGN: {
                        this.self = null;
                        this.assignedTo = TreeInfo.symbol(((JCTree.JCAssign)frame.tree).getVariable());
                        break;
                    }
                    default: {
                        this.self = null;
                        this.assignedTo = null;
                    }
                }
                this.translatedSym = LambdaToMethod.this.makePrivateSyntheticMethod(0L, null, null, this.owner.enclClass());
                this.translatedSymbols = new EnumMap<LambdaSymbolKind, Map<Symbol, Symbol>>(LambdaSymbolKind.class);
                this.translatedSymbols.put(LambdaSymbolKind.PARAM, new LinkedHashMap());
                this.translatedSymbols.put(LambdaSymbolKind.LOCAL_VAR, new LinkedHashMap());
                this.translatedSymbols.put(LambdaSymbolKind.CAPTURED_VAR, new LinkedHashMap());
                this.translatedSymbols.put(LambdaSymbolKind.CAPTURED_THIS, new LinkedHashMap());
                this.translatedSymbols.put(LambdaSymbolKind.CAPTURED_OUTER_THIS, new LinkedHashMap());
                this.translatedSymbols.put(LambdaSymbolKind.TYPE_VAR, new LinkedHashMap());
                this.freeVarProcessedLocalClasses = new HashSet<Symbol>();
            }

            private String serializedLambdaDisambiguation() {
                StringBuilder buf = new StringBuilder();
                Assert.check(this.owner.type != null || LambdaAnalyzerPreprocessor.this.directlyEnclosingLambda() != null);
                if (this.owner.type != null) {
                    buf.append(LambdaToMethod.this.typeSig(this.owner.type));
                    buf.append(":");
                }
                buf.append(((LambdaToMethod)LambdaToMethod.this).types.findDescriptorSymbol((Symbol.TypeSymbol)((JCTree.JCLambda)this.tree).type.tsym).owner.flatName());
                buf.append(" ");
                if (this.assignedTo != null) {
                    buf.append(this.assignedTo.flatName());
                    buf.append("=");
                }
                for (Symbol fv : this.getSymbolMap(LambdaSymbolKind.CAPTURED_VAR).keySet()) {
                    if (fv == this.self) continue;
                    buf.append(LambdaToMethod.this.typeSig(fv.type));
                    buf.append(" ");
                    buf.append(fv.flatName());
                    buf.append(",");
                }
                return buf.toString();
            }

            private Name lambdaName() {
                return ((LambdaToMethod)LambdaToMethod.this).names.lambda.append(LambdaToMethod.this.names.fromString(this.enclosingMethodName() + "$" + LambdaAnalyzerPreprocessor.this.lambdaCount++));
            }

            private Name serializedLambdaName() {
                StringBuilder buf = new StringBuilder();
                buf.append(((LambdaToMethod)LambdaToMethod.this).names.lambda);
                buf.append(this.enclosingMethodName());
                buf.append('$');
                String disam = this.serializedLambdaDisambiguation();
                buf.append(Integer.toHexString(disam.hashCode()));
                buf.append('$');
                buf.append(LambdaAnalyzerPreprocessor.this.syntheticMethodNameCounts.getIndex(buf));
                String result = buf.toString();
                return LambdaToMethod.this.names.fromString(result);
            }

            Symbol translate(final Symbol sym, LambdaSymbolKind skind) {
                Symbol ret;
                switch (skind) {
                    case CAPTURED_THIS: {
                        ret = sym;
                        break;
                    }
                    case TYPE_VAR: {
                        ret = new Symbol.VarSymbol(sym.flags(), sym.name, LambdaToMethod.this.types.erasure(sym.type), sym.owner);
                        ((Symbol.VarSymbol)ret).pos = ((Symbol.VarSymbol)sym).pos;
                        break;
                    }
                    case CAPTURED_VAR: {
                        ret = new Symbol.VarSymbol(0x200001010L, sym.name, LambdaToMethod.this.types.erasure(sym.type), this.translatedSym){

                            @Override
                            public Symbol baseSymbol() {
                                return sym;
                            }
                        };
                        break;
                    }
                    case CAPTURED_OUTER_THIS: {
                        Name name = LambdaToMethod.this.names.fromString(new String(sym.flatName().toString() + ((LambdaToMethod)LambdaToMethod.this).names.dollarThis));
                        ret = new Symbol.VarSymbol(0x200001010L, name, LambdaToMethod.this.types.erasure(sym.type), this.translatedSym){

                            @Override
                            public Symbol baseSymbol() {
                                return sym;
                            }
                        };
                        break;
                    }
                    case LOCAL_VAR: {
                        ret = new Symbol.VarSymbol(sym.flags() & 0x10L, sym.name, sym.type, this.translatedSym);
                        ((Symbol.VarSymbol)ret).pos = ((Symbol.VarSymbol)sym).pos;
                        break;
                    }
                    case PARAM: {
                        ret = new Symbol.VarSymbol(sym.flags() & 0x10L | 0x200000000L, sym.name, LambdaToMethod.this.types.erasure(sym.type), this.translatedSym);
                        ((Symbol.VarSymbol)ret).pos = ((Symbol.VarSymbol)sym).pos;
                        break;
                    }
                    default: {
                        Assert.error(skind.name());
                        throw new AssertionError();
                    }
                }
                if (ret != sym && skind.propagateAnnotations()) {
                    ret.setDeclarationAttributes(sym.getRawAttributes());
                    ret.setTypeAttributes(sym.getRawTypeAttributes());
                }
                return ret;
            }

            void addSymbol(Symbol sym, LambdaSymbolKind skind) {
                Map<Symbol, Symbol> transMap;
                Symbol.ClassSymbol currentClass;
                if (skind == LambdaSymbolKind.CAPTURED_THIS && sym != null && sym.kind == 2 && !LambdaAnalyzerPreprocessor.this.typesUnderConstruction.isEmpty() && (currentClass = LambdaAnalyzerPreprocessor.this.currentClass()) != null && LambdaAnalyzerPreprocessor.this.typesUnderConstruction.contains(currentClass)) {
                    Assert.check(sym != currentClass);
                    skind = LambdaSymbolKind.CAPTURED_OUTER_THIS;
                }
                if (!(transMap = this.getSymbolMap(skind)).containsKey(sym)) {
                    transMap.put(sym, this.translate(sym, skind));
                }
            }

            Map<Symbol, Symbol> getSymbolMap(LambdaSymbolKind skind) {
                Map<Symbol, Symbol> m = this.translatedSymbols.get((Object)skind);
                Assert.checkNonNull(m);
                return m;
            }

            JCTree translate(JCTree.JCIdent lambdaIdent) {
                block3: for (LambdaSymbolKind kind : LambdaSymbolKind.values()) {
                    Map<Symbol, Symbol> m = this.getSymbolMap(kind);
                    switch (kind) {
                        default: {
                            if (!m.containsKey(lambdaIdent.sym)) continue block3;
                            Symbol tSym = m.get(lambdaIdent.sym);
                            JCTree.JCExpression t = LambdaToMethod.this.make.Ident(tSym).setType(lambdaIdent.type);
                            return t;
                        }
                        case CAPTURED_OUTER_THIS: {
                            if (lambdaIdent.sym.owner.kind != 2 || !m.containsKey(lambdaIdent.sym.owner)) continue block3;
                            Symbol tSym = m.get(lambdaIdent.sym.owner);
                            JCTree.JCExpression t = LambdaToMethod.this.make.Ident(tSym).setType(lambdaIdent.sym.owner.type);
                            t = LambdaToMethod.this.make.Select(t, lambdaIdent.name);
                            t.setType(lambdaIdent.type);
                            TreeInfo.setSymbol(t, lambdaIdent.sym);
                            return t;
                        }
                    }
                }
                return null;
            }

            public JCTree translate(JCTree.JCFieldAccess fieldAccess) {
                Assert.check(fieldAccess.name == ((LambdaToMethod)LambdaToMethod.this).names._this);
                Map<Symbol, Symbol> m = this.translatedSymbols.get((Object)LambdaSymbolKind.CAPTURED_OUTER_THIS);
                if (m.containsKey(fieldAccess.sym.owner)) {
                    Symbol tSym = m.get(fieldAccess.sym.owner);
                    JCTree.JCExpression t = LambdaToMethod.this.make.Ident(tSym).setType(fieldAccess.sym.owner.type);
                    return t;
                }
                return null;
            }

            void complete() {
                if (this.syntheticParams != null) {
                    return;
                }
                boolean inInterface = this.translatedSym.owner.isInterface();
                boolean thisReferenced = !this.getSymbolMap(LambdaSymbolKind.CAPTURED_THIS).isEmpty();
                this.translatedSym.flags_field = 0x2000000001000L | this.owner.flags_field & 0x800L | this.owner.owner.flags_field & 0x800L | 2L | (thisReferenced ? (inInterface ? 0x80000000000L : 0L) : 8L);
                ListBuffer<JCTree.JCVariableDecl> params = new ListBuffer<JCTree.JCVariableDecl>();
                ListBuffer<Symbol.VarSymbol> parameterSymbols = new ListBuffer<Symbol.VarSymbol>();
                for (Symbol thisSym : this.getSymbolMap(LambdaSymbolKind.CAPTURED_VAR).values()) {
                    params.append(LambdaToMethod.this.make.VarDef((Symbol.VarSymbol)thisSym, null));
                    parameterSymbols.append((Symbol.VarSymbol)thisSym);
                }
                for (Symbol thisSym : this.getSymbolMap(LambdaSymbolKind.CAPTURED_OUTER_THIS).values()) {
                    params.append(LambdaToMethod.this.make.VarDef((Symbol.VarSymbol)thisSym, null));
                    parameterSymbols.append((Symbol.VarSymbol)thisSym);
                }
                for (Symbol thisSym : this.getSymbolMap(LambdaSymbolKind.PARAM).values()) {
                    params.append(LambdaToMethod.this.make.VarDef((Symbol.VarSymbol)thisSym, null));
                    parameterSymbols.append((Symbol.VarSymbol)thisSym);
                }
                this.syntheticParams = params.toList();
                this.translatedSym.params = parameterSymbols.toList();
                this.translatedSym.name = this.isSerializable() ? this.serializedLambdaName() : this.lambdaName();
                this.translatedSym.type = LambdaToMethod.this.types.createMethodTypeWithParameters(this.generatedLambdaSig(), TreeInfo.types(this.syntheticParams));
            }

            Type generatedLambdaSig() {
                return LambdaToMethod.this.types.erasure(((JCTree.JCLambda)this.tree).getDescriptorType(LambdaToMethod.this.types));
            }
        }

        static abstract class TranslationContext<T extends JCTree.JCFunctionalExpression> {
            final T tree;
            final Symbol owner;
            final int depth;
            final TranslationContext<?> prev;
            final List<Symbol> bridges;
            final /* synthetic */ LambdaAnalyzerPreprocessor this$1;

            TranslationContext(T tree) {
                this.this$1 = this$1;
                this.tree = tree;
                this.owner = ((LambdaAnalyzerPreprocessor)this$1).owner();
                this.depth = ((LambdaAnalyzerPreprocessor)this$1).frameStack.size() - 1;
                this.prev = ((LambdaAnalyzerPreprocessor)this$1).context();
                Symbol.ClassSymbol csym = this$1.LambdaToMethod.this.types.makeFunctionalInterfaceClass(this$1.LambdaToMethod.this.attrEnv, ((LambdaToMethod)this$1.LambdaToMethod.this).names.empty, ((JCTree.JCFunctionalExpression)tree).targets, 1536L);
                this.bridges = this$1.LambdaToMethod.this.types.functionalInterfaceBridges(csym);
            }

            boolean needsAltMetafactory() {
                return ((JCTree.JCFunctionalExpression)this.tree).targets.length() > 1 || this.isSerializable() || this.bridges.length() > 1;
            }

            boolean isSerializable() {
                if (this.this$1.LambdaToMethod.this.forceSerializable) {
                    return true;
                }
                for (Type target : ((JCTree.JCFunctionalExpression)this.tree).targets) {
                    if (this.this$1.LambdaToMethod.this.types.asSuper(target, ((LambdaToMethod)this.this$1.LambdaToMethod.this).syms.serializableType.tsym) == null) continue;
                    return true;
                }
                return false;
            }

            String enclosingMethodName() {
                return this.syntheticMethodNameComponent(this.owner.name);
            }

            String syntheticMethodNameComponent(Name name) {
                if (name == null) {
                    return "null";
                }
                String methodName = name.toString();
                if (methodName.equals("<clinit>")) {
                    methodName = "static";
                } else if (methodName.equals("<init>")) {
                    methodName = "new";
                }
                return methodName;
            }
        }

        private class Frame {
            final JCTree tree;
            List<Symbol> locals;

            public Frame(JCTree tree) {
                this.tree = tree;
            }

            void addLocal(Symbol sym) {
                if (this.locals == null) {
                    this.locals = List.nil();
                }
                this.locals = this.locals.prepend(sym);
            }
        }

        private class SyntheticMethodNameCounter {
            private Map<String, Integer> map = new HashMap<String, Integer>();

            private SyntheticMethodNameCounter() {
            }

            int getIndex(StringBuilder buf) {
                String temp = buf.toString();
                Integer count = this.map.get(temp);
                if (count == null) {
                    count = 0;
                }
                count = count + 1;
                this.map.put(temp, count);
                return count;
            }
        }
    }

    private class MemberReferenceToLambda {
        private final JCTree.JCMemberReference tree;
        private final LambdaAnalyzerPreprocessor.ReferenceTranslationContext localContext;
        private final Symbol owner;
        private final ListBuffer<JCTree.JCExpression> args = new ListBuffer();
        private final ListBuffer<JCTree.JCVariableDecl> params = new ListBuffer();
        private JCTree.JCExpression receiverExpression = null;

        MemberReferenceToLambda(JCTree.JCMemberReference tree, LambdaAnalyzerPreprocessor.ReferenceTranslationContext localContext, Symbol owner) {
            this.tree = tree;
            this.localContext = localContext;
            this.owner = owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        JCTree.JCLambda lambda() {
            int prevPos = ((LambdaToMethod)LambdaToMethod.this).make.pos;
            try {
                LambdaToMethod.this.make.at(this.tree);
                Symbol.VarSymbol rcvr = this.addParametersReturnReceiver();
                JCTree.JCExpression expr = this.tree.getMode() == MemberReferenceTree.ReferenceMode.INVOKE ? this.expressionInvoke(rcvr) : this.expressionNew();
                JCTree.JCLambda slam = LambdaToMethod.this.make.Lambda(this.params.toList(), expr);
                slam.targets = this.tree.targets;
                slam.type = this.tree.type;
                slam.pos = this.tree.pos;
                JCTree.JCLambda jCLambda = slam;
                return jCLambda;
            }
            finally {
                LambdaToMethod.this.make.at(prevPos);
            }
        }

        Symbol.VarSymbol addParametersReturnReceiver() {
            int i;
            Symbol.VarSymbol rcvr;
            Type samDesc = this.localContext.bridgedRefSig();
            List<Type> samPTypes = samDesc.getParameterTypes();
            List<Type> descPTypes = this.tree.getDescriptorType(LambdaToMethod.this.types).getParameterTypes();
            switch (this.tree.kind) {
                case BOUND: {
                    rcvr = this.addParameter("rec$", this.tree.getQualifierExpression().type, false);
                    this.receiverExpression = LambdaToMethod.this.attr.makeNullCheck(this.tree.getQualifierExpression());
                    break;
                }
                case UNBOUND: {
                    rcvr = this.addParameter("rec$", (Type)samDesc.getParameterTypes().head, false);
                    samPTypes = samPTypes.tail;
                    descPTypes = descPTypes.tail;
                    break;
                }
                default: {
                    rcvr = null;
                }
            }
            List<Type> implPTypes = this.tree.sym.type.getParameterTypes();
            int implSize = implPTypes.size();
            int samSize = samPTypes.size();
            int last = this.localContext.needsVarArgsConversion() ? implSize - 1 : implSize;
            boolean checkForIntersection = this.tree.varargsElement != null || implSize == descPTypes.size();
            for (i = 0; implPTypes.nonEmpty() && i < last; ++i) {
                Type parmType = (Type)implPTypes.head;
                if (checkForIntersection && ((Type)descPTypes.head).getKind() == TypeKind.TYPEVAR) {
                    Type.TypeVar tv = (Type.TypeVar)descPTypes.head;
                    if (tv.bound.getKind() == TypeKind.INTERSECTION) {
                        parmType = (Type)samPTypes.head;
                    }
                }
                this.addParameter("x$" + i, parmType, true);
                implPTypes = implPTypes.tail;
                samPTypes = samPTypes.tail;
                descPTypes = descPTypes.tail;
            }
            for (i = last; i < samSize; ++i) {
                this.addParameter("xva$" + i, this.tree.varargsElement, true);
            }
            return rcvr;
        }

        JCTree.JCExpression getReceiverExpression() {
            return this.receiverExpression;
        }

        private JCTree.JCExpression makeReceiver(Symbol.VarSymbol rcvr) {
            Type rcvrType;
            if (rcvr == null) {
                return null;
            }
            JCTree.JCExpression rcvrExpr = LambdaToMethod.this.make.Ident(rcvr);
            Type type = rcvrType = this.tree.ownerAccessible ? this.tree.sym.enclClass().type : this.tree.expr.type;
            if (rcvrType == ((LambdaToMethod)LambdaToMethod.this).syms.arrayClass.type) {
                rcvrType = this.tree.getQualifierExpression().type;
            }
            if (!rcvr.type.tsym.isSubClass(rcvrType.tsym, LambdaToMethod.this.types)) {
                rcvrExpr = LambdaToMethod.this.make.TypeCast(LambdaToMethod.this.make.Type(rcvrType), rcvrExpr).setType(rcvrType);
            }
            return rcvrExpr;
        }

        private JCTree.JCExpression expressionInvoke(Symbol.VarSymbol rcvr) {
            JCTree.JCExpression qualifier = rcvr != null ? this.makeReceiver(rcvr) : this.tree.getQualifierExpression();
            JCTree.JCFieldAccess select = LambdaToMethod.this.make.Select(qualifier, this.tree.sym.name);
            select.sym = this.tree.sym;
            select.type = this.tree.sym.erasure(LambdaToMethod.this.types);
            JCTree.JCExpression apply = LambdaToMethod.this.make.Apply(List.nil(), select, LambdaToMethod.this.convertArgs(this.tree.sym, this.args.toList(), this.tree.varargsElement)).setType(this.tree.sym.erasure(LambdaToMethod.this.types).getReturnType());
            apply = LambdaToMethod.this.transTypes.coerce(apply, this.localContext.generatedRefSig().getReturnType());
            LambdaToMethod.this.setVarargsIfNeeded(apply, this.tree.varargsElement);
            return apply;
        }

        private JCTree.JCExpression expressionNew() {
            if (this.tree.kind == JCTree.JCMemberReference.ReferenceKind.ARRAY_CTOR) {
                JCTree.JCNewArray newArr = LambdaToMethod.this.make.NewArray(LambdaToMethod.this.make.Type(LambdaToMethod.this.types.elemtype(this.tree.getQualifierExpression().type)), List.of(LambdaToMethod.this.make.Ident(this.params.first())), null);
                newArr.type = this.tree.getQualifierExpression().type;
                return newArr;
            }
            JCTree.JCNewClass newClass = LambdaToMethod.this.make.NewClass(null, List.nil(), LambdaToMethod.this.make.Type(this.tree.getQualifierExpression().type), LambdaToMethod.this.convertArgs(this.tree.sym, this.args.toList(), this.tree.varargsElement), null);
            newClass.constructor = this.tree.sym;
            newClass.constructorType = this.tree.sym.erasure(LambdaToMethod.this.types);
            newClass.type = this.tree.getQualifierExpression().type;
            LambdaToMethod.this.setVarargsIfNeeded(newClass, this.tree.varargsElement);
            return newClass;
        }

        private Symbol.VarSymbol addParameter(String name, Type p, boolean genArg) {
            Symbol.VarSymbol vsym = new Symbol.VarSymbol(0x200001000L, LambdaToMethod.this.names.fromString(name), p, this.owner);
            vsym.pos = this.tree.pos;
            this.params.append(LambdaToMethod.this.make.VarDef(vsym, null));
            if (genArg) {
                this.args.append(LambdaToMethod.this.make.Ident(vsym));
            }
            return vsym;
        }
    }

    private class KlassInfo {
        private ListBuffer<JCTree> appendedMethodList;
        private final Map<String, ListBuffer<JCTree.JCStatement>> deserializeCases;
        private final Symbol.MethodSymbol deserMethodSym;
        private final Symbol.VarSymbol deserParamSym;
        private final JCTree.JCClassDecl clazz;

        private KlassInfo(JCTree.JCClassDecl clazz) {
            this.clazz = clazz;
            this.appendedMethodList = new ListBuffer();
            this.deserializeCases = new HashMap<String, ListBuffer<JCTree.JCStatement>>();
            Type.MethodType type = new Type.MethodType(List.of(((LambdaToMethod)LambdaToMethod.this).syms.serializedLambdaType), ((LambdaToMethod)LambdaToMethod.this).syms.objectType, List.nil(), ((LambdaToMethod)LambdaToMethod.this).syms.methodClass);
            this.deserMethodSym = LambdaToMethod.this.makePrivateSyntheticMethod(8L, ((LambdaToMethod)LambdaToMethod.this).names.deserializeLambda, type, clazz.sym);
            this.deserParamSym = new Symbol.VarSymbol(16L, LambdaToMethod.this.names.fromString("lambda"), ((LambdaToMethod)LambdaToMethod.this).syms.serializedLambdaType, this.deserMethodSym);
        }

        private void addMethod(JCTree decl) {
            this.appendedMethodList = this.appendedMethodList.prepend(decl);
        }
    }
}

