/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.parser.UnicodeReader;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Position;
import java.nio.CharBuffer;

public class JavaTokenizer {
    private static final boolean scannerDebug = false;
    private boolean allowHexFloats;
    private boolean allowBinaryLiterals;
    private boolean allowUnderscoresInLiterals;
    private Source source;
    private final Log log;
    private final Tokens tokens;
    protected Tokens.TokenKind tk;
    protected int radix;
    protected Name name;
    protected int errPos = -1;
    protected UnicodeReader reader;
    protected ScannerFactory fac;
    protected boolean annotationsincomments;
    protected final boolean spacesincomments;
    protected boolean magicAt = false;
    protected boolean magicID = false;
    protected boolean magic = false;
    protected boolean voodoo = false;
    private static final boolean hexFloatsWork = JavaTokenizer.hexFloatsWork();

    private static boolean hexFloatsWork() {
        try {
            Float.valueOf("0x1.0p1");
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    protected JavaTokenizer(ScannerFactory fac, CharBuffer buf) {
        this(fac, new UnicodeReader(fac, buf));
    }

    protected JavaTokenizer(ScannerFactory fac, char[] buf, int inputLength) {
        this(fac, new UnicodeReader(fac, buf, inputLength));
    }

    protected JavaTokenizer(ScannerFactory fac, UnicodeReader reader) {
        this.fac = fac;
        this.log = fac.log;
        this.tokens = fac.tokens;
        this.source = fac.source;
        this.reader = reader;
        this.allowBinaryLiterals = this.source.allowBinaryLiterals();
        this.allowHexFloats = this.source.allowHexFloats();
        this.allowUnderscoresInLiterals = this.source.allowUnderscoresInLiterals();
        this.annotationsincomments = fac.annotationsincomments;
        this.spacesincomments = fac.spacesincomments;
    }

    protected void lexError(int pos, String key, Object ... args) {
        this.log.error(pos, key, args);
        this.tk = Tokens.TokenKind.ERROR;
        this.errPos = pos;
    }

    private void scanLitChar(int pos) {
        if (this.reader.ch == '\\') {
            if (this.reader.peekChar() == '\\' && !this.reader.isUnicode()) {
                this.reader.skipChar();
                this.reader.putChar('\\', true);
            } else {
                this.reader.scanChar();
                switch (this.reader.ch) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char leadch = this.reader.ch;
                        int oct = this.reader.digit(pos, 8);
                        this.reader.scanChar();
                        if ('0' <= this.reader.ch && this.reader.ch <= '7') {
                            oct = oct * 8 + this.reader.digit(pos, 8);
                            this.reader.scanChar();
                            if (leadch <= '3' && '0' <= this.reader.ch && this.reader.ch <= '7') {
                                oct = oct * 8 + this.reader.digit(pos, 8);
                                this.reader.scanChar();
                            }
                        }
                        this.reader.putChar((char)oct);
                        break;
                    }
                    case 'b': {
                        this.reader.putChar('\b', true);
                        break;
                    }
                    case 't': {
                        this.reader.putChar('\t', true);
                        break;
                    }
                    case 'n': {
                        this.reader.putChar('\n', true);
                        break;
                    }
                    case 'f': {
                        this.reader.putChar('\f', true);
                        break;
                    }
                    case 'r': {
                        this.reader.putChar('\r', true);
                        break;
                    }
                    case '\'': {
                        this.reader.putChar('\'', true);
                        break;
                    }
                    case '\"': {
                        this.reader.putChar('\"', true);
                        break;
                    }
                    case '\\': {
                        this.reader.putChar('\\', true);
                        break;
                    }
                    default: {
                        this.lexError(this.reader.bp, "illegal.esc.char", new Object[0]);
                        break;
                    }
                }
            }
        } else if (this.reader.bp != this.reader.buflen) {
            this.reader.putChar(true);
        }
    }

    private void scanDigits(int pos, int digitRadix) {
        int savePos;
        char saveCh;
        do {
            if (this.reader.ch != '_') {
                this.reader.putChar(false);
            } else if (!this.allowUnderscoresInLiterals) {
                this.lexError(pos, "unsupported.underscore.lit", this.source.name);
                this.allowUnderscoresInLiterals = true;
            }
            saveCh = this.reader.ch;
            savePos = this.reader.bp;
            this.reader.scanChar();
        } while (this.reader.digit(pos, digitRadix) >= 0 || this.reader.ch == '_');
        if (saveCh == '_') {
            this.lexError(savePos, "illegal.underscore", new Object[0]);
        }
    }

    private void scanHexExponentAndSuffix(int pos) {
        if (this.reader.ch == 'p' || this.reader.ch == 'P') {
            this.reader.putChar(true);
            this.skipIllegalUnderscores();
            if (this.reader.ch == '+' || this.reader.ch == '-') {
                this.reader.putChar(true);
            }
            this.skipIllegalUnderscores();
            if ('0' <= this.reader.ch && this.reader.ch <= '9') {
                this.scanDigits(pos, 10);
                if (!this.allowHexFloats) {
                    this.lexError(pos, "unsupported.fp.lit", this.source.name);
                    this.allowHexFloats = true;
                } else if (!hexFloatsWork) {
                    this.lexError(pos, "unsupported.cross.fp.lit", new Object[0]);
                }
            } else {
                this.lexError(pos, "malformed.fp.lit", new Object[0]);
            }
        } else {
            this.lexError(pos, "malformed.fp.lit", new Object[0]);
        }
        if (this.reader.ch == 'f' || this.reader.ch == 'F') {
            this.reader.putChar(true);
            this.tk = Tokens.TokenKind.FLOATLITERAL;
            this.radix = 16;
        } else {
            if (this.reader.ch == 'd' || this.reader.ch == 'D') {
                this.reader.putChar(true);
            }
            this.tk = Tokens.TokenKind.DOUBLELITERAL;
            this.radix = 16;
        }
    }

    private void scanFraction(int pos) {
        this.skipIllegalUnderscores();
        if ('0' <= this.reader.ch && this.reader.ch <= '9') {
            this.scanDigits(pos, 10);
        }
        int sp1 = this.reader.sp;
        if (this.reader.ch == 'e' || this.reader.ch == 'E') {
            this.reader.putChar(true);
            this.skipIllegalUnderscores();
            if (this.reader.ch == '+' || this.reader.ch == '-') {
                this.reader.putChar(true);
            }
            this.skipIllegalUnderscores();
            if ('0' <= this.reader.ch && this.reader.ch <= '9') {
                this.scanDigits(pos, 10);
                return;
            }
            this.lexError(pos, "malformed.fp.lit", new Object[0]);
            this.reader.sp = sp1;
        }
    }

    private void scanFractionAndSuffix(int pos) {
        this.radix = 10;
        this.scanFraction(pos);
        if (this.reader.ch == 'f' || this.reader.ch == 'F') {
            this.reader.putChar(true);
            this.tk = Tokens.TokenKind.FLOATLITERAL;
        } else {
            if (this.reader.ch == 'd' || this.reader.ch == 'D') {
                this.reader.putChar(true);
            }
            this.tk = Tokens.TokenKind.DOUBLELITERAL;
        }
    }

    private void scanHexFractionAndSuffix(int pos, boolean seendigit) {
        this.radix = 16;
        Assert.check(this.reader.ch == '.');
        this.reader.putChar(true);
        this.skipIllegalUnderscores();
        if (this.reader.digit(pos, 16) >= 0) {
            seendigit = true;
            this.scanDigits(pos, 16);
        }
        if (!seendigit) {
            this.lexError(pos, "invalid.hex.number", new Object[0]);
        } else {
            this.scanHexExponentAndSuffix(pos);
        }
    }

    private void skipIllegalUnderscores() {
        if (this.reader.ch == '_') {
            this.lexError(this.reader.bp, "illegal.underscore", new Object[0]);
            while (this.reader.ch == '_') {
                this.reader.scanChar();
            }
        }
    }

    private void scanNumber(int pos, int radix) {
        this.radix = radix;
        int digitRadix = radix == 8 ? 10 : radix;
        boolean seendigit = false;
        if (this.reader.digit(pos, digitRadix) >= 0) {
            seendigit = true;
            this.scanDigits(pos, digitRadix);
        }
        if (radix == 16 && this.reader.ch == '.') {
            this.scanHexFractionAndSuffix(pos, seendigit);
        } else if (seendigit && radix == 16 && (this.reader.ch == 'p' || this.reader.ch == 'P')) {
            this.scanHexExponentAndSuffix(pos);
        } else if (digitRadix == 10 && this.reader.ch == '.') {
            this.reader.putChar(true);
            this.scanFractionAndSuffix(pos);
        } else if (digitRadix == 10 && (this.reader.ch == 'e' || this.reader.ch == 'E' || this.reader.ch == 'f' || this.reader.ch == 'F' || this.reader.ch == 'd' || this.reader.ch == 'D')) {
            this.scanFractionAndSuffix(pos);
        } else if (this.reader.ch == 'l' || this.reader.ch == 'L') {
            this.reader.scanChar();
            this.tk = Tokens.TokenKind.LONGLITERAL;
        } else {
            this.tk = Tokens.TokenKind.INTLITERAL;
        }
    }

    private void scanIdent() {
        this.reader.putChar(true);
        block5: while (true) {
            switch (this.reader.ch) {
                case '$': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    break;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001b': 
                case '\u007f': {
                    this.reader.scanChar();
                    continue block5;
                }
                case '\u001a': {
                    if (this.reader.bp >= this.reader.buflen) {
                        this.name = this.reader.name();
                        this.tk = this.tokens.lookupKind(this.name);
                        return;
                    }
                    this.reader.scanChar();
                    continue block5;
                }
                default: {
                    boolean isJavaIdentifierPart;
                    if (this.reader.ch < '\u0080') {
                        isJavaIdentifierPart = false;
                    } else {
                        if (Character.isIdentifierIgnorable(this.reader.ch)) {
                            this.reader.scanChar();
                            continue block5;
                        }
                        char high = this.reader.scanSurrogates();
                        if (high != '\u0000') {
                            this.reader.putChar(high);
                            isJavaIdentifierPart = Character.isJavaIdentifierPart(Character.toCodePoint(high, this.reader.ch));
                        } else {
                            isJavaIdentifierPart = Character.isJavaIdentifierPart(this.reader.ch);
                        }
                    }
                    if (isJavaIdentifierPart) break;
                    this.name = this.reader.name();
                    this.tk = this.tokens.lookupKind(this.name);
                    return;
                }
            }
            this.reader.putChar(true);
        }
    }

    private boolean isSpecial(char ch) {
        switch (ch) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private void scanOperator() {
        do {
            this.reader.putChar(false);
            Name newname = this.reader.name();
            Tokens.TokenKind tk1 = this.tokens.lookupKind(newname);
            if (tk1 == Tokens.TokenKind.IDENTIFIER) {
                --this.reader.sp;
                break;
            }
            this.tk = tk1;
            this.reader.scanChar();
        } while (this.isSpecial(this.reader.ch));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tokens.Token readToken() {
        List<Tokens.Comment> comments;
        int endPos;
        int pos;
        block86: {
            this.reader.sp = 0;
            this.name = null;
            this.radix = 0;
            pos = 0;
            endPos = 0;
            comments = null;
            if (this.magicAt) {
                this.magicAt = false;
                this.magicID = true;
            }
            if (this.magicID && this.reader.ch == ' ') {
                while (this.reader.ch == ' ') {
                    this.reader.scanChar();
                }
            }
            if (this.magicID && this.reader.ch == '*') {
                this.magicID = false;
                this.magic = true;
                this.reader.scanChar();
                if (this.reader.ch != '/') {
                    this.lexError(pos, "invalid.anno.comment.char", new Object[0]);
                }
                this.reader.scanChar();
            }
            block29: while (true) {
                Tokens.Comment.CommentStyle style;
                boolean isEmpty;
                pos = this.reader.bp;
                switch (this.reader.ch) {
                    case '\t': 
                    case '\f': 
                    case ' ': {
                        do {
                            this.reader.scanChar();
                        } while (this.reader.ch == ' ' || this.reader.ch == '\t' || this.reader.ch == '\f');
                        this.processWhiteSpace(pos, this.reader.bp);
                        continue block29;
                    }
                    case '\n': {
                        this.reader.scanChar();
                        this.processLineTerminator(pos, this.reader.bp);
                        continue block29;
                    }
                    case '\r': {
                        this.reader.scanChar();
                        if (this.reader.ch == '\n') {
                            this.reader.scanChar();
                        }
                        this.processLineTerminator(pos, this.reader.bp);
                        continue block29;
                    }
                    case '$': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case '_': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        this.scanIdent();
                        break block86;
                    }
                    case '0': {
                        int savePos;
                        this.reader.scanChar();
                        if (this.reader.ch == 'x' || this.reader.ch == 'X') {
                            this.reader.scanChar();
                            this.skipIllegalUnderscores();
                            if (this.reader.ch == '.') {
                                this.scanHexFractionAndSuffix(pos, false);
                                break block86;
                            }
                            if (this.reader.digit(pos, 16) < 0) {
                                this.lexError(pos, "invalid.hex.number", new Object[0]);
                                break block86;
                            } else {
                                this.scanNumber(pos, 16);
                            }
                            break block86;
                        }
                        if (this.reader.ch == 'b' || this.reader.ch == 'B') {
                            if (!this.allowBinaryLiterals) {
                                this.lexError(pos, "unsupported.binary.lit", this.source.name);
                                this.allowBinaryLiterals = true;
                            }
                            this.reader.scanChar();
                            this.skipIllegalUnderscores();
                            if (this.reader.digit(pos, 2) < 0) {
                                this.lexError(pos, "invalid.binary.number", new Object[0]);
                                break block86;
                            } else {
                                this.scanNumber(pos, 2);
                            }
                            break block86;
                        }
                        this.reader.putChar('0');
                        if (this.reader.ch == '_') {
                            savePos = this.reader.bp;
                            do {
                                this.reader.scanChar();
                            } while (this.reader.ch == '_');
                            if (this.reader.digit(pos, 10) < 0) {
                                this.lexError(savePos, "illegal.underscore", new Object[0]);
                            }
                        }
                        this.scanNumber(pos, 8);
                        break block86;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.scanNumber(pos, 10);
                        break block86;
                    }
                    case '.': {
                        int savePos;
                        this.reader.scanChar();
                        if ('0' <= this.reader.ch && this.reader.ch <= '9') {
                            this.reader.putChar('.');
                            this.scanFractionAndSuffix(pos);
                            break block86;
                        }
                        if (this.reader.ch == '.') {
                            savePos = this.reader.bp;
                            this.reader.putChar('.');
                            this.reader.putChar('.', true);
                            if (this.reader.ch == '.') {
                                this.reader.scanChar();
                                this.reader.putChar('.');
                                this.tk = Tokens.TokenKind.ELLIPSIS;
                                break block86;
                            } else {
                                this.lexError(savePos, "illegal.dot", new Object[0]);
                            }
                            break block86;
                        }
                        this.tk = Tokens.TokenKind.DOT;
                        break block86;
                    }
                    case ',': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.COMMA;
                        break block86;
                    }
                    case ';': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.SEMI;
                        break block86;
                    }
                    case '(': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.LPAREN;
                        break block86;
                    }
                    case ')': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.RPAREN;
                        break block86;
                    }
                    case '[': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.LBRACKET;
                        break block86;
                    }
                    case ']': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.RBRACKET;
                        break block86;
                    }
                    case '{': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.LBRACE;
                        break block86;
                    }
                    case '}': {
                        this.reader.scanChar();
                        this.tk = Tokens.TokenKind.RBRACE;
                        break block86;
                    }
                    case '/': {
                        this.reader.scanChar();
                        if (this.reader.ch == '/') {
                            do {
                                this.reader.scanCommentChar();
                            } while (this.reader.ch != '\r' && this.reader.ch != '\n' && this.reader.bp < this.reader.buflen);
                            if (this.reader.bp >= this.reader.buflen) continue block29;
                            comments = this.addComment(comments, this.processComment(pos, this.reader.bp, Tokens.Comment.CommentStyle.LINE));
                            continue block29;
                        }
                        if (this.reader.ch == '*') {
                            isEmpty = false;
                            this.reader.scanChar();
                            if (this.reader.ch == '*') {
                                style = Tokens.Comment.CommentStyle.JAVADOC;
                                this.reader.scanCommentChar();
                                if (this.reader.ch != '/') break;
                                isEmpty = true;
                                break;
                            }
                            if (this.annotationsincomments && this.reader.bp < this.reader.buflen) {
                                if (this.spacesincomments) {
                                    while (Character.isWhitespace(this.reader.ch)) {
                                        this.reader.scanChar();
                                    }
                                }
                                if (this.reader.ch == '@' && this.isMagicComment()) {
                                    this.reader.scanChar();
                                    this.tk = Tokens.TokenKind.MONKEYS_AT;
                                    this.magicAt = true;
                                    break block86;
                                } else {
                                    if (this.reader.ch == '>') {
                                        this.reader.scanChar();
                                        if (this.reader.ch == '>') {
                                            this.reader.scanChar();
                                            if (this.reader.ch == '>') {
                                                this.reader.scanChar();
                                                this.voodoo = true;
                                                continue block29;
                                            }
                                        }
                                    }
                                    style = Tokens.Comment.CommentStyle.BLOCK;
                                    break;
                                }
                            }
                            style = Tokens.Comment.CommentStyle.BLOCK;
                            break;
                        }
                        if (this.reader.ch == '=') {
                            this.tk = Tokens.TokenKind.SLASHEQ;
                            this.reader.scanChar();
                            break block86;
                        } else {
                            this.tk = Tokens.TokenKind.SLASH;
                        }
                        break block86;
                    }
                    case '\'': {
                        this.reader.scanChar();
                        if (this.reader.ch == '\'') {
                            this.lexError(pos, "empty.char.lit", new Object[0]);
                            break block86;
                        }
                        if (this.reader.ch == '\r' || this.reader.ch == '\n') {
                            this.lexError(pos, "illegal.line.end.in.char.lit", new Object[0]);
                        }
                        this.scanLitChar(pos);
                        char ch2 = this.reader.ch;
                        if (this.reader.ch == '\'') {
                            this.reader.scanChar();
                            this.tk = Tokens.TokenKind.CHARLITERAL;
                            break block86;
                        } else {
                            this.lexError(pos, "unclosed.char.lit", new Object[0]);
                        }
                        break block86;
                    }
                    case '\"': {
                        this.reader.scanChar();
                        while (this.reader.ch != '\"' && this.reader.ch != '\r' && this.reader.ch != '\n' && this.reader.bp < this.reader.buflen) {
                            this.scanLitChar(pos);
                        }
                        if (this.reader.ch == '\"') {
                            this.tk = Tokens.TokenKind.STRINGLITERAL;
                            this.reader.scanChar();
                            break block86;
                        } else {
                            this.lexError(pos, "unclosed.str.lit", new Object[0]);
                        }
                        break block86;
                    }
                    default: {
                        boolean isJavaIdentifierStart;
                        if (this.voodoo && this.reader.ch == '*' && this.reader.peekChar() == '/') {
                            this.reader.scanChar();
                            this.reader.scanChar();
                            this.voodoo = false;
                            continue block29;
                        }
                        if (this.isSpecial(this.reader.ch)) {
                            this.scanOperator();
                            break block86;
                        }
                        if (this.reader.ch < '\u0080') {
                            isJavaIdentifierStart = false;
                        } else {
                            char high = this.reader.scanSurrogates();
                            if (high != '\u0000') {
                                this.reader.putChar(high);
                                isJavaIdentifierStart = Character.isJavaIdentifierStart(Character.toCodePoint(high, this.reader.ch));
                            } else {
                                isJavaIdentifierStart = Character.isJavaIdentifierStart(this.reader.ch);
                            }
                        }
                        if (isJavaIdentifierStart) {
                            this.scanIdent();
                            break block86;
                        }
                        if (this.reader.bp == this.reader.buflen || this.reader.ch == '\u001a' && this.reader.bp + 1 == this.reader.buflen) {
                            this.tk = Tokens.TokenKind.EOF;
                            pos = this.reader.buflen;
                            break block86;
                        } else {
                            String arg = ' ' < this.reader.ch && this.reader.ch < '\u007f' ? String.format("%s", Character.valueOf(this.reader.ch)) : String.format("\\u%04x", this.reader.ch);
                            this.lexError(pos, "illegal.char", arg);
                            this.reader.scanChar();
                        }
                        break block86;
                    }
                }
                while (!isEmpty && this.reader.bp < this.reader.buflen) {
                    if (this.reader.ch == '*') {
                        this.reader.scanChar();
                        if (this.reader.ch != '/') continue;
                        break;
                    }
                    if (this.magic && this.reader.ch == '@') {
                        this.reader.scanChar();
                        if (Character.isJavaIdentifierStart(this.reader.ch)) {
                            this.tk = Tokens.TokenKind.MONKEYS_AT;
                            this.magicAt = true;
                            break block86;
                        } else {
                            this.reader.scanChar();
                            if (this.reader.ch != '/') continue;
                            break;
                        }
                    }
                    this.reader.scanCommentChar();
                    if (Character.isWhitespace(this.reader.ch) && this.reader.ch != '\n') continue;
                    this.magic = false;
                }
                if (this.reader.ch != '/') break;
                this.reader.scanChar();
                comments = this.addComment(comments, this.processComment(pos, this.reader.bp, style));
            }
            this.lexError(pos, "unclosed.comment", new Object[0]);
        }
        endPos = this.reader.bp;
        switch (this.tk.tag) {
            case DEFAULT: {
                return new Tokens.Token(this.tk, pos, endPos, comments);
            }
            case NAMED: {
                return new Tokens.NamedToken(this.tk, pos, endPos, this.name, comments);
            }
            case STRING: {
                return new Tokens.StringToken(this.tk, pos, endPos, this.reader.chars(), comments);
            }
            case NUMERIC: {
                return new Tokens.NumericToken(this.tk, pos, endPos, this.reader.chars(), this.radix, comments);
            }
        }
        throw new AssertionError();
    }

    List<Tokens.Comment> addComment(List<Tokens.Comment> comments, Tokens.Comment comment) {
        return comments == null ? List.of(comment) : comments.prepend(comment);
    }

    private boolean isMagicComment() {
        char lch;
        assert (this.reader.ch == '@');
        int parens = 0;
        boolean stringLit = false;
        int lbp = this.reader.bp;
        if (!Character.isJavaIdentifierStart(lch = this.reader.buf[++lbp])) {
            return false;
        }
        while (lbp < this.reader.buflen) {
            if (Character.isWhitespace(lch = this.reader.buf[++lbp]) && !this.spacesincomments && parens == 0) {
                return false;
            }
            if (lch == '@' && parens == 0) {
                return false;
            }
            if (lch == '(' && !stringLit) {
                ++parens;
                continue;
            }
            if (lch == ')' && !stringLit) {
                --parens;
                continue;
            }
            if (lch == '\"') {
                stringLit = !stringLit;
                continue;
            }
            if (lch == '*' && !stringLit && lbp + 1 < this.reader.buflen && this.reader.buf[lbp + 1] == '/') {
                return parens == 0;
            }
            if (Character.isJavaIdentifierPart(lch) || Character.isWhitespace(lch) || lch == '.' || this.spacesincomments || parens != 0 || stringLit) continue;
            return false;
        }
        return false;
    }

    public int errPos() {
        return this.errPos;
    }

    public void errPos(int pos) {
        this.errPos = pos;
    }

    protected Tokens.Comment processComment(int pos, int endPos, Tokens.Comment.CommentStyle style) {
        char[] buf = this.reader.getRawCharacters(pos, endPos);
        return new BasicComment<UnicodeReader>(new UnicodeReader(this.fac, buf, buf.length), style);
    }

    protected void processWhiteSpace(int pos, int endPos) {
    }

    protected void processLineTerminator(int pos, int endPos) {
    }

    public Position.LineMap getLineMap() {
        return Position.makeLineMap(this.reader.getRawCharacters(), this.reader.buflen, false);
    }

    protected static class BasicComment<U extends UnicodeReader>
    implements Tokens.Comment {
        Tokens.Comment.CommentStyle cs;
        U comment_reader;
        protected boolean deprecatedFlag = false;
        protected boolean scanned = false;

        protected BasicComment(U comment_reader, Tokens.Comment.CommentStyle cs) {
            this.comment_reader = comment_reader;
            this.cs = cs;
        }

        @Override
        public String getText() {
            return null;
        }

        @Override
        public int getSourcePos(int pos) {
            return -1;
        }

        @Override
        public Tokens.Comment.CommentStyle getStyle() {
            return this.cs;
        }

        @Override
        public boolean isDeprecated() {
            if (!this.scanned && this.cs == Tokens.Comment.CommentStyle.JAVADOC) {
                this.scanDocComment();
            }
            return this.deprecatedFlag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void scanDocComment() {
            try {
                boolean deprecatedPrefix = false;
                ((UnicodeReader)this.comment_reader).bp += 3;
                ((UnicodeReader)this.comment_reader).ch = ((UnicodeReader)this.comment_reader).buf[((UnicodeReader)this.comment_reader).bp];
                block11: while (((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen) {
                    while (((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen && (((UnicodeReader)this.comment_reader).ch == ' ' || ((UnicodeReader)this.comment_reader).ch == '\t' || ((UnicodeReader)this.comment_reader).ch == '\f')) {
                        ((UnicodeReader)this.comment_reader).scanCommentChar();
                    }
                    while (((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen && ((UnicodeReader)this.comment_reader).ch == '*') {
                        ((UnicodeReader)this.comment_reader).scanCommentChar();
                        if (((UnicodeReader)this.comment_reader).ch != '/') continue;
                        return;
                    }
                    while (((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen && (((UnicodeReader)this.comment_reader).ch == ' ' || ((UnicodeReader)this.comment_reader).ch == '\t' || ((UnicodeReader)this.comment_reader).ch == '\f')) {
                        ((UnicodeReader)this.comment_reader).scanCommentChar();
                    }
                    deprecatedPrefix = false;
                    if (!this.deprecatedFlag) {
                        String deprecated = "@deprecated";
                        int i = 0;
                        while (((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen && ((UnicodeReader)this.comment_reader).ch == deprecated.charAt(i)) {
                            ((UnicodeReader)this.comment_reader).scanCommentChar();
                            if (++i != deprecated.length()) continue;
                            deprecatedPrefix = true;
                            break;
                        }
                    }
                    if (deprecatedPrefix && ((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen) {
                        if (Character.isWhitespace(((UnicodeReader)this.comment_reader).ch)) {
                            this.deprecatedFlag = true;
                        } else if (((UnicodeReader)this.comment_reader).ch == '*') {
                            ((UnicodeReader)this.comment_reader).scanCommentChar();
                            if (((UnicodeReader)this.comment_reader).ch == '/') {
                                this.deprecatedFlag = true;
                                return;
                            }
                        }
                    }
                    block16: while (((UnicodeReader)this.comment_reader).bp < ((UnicodeReader)this.comment_reader).buflen) {
                        switch (((UnicodeReader)this.comment_reader).ch) {
                            case '*': {
                                ((UnicodeReader)this.comment_reader).scanCommentChar();
                                if (((UnicodeReader)this.comment_reader).ch != '/') continue block16;
                                return;
                            }
                            case '\r': {
                                ((UnicodeReader)this.comment_reader).scanCommentChar();
                                if (((UnicodeReader)this.comment_reader).ch != '\n') continue block11;
                            }
                            case '\n': {
                                ((UnicodeReader)this.comment_reader).scanCommentChar();
                                continue block11;
                            }
                        }
                        ((UnicodeReader)this.comment_reader).scanCommentChar();
                    }
                }
                return;
            }
            finally {
                this.scanned = true;
            }
        }
    }
}

