/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class LVTRanges {
    protected static final Context.Key<LVTRanges> lvtRangesKey = new Context.Key();
    private static final long serialVersionUID = 1812267524140424433L;
    protected Context context;
    protected Map<Symbol.MethodSymbol, Map<JCTree, List<Symbol.VarSymbol>>> aliveRangeClosingTrees = new WeakHashMap<Symbol.MethodSymbol, Map<JCTree, List<Symbol.VarSymbol>>>();

    public static LVTRanges instance(Context context) {
        LVTRanges instance = context.get(lvtRangesKey);
        if (instance == null) {
            instance = new LVTRanges(context);
        }
        return instance;
    }

    public LVTRanges(Context context) {
        this.context = context;
        context.put(lvtRangesKey, this);
    }

    public List<Symbol.VarSymbol> getVars(Symbol.MethodSymbol method, JCTree tree) {
        Map<JCTree, List<Symbol.VarSymbol>> varMap = this.aliveRangeClosingTrees.get(method);
        return varMap != null ? varMap.get(tree) : null;
    }

    public boolean containsKey(Symbol.MethodSymbol method, JCTree tree) {
        Map<JCTree, List<Symbol.VarSymbol>> varMap = this.aliveRangeClosingTrees.get(method);
        if (varMap == null) {
            return false;
        }
        return varMap.containsKey(tree);
    }

    public void setEntry(Symbol.MethodSymbol method, JCTree tree, List<Symbol.VarSymbol> vars) {
        Map<JCTree, List<Symbol.VarSymbol>> varMap = this.aliveRangeClosingTrees.get(method);
        if (varMap != null) {
            varMap.put(tree, vars);
        } else {
            varMap = new WeakHashMap<JCTree, List<Symbol.VarSymbol>>();
            varMap.put(tree, vars);
            this.aliveRangeClosingTrees.put(method, varMap);
        }
    }

    public List<Symbol.VarSymbol> removeEntry(Symbol.MethodSymbol method, JCTree tree) {
        Map<JCTree, List<Symbol.VarSymbol>> varMap = this.aliveRangeClosingTrees.get(method);
        if (varMap != null) {
            List<Symbol.VarSymbol> result = varMap.remove(tree);
            if (varMap.isEmpty()) {
                this.aliveRangeClosingTrees.remove(method);
            }
            return result;
        }
        return null;
    }

    public String toString() {
        String result = "";
        for (Map.Entry<Symbol.MethodSymbol, Map<JCTree, List<Symbol.VarSymbol>>> mainEntry : this.aliveRangeClosingTrees.entrySet()) {
            result = result + "Method: \n" + mainEntry.getKey().flatName() + "\n";
            int i = 1;
            for (Map.Entry<JCTree, List<Symbol.VarSymbol>> treeEntry : mainEntry.getValue().entrySet()) {
                result = result + "    Tree " + i + ": \n" + treeEntry.getKey().toString() + "\n";
                result = result + "        Variables closed:\n";
                for (Symbol.VarSymbol var : treeEntry.getValue()) {
                    result = result + "            " + var.toString();
                }
                result = result + "\n";
                ++i;
            }
        }
        return result;
    }
}

