/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.file.ZipFileIndex;
import com.sun.tools.javac.util.Context;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZipFileIndexCache {
    private final Map<File, ZipFileIndex> map = new HashMap<File, ZipFileIndex>();
    private static ZipFileIndexCache sharedInstance;

    public static synchronized ZipFileIndexCache getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new ZipFileIndexCache();
        }
        return sharedInstance;
    }

    public static ZipFileIndexCache instance(Context context) {
        ZipFileIndexCache instance = context.get(ZipFileIndexCache.class);
        if (instance == null) {
            instance = new ZipFileIndexCache();
            context.put(ZipFileIndexCache.class, instance);
        }
        return instance;
    }

    public List<ZipFileIndex> getZipFileIndexes() {
        return this.getZipFileIndexes(false);
    }

    public synchronized List<ZipFileIndex> getZipFileIndexes(boolean openedOnly) {
        ArrayList<ZipFileIndex> zipFileIndexes = new ArrayList<ZipFileIndex>();
        zipFileIndexes.addAll(this.map.values());
        if (openedOnly) {
            for (ZipFileIndex elem : zipFileIndexes) {
                if (elem.isOpen()) continue;
                zipFileIndexes.remove(elem);
            }
        }
        return zipFileIndexes;
    }

    public synchronized ZipFileIndex getZipFileIndex(File zipFile, RelativePath.RelativeDirectory symbolFilePrefix, boolean useCache, String cacheLocation, boolean writeIndex) throws IOException {
        ZipFileIndex zi = this.getExistingZipIndex(zipFile);
        if (zi == null || zi != null && zipFile.lastModified() != zi.zipFileLastModified) {
            zi = new ZipFileIndex(zipFile, symbolFilePrefix, writeIndex, useCache, cacheLocation);
            this.map.put(zipFile, zi);
        }
        return zi;
    }

    public synchronized ZipFileIndex getExistingZipIndex(File zipFile) {
        return this.map.get(zipFile);
    }

    public synchronized void clearCache() {
        this.map.clear();
    }

    public synchronized void clearCache(long timeNotUsed) {
        for (File cachedFile : this.map.keySet()) {
            long timeToTest;
            ZipFileIndex cachedZipIndex = this.map.get(cachedFile);
            if (cachedZipIndex == null || (timeToTest = cachedZipIndex.lastReferenceTimeStamp + timeNotUsed) >= cachedZipIndex.lastReferenceTimeStamp && System.currentTimeMillis() <= timeToTest) continue;
            this.map.remove(cachedFile);
        }
    }

    public synchronized void removeFromCache(File file) {
        this.map.remove(file);
    }

    public synchronized void setOpenedIndexes(List<ZipFileIndex> indexes) throws IllegalStateException {
        if (this.map.isEmpty()) {
            String msg = "Setting opened indexes should be called only when the ZipFileCache is empty. Call JavacFileManager.flush() before calling this method.";
            throw new IllegalStateException(msg);
        }
        for (ZipFileIndex zfi : indexes) {
            this.map.put(zfi.zipFile, zfi);
        }
    }
}

