/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.DeferredLintHandler;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.ConstFold;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.tools.JavaFileObject;

public class Annotate {
    protected static final Context.Key<Annotate> annotateKey = new Context.Key();
    private final Attr attr;
    private final TreeMaker make;
    private final Log log;
    private final Symtab syms;
    private final Names names;
    private final Resolve rs;
    private final Types types;
    private final ConstFold cfolder;
    private final Check chk;
    private final Lint lint;
    private final DeferredLintHandler deferredLintHandler;
    private final Source source;
    private boolean allowTypeAnnos;
    private boolean allowRepeatedAnnos;
    private int enterCount = 0;
    ListBuffer<Worker> q = new ListBuffer();
    ListBuffer<Worker> typesQ = new ListBuffer();
    ListBuffer<Worker> repeatedQ = new ListBuffer();
    ListBuffer<Worker> afterRepeatedQ = new ListBuffer();
    ListBuffer<Worker> validateQ = new ListBuffer();
    private final AttributeAttacher<Attribute.Compound> declAnnotationsAttacher = new AttributeAttacher<Attribute.Compound>(){

        @Override
        public void attach(Symbol sym, List<Attribute.Compound> attrs) {
            sym.resetAnnotations();
            sym.setDeclarationAttributes(attrs);
        }
    };
    private final AttributeAttacher<Attribute.TypeCompound> typeAnnotationsAttacher = new AttributeAttacher<Attribute.TypeCompound>(){

        @Override
        public void attach(Symbol sym, List<Attribute.TypeCompound> attrs) {
            sym.appendUniqueTypeAttributes(attrs);
        }
    };
    private final AttributeCreator<Attribute.Compound> enterAnnotationsCreator = new AttributeCreator<Attribute.Compound>(){

        @Override
        public Attribute.Compound create(JCTree.JCAnnotation a, Type expected, Env<AttrContext> env) {
            return Annotate.this.enterAnnotation(a, ((Annotate)Annotate.this).syms.annotationType, env);
        }
    };
    private final AttributeCreator<Attribute.TypeCompound> enterTypeAnnotationsCreator = new AttributeCreator<Attribute.TypeCompound>(){

        @Override
        public Attribute.TypeCompound create(JCTree.JCAnnotation a, Type expected, Env<AttrContext> env) {
            return Annotate.this.enterTypeAnnotation(a, ((Annotate)Annotate.this).syms.annotationType, env);
        }
    };

    public static Annotate instance(Context context) {
        Annotate instance = context.get(annotateKey);
        if (instance == null) {
            instance = new Annotate(context);
        }
        return instance;
    }

    protected Annotate(Context context) {
        context.put(annotateKey, this);
        this.attr = Attr.instance(context);
        this.make = TreeMaker.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.names = Names.instance(context);
        this.rs = Resolve.instance(context);
        this.types = Types.instance(context);
        this.cfolder = ConstFold.instance(context);
        this.chk = Check.instance(context);
        this.source = Source.instance(context);
        this.lint = Lint.instance(context);
        this.deferredLintHandler = DeferredLintHandler.instance(context);
        this.allowRepeatedAnnos = this.source.allowRepeatedAnnotations();
        this.allowTypeAnnos = this.source.allowTypeAnnotations();
    }

    public void earlier(Worker a) {
        this.q.prepend(a);
    }

    public void normal(Worker a) {
        this.q.append(a);
    }

    public void typeAnnotation(Worker a) {
        this.typesQ.append(a);
    }

    public void repeated(Worker a) {
        this.repeatedQ.append(a);
    }

    public void afterRepeated(Worker a) {
        this.afterRepeatedQ.append(a);
    }

    public void validate(Worker a) {
        this.validateQ.append(a);
    }

    public void enterStart() {
        ++this.enterCount;
    }

    public void enterDone() {
        --this.enterCount;
        this.flush();
    }

    public void enterDoneWithoutFlush() {
        --this.enterCount;
    }

    public void flush() {
        if (this.enterCount != 0) {
            return;
        }
        ++this.enterCount;
        try {
            while (this.q.nonEmpty()) {
                this.q.next().run();
            }
            while (this.typesQ.nonEmpty()) {
                this.typesQ.next().run();
            }
            while (this.repeatedQ.nonEmpty()) {
                this.repeatedQ.next().run();
            }
            while (this.afterRepeatedQ.nonEmpty()) {
                this.afterRepeatedQ.next().run();
            }
            while (this.validateQ.nonEmpty()) {
                this.validateQ.next().run();
            }
        }
        finally {
            --this.enterCount;
        }
    }

    Attribute.Compound enterAnnotation(JCTree.JCAnnotation a, Type expected, Env<AttrContext> env) {
        Attribute.Compound ac;
        List<Pair<Symbol.MethodSymbol, Attribute>> elems = this.enterAttributeValues(a, expected, env);
        a.attribute = ac = new Attribute.Compound(a.type, elems);
        return ac;
    }

    Attribute.TypeCompound enterTypeAnnotation(JCTree.JCAnnotation a, Type expected, Env<AttrContext> env) {
        List<Pair<Symbol.MethodSymbol, Attribute>> elems = this.enterAttributeValues(a, expected, env);
        if (a.attribute == null || !(a.attribute instanceof Attribute.TypeCompound)) {
            Attribute.TypeCompound tc = new Attribute.TypeCompound(a.type, elems, TypeAnnotationPosition.unknown);
            a.attribute = tc;
            return tc;
        }
        return (Attribute.TypeCompound)a.attribute;
    }

    private List<Pair<Symbol.MethodSymbol, Attribute>> enterAttributeValues(JCTree.JCAnnotation a, Type expected, Env<AttrContext> env) {
        List<JCTree.JCExpression> args;
        Type at = a.annotationType.type != null ? a.annotationType.type : this.attr.attribType(a.annotationType, env);
        a.type = this.chk.checkType(a.annotationType.pos(), at, expected);
        boolean isError = a.type.isErroneous();
        if ((a.type.tsym.flags() & 0x2000L) == 0L && !isError) {
            this.log.error(a.annotationType.pos(), "not.annotation.type", a.type.toString());
            isError = true;
        }
        if ((args = a.args).length() == 1 && !((JCTree.JCExpression)args.head).hasTag(JCTree.Tag.ASSIGN)) {
            args.head = this.make.at(((JCTree.JCExpression)args.head).pos).Assign(this.make.Ident(this.names.value), (JCTree.JCExpression)args.head);
        }
        ListBuffer<Pair<Symbol.MethodSymbol, Attribute>> buf = new ListBuffer<Pair<Symbol.MethodSymbol, Attribute>>();
        List<JCTree.JCExpression> tl = args;
        while (tl.nonEmpty()) {
            JCTree.JCExpression t = (JCTree.JCExpression)tl.head;
            if (!t.hasTag(JCTree.Tag.ASSIGN)) {
                this.log.error(t.pos(), "annotation.value.must.be.name.value", new Object[0]);
                t.type = this.syms.errType;
                this.enterAttributeValue(t.type, t, env);
            } else {
                JCTree.JCAssign assign = (JCTree.JCAssign)t;
                if (!assign.lhs.hasTag(JCTree.Tag.IDENT)) {
                    this.log.error(t.pos(), "annotation.value.must.be.name.value", new Object[0]);
                    t.type = this.syms.errType;
                    this.enterAttributeValue(t.type, t, env);
                } else {
                    Symbol method;
                    JCTree.JCIdent left = (JCTree.JCIdent)assign.lhs;
                    left.sym = method = this.rs.resolveQualifiedMethod(assign.rhs.pos(), env, a.type, left.name, List.nil(), null);
                    left.type = method.type;
                    if (method.owner != a.type.tsym && !isError) {
                        this.log.error(left.pos(), "no.annotation.member", left.name, a.type);
                    }
                    Type result = method.type.getReturnType();
                    Attribute value = this.enterAttributeValue(result, assign.rhs, env);
                    if (!method.type.isErroneous()) {
                        buf.append(new Pair<Symbol.MethodSymbol, Attribute>((Symbol.MethodSymbol)method, value));
                    }
                    t.type = result;
                }
            }
            tl = tl.tail;
        }
        return buf.toList();
    }

    Attribute enterAttributeValue(Type expected, JCTree.JCExpression tree, Env<AttrContext> env) {
        try {
            expected.tsym.complete();
        }
        catch (Symbol.CompletionFailure e) {
            this.log.error(tree.pos(), "cant.resolve", Kinds.kindName(e.sym), e.sym);
            expected = this.syms.errType;
        }
        if (expected.hasTag(TypeTag.ARRAY)) {
            if (!tree.hasTag(JCTree.Tag.NEWARRAY)) {
                tree = this.make.at(tree.pos).NewArray(null, List.nil(), List.of(tree));
            }
            JCTree.JCNewArray na = (JCTree.JCNewArray)tree;
            if (na.elemtype != null) {
                this.log.error(na.elemtype.pos(), "new.not.allowed.in.annotation", new Object[0]);
            }
            ListBuffer<Attribute> buf = new ListBuffer<Attribute>();
            List<JCTree.JCExpression> l = na.elems;
            while (l.nonEmpty()) {
                buf.append(this.enterAttributeValue(this.types.elemtype(expected), (JCTree.JCExpression)l.head, env));
                l = l.tail;
            }
            na.type = expected;
            return new Attribute.Array(expected, buf.toArray(new Attribute[buf.length()]));
        }
        if (tree.hasTag(JCTree.Tag.NEWARRAY)) {
            if (!expected.isErroneous()) {
                this.log.error(tree.pos(), "annotation.value.not.allowable.type", new Object[0]);
            }
            JCTree.JCNewArray na = (JCTree.JCNewArray)tree;
            if (na.elemtype != null) {
                this.log.error(na.elemtype.pos(), "new.not.allowed.in.annotation", new Object[0]);
            }
            List<JCTree.JCExpression> l = na.elems;
            while (l.nonEmpty()) {
                this.enterAttributeValue(this.syms.errType, (JCTree.JCExpression)l.head, env);
                l = l.tail;
            }
            return new Attribute.Error(this.syms.errType);
        }
        if ((expected.tsym.flags() & 0x2000L) != 0L) {
            if (tree.hasTag(JCTree.Tag.ANNOTATION)) {
                return this.enterAnnotation((JCTree.JCAnnotation)tree, expected, env);
            }
            this.log.error(tree.pos(), "annotation.value.must.be.annotation", new Object[0]);
            expected = this.syms.errType;
        }
        if (tree.hasTag(JCTree.Tag.ANNOTATION)) {
            if (!expected.isErroneous()) {
                this.log.error(tree.pos(), "annotation.not.valid.for.type", expected);
            }
            this.enterAnnotation((JCTree.JCAnnotation)tree, this.syms.errType, env);
            return new Attribute.Error(((JCTree.JCAnnotation)tree).annotationType.type);
        }
        if (expected.isPrimitive() || this.types.isSameType(expected, this.syms.stringType) && !expected.hasTag(TypeTag.ERROR)) {
            Type result = this.attr.attribExpr(tree, env, expected);
            if (result.isErroneous()) {
                return new Attribute.Error(result.getOriginalType());
            }
            if (result.constValue() == null) {
                this.log.error(tree.pos(), "attribute.value.must.be.constant", new Object[0]);
                return new Attribute.Error(expected);
            }
            result = this.cfolder.coerce(result, expected);
            return new Attribute.Constant(expected, result.constValue());
        }
        if (expected.tsym == this.syms.classType.tsym) {
            Type result = this.attr.attribExpr(tree, env, expected);
            if (result.isErroneous()) {
                if (TreeInfo.name(tree) == this.names._class && ((JCTree.JCFieldAccess)tree).selected.type.isErroneous()) {
                    Name n = ((JCTree.JCFieldAccess)tree).selected.type.tsym.flatName();
                    return new Attribute.UnresolvedClass(expected, this.types.createErrorType(n, this.syms.unknownSymbol, this.syms.classType));
                }
                return new Attribute.Error(result.getOriginalType());
            }
            if (TreeInfo.name(tree) != this.names._class) {
                this.log.error(tree.pos(), "annotation.value.must.be.class.literal", new Object[0]);
                return new Attribute.Error(this.syms.errType);
            }
            return new Attribute.Class(this.types, ((JCTree.JCFieldAccess)tree).selected.type);
        }
        if (expected.hasTag(TypeTag.CLASS) && (expected.tsym.flags() & 0x4000L) != 0L) {
            Type result = this.attr.attribExpr(tree, env, expected);
            Symbol sym = TreeInfo.symbol(tree);
            if (sym == null || TreeInfo.nonstaticSelect(tree) || sym.kind != 4 || (sym.flags() & 0x4000L) == 0L) {
                this.log.error(tree.pos(), "enum.annotation.must.be.enum.constant", new Object[0]);
                return new Attribute.Error(result.getOriginalType());
            }
            Symbol.VarSymbol enumerator = (Symbol.VarSymbol)sym;
            return new Attribute.Enum(expected, enumerator);
        }
        if (!expected.isErroneous()) {
            this.log.error(tree.pos(), "annotation.value.not.allowable.type", new Object[0]);
        }
        return new Attribute.Error(this.attr.attribExpr(tree, env, expected));
    }

    private <T extends Attribute.Compound> T processRepeatedAnnotations(List<T> annotations, AnnotationContext<T> ctx, Symbol on) {
        Attribute.Compound firstOccurrence = (Attribute.Compound)annotations.head;
        List<Attribute> repeated = List.nil();
        Type origAnnoType = null;
        Type.ArrayType arrayOfOrigAnnoType = null;
        Type targetContainerType = null;
        Symbol.MethodSymbol containerValueSymbol = null;
        Assert.check(!annotations.isEmpty() && !annotations.tail.isEmpty());
        int count = 0;
        List<Object> al = annotations;
        while (!al.isEmpty()) {
            Assert.check(++count > 1 || !al.tail.isEmpty());
            Attribute.Compound currentAnno = (Attribute.Compound)al.head;
            origAnnoType = currentAnno.type;
            if (arrayOfOrigAnnoType == null) {
                arrayOfOrigAnnoType = this.types.makeArrayType(origAnnoType);
            }
            boolean reportError = count > 1;
            Type currentContainerType = this.getContainingType(currentAnno, ctx.pos.get(currentAnno), reportError);
            if (currentContainerType != null) {
                Assert.check(targetContainerType == null || currentContainerType == targetContainerType);
                targetContainerType = currentContainerType;
                containerValueSymbol = this.validateContainer(targetContainerType, origAnnoType, ctx.pos.get(currentAnno));
                if (containerValueSymbol != null) {
                    repeated = repeated.prepend(currentAnno);
                }
            }
            al = al.tail;
        }
        if (!repeated.isEmpty()) {
            repeated = repeated.reverse();
            TreeMaker m = this.make.at(ctx.pos.get(firstOccurrence));
            Pair<Object, Attribute.Array> p = new Pair<Object, Attribute.Array>(containerValueSymbol, new Attribute.Array((Type)arrayOfOrigAnnoType, repeated));
            if (ctx.isTypeCompound) {
                Attribute.TypeCompound at = new Attribute.TypeCompound(targetContainerType, List.of(p), ((Attribute.TypeCompound)((Attribute.Compound)annotations.head)).position);
                at.setSynthesized(true);
                Attribute.TypeCompound x = at;
                return (T)x;
            }
            Attribute.Compound c = new Attribute.Compound(targetContainerType, List.of(p));
            JCTree.JCAnnotation annoTree = m.Annotation(c);
            if (!this.chk.annotationApplicable(annoTree, on)) {
                this.log.error(annoTree.pos(), "invalid.repeatable.annotation.incompatible.target", targetContainerType, origAnnoType);
            }
            if (!this.chk.validateAnnotationDeferErrors(annoTree)) {
                this.log.error(annoTree.pos(), "duplicate.annotation.invalid.repeated", origAnnoType);
            }
            c = this.enterAnnotation(annoTree, targetContainerType, ctx.env);
            c.setSynthesized(true);
            Attribute.Compound x = c;
            return (T)x;
        }
        return null;
    }

    private Type getContainingType(Attribute.Compound currentAnno, JCDiagnostic.DiagnosticPosition pos, boolean reportError) {
        Type origAnnoType = currentAnno.type;
        Symbol.TypeSymbol origAnnoDecl = origAnnoType.tsym;
        Attribute.Compound ca = origAnnoDecl.attribute(this.syms.repeatableType.tsym);
        if (ca == null) {
            if (reportError) {
                this.log.error(pos, "duplicate.annotation.missing.container", origAnnoType, this.syms.repeatableType);
            }
            return null;
        }
        return this.filterSame(this.extractContainingType(ca, pos, origAnnoDecl), origAnnoType);
    }

    private Type filterSame(Type t, Type s) {
        if (t == null || s == null) {
            return t;
        }
        return this.types.isSameType(t, s) ? null : t;
    }

    private Type extractContainingType(Attribute.Compound ca, JCDiagnostic.DiagnosticPosition pos, Symbol.TypeSymbol annoDecl) {
        if (ca.values.isEmpty()) {
            this.log.error(pos, "invalid.repeatable.annotation", annoDecl);
            return null;
        }
        Pair p = (Pair)ca.values.head;
        Name name = ((Symbol.MethodSymbol)p.fst).name;
        if (name != this.names.value) {
            this.log.error(pos, "invalid.repeatable.annotation", annoDecl);
            return null;
        }
        if (!(p.snd instanceof Attribute.Class)) {
            this.log.error(pos, "invalid.repeatable.annotation", annoDecl);
            return null;
        }
        return ((Attribute.Class)((Attribute)p.snd)).getValue();
    }

    private Symbol.MethodSymbol validateContainer(Type targetContainerType, Type originalAnnoType, JCDiagnostic.DiagnosticPosition pos) {
        Symbol.MethodSymbol containerValueSymbol = null;
        boolean fatalError = false;
        Scope scope = targetContainerType.tsym.members();
        int nr_value_elems = 0;
        boolean error = false;
        for (Symbol elm : scope.getElementsByName(this.names.value)) {
            if (++nr_value_elems == 1 && elm.kind == 16) {
                containerValueSymbol = (Symbol.MethodSymbol)elm;
                continue;
            }
            error = true;
        }
        if (error) {
            this.log.error(pos, "invalid.repeatable.annotation.multiple.values", targetContainerType, nr_value_elems);
            return null;
        }
        if (nr_value_elems == 0) {
            this.log.error(pos, "invalid.repeatable.annotation.no.value", targetContainerType);
            return null;
        }
        if (containerValueSymbol.kind != 16) {
            this.log.error(pos, "invalid.repeatable.annotation.invalid.value", targetContainerType);
            fatalError = true;
        }
        Type valueRetType = containerValueSymbol.type.getReturnType();
        Type.ArrayType expectedType = this.types.makeArrayType(originalAnnoType);
        if (!this.types.isArray(valueRetType) || !this.types.isSameType(expectedType, valueRetType)) {
            this.log.error(pos, "invalid.repeatable.annotation.value.return", targetContainerType, valueRetType, expectedType);
            fatalError = true;
        }
        if (error) {
            fatalError = true;
        }
        return fatalError ? null : containerValueSymbol;
    }

    private <T extends Attribute.Compound> AnnotationContext<T> prepareEnterAnnotations(List<JCTree.JCAnnotation> annotations, Env<AttrContext> env, Symbol sym, AttributeCreator<T> creator, boolean isTypeCompound) {
        LinkedHashMap annotated = new LinkedHashMap();
        HashMap<T, JCDiagnostic.DiagnosticPosition> pos = new HashMap<T, JCDiagnostic.DiagnosticPosition>();
        List<JCTree.JCAnnotation> al = annotations;
        while (!al.isEmpty()) {
            JCTree.JCAnnotation a = (JCTree.JCAnnotation)al.head;
            T c = creator.create(a, this.syms.annotationType, env);
            Assert.checkNonNull(c, "Failed to create annotation");
            if (annotated.containsKey(a.type.tsym)) {
                if (!this.allowRepeatedAnnos) {
                    this.log.error(a.pos(), "repeatable.annotations.not.supported.in.source", new Object[0]);
                    this.allowRepeatedAnnos = true;
                }
                ListBuffer<T> l = (ListBuffer<T>)annotated.get(a.type.tsym);
                l = l.append(c);
                annotated.put(a.type.tsym, l);
                pos.put(c, a.pos());
            } else {
                annotated.put(a.type.tsym, ListBuffer.of(c));
                pos.put(c, a.pos());
            }
            if (!((Attribute.Compound)c).type.isErroneous() && sym.owner.kind != 16 && this.types.isSameType(((Attribute.Compound)c).type, this.syms.deprecatedType)) {
                sym.flags_field |= 0x20000L;
            }
            al = al.tail;
        }
        return new AnnotationContext(env, annotated, pos, isTypeCompound);
    }

    private <T extends Attribute.Compound> void attachAttributesLater(List<JCTree.JCAnnotation> annotations, final Env<AttrContext> env, final Symbol sym, boolean isTypeCompound, AttributeCreator<T> creator, final AttributeAttacher<T> attacher) {
        final AnnotationContext<T> ctx = this.prepareEnterAnnotations(annotations, env, sym, creator, isTypeCompound);
        Map annotated = ctx.annotated;
        boolean hasRepeated = false;
        List<Object> buf = List.nil();
        for (ListBuffer lb : annotated.values()) {
            if (lb.size() == 1) {
                buf = buf.prepend(lb.first());
                continue;
            }
            Placeholder<T> res = new Placeholder<T>(ctx, lb.toList(), sym);
            buf = buf.prepend(res);
            hasRepeated = true;
        }
        final List attrs = buf.reverse();
        if (!isTypeCompound) {
            attacher.attach(sym, attrs);
        }
        if (hasRepeated) {
            this.repeated(new Worker(){

                @Override
                public String toString() {
                    return "repeated annotation pass of: " + sym + " in: " + sym.owner;
                }

                @Override
                public void run() {
                    JavaFileObject oldSource = Annotate.this.log.useSource(env.toplevel.sourcefile);
                    try {
                        attacher.attach(sym, Annotate.this.replacePlaceholders(attrs, ctx, sym));
                    }
                    finally {
                        Annotate.this.log.useSource(oldSource);
                    }
                }
            });
        } else {
            attacher.attach(sym, attrs);
        }
    }

    private <T extends Attribute.Compound> List<T> replacePlaceholders(List<T> buf, AnnotationContext<T> ctx, Symbol sym) {
        List<Object> result = List.nil();
        for (Attribute.Compound a : buf) {
            if (a instanceof Placeholder) {
                T replacement = this.replaceOne((Placeholder)a, ctx, sym);
                if (null == replacement) continue;
                result = result.prepend(replacement);
                continue;
            }
            result = result.prepend(a);
        }
        return result.reverse();
    }

    private <T extends Attribute.Compound> T replaceOne(Placeholder<T> placeholder, AnnotationContext<T> ctx, Symbol sym) {
        ListBuffer manualContainer;
        T validRepeated = this.processRepeatedAnnotations(placeholder.getPlaceholderFor(), ctx, sym);
        if (validRepeated != null && (manualContainer = ctx.annotated.get(((Attribute.Compound)validRepeated).type.tsym)) != null) {
            this.log.error(ctx.pos.get(manualContainer.first()), "invalid.repeatable.annotation.repeated.and.container.present", ((Attribute.Compound)manualContainer.first()).type.tsym);
        }
        return validRepeated;
    }

    void annotateLater(final List<JCTree.JCAnnotation> annotations, final Env<AttrContext> localEnv, final Symbol s, final JCDiagnostic.DiagnosticPosition deferPos) {
        if (annotations.isEmpty()) {
            return;
        }
        if (s.kind != 1) {
            s.resetAnnotations();
        }
        this.normal(new Worker(){

            @Override
            public String toString() {
                return "annotate " + annotations + " onto " + s + " in " + s.owner;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Assert.check(s.kind == 1 || s.annotationsPendingCompletion());
                JavaFileObject prev = Annotate.this.log.useSource(localEnv.toplevel.sourcefile);
                JCDiagnostic.DiagnosticPosition prevLintPos = deferPos != null ? Annotate.this.deferredLintHandler.setPos(deferPos) : Annotate.this.deferredLintHandler.immediate();
                Lint prevLint = deferPos != null ? null : Annotate.this.chk.setLint(Annotate.this.lint);
                try {
                    if (s.hasAnnotations() && annotations.nonEmpty()) {
                        Annotate.this.log.error(((JCTree.JCAnnotation)annotations.head).pos, "already.annotated", Kinds.kindName(s), s);
                    }
                    Annotate.this.actualEnterAnnotations(annotations, localEnv, s);
                }
                finally {
                    if (prevLint != null) {
                        Annotate.this.chk.setLint(prevLint);
                    }
                    Annotate.this.deferredLintHandler.setPos(prevLintPos);
                    Annotate.this.log.useSource(prev);
                }
            }
        });
        this.validate(new Worker(){

            @Override
            public void run() {
                JavaFileObject prev = Annotate.this.log.useSource(localEnv.toplevel.sourcefile);
                try {
                    Annotate.this.chk.validateAnnotations(annotations, s);
                }
                finally {
                    Annotate.this.log.useSource(prev);
                }
            }
        });
    }

    private void actualEnterAnnotations(List<JCTree.JCAnnotation> annotations, Env<AttrContext> env, Symbol s) {
        Assert.checkNonNull(s, "Symbol argument to actualEnterAnnotations is null");
        this.attachAttributesLater(annotations, env, s, false, this.enterAnnotationsCreator, this.declAnnotationsAttacher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualEnterTypeAnnotations(List<JCTree.JCAnnotation> annotations, Env<AttrContext> env, Symbol s, JCDiagnostic.DiagnosticPosition deferPos) {
        Assert.checkNonNull(s, "Symbol argument to actualEnterTypeAnnotations is nul/");
        JavaFileObject prev = this.log.useSource(env.toplevel.sourcefile);
        JCDiagnostic.DiagnosticPosition prevLintPos = null;
        if (deferPos != null) {
            prevLintPos = this.deferredLintHandler.setPos(deferPos);
        }
        try {
            this.attachAttributesLater(annotations, env, s, true, this.enterTypeAnnotationsCreator, this.typeAnnotationsAttacher);
        }
        finally {
            if (prevLintPos != null) {
                this.deferredLintHandler.setPos(prevLintPos);
            }
            this.log.useSource(prev);
        }
    }

    public void annotateTypeLater(final JCTree tree, final Env<AttrContext> env, final Symbol sym, final JCDiagnostic.DiagnosticPosition deferPos) {
        Assert.checkNonNull(sym);
        this.normal(new Worker(){

            @Override
            public String toString() {
                return "type annotate " + tree + " onto " + sym + " in " + sym.owner;
            }

            @Override
            public void run() {
                tree.accept(new TypeAnnotate(env, sym, deferPos));
            }
        });
    }

    private class TypeAnnotate
    extends TreeScanner {
        private final Env<AttrContext> env;
        private final Symbol sym;
        private JCDiagnostic.DiagnosticPosition deferPos;

        public TypeAnnotate(Env<AttrContext> env, Symbol sym, JCDiagnostic.DiagnosticPosition deferPos) {
            this.env = env;
            this.sym = sym;
            this.deferPos = deferPos;
        }

        @Override
        public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
            Annotate.this.actualEnterTypeAnnotations(tree.annotations, this.env, this.sym, this.deferPos);
            super.visitAnnotatedType(tree);
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter tree) {
            Annotate.this.actualEnterTypeAnnotations(tree.annotations, this.env, this.sym, this.deferPos);
            super.visitTypeParameter(tree);
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray tree) {
            Annotate.this.actualEnterTypeAnnotations(tree.annotations, this.env, this.sym, this.deferPos);
            for (List<JCTree.JCAnnotation> dimAnnos : tree.dimAnnotations) {
                Annotate.this.actualEnterTypeAnnotations(dimAnnos, this.env, this.sym, this.deferPos);
            }
            super.visitNewArray(tree);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            this.scan(tree.mods);
            this.scan(tree.restype);
            this.scan(tree.typarams);
            this.scan(tree.recvparam);
            this.scan(tree.params);
            this.scan(tree.thrown);
            this.scan(tree.defaultValue);
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            JCDiagnostic.DiagnosticPosition prevPos = this.deferPos;
            this.deferPos = tree.pos();
            try {
                if (this.sym != null && this.sym.kind == 4) {
                    this.scan(tree.mods);
                    this.scan(tree.vartype);
                }
                this.scan(tree.init);
            }
            finally {
                this.deferPos = prevPos;
            }
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass tree) {
            if (tree.def == null) {
                super.visitNewClass(tree);
            }
        }
    }

    private static interface AttributeCreator<T extends Attribute.Compound> {
        public T create(JCTree.JCAnnotation var1, Type var2, Env<AttrContext> var3);
    }

    private static interface AttributeAttacher<T extends Attribute.Compound> {
        public void attach(Symbol var1, List<T> var2);
    }

    private static class Placeholder<T extends Attribute.Compound>
    extends Attribute.Compound {
        private final AnnotationContext<T> ctx;
        private final List<T> placeholderFor;
        private final Symbol on;

        public Placeholder(AnnotationContext<T> ctx, List<T> placeholderFor, Symbol on) {
            super(on.type, List.nil(), ((Attribute.Compound)placeholderFor.head).position);
            this.ctx = ctx;
            this.placeholderFor = placeholderFor;
            this.on = on;
        }

        @Override
        public String toString() {
            return "<placeholder: " + this.placeholderFor + " on: " + this.on + ">";
        }

        public List<T> getPlaceholderFor() {
            return this.placeholderFor;
        }

        public AnnotationContext<T> getRepeatedContext() {
            return this.ctx;
        }
    }

    private class AnnotationContext<T extends Attribute.Compound> {
        public final Env<AttrContext> env;
        public final Map<Symbol.TypeSymbol, ListBuffer<T>> annotated;
        public final Map<T, JCDiagnostic.DiagnosticPosition> pos;
        public final boolean isTypeCompound;

        public AnnotationContext(Env<AttrContext> env, Map<Symbol.TypeSymbol, ListBuffer<T>> annotated, Map<T, JCDiagnostic.DiagnosticPosition> pos, boolean isTypeCompound) {
            Assert.checkNonNull(env);
            Assert.checkNonNull(annotated);
            Assert.checkNonNull(pos);
            this.env = env;
            this.annotated = annotated;
            this.pos = pos;
            this.isTypeCompound = isTypeCompound;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("RepeatedContext[");
            for (Map.Entry<Symbol.TypeSymbol, ListBuffer<T>> entry : this.annotated.entrySet()) {
                sb.append(" ");
                sb.append(entry.getKey());
                sb.append(" = { ");
                sb.append(entry.getValue());
                sb.append(" }");
            }
            sb.append(" ]");
            return sb.toString();
        }
    }

    public static interface Worker {
        public void run();

        public String toString();
    }
}

