/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.model;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.model.FilteredMemberList;
import com.sun.tools.javac.model.JavacSourcePosition;
import com.sun.tools.javac.processing.PrintingProcessor;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Constants;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import java.io.Writer;
import java.util.Map;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.JavaFileObject;

public class JavacElements
implements Elements {
    private JavaCompiler javaCompiler;
    private Symtab syms;
    private Names names;
    private Types types;
    private Enter enter;

    public static JavacElements instance(Context context) {
        JavacElements instance = context.get(JavacElements.class);
        if (instance == null) {
            instance = new JavacElements(context);
        }
        return instance;
    }

    protected JavacElements(Context context) {
        this.setContext(context);
    }

    public void setContext(Context context) {
        context.put(JavacElements.class, this);
        this.javaCompiler = JavaCompiler.instance(context);
        this.syms = Symtab.instance(context);
        this.names = Names.instance(context);
        this.types = Types.instance(context);
        this.enter = Enter.instance(context);
    }

    @Override
    public Symbol.PackageSymbol getPackageElement(CharSequence name) {
        String strName = name.toString();
        if (strName.equals("")) {
            return this.syms.unnamedPackage;
        }
        return SourceVersion.isName(strName) ? this.nameToSymbol(strName, Symbol.PackageSymbol.class) : null;
    }

    @Override
    public Symbol.ClassSymbol getTypeElement(CharSequence name) {
        String strName = name.toString();
        return SourceVersion.isName(strName) ? this.nameToSymbol(strName, Symbol.ClassSymbol.class) : null;
    }

    private <S extends Symbol> S nameToSymbol(String nameStr, Class<S> clazz) {
        Name name = this.names.fromString(nameStr);
        Symbol sym = clazz == Symbol.ClassSymbol.class ? (Symbol.TypeSymbol)this.syms.classes.get(name) : (Symbol.TypeSymbol)this.syms.packages.get(name);
        try {
            if (sym == null) {
                sym = this.javaCompiler.resolveIdent(nameStr);
            }
            sym.complete();
            return (S)(sym.kind != 63 && sym.exists() && clazz.isInstance(sym) && name.equals(sym.getQualifiedName()) ? (Symbol)clazz.cast(sym) : null);
        }
        catch (Symbol.CompletionFailure e) {
            return null;
        }
    }

    public JavacSourcePosition getSourcePosition(Element e) {
        Pair<JCTree, JCTree.JCCompilationUnit> treeTop = this.getTreeAndTopLevel(e);
        if (treeTop == null) {
            return null;
        }
        JCTree tree = (JCTree)treeTop.fst;
        JCTree.JCCompilationUnit toplevel = (JCTree.JCCompilationUnit)treeTop.snd;
        JavaFileObject sourcefile = toplevel.sourcefile;
        if (sourcefile == null) {
            return null;
        }
        return new JavacSourcePosition(sourcefile, tree.pos, toplevel.lineMap);
    }

    public JavacSourcePosition getSourcePosition(Element e, AnnotationMirror a) {
        Pair<JCTree, JCTree.JCCompilationUnit> treeTop = this.getTreeAndTopLevel(e);
        if (treeTop == null) {
            return null;
        }
        JCTree tree = (JCTree)treeTop.fst;
        JCTree.JCCompilationUnit toplevel = (JCTree.JCCompilationUnit)treeTop.snd;
        JavaFileObject sourcefile = toplevel.sourcefile;
        if (sourcefile == null) {
            return null;
        }
        JCTree annoTree = this.matchAnnoToTree(a, e, tree);
        if (annoTree == null) {
            return null;
        }
        return new JavacSourcePosition(sourcefile, annoTree.pos, toplevel.lineMap);
    }

    public JavacSourcePosition getSourcePosition(Element e, AnnotationMirror a, AnnotationValue v) {
        return this.getSourcePosition(e, a);
    }

    private JCTree matchAnnoToTree(AnnotationMirror findme, Element e, JCTree tree) {
        Symbol sym = JavacElements.cast(Symbol.class, e);
        class Vis
        extends JCTree.Visitor {
            List<JCTree.JCAnnotation> result = null;

            Vis() {
            }

            @Override
            public void visitTopLevel(JCTree.JCCompilationUnit tree) {
                this.result = tree.packageAnnotations;
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl tree) {
                this.result = tree.mods.annotations;
            }

            @Override
            public void visitMethodDef(JCTree.JCMethodDecl tree) {
                this.result = tree.mods.annotations;
            }

            @Override
            public void visitVarDef(JCTree.JCVariableDecl tree) {
                this.result = tree.mods.annotations;
            }

            @Override
            public void visitTypeParameter(JCTree.JCTypeParameter tree) {
                this.result = tree.annotations;
            }
        }
        Vis vis = new Vis();
        tree.accept(vis);
        if (vis.result == null) {
            return null;
        }
        java.util.List annos = sym.getAnnotationMirrors();
        return this.matchAnnoToTree(JavacElements.cast(Attribute.Compound.class, findme), (List<Attribute.Compound>)annos, vis.result);
    }

    private JCTree matchAnnoToTree(Attribute.Compound findme, List<Attribute.Compound> annos, List<JCTree.JCAnnotation> trees) {
        for (Attribute.Compound anno : annos) {
            for (JCTree.JCAnnotation tree : trees) {
                JCTree match = this.matchAnnoToTree(findme, anno, (JCTree)tree);
                if (match == null) continue;
                return match;
            }
        }
        return null;
    }

    private JCTree matchAnnoToTree(final Attribute.Compound findme, Attribute attr, final JCTree tree) {
        if (attr == findme) {
            return tree.type.tsym == findme.type.tsym ? tree : null;
        }
        class Vis
        implements Attribute.Visitor {
            JCTree result = null;

            Vis() {
            }

            @Override
            public void visitConstant(Attribute.Constant value) {
            }

            @Override
            public void visitClass(Attribute.Class clazz) {
            }

            @Override
            public void visitCompound(Attribute.Compound anno) {
                for (Pair<Symbol.MethodSymbol, Attribute> pair : anno.values) {
                    JCTree match;
                    JCTree.JCExpression expr = JavacElements.this.scanForAssign((Symbol.MethodSymbol)pair.fst, tree);
                    if (expr == null || (match = JavacElements.this.matchAnnoToTree(findme, (Attribute)pair.snd, expr)) == null) continue;
                    this.result = match;
                    return;
                }
            }

            @Override
            public void visitArray(Attribute.Array array) {
                if (tree.hasTag(JCTree.Tag.NEWARRAY) && ((JavacElements)JavacElements.this).types.elemtype((Type)array.type).tsym == findme.type.tsym) {
                    List<JCTree.JCExpression> elems = ((JCTree.JCNewArray)tree).elems;
                    for (Attribute value : array.values) {
                        if (value == findme) {
                            this.result = (JCTree)elems.head;
                            return;
                        }
                        elems = elems.tail;
                    }
                }
            }

            @Override
            public void visitEnum(Attribute.Enum e) {
            }

            @Override
            public void visitError(Attribute.Error e) {
            }
        }
        Vis vis = new Vis();
        attr.accept(vis);
        return vis.result;
    }

    private JCTree.JCExpression scanForAssign(final Symbol.MethodSymbol sym, final JCTree tree) {
        class TS
        extends TreeScanner {
            JCTree.JCExpression result = null;

            TS() {
            }

            @Override
            public void scan(JCTree t) {
                if (t != null && this.result == null) {
                    t.accept(this);
                }
            }

            @Override
            public void visitAnnotation(JCTree.JCAnnotation t) {
                if (t == tree) {
                    this.scan(t.args);
                }
            }

            @Override
            public void visitAssign(JCTree.JCAssign t) {
                if (t.lhs.hasTag(JCTree.Tag.IDENT)) {
                    JCTree.JCIdent ident = (JCTree.JCIdent)t.lhs;
                    if (ident.sym == sym) {
                        this.result = t.rhs;
                    }
                }
            }
        }
        TS scanner = new TS();
        tree.accept(scanner);
        return scanner.result;
    }

    public JCTree getTree(Element e) {
        Pair<JCTree, JCTree.JCCompilationUnit> treeTop = this.getTreeAndTopLevel(e);
        return treeTop != null ? (JCTree)treeTop.fst : null;
    }

    @Override
    public String getDocComment(Element e) {
        Pair<JCTree, JCTree.JCCompilationUnit> treeTop = this.getTreeAndTopLevel(e);
        if (treeTop == null) {
            return null;
        }
        JCTree tree = (JCTree)treeTop.fst;
        JCTree.JCCompilationUnit toplevel = (JCTree.JCCompilationUnit)treeTop.snd;
        if (toplevel.docComments == null) {
            return null;
        }
        return toplevel.docComments.getCommentText(tree);
    }

    @Override
    public PackageElement getPackageOf(Element e) {
        return JavacElements.cast(Symbol.class, e).packge();
    }

    @Override
    public boolean isDeprecated(Element e) {
        Symbol sym = JavacElements.cast(Symbol.class, e);
        return (sym.flags() & 0x20000L) != 0L;
    }

    @Override
    public Name getBinaryName(TypeElement type) {
        return JavacElements.cast(Symbol.TypeSymbol.class, type).flatName();
    }

    public Map<Symbol.MethodSymbol, Attribute> getElementValuesWithDefaults(AnnotationMirror a) {
        Attribute.Compound anno = JavacElements.cast(Attribute.Compound.class, a);
        DeclaredType annotype = a.getAnnotationType();
        Map<Symbol.MethodSymbol, Attribute> valmap = anno.getElementValues();
        for (ExecutableElement ex : ElementFilter.methodsIn(annotype.asElement().getEnclosedElements())) {
            Symbol.MethodSymbol meth = (Symbol.MethodSymbol)ex;
            Attribute defaultValue = meth.getDefaultValue();
            if (defaultValue == null || valmap.containsKey(meth)) continue;
            valmap.put(meth, defaultValue);
        }
        return valmap;
    }

    public FilteredMemberList getAllMembers(TypeElement element) {
        Symbol sym = JavacElements.cast(Symbol.class, element);
        Scope scope = sym.members().dupUnshared();
        List<Type> closure = this.types.closure(sym.asType());
        for (Type t : closure) {
            this.addMembers(scope, t);
        }
        return new FilteredMemberList(scope);
    }

    private void addMembers(Scope scope, Type type) {
        Scope.Entry e = type.asElement().members().elems;
        while (e != null) {
            block4: {
                boolean initializer;
                Scope.Entry overrider = scope.lookup(e.sym.getSimpleName());
                while (overrider.scope != null) {
                    if (overrider.sym.kind != e.sym.kind || (overrider.sym.flags() & 0x1000L) != 0L || overrider.sym.getKind() != ElementKind.METHOD || !this.overrides((ExecutableElement)((Object)overrider.sym), (ExecutableElement)((Object)e.sym), (TypeElement)((Object)type.asElement()))) {
                        overrider = overrider.next();
                        continue;
                    }
                    break block4;
                }
                boolean derived = e.sym.getEnclosingElement() != scope.owner;
                ElementKind kind = e.sym.getKind();
                boolean bl = initializer = kind == ElementKind.CONSTRUCTOR || kind == ElementKind.INSTANCE_INIT || kind == ElementKind.STATIC_INIT;
                if (!derived || !initializer && e.sym.isInheritedIn(scope.owner, this.types)) {
                    scope.enter(e.sym);
                }
            }
            e = e.sibling;
        }
    }

    public List<Attribute.Compound> getAllAnnotationMirrors(Element e) {
        Type sup;
        Symbol sym = JavacElements.cast(Symbol.class, e);
        List<Attribute.Compound> annos = sym.getAnnotationMirrors();
        while (sym.getKind() == ElementKind.CLASS && (sup = ((Symbol.ClassSymbol)sym).getSuperclass()).hasTag(TypeTag.CLASS) && !sup.isErroneous() && sup.tsym != this.syms.objectType.tsym) {
            sym = sup.tsym;
            List<Attribute.Compound> oldAnnos = annos;
            java.util.List newAnnos = sym.getAnnotationMirrors();
            for (Attribute.Compound anno : newAnnos) {
                if (!this.isInherited(anno.type) || JavacElements.containsAnnoOfType(oldAnnos, anno.type)) continue;
                annos = annos.prepend(anno);
            }
        }
        return annos;
    }

    private boolean isInherited(Type annotype) {
        return annotype.tsym.attribute(this.syms.inheritedType.tsym) != null;
    }

    private static boolean containsAnnoOfType(List<Attribute.Compound> annos, Type type) {
        for (Attribute.Compound anno : annos) {
            if (anno.type.tsym != type.tsym) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hides(Element hiderEl, Element hideeEl) {
        Symbol hidee;
        Symbol hider = JavacElements.cast(Symbol.class, hiderEl);
        if (hider == (hidee = JavacElements.cast(Symbol.class, hideeEl)) || hider.kind != hidee.kind || hider.name != hidee.name) {
            return false;
        }
        if (!(hider.kind != 16 || hider.isStatic() && this.types.isSubSignature(hider.type, hidee.type))) {
            return false;
        }
        Symbol.ClassSymbol hiderClass = hider.owner.enclClass();
        Symbol.ClassSymbol hideeClass = hidee.owner.enclClass();
        if (hiderClass == null || hideeClass == null || !hiderClass.isSubClass(hideeClass, this.types)) {
            return false;
        }
        return hidee.isInheritedIn(hiderClass, this.types);
    }

    @Override
    public boolean overrides(ExecutableElement riderEl, ExecutableElement rideeEl, TypeElement typeEl) {
        Symbol.MethodSymbol rider = JavacElements.cast(Symbol.MethodSymbol.class, riderEl);
        Symbol.MethodSymbol ridee = JavacElements.cast(Symbol.MethodSymbol.class, rideeEl);
        Symbol.ClassSymbol origin = JavacElements.cast(Symbol.ClassSymbol.class, typeEl);
        return rider.name == ridee.name && rider != ridee && !rider.isStatic() && ridee.isMemberOf(origin, this.types) && rider.overrides(ridee, origin, this.types, false);
    }

    @Override
    public String getConstantExpression(Object value) {
        return Constants.format(value);
    }

    @Override
    public void printElements(Writer w, Element ... elements) {
        for (Element element : elements) {
            ((PrintingProcessor.PrintingElementVisitor)new PrintingProcessor.PrintingElementVisitor(w, this).visit(element)).flush();
        }
    }

    @Override
    public Name getName(CharSequence cs) {
        return this.names.fromString(cs.toString());
    }

    @Override
    public boolean isFunctionalInterface(TypeElement element) {
        if (element.getKind() != ElementKind.INTERFACE) {
            return false;
        }
        Symbol.TypeSymbol tsym = JavacElements.cast(Symbol.TypeSymbol.class, element);
        return this.types.isFunctionalInterface(tsym);
    }

    private Pair<JCTree, JCTree.JCCompilationUnit> getTreeAndTopLevel(Element e) {
        Symbol sym = JavacElements.cast(Symbol.class, e);
        Env<AttrContext> enterEnv = this.getEnterEnv(sym);
        if (enterEnv == null) {
            return null;
        }
        JCTree tree = TreeInfo.declarationFor(sym, enterEnv.tree);
        if (tree == null || enterEnv.toplevel == null) {
            return null;
        }
        return new Pair<JCTree, JCTree.JCCompilationUnit>(tree, enterEnv.toplevel);
    }

    public Pair<JCTree, JCTree.JCCompilationUnit> getTreeAndTopLevel(Element e, AnnotationMirror a, AnnotationValue v) {
        if (e == null) {
            return null;
        }
        Pair<JCTree, JCTree.JCCompilationUnit> elemTreeTop = this.getTreeAndTopLevel(e);
        if (elemTreeTop == null) {
            return null;
        }
        if (a == null) {
            return elemTreeTop;
        }
        JCTree annoTree = this.matchAnnoToTree(a, e, (JCTree)elemTreeTop.fst);
        if (annoTree == null) {
            return elemTreeTop;
        }
        return new Pair<JCTree, JCTree.JCCompilationUnit>(annoTree, (JCTree.JCCompilationUnit)elemTreeTop.snd);
    }

    private Env<AttrContext> getEnterEnv(Symbol sym) {
        Symbol.TypeSymbol ts = sym.kind != 1 ? sym.enclClass() : (Symbol.PackageSymbol)sym;
        return ts != null ? this.enter.getEnv(ts) : null;
    }

    private static <T> T cast(Class<T> clazz, Object o) {
        if (!clazz.isInstance(o)) {
            throw new IllegalArgumentException(o.toString());
        }
        return clazz.cast(o);
    }
}

